/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.PhoenixTestBuilder;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class TTLIT
extends ParallelStatsDisabledIT {
    private final boolean isMultiTenant;
    private static final int DEFAULT_TEST_TTL_VALUE = 800000;
    private static final int ALTER_TEST_TTL_VALUE = 100000;
    private static final int DEFAULT_TEST_TTL_VALUE_AT_GLOBAL = 400000;
    private static final int DEFAULT_TEST_TTL_VALUE_AT_TENANT = 200000;
    public static final String SKIP_ASSERT = "SKIP_ASSERT";

    public TTLIT(boolean isMultiTenant) {
        this.isMultiTenant = isMultiTenant;
    }

    @Parameterized.Parameters(name="isMultiTenant={0}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    private PhoenixTestBuilder.SchemaBuilder createTableWithTTL(boolean addTTL, boolean addIndex, PhoenixTestBuilder.SchemaBuilder.TableIndexOptions indexOptions) {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(TTLIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setMultiTenant(this.isMultiTenant);
        if (addTTL) {
            tableOptions.setTableProps("TTL = 800000");
        }
        if (addIndex) {
            if (indexOptions == null) {
                indexOptions = PhoenixTestBuilder.SchemaBuilder.TableIndexOptions.withDefaults();
            }
            schemaBuilder.withTableIndexOptions(indexOptions);
        }
        return schemaBuilder.withTableOptions(tableOptions);
    }

    private PhoenixTestBuilder.SchemaBuilder createGlobalViewOnTable(boolean addTTL, boolean addIndex) {
        return this.createGlobalViewOnTable(this.createTableWithTTL(false, false, null), addTTL, addIndex, true);
    }

    private PhoenixTestBuilder.SchemaBuilder createGlobalViewOnTable(PhoenixTestBuilder.SchemaBuilder schemaBuilder, boolean addTTL, boolean addIndex, boolean addPK) {
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        if (!addPK) {
            globalViewOptions.setGlobalViewPKColumns(Lists.newArrayList());
        }
        if (addTTL) {
            globalViewOptions.setTableProps("TTL = 400000");
        }
        if (addIndex) {
            schemaBuilder.withGlobalViewIndexDefaults();
        }
        return schemaBuilder.withGlobalViewOptions(globalViewOptions);
    }

    private PhoenixTestBuilder.SchemaBuilder createTenantViewOnTable(boolean addTTL, boolean addIndex) {
        return this.createTenantViewOnTableOrGlobalView(this.createTableWithTTL(false, false, null), addTTL, addIndex, true);
    }

    private PhoenixTestBuilder.SchemaBuilder createTenantViewOnGlobalView(boolean addTTL, boolean addIndex) {
        return this.createTenantViewOnTableOrGlobalView(this.createGlobalViewOnTable(false, false), addTTL, addIndex, true);
    }

    private PhoenixTestBuilder.SchemaBuilder createTenantViewOnTableOrGlobalView(PhoenixTestBuilder.SchemaBuilder schemaBuilder, boolean addTTL, boolean addIndex, boolean addPK) {
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        if (!addPK) {
            tenantViewOptions.setTenantViewPKColumns(Lists.newArrayList());
        }
        if (addTTL) {
            tenantViewOptions.setTableProps("TTL = 200000");
        }
        if (addIndex) {
            schemaBuilder.withTenantViewIndexDefaults();
        }
        return schemaBuilder.withTenantViewOptions(tenantViewOptions);
    }

    private void assertTTLForGivenPTable(Connection connection, PTable table, int ttl) throws SQLException, IOException {
        LiteralTTLExpression expected = new LiteralTTLExpression(ttl);
        TestUtil.assertTTLValue(connection, table, (TTLExpression)expected);
    }

    private void assertTTLForGivenEntity(Connection connection, String entityName, int ttl) throws SQLException, IOException {
        PTable pTable = PhoenixRuntime.getTable((Connection)connection, (String)entityName);
        LiteralTTLExpression expected = new LiteralTTLExpression(ttl);
        TestUtil.assertTTLValue(connection, pTable, (TTLExpression)expected);
    }

    private void assertTTLForIndexName(Connection connection, String indexName, int ttl) throws SQLException, IOException {
        if (!indexName.equals(SKIP_ASSERT)) {
            PTable index = PhoenixRuntime.getTable((Connection)connection, (String)indexName);
            LiteralTTLExpression expected = new LiteralTTLExpression(ttl);
            TestUtil.assertTTLValue(connection, index, (TTLExpression)expected);
        }
    }

    private void assertTTLForIndexFromParentPTable(Connection connection, String baseEntity, int ttl) throws SQLException, IOException {
        PTable entity = PhoenixRuntime.getTable((Connection)connection, (String)baseEntity);
        List indexes = entity.getIndexes();
        LiteralTTLExpression expected = new LiteralTTLExpression(ttl);
        for (PTable index : indexes) {
            TestUtil.assertTTLValue(connection, index, (TTLExpression)expected);
        }
    }

    @Test
    public void testTTLAtTableLevelWithIndex() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTableWithTTL(true, true, null);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String indexName = schemaBuilder.getEntityTableIndexName();
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());){
            this.assertTTLForGivenPTable(globalConnection, table, 800000);
            this.assertTTLForIndexName(globalConnection, indexName, 800000);
            this.assertTTLForIndexFromParentPTable(globalConnection, schemaBuilder.getEntityTableName(), 800000);
        }
    }

    @Test
    public void testSettingTTLForIndex() throws Exception {
        PhoenixTestBuilder.SchemaBuilder.TableIndexOptions indexOptions = new PhoenixTestBuilder.SchemaBuilder.TableIndexOptions();
        indexOptions.setTableIndexColumns(PhoenixTestBuilder.DDLDefaults.TABLE_INDEX_COLUMNS);
        indexOptions.setTableIncludeColumns(PhoenixTestBuilder.DDLDefaults.TABLE_INCLUDE_COLUMNS);
        indexOptions.setIndexProps("TTL = 800000");
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTableWithTTL(false, true, indexOptions);
        try {
            schemaBuilder.build();
            Assert.fail();
        }
        catch (SQLException sqe) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX.getErrorCode(), (long)sqe.getErrorCode());
        }
    }

    @Test
    public void testTTLInHierarchyDefinedAtTableLevel() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTableWithTTL(true, false, null);
        schemaBuilder = this.createGlobalViewOnTable(schemaBuilder, false, false, true);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, false, false, true);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String globalView = schemaBuilder.getEntityGlobalViewName();
        String childView = schemaBuilder.getEntityTenantViewName();
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 800000);
            this.assertTTLForGivenEntity(globalConnection, globalView, 800000);
            this.assertTTLForGivenEntity(tenantConnection, childView, 800000);
        }
    }

    @Test
    public void testSettingTTLForViewsInHierarchyWithTTLAtTableLevel() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTableWithTTL(true, false, null);
        schemaBuilder = this.createGlobalViewOnTable(schemaBuilder, true, false, true);
        try {
            schemaBuilder.build();
            Assert.fail();
        }
        catch (SQLException sqe) {
            Assert.assertEquals((long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)sqe.getErrorCode());
        }
        schemaBuilder = this.createTableWithTTL(true, false, null);
        schemaBuilder = this.createGlobalViewOnTable(schemaBuilder, false, false, true);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, true, false, true);
        try {
            schemaBuilder.build();
            Assert.fail();
        }
        catch (SQLException sqe) {
            Assert.assertEquals((long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)sqe.getErrorCode());
        }
    }

    @Test
    public void testAlteringTTLForViewsInHierarchyWithTTLAtTableLevel() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTableWithTTL(true, false, null);
        schemaBuilder = this.createGlobalViewOnTable(schemaBuilder, false, false, true);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, false, false, true);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String globalViewName = schemaBuilder.getEntityGlobalViewName();
        String childViewName = schemaBuilder.getEntityTenantViewName();
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 800000);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 800000);
            this.assertTTLForGivenEntity(tenantConnection, childViewName, 800000);
            String dml = "ALTER VIEW " + globalViewName + " SET TTL = " + 100000;
            try {
                globalConnection.createStatement().execute(dml);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)sqe.getErrorCode());
            }
            dml = "ALTER VIEW " + childViewName + " SET TTL = " + 100000;
            try {
                tenantConnection.createStatement().execute(dml);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)sqe.getErrorCode());
            }
        }
    }

    @Test
    public void testTTLInHierarchyDefinedAtTableLevelWithIndex() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTableWithTTL(true, true, null);
        schemaBuilder = this.createGlobalViewOnTable(schemaBuilder, false, false, false);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, false, false, false);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String indexName = schemaBuilder.getEntityTableIndexName();
        String globalView = schemaBuilder.getEntityGlobalViewName();
        String childView = schemaBuilder.getEntityTenantViewName();
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 800000);
            this.assertTTLForIndexName(globalConnection, indexName, 800000);
            this.assertTTLForIndexFromParentPTable(globalConnection, schemaBuilder.getEntityTableName(), 800000);
            this.assertTTLForGivenEntity(globalConnection, globalView, 800000);
            this.assertTTLForGivenEntity(tenantConnection, childView, 800000);
        }
    }

    @Test
    public void testTTLInHierarchyDefinedAtTableLevelWithIndexAtGlobalLevel() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTableWithTTL(true, false, null);
        schemaBuilder = this.createGlobalViewOnTable(schemaBuilder, false, true, true);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, false, false, false);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String globalView = schemaBuilder.getEntityGlobalViewName();
        String globalViewIndexName = schemaBuilder.getEntityGlobalViewIndexName();
        String childView = schemaBuilder.getEntityTenantViewName();
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 800000);
            this.assertTTLForGivenEntity(globalConnection, globalView, 800000);
            this.assertTTLForIndexName(globalConnection, globalViewIndexName, 800000);
            this.assertTTLForIndexFromParentPTable(globalConnection, globalView, 800000);
            this.assertTTLForGivenEntity(tenantConnection, childView, 800000);
        }
    }

    @Test
    public void testTTLInHierarchyDefinedAtTableLevelWithIndexAtTenantLevel() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTableWithTTL(true, false, null);
        schemaBuilder = this.createGlobalViewOnTable(schemaBuilder, false, false, true);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, false, this.isMultiTenant, true);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String globalView = schemaBuilder.getEntityGlobalViewName();
        String childView = schemaBuilder.getEntityTenantViewName();
        String childViewIndexName = this.isMultiTenant ? schemaBuilder.getEntityTenantViewIndexName() : SKIP_ASSERT;
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 800000);
            this.assertTTLForGivenEntity(globalConnection, globalView, 800000);
            this.assertTTLForGivenEntity(tenantConnection, childView, 800000);
            this.assertTTLForIndexName(tenantConnection, childViewIndexName, 800000);
            this.assertTTLForIndexFromParentPTable(tenantConnection, childView, 800000);
        }
    }

    @Test
    public void testTTLHierarchyDefinedAtGlobalViewLevel() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createGlobalViewOnTable(true, true);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, false, false, false);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String globalViewName = schemaBuilder.getEntityGlobalViewName();
        String globalViewIndexName = schemaBuilder.getEntityGlobalViewIndexName();
        String childViewName = schemaBuilder.getEntityTenantViewName();
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 400000);
            this.assertTTLForIndexName(globalConnection, globalViewIndexName, 400000);
            this.assertTTLForIndexFromParentPTable(globalConnection, globalViewName, 400000);
            this.assertTTLForGivenEntity(tenantConnection, childViewName, 400000);
        }
    }

    @Test
    public void testTTLHierarchyDefinedAtGlobalViewLevelWithTenantIndex() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createGlobalViewOnTable(true, false);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, false, this.isMultiTenant, true);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String globalViewName = schemaBuilder.getEntityGlobalViewName();
        String childViewName = schemaBuilder.getEntityTenantViewName();
        String childViewIndexName = this.isMultiTenant ? schemaBuilder.getEntityTenantViewIndexName() : SKIP_ASSERT;
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 400000);
            this.assertTTLForGivenEntity(tenantConnection, childViewName, 400000);
            this.assertTTLForIndexName(tenantConnection, childViewIndexName, 400000);
            this.assertTTLForIndexFromParentPTable(tenantConnection, childViewName, 400000);
        }
    }

    @Test
    public void testSettingTTLAtTenantViewLevelWithTTLDefinedAtGlobalView() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createGlobalViewOnTable(true, false);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, true, false, true);
        try {
            schemaBuilder.build();
            Assert.fail();
        }
        catch (SQLException sqe) {
            Assert.assertEquals((long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)sqe.getErrorCode());
        }
        schemaBuilder = this.createGlobalViewOnTable(true, false);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, false, false, true);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String globalViewName = schemaBuilder.getEntityGlobalViewName();
        String childViewName = schemaBuilder.getEntityTenantViewName();
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 400000);
            this.assertTTLForGivenEntity(tenantConnection, childViewName, 400000);
        }
    }

    @Test
    public void testAlteringTTLAtDifferentLevelsWithTTLDefinedAtGlobalView() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createGlobalViewOnTable(true, false);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, false, false, true);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String tableName = schemaBuilder.getEntityTableName();
        String globalViewName = schemaBuilder.getEntityGlobalViewName();
        String childViewName = schemaBuilder.getEntityTenantViewName();
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 400000);
            this.assertTTLForGivenEntity(tenantConnection, childViewName, 400000);
            String dml = "ALTER VIEW " + childViewName + " SET TTL = " + 100000;
            try {
                tenantConnection.createStatement().execute(dml);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)sqe.getErrorCode());
            }
            dml = "ALTER TABLE " + tableName + " SET TTL = " + 100000;
            try {
                globalConnection.createStatement().execute(dml);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)sqe.getErrorCode());
            }
        }
    }

    @Test
    public void testTTLHierarchyDefinedAtTenantViewLevel() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTenantViewOnGlobalView(true, this.isMultiTenant);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String globalView = schemaBuilder.getEntityGlobalViewName();
        String childView = schemaBuilder.getEntityTenantViewName();
        String childViewIndex = this.isMultiTenant ? schemaBuilder.getEntityTenantViewIndexName() : SKIP_ASSERT;
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 0);
            this.assertTTLForGivenEntity(globalConnection, globalView, 0);
            this.assertTTLForGivenEntity(tenantConnection, childView, 200000);
            this.assertTTLForIndexName(tenantConnection, childViewIndex, 200000);
            this.assertTTLForIndexFromParentPTable(tenantConnection, childView, 200000);
        }
    }

    @Test
    public void testSettingAndAlteringTTLInHierarchyAboveOfTenantViewWithTTLDefined() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTenantViewOnGlobalView(true, this.isMultiTenant);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String tableName = schemaBuilder.getEntityTableName();
        String globalView = schemaBuilder.getEntityGlobalViewName();
        String childView = schemaBuilder.getEntityTenantViewName();
        String childViewIndex = this.isMultiTenant ? schemaBuilder.getEntityTenantViewIndexName() : SKIP_ASSERT;
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 0);
            this.assertTTLForGivenEntity(globalConnection, globalView, 0);
            this.assertTTLForGivenEntity(tenantConnection, childView, 200000);
            this.assertTTLForIndexName(tenantConnection, childViewIndex, 200000);
            this.assertTTLForIndexFromParentPTable(tenantConnection, childView, 200000);
            String dml = "ALTER VIEW " + globalView + " SET TTL = " + 100000;
            try {
                globalConnection.createStatement().execute(dml);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)sqe.getErrorCode());
            }
            dml = "ALTER TABLE " + tableName + " SET TTL = " + 100000;
            try {
                globalConnection.createStatement().execute(dml);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)sqe.getErrorCode());
            }
        }
    }

    @Test
    public void testAlteringTTLFromTableToLevel1() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTableWithTTL(true, false, null);
        schemaBuilder = this.createGlobalViewOnTable(schemaBuilder, false, false, true);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, false, this.isMultiTenant, true);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String schemaName = schemaBuilder.getTableOptions().getSchemaName();
        String tableName = schemaBuilder.getEntityTableName();
        String globalViewName = schemaBuilder.getEntityGlobalViewName();
        String tenantViewName = schemaBuilder.getEntityTenantViewName();
        String tenantViewIndexName = this.isMultiTenant ? schemaBuilder.getEntityTenantViewIndexName() : SKIP_ASSERT;
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 800000);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 800000);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 800000);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 800000);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 800000);
            String dml = "ALTER TABLE " + tableName + " SET TTL = NONE";
            globalConnection.createStatement().execute(dml);
            globalConnection.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            this.assertTTLForGivenEntity(globalConnection, tableName, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 0);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 0);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 0);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 0);
            dml = "ALTER VIEW " + globalViewName + " SET TTL = " + 100000;
            globalConnection.createStatement().execute(dml);
            globalConnection.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            this.assertTTLForGivenEntity(globalConnection, tableName, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 100000);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 100000);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 100000);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 100000);
        }
    }

    @Test
    public void testAlteringTTLFromTableToLevel2() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTableWithTTL(true, false, null);
        schemaBuilder = this.createGlobalViewOnTable(schemaBuilder, false, false, true);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, false, this.isMultiTenant, true);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String schemaName = schemaBuilder.getTableOptions().getSchemaName();
        String tableName = schemaBuilder.getEntityTableName();
        String globalViewName = schemaBuilder.getEntityGlobalViewName();
        String tenantViewName = schemaBuilder.getEntityTenantViewName();
        String tenantViewIndexName = this.isMultiTenant ? schemaBuilder.getEntityTenantViewIndexName() : SKIP_ASSERT;
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 800000);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 800000);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 800000);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 800000);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 800000);
            String dml = "ALTER TABLE " + tableName + " SET TTL = NONE";
            globalConnection.createStatement().execute(dml);
            globalConnection.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            this.assertTTLForGivenEntity(globalConnection, tableName, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 0);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 0);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 0);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 0);
            dml = "ALTER VIEW " + tenantViewName + " SET TTL = " + 100000;
            tenantConnection.createStatement().execute(dml);
            globalConnection.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            this.assertTTLForGivenEntity(globalConnection, tableName, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 0);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 100000);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 100000);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 100000);
        }
    }

    @Test
    public void testAlteringTTLFromLevel1ToLevel2() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTableWithTTL(false, false, null);
        schemaBuilder = this.createGlobalViewOnTable(schemaBuilder, true, false, true);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, false, this.isMultiTenant, true);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String schemaName = schemaBuilder.getTableOptions().getSchemaName();
        String tableName = schemaBuilder.getEntityTableName();
        String globalViewName = schemaBuilder.getEntityGlobalViewName();
        String tenantViewName = schemaBuilder.getEntityTenantViewName();
        String tenantViewIndexName = this.isMultiTenant ? schemaBuilder.getEntityTenantViewIndexName() : SKIP_ASSERT;
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 400000);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 400000);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 400000);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 400000);
            String dml = "ALTER VIEW " + globalViewName + " SET TTL = NONE";
            globalConnection.createStatement().execute(dml);
            globalConnection.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            this.assertTTLForGivenEntity(globalConnection, tableName, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 0);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 0);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 0);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 0);
            dml = "ALTER VIEW " + tenantViewName + " SET TTL = " + 100000;
            tenantConnection.createStatement().execute(dml);
            globalConnection.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            this.assertTTLForGivenEntity(globalConnection, tableName, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 0);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 100000);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 100000);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 100000);
        }
    }

    @Test
    public void testAlteringTTLFromLevel2ToTable() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTableWithTTL(false, false, null);
        schemaBuilder = this.createGlobalViewOnTable(schemaBuilder, false, false, true);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, true, this.isMultiTenant, true);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String schemaName = schemaBuilder.getTableOptions().getSchemaName();
        String tableName = schemaBuilder.getEntityTableName();
        String globalViewName = schemaBuilder.getEntityGlobalViewName();
        String tenantViewName = schemaBuilder.getEntityTenantViewName();
        String tenantViewIndexName = this.isMultiTenant ? schemaBuilder.getEntityTenantViewIndexName() : SKIP_ASSERT;
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 0);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 200000);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 200000);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 200000);
            String dml = "ALTER VIEW " + tenantViewName + " SET TTL = NONE";
            tenantConnection.createStatement().execute(dml);
            globalConnection.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            this.assertTTLForGivenEntity(globalConnection, tableName, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 0);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 0);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 0);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 0);
            dml = "ALTER TABLE " + tableName + " SET TTL = " + 100000;
            globalConnection.createStatement().execute(dml);
            globalConnection.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            this.assertTTLForGivenEntity(globalConnection, tableName, 100000);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 100000);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 100000);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 100000);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 100000);
        }
    }

    @Test
    public void testAlteringTTLFromLevel2ToLevel1() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createTableWithTTL(false, false, null);
        schemaBuilder = this.createGlobalViewOnTable(schemaBuilder, false, false, true);
        schemaBuilder = this.createTenantViewOnTableOrGlobalView(schemaBuilder, true, this.isMultiTenant, true);
        schemaBuilder.build();
        PTable table = schemaBuilder.getBaseTable();
        String schemaName = schemaBuilder.getTableOptions().getSchemaName();
        String tableName = schemaBuilder.getEntityTableName();
        String globalViewName = schemaBuilder.getEntityGlobalViewName();
        String tenantViewName = schemaBuilder.getEntityTenantViewName();
        String tenantViewIndexName = this.isMultiTenant ? schemaBuilder.getEntityTenantViewIndexName() : SKIP_ASSERT;
        try (Connection globalConnection = DriverManager.getConnection(TTLIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(TTLIT.getUrl() + ';' + "TenantId" + '=' + schemaBuilder.getDataOptions().getTenantId());){
            this.assertTTLForGivenPTable(globalConnection, table, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 0);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 200000);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 200000);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 200000);
            String dml = "ALTER VIEW " + tenantViewName + " SET TTL = NONE";
            tenantConnection.createStatement().execute(dml);
            globalConnection.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            this.assertTTLForGivenEntity(globalConnection, tableName, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 0);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 0);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 0);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 0);
            dml = "ALTER VIEW " + globalViewName + " SET TTL = " + 100000;
            globalConnection.createStatement().execute(dml);
            globalConnection.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            this.assertTTLForGivenEntity(globalConnection, tableName, 0);
            this.assertTTLForGivenEntity(globalConnection, globalViewName, 100000);
            this.assertTTLForGivenEntity(tenantConnection, tenantViewName, 100000);
            this.assertTTLForIndexName(tenantConnection, tenantViewIndexName, 100000);
            this.assertTTLForIndexFromParentPTable(tenantConnection, tenantViewName, 100000);
        }
    }
}

