/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.phoenix.coprocessor.TaskMetaDataEndpoint;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.query.QueryServicesTestImpl;
import org.apache.phoenix.schema.SystemTaskSplitPolicy;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SystemTablesUpgradeIT
extends BaseTest {
    private static boolean reinitialize;
    private static int countUpgradeAttempts;
    private static long systemTableVersion;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        ConcurrentMap props = Maps.newConcurrentMap();
        props.put("phoenix.driver.class.name", PhoenixUpgradeCountingDriver.class.getName());
        SystemTablesUpgradeIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testUpgradeOnlyHappensOnce() throws Exception {
        ConnectionQueryServices services = DriverManager.getConnection(SystemTablesUpgradeIT.getUrl()).unwrap(PhoenixConnection.class).getQueryServices();
        Assert.assertTrue((boolean)(services instanceof PhoenixUpgradeCountingServices));
        boolean wasTimestampChanged = systemTableVersion != 42L;
        reinitialize = true;
        systemTableVersion = 42L;
        DriverManager.getConnection(SystemTablesUpgradeIT.getUrl());
        Assert.assertEquals((long)(wasTimestampChanged ? 1L : 0L), (long)countUpgradeAttempts);
        DriverManager.getConnection(SystemTablesUpgradeIT.getUrl());
        Assert.assertEquals((long)(wasTimestampChanged ? 1L : 0L), (long)countUpgradeAttempts);
        try (Admin admin = services.getAdmin();){
            TableDescriptor td = admin.getDescriptor(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_TASK_NAME));
            String taskSplitPolicy = td.getRegionSplitPolicyClassName();
            Assert.assertEquals((Object)SystemTaskSplitPolicy.class.getName(), (Object)taskSplitPolicy);
            Assert.assertTrue((boolean)td.hasCoprocessor(TaskMetaDataEndpoint.class.getName()));
        }
    }

    static {
        systemTableVersion = MetaDataProtocol.getPriorVersion();
    }

    public static class PhoenixUpgradeCountingDriver
    extends PhoenixTestDriver {
        private ConnectionQueryServices cqs;
        private final ReadOnlyProps overrideProps;

        public PhoenixUpgradeCountingDriver(ReadOnlyProps props) {
            this.overrideProps = props;
        }

        @Override
        public boolean acceptsURL(String url) throws SQLException {
            return true;
        }

        @Override
        public synchronized ConnectionQueryServices getConnectionQueryServices(String url, Properties info) throws SQLException {
            if (this.cqs == null) {
                this.cqs = new PhoenixUpgradeCountingServices((QueryServices)new QueryServicesTestImpl(this.getDefaultProps(), this.overrideProps), ConnectionInfo.create((String)url, null, null), info);
                this.cqs.init(url, info);
            } else if (reinitialize) {
                this.cqs.init(url, info);
                reinitialize = false;
            }
            return this.cqs;
        }
    }

    private static class PhoenixUpgradeCountingServices
    extends ConnectionQueryServicesImpl {
        public PhoenixUpgradeCountingServices(QueryServices services, ConnectionInfo connectionInfo, Properties info) {
            super(services, connectionInfo, info);
        }

        protected void setUpgradeRequired() {
            super.setUpgradeRequired();
            countUpgradeAttempts++;
        }

        protected long getSystemTableVersion() {
            return systemTableVersion;
        }

        protected boolean isInitialized() {
            return !reinitialize && super.isInitialized();
        }
    }
}

