/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class SystemCatalogRollbackEnabledIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap<String, String> serverProps = new HashMap<String, String>(2);
        HashMap<String, String> clientProps = new HashMap<String, String>(1);
        serverProps.put("phoenix.system.catalog.splittable", "false");
        serverProps.put("phoenix.allow.system.catalog.rollback", "true");
        clientProps.put("phoenix.allow.system.catalog.rollback", "true");
        SystemCatalogRollbackEnabledIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    private void createTableAndTenantViews(String tableName) throws Exception {
        try (Connection conn = DriverManager.getConnection(SystemCatalogRollbackEnabledIT.getUrl());
             Statement stmt = conn.createStatement();){
            String view1DDL;
            stmt.execute("DROP TABLE IF EXISTS " + tableName);
            stmt.execute("CREATE TABLE " + tableName + " (TENANT_ID VARCHAR NOT NULL, PK1 VARCHAR NOT NULL, V1 VARCHAR CONSTRAINT PK PRIMARY KEY(TENANT_ID, PK1)) MULTI_TENANT=true");
            try (Connection tenant1Conn = this.getTenantConnection("tenant1");){
                view1DDL = "CREATE VIEW " + tableName + "_view1 AS SELECT * FROM " + tableName;
                tenant1Conn.createStatement().execute(view1DDL);
            }
            var7_11 = null;
            try (Connection tenant2Conn = this.getTenantConnection("tenant2");){
                view1DDL = "CREATE VIEW " + tableName + "_view2 AS SELECT * FROM " + tableName;
                tenant2Conn.createStatement().execute(view1DDL);
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
            conn.commit();
        }
    }

    private Connection getTenantConnection(String tenantId) throws SQLException {
        Properties tenantProps = new Properties();
        tenantProps.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(SystemCatalogRollbackEnabledIT.getUrl(), tenantProps);
    }

    private void assertNumRegions(HBaseTestingUtility testUtil, TableName tableName, int expectedNumRegions) throws IOException {
        RegionLocator rl = testUtil.getConnection().getRegionLocator(tableName);
        Assert.assertEquals((long)expectedNumRegions, (long)rl.getAllRegionLocations().size());
    }

    @Test
    public void testSystemCatalogDoesNotSplit() throws Exception {
        HBaseTestingUtility testUtil = SystemCatalogRollbackEnabledIT.getUtility();
        for (int i = 0; i < 10; ++i) {
            this.createTableAndTenantViews("schema" + i + ".table_" + i);
        }
        TableName systemCatalog = TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
        this.assertNumRegions(testUtil, systemCatalog, 1);
        try {
            testUtil.getAdmin().split(systemCatalog);
            testUtil.getAdmin().disableTable(systemCatalog);
            testUtil.getAdmin().enableTable(systemCatalog);
            Assert.fail((String)String.format("Splitting %s should have failed", systemCatalog.getNameAsString()));
        }
        catch (DoNotRetryIOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("NOT splittable"));
        }
        this.assertNumRegions(testUtil, systemCatalog, 1);
    }

    @Test
    public void testAddColumnOnParentFails() throws Exception {
        try (Connection conn = DriverManager.getConnection(SystemCatalogRollbackEnabledIT.getUrl());){
            String parentTableName = SchemaUtil.getTableName((String)SystemCatalogRollbackEnabledIT.generateUniqueName(), (String)SystemCatalogRollbackEnabledIT.generateUniqueName());
            String parentViewName = SchemaUtil.getTableName((String)SystemCatalogRollbackEnabledIT.generateUniqueName(), (String)SystemCatalogRollbackEnabledIT.generateUniqueName());
            String childViewName = SchemaUtil.getTableName((String)SystemCatalogRollbackEnabledIT.generateUniqueName(), (String)SystemCatalogRollbackEnabledIT.generateUniqueName());
            String ddl = "CREATE TABLE " + parentTableName + " (col1 INTEGER NOT NULL, col2 INTEGER CONSTRAINT pk PRIMARY KEY (col1))";
            conn.createStatement().execute(ddl);
            ddl = "CREATE VIEW " + parentViewName + " AS SELECT * FROM " + parentTableName;
            conn.createStatement().execute(ddl);
            try {
                ddl = "ALTER TABLE " + parentTableName + " ADD col4 INTEGER";
                conn.createStatement().execute(ddl);
                Assert.fail((String)"ALTER TABLE ADD should not be allowed on parent table");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            ddl = "CREATE VIEW " + childViewName + "(col3 INTEGER) AS SELECT * FROM " + parentViewName;
            conn.createStatement().execute(ddl);
            try {
                ddl = "ALTER VIEW " + parentViewName + " ADD col4 INTEGER";
                conn.createStatement().execute(ddl);
                Assert.fail((String)"ALTER VIEW ADD should not be allowed on parent view");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            ddl = "ALTER VIEW " + childViewName + " ADD col4 INTEGER";
            conn.createStatement().execute(ddl);
        }
    }

    @Test
    public void testDropColumnOnParentFails() throws Exception {
        try (Connection conn = DriverManager.getConnection(SystemCatalogRollbackEnabledIT.getUrl());){
            String parentTableName = SchemaUtil.getTableName((String)SystemCatalogRollbackEnabledIT.generateUniqueName(), (String)SystemCatalogRollbackEnabledIT.generateUniqueName());
            String parentViewName = SchemaUtil.getTableName((String)SystemCatalogRollbackEnabledIT.generateUniqueName(), (String)SystemCatalogRollbackEnabledIT.generateUniqueName());
            String childViewName = SchemaUtil.getTableName((String)SystemCatalogRollbackEnabledIT.generateUniqueName(), (String)SystemCatalogRollbackEnabledIT.generateUniqueName());
            String ddl = "CREATE TABLE " + parentTableName + " (col1 INTEGER NOT NULL, col2 INTEGER, col3 VARCHAR CONSTRAINT pk PRIMARY KEY (col1))";
            conn.createStatement().execute(ddl);
            ddl = "CREATE VIEW " + parentViewName + " AS SELECT * FROM " + parentTableName;
            conn.createStatement().execute(ddl);
            try {
                ddl = "ALTER TABLE " + parentTableName + " DROP COLUMN col2";
                conn.createStatement().execute(ddl);
                Assert.fail((String)"ALTER TABLE DROP COLUMN should not be allowed on parent table");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            ddl = "CREATE VIEW " + childViewName + "(col5 INTEGER) AS SELECT * FROM " + parentViewName;
            conn.createStatement().execute(ddl);
            try {
                ddl = "ALTER VIEW " + parentViewName + " DROP COLUMN col2";
                conn.createStatement().execute(ddl);
                Assert.fail((String)"ALTER VIEW DROP COLUMN should not be allowed on parent view");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            ddl = "ALTER VIEW " + childViewName + " DROP COLUMN col2";
            conn.createStatement().execute(ddl);
        }
    }

    @Test
    public void testViewDoesNotSeeDataForDroppedColumn() throws Exception {
        String parentName = "T_" + SchemaUtil.getTableName((String)SystemCatalogRollbackEnabledIT.generateUniqueName(), (String)SystemCatalogRollbackEnabledIT.generateUniqueName());
        String viewName = "V_" + SchemaUtil.getTableName((String)SystemCatalogRollbackEnabledIT.generateUniqueName(), (String)SystemCatalogRollbackEnabledIT.generateUniqueName());
        try (Connection conn = DriverManager.getConnection(SystemCatalogRollbackEnabledIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + parentName + " (A INTEGER PRIMARY KEY, B INTEGER, C VARCHAR, D INTEGER)");
            conn.createStatement().execute("CREATE VIEW " + viewName + " (VA INTEGER, VB INTEGER) AS SELECT * FROM " + parentName + " WHERE B=200");
            conn.createStatement().execute("UPSERT INTO " + viewName + " (A,B,C,D,VA,VB) VALUES (2, 200, 'def', -20, 91, 101)");
            conn.commit();
        }
        conn = DriverManager.getConnection(SystemCatalogRollbackEnabledIT.getUrl());
        var4_4 = null;
        try {
            ResultSet rs = conn.createStatement().executeQuery("SELECT A,B,C,D FROM " + parentName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((long)200L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"def", (Object)rs.getString(3));
            Assert.assertEquals((long)-20L, (long)rs.getInt(4));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT A,B,C,D,VA,VB FROM " + viewName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((long)200L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"def", (Object)rs.getString(3));
            Assert.assertEquals((long)-20L, (long)rs.getInt(4));
            Assert.assertEquals((long)91L, (long)rs.getInt(5));
            Assert.assertEquals((long)101L, (long)rs.getInt(6));
            Assert.assertFalse((boolean)rs.next());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(SystemCatalogRollbackEnabledIT.getUrl());
        var4_4 = null;
        try {
            conn.createStatement().execute("ALTER VIEW " + viewName + " DROP COLUMN C");
            try {
                conn.createStatement().executeQuery("SELECT C FROM " + viewName);
                Assert.fail((String)"Expected a ColumnNotFoundException for C since it was dropped");
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }
}

