/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.Table;
import org.apache.phoenix.coprocessor.SystemCatalogRegionObserver;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class SystemCatalogRegionObserverIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)7);
        serverProps.put("phoenix.schema.isNamespaceMappingEnabled", "true");
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)1);
        clientProps.put("phoenix.schema.isNamespaceMappingEnabled", "true");
        SystemCatalogRegionObserverIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    protected Connection getConnection() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
        return DriverManager.getConnection(SystemCatalogRegionObserverIT.getUrl(), props);
    }

    @Test
    public void testSystemCatalogRegionObserverWasAdded() throws Exception {
        try (Connection conn = this.getConnection();){
            PhoenixConnection phoenixConn = conn.unwrap(PhoenixConnection.class);
            Table syscatTable = phoenixConn.getQueryServices().getTable(SchemaUtil.getPhysicalTableName((byte[])PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, (boolean)true).getName());
            Assert.assertTrue((String)"SystemCatalogRegionObserver was not added to SYSTEM.CATALOG", (boolean)syscatTable.getDescriptor().getCoprocessorDescriptors().stream().map(CoprocessorDescriptor::getClassName).collect(Collectors.toList()).contains(SystemCatalogRegionObserver.class.getName()));
        }
    }
}

