/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SyncUpdateCacheFreqIT
extends BaseTest {
    private static final String SCHEMA_NAME = "SCHEMA2";
    private static final String TABLE_NAME = SyncUpdateCacheFreqIT.generateUniqueName();
    private static String tenant_name;
    private static final String GLOBAL_INDEX = "GLOBAL_INDEX";
    private static final String LOCAL_INDEX = "LOCAL_INDEX";
    private static final String VIEW1_NAME = "VIEW1";
    private static final String VIEW1_INDEX1_NAME = "VIEW1_INDEX1";
    private static final String VIEW1_INDEX2_NAME = "VIEW1_INDEX2";
    private static final String VIEW2_NAME = "VIEW2";
    private static final String VIEW2_INDEX1_NAME = "VIEW2_INDEX1";
    private static final String VIEW2_INDEX2_NAME = "VIEW2_INDEX2";
    private static final String VIEW_INDEX_COL = "v2";
    private static final List<String> INDEXS_TO_UPDATE_CACHE_FREQ;
    private static final Map<String, List<String>> TABLE_TO_INDEX;
    private static final Set<String> GLOBAL_TABLES;
    private static final int TABLE_CACHE_FREQ = 5000;
    private static final int VIEW_CACHE_FREQ = 7000;
    private static final Random RANDOM_INT;
    private static final String CREATE_GLOBAL_INDEX = "CREATE INDEX %s ON %s(%s)";
    private static final String CREATE_LOCAL_INDEX = "CREATE LOCAL INDEX %s ON %s(%s)";

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        SyncUpdateCacheFreqIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
        SyncUpdateCacheFreqIT.createBaseTable(SCHEMA_NAME, TABLE_NAME, true, 5000);
        SyncUpdateCacheFreqIT.createIndex(SyncUpdateCacheFreqIT.getConnection(), SCHEMA_NAME, GLOBAL_INDEX, TABLE_NAME, VIEW_INDEX_COL, false);
        SyncUpdateCacheFreqIT.createIndex(SyncUpdateCacheFreqIT.getConnection(), SCHEMA_NAME, LOCAL_INDEX, TABLE_NAME, VIEW_INDEX_COL, true);
    }

    @Test
    public void testSyncCacheFreqWithTenantView() throws Exception {
        for (int i = 1; i <= 3; ++i) {
            tenant_name = "TENANT_" + i;
            try (Connection conn = SyncUpdateCacheFreqIT.getTenantConnection(tenant_name);){
                SyncUpdateCacheFreqIT.createView(conn, SCHEMA_NAME, VIEW1_NAME, TABLE_NAME);
                SyncUpdateCacheFreqIT.createIndex(conn, SCHEMA_NAME, VIEW1_INDEX1_NAME, VIEW1_NAME, VIEW_INDEX_COL, false);
                SyncUpdateCacheFreqIT.createIndex(conn, SCHEMA_NAME, VIEW1_INDEX2_NAME, VIEW1_NAME, VIEW_INDEX_COL, false);
                SyncUpdateCacheFreqIT.createView(conn, SCHEMA_NAME, VIEW2_NAME, VIEW1_NAME);
                SyncUpdateCacheFreqIT.createIndex(conn, SCHEMA_NAME, VIEW2_INDEX1_NAME, VIEW2_NAME, VIEW_INDEX_COL, false);
                SyncUpdateCacheFreqIT.createIndex(conn, SCHEMA_NAME, VIEW2_INDEX2_NAME, VIEW2_NAME, VIEW_INDEX_COL, false);
            }
            conn = (PhoenixConnection)SyncUpdateCacheFreqIT.getConnection();
            var3_3 = null;
            try {
                PreparedStatement stmt = conn.prepareStatement("UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,UPDATE_CACHE_FREQUENCY) VALUES (?, ?, ?, ?)");
                HashMap<String, Long> updatedIndexFreqMap = new HashMap<String, Long>();
                for (String index : INDEXS_TO_UPDATE_CACHE_FREQ) {
                    long updatedCacheFreq = RANDOM_INT.nextInt(4000);
                    updatedIndexFreqMap.put(index, updatedCacheFreq);
                    this.updateCacheFreq(index, updatedCacheFreq, stmt);
                }
                stmt.executeBatch();
                conn.commit();
                ((PhoenixConnection)conn.unwrap(PhoenixConnection.class)).getQueryServices().clearCache();
                for (String table : updatedIndexFreqMap.keySet()) {
                    this.assertTableFrequencies(conn, table, (Long)updatedIndexFreqMap.get(table));
                }
                ((PhoenixConnection)conn.unwrap(PhoenixConnection.class)).getQueryServices().clearCache();
                PhoenixConnection pcon = (PhoenixConnection)conn.unwrap(PhoenixConnection.class);
                pcon.setRunningUpgrade(true);
                UpgradeUtil.syncUpdateCacheFreqAllIndexes((PhoenixConnection)pcon, (PTable)conn.getTableNoCache(SchemaUtil.getTableName((String)SCHEMA_NAME, (String)TABLE_NAME)));
                for (String tableOrView : TABLE_TO_INDEX.keySet()) {
                    long expectedFreqForTableAndIndex = tableOrView.equals(TABLE_NAME) ? 5000L : 7000L;
                    this.assertTableFrequencies(conn, tableOrView, expectedFreqForTableAndIndex);
                    for (String index : TABLE_TO_INDEX.get(tableOrView)) {
                        this.assertTableFrequencies(conn, index, expectedFreqForTableAndIndex);
                    }
                }
                continue;
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (var3_3 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
    }

    private void updateCacheFreq(String tableName, long freq, PreparedStatement stmt) throws SQLException {
        stmt.setString(1, tenant_name);
        stmt.setString(2, SCHEMA_NAME);
        stmt.setString(3, tableName);
        stmt.setLong(4, freq);
        stmt.addBatch();
    }

    private void assertTableFrequencies(Connection conn, String tableName, long expectedCacheFreq) throws SQLException {
        conn.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
        ResultSet rs = GLOBAL_TABLES.contains(tableName) ? conn.createStatement().executeQuery(String.format("SELECT UPDATE_CACHE_FREQUENCY FROM SYSTEM.CATALOG WHERE TABLE_NAME='%s'", tableName)) : conn.createStatement().executeQuery(String.format("SELECT UPDATE_CACHE_FREQUENCY FROM SYSTEM.CATALOG WHERE TABLE_NAME='%s' AND TENANT_ID='%s'", tableName, tenant_name));
        rs.next();
        long cacheFreq = rs.getLong(1);
        Assert.assertEquals((String)("Cache Freq for " + tableName + " not matching. actual: " + cacheFreq + " , expected: " + expectedCacheFreq), (long)expectedCacheFreq, (long)cacheFreq);
    }

    private static void createBaseTable(String schemaName, String tableName, boolean multiTenant, int cacheFre) throws SQLException {
        Connection conn = SyncUpdateCacheFreqIT.getConnection();
        String ddl = "CREATE TABLE " + SchemaUtil.getTableName((String)schemaName, (String)tableName) + " (t_id VARCHAR NOT NULL,\nk1 VARCHAR NOT NULL,\nk2 INTEGER,\nv1 VARCHAR,\n" + VIEW_INDEX_COL + " INTEGER,\nCONSTRAINT pk PRIMARY KEY (t_id, k1))\n";
        String ddlOptions = multiTenant ? "MULTI_TENANT=true" : "";
        ddlOptions = ddlOptions + (ddlOptions.isEmpty() ? "" : ",") + "UPDATE_CACHE_FREQUENCY=" + cacheFre;
        conn.createStatement().execute(ddl + ddlOptions);
        conn.close();
    }

    private static void createIndex(Connection conn, String schemaName, String indexName, String tableName, String indexColumn, boolean isLocal) throws SQLException {
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        conn.createStatement().execute(String.format(isLocal ? CREATE_LOCAL_INDEX : CREATE_GLOBAL_INDEX, indexName, fullTableName, indexColumn));
        conn.commit();
    }

    private static void createView(Connection conn, String schemaName, String viewName, String baseTableName) throws SQLException {
        String fullViewName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)baseTableName);
        conn.createStatement().execute(String.format("CREATE VIEW %s AS SELECT * FROM %s UPDATE_CACHE_FREQUENCY=%s", fullViewName, fullTableName, 7000));
        conn.commit();
    }

    private static Connection getTenantConnection(String tenant) throws SQLException {
        Properties props = new Properties();
        props.setProperty("TenantId", tenant);
        return DriverManager.getConnection(SyncUpdateCacheFreqIT.getUrl(), props);
    }

    private static Connection getConnection() throws SQLException {
        Properties props = new Properties();
        return DriverManager.getConnection(SyncUpdateCacheFreqIT.getUrl(), props);
    }

    static {
        INDEXS_TO_UPDATE_CACHE_FREQ = ImmutableList.of((Object)VIEW1_INDEX1_NAME, (Object)VIEW2_INDEX1_NAME, (Object)VIEW1_INDEX2_NAME, (Object)VIEW2_INDEX2_NAME);
        TABLE_TO_INDEX = ImmutableMap.of((Object)TABLE_NAME, (Object)ImmutableList.of((Object)GLOBAL_INDEX, (Object)LOCAL_INDEX), (Object)VIEW1_NAME, (Object)ImmutableList.of((Object)VIEW1_INDEX1_NAME, (Object)VIEW1_INDEX2_NAME), (Object)VIEW2_NAME, (Object)ImmutableList.of((Object)VIEW2_INDEX1_NAME, (Object)VIEW2_INDEX2_NAME));
        GLOBAL_TABLES = ImmutableSet.of((Object)GLOBAL_INDEX, (Object)LOCAL_INDEX, (Object)TABLE_NAME);
        RANDOM_INT = new Random();
    }
}

