/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class StatementHintsIT
extends ParallelStatsDisabledIT {
    private static final String TABLE_NAME = StatementHintsIT.generateUniqueName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTableValues() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(StatementHintsIT.getUrl(), props);){
            String ddl = "CREATE TABLE " + TABLE_NAME + "   (a_integer integer not null, \n    a_string varchar not null, \n    a_id char(3) not null,\n    b_string varchar \n    CONSTRAINT pk PRIMARY KEY (a_integer, a_string, a_id))\n";
            StatementHintsIT.createTestTable(StatementHintsIT.getUrl(), ddl);
            String query = "UPSERT INTO " + TABLE_NAME + "(a_integer, a_string, a_id, b_string) VALUES(?,?,?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setInt(1, 1);
            stmt.setString(2, "ab");
            stmt.setString(3, "123");
            stmt.setString(4, "abc");
            stmt.execute();
            stmt.setInt(1, 1);
            stmt.setString(2, "abc");
            stmt.setString(3, "456");
            stmt.setString(4, "abc");
            stmt.execute();
            stmt.setInt(1, 1);
            stmt.setString(2, "de");
            stmt.setString(3, "123");
            stmt.setString(4, "abc");
            stmt.execute();
            stmt.setInt(1, 2);
            stmt.setString(2, "abc");
            stmt.setString(3, "123");
            stmt.setString(4, "def");
            stmt.execute();
            stmt.setInt(1, 3);
            stmt.setString(2, "abc");
            stmt.setString(3, "123");
            stmt.setString(4, "ghi");
            stmt.execute();
            stmt.setInt(1, 4);
            stmt.setString(2, "abc");
            stmt.setString(3, "123");
            stmt.setString(4, "jkl");
            stmt.execute();
            conn.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectForceRangeScan() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(StatementHintsIT.getUrl(), props);){
            StatementHintsIT.initTableValues();
            String query = "SELECT /*+ RANGE_SCAN */ * FROM " + TABLE_NAME + " WHERE a_integer IN (1, 2, 3, 4)";
            PreparedStatement stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"def", (Object)rs.getString(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectForceSkipScan() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(StatementHintsIT.getUrl(), props);){
            StatementHintsIT.initTableValues();
            String query = "SELECT /*+ SKIP_SCAN */ * FROM " + TABLE_NAME + " WHERE a_string = 'abc'";
            PreparedStatement stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"456", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

