/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.File;
import java.io.FileFilter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class SpooledTmpFileDeleteIT
extends ParallelStatsDisabledIT {
    private static final String PRINCIPAL = "noRenewLease";
    private File spoolDir;
    private String tableName;

    private Connection getConnection() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.spool.directory", this.spoolDir.getPath());
        props.setProperty("phoenix.query.client.spoolThresholdBytes", Integer.toString(1));
        props.setProperty("phoenix.scanner.lease.renew.enabled", Boolean.toString(false));
        props.setProperty("phoenix.query.force.rowkeyorder", Boolean.toString(true));
        props.setProperty("phoenix.jdbc.extra.arguments", "");
        String url = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)PRINCIPAL);
        return DriverManager.getConnection(url, props);
    }

    @Before
    public void setup() throws Exception {
        this.tableName = SpooledTmpFileDeleteIT.generateUniqueName();
        this.spoolDir = TestUtil.createTempDirectory().toFile();
        try (Connection conn = this.getConnection();){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + this.tableName + " (ID varchar NOT NULL PRIMARY KEY) SPLIT ON ('EA','EZ')");
            stmt.execute("UPSERT INTO " + this.tableName + " VALUES ('AA')");
            stmt.execute("UPSERT INTO " + this.tableName + " VALUES ('EB')");
            stmt.execute("UPSERT INTO " + this.tableName + " VALUES ('FA')");
            stmt.close();
            conn.commit();
        }
    }

    @After
    public void tearDown() throws Exception {
        boolean refCountLeaked = SpooledTmpFileDeleteIT.isAnyStoreRefCountLeaked();
        if (this.spoolDir != null) {
            this.spoolDir.delete();
        }
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    @Test
    public void testDeleteAllSpooledTmpFiles() throws SQLException, Throwable {
        File dir = new File(this.spoolDir.getPath());
        File[] files = null;
        class FilenameFilter
        implements FileFilter {
            FilenameFilter() {
            }

            @Override
            public boolean accept(File dir) {
                return dir.getName().toLowerCase().endsWith(".bin") && dir.getName().startsWith("ResultSpooler");
            }
        }
        FilenameFilter fnameFilter = new FilenameFilter();
        for (File file : files = dir.listFiles(fnameFilter)) {
            file.delete();
        }
        String query = "select * from " + this.tableName;
        Connection conn = this.getConnection();
        Statement statement = conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        files = dir.listFiles(fnameFilter);
        Assert.assertTrue((files.length > 0 ? 1 : 0) != 0);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : files) {
            fileNames.add(file.getName());
        }
        String preparedQuery = "select * from " + this.tableName + " where id = ?";
        PreparedStatement pstmt = conn.prepareStatement(preparedQuery);
        pstmt.setString(1, "EB");
        ResultSet prs = pstmt.executeQuery(preparedQuery);
        Assert.assertTrue((boolean)prs.next());
        files = dir.listFiles(fnameFilter);
        Assert.assertTrue((files.length > 0 ? 1 : 0) != 0);
        for (File file : files) {
            fileNames.add(file.getName());
        }
        Connection connection = this.getConnection();
        String query2 = "select * from " + this.tableName + "";
        Statement statement2 = connection.createStatement();
        ResultSet rs2 = statement2.executeQuery(query2);
        Assert.assertTrue((boolean)rs2.next());
        files = dir.listFiles(fnameFilter);
        Assert.assertTrue((files.length > 0 ? 1 : 0) != 0);
        String preparedQuery2 = "select * from " + this.tableName + " where id = ?";
        PreparedStatement pstmt2 = connection.prepareStatement(preparedQuery2);
        pstmt2.setString(1, "EB");
        ResultSet prs2 = pstmt2.executeQuery(preparedQuery2);
        Assert.assertTrue((boolean)prs2.next());
        files = dir.listFiles(fnameFilter);
        Assert.assertTrue((files.length > 0 ? 1 : 0) != 0);
        conn.close();
        for (File file : files = dir.listFiles(fnameFilter)) {
            Assert.assertFalse((boolean)fileNames.contains(file.getName()));
        }
        connection.close();
        files = dir.listFiles(fnameFilter);
        Assert.assertTrue((files.length == 0 ? 1 : 0) != 0);
    }
}

