/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.BeforeClass;

public abstract class SplitSystemCatalogIT
extends BaseTest {
    protected static String SCHEMA1 = "SCHEMA1";
    protected static String SCHEMA2 = "SCHEMA2";
    protected static String SCHEMA3 = "SCHEMA3";
    protected static String SCHEMA4 = "SCHEMA4";
    protected static String TENANT1 = "tenant1";
    protected static String TENANT2 = "tenant2";

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        SplitSystemCatalogIT.doSetup(null);
    }

    public static synchronized void doSetup(Map<String, String> props) throws Exception {
        NUM_SLAVES_BASE = 6;
        if (props == null) {
            props = Collections.emptyMap();
        }
        boolean splitSystemCatalog = driver == null;
        SplitSystemCatalogIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
        if (splitSystemCatalog) {
            SplitSystemCatalogIT.getUtility().getHBaseCluster().getMaster().balanceSwitch(false);
            SplitSystemCatalogIT.splitSystemCatalog();
        }
    }

    protected static void splitSystemCatalog() throws Exception {
        Connection ignored = DriverManager.getConnection(SplitSystemCatalogIT.getUrl());
        Throwable throwable = null;
        if (ignored != null) {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ignored.close();
            }
        }
        String tableName = "TABLE";
        String fullTableName1 = SchemaUtil.getTableName((String)SCHEMA1, (String)tableName);
        String fullTableName2 = SchemaUtil.getTableName((String)SCHEMA2, (String)tableName);
        String fullTableName3 = SchemaUtil.getTableName((String)SCHEMA3, (String)tableName);
        String fullTableName4 = SchemaUtil.getTableName((String)SCHEMA4, (String)tableName);
        ArrayList tableList = Lists.newArrayList((Object[])new String[]{fullTableName1, fullTableName2, fullTableName3});
        HashMap tenantToTableMap = Maps.newHashMap();
        tenantToTableMap.put(null, tableList);
        tenantToTableMap.put(TENANT1, Lists.newArrayList((Object[])new String[]{fullTableName2, fullTableName3}));
        tenantToTableMap.put(TENANT2, Lists.newArrayList((Object[])new String[]{fullTableName4}));
        SplitSystemCatalogIT.splitSystemCatalog(tenantToTableMap);
    }
}

