/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionStatesCount;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.SortOrderIT;
import org.apache.phoenix.iterate.ScanningResultPostDummyResultCaller;
import org.apache.phoenix.iterate.ScanningResultPostValidResultCaller;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class SortOrderWithRegionMovesIT
extends SortOrderIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortOrderWithRegionMovesIT.class);
    private static int countOfValidResults = 0;
    protected static boolean hasTestStarted = false;
    protected static int countOfDummyResults = 0;

    @Before
    public void setUp() throws Exception {
        hasTestStarted = true;
        this.baseTableName = SortOrderWithRegionMovesIT.generateUniqueName();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        countOfDummyResults = 0;
        countOfValidResults = 0;
        TABLE_NAMES.clear();
        hasTestStarted = false;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        props.put("phoenix.server.page.size.ms", Long.toString(0L));
        props.put("phoenix.tests.minicluster.numregionservers", String.valueOf(2));
        props.put("hbase.client.scanner.max.result.size", String.valueOf(1));
        props.put("phoenix.scanning.result.post.dummy.process", TestScanningResultPostDummyResultCaller.class.getName());
        props.put("phoenix.scanning.result.post.valid.process", TestScanningResultPostValidResultCaller.class.getName());
        SortOrderWithRegionMovesIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @AfterClass
    public static synchronized void freeResources() throws Exception {
        BaseTest.freeResourcesIfBeyondThreshold();
    }

    private static void moveRegionsOfTable(String tableName) throws IOException {
        try (AsyncConnection asyncConnection = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)SortOrderWithRegionMovesIT.getUtility().getConfiguration()).get();){
            AsyncAdmin admin = asyncConnection.getAdmin();
            ArrayList servers = new ArrayList((Collection)admin.getRegionServers().get());
            ServerName server1 = (ServerName)servers.get(0);
            ServerName server2 = (ServerName)servers.get(1);
            List regionsOnServer1 = (List)admin.getRegions(server1).get();
            List regionsOnServer2 = (List)admin.getRegions(server2).get();
            regionsOnServer1.forEach(regionInfo -> {
                if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                    try {
                        for (int i = 0; i < 2; ++i) {
                            RegionStatesCount regionStatesCount = (RegionStatesCount)((ClusterMetrics)admin.getClusterMetrics().get()).getTableRegionStatesCount().get(TableName.valueOf((String)tableName));
                            if (regionStatesCount.getRegionsInTransition() == 0 && regionStatesCount.getOpenRegions() == regionStatesCount.getTotalRegions()) {
                                LOGGER.info("Moving region {} to {}", (Object)regionInfo.getRegionNameAsString(), (Object)server2);
                                admin.move(regionInfo.getEncodedNameAsBytes(), server2).get(3L, TimeUnit.SECONDS);
                                break;
                            }
                            LOGGER.info("Table {} has some region(s) in RIT or not online", (Object)tableName);
                        }
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        LOGGER.error("Something went wrong", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
            regionsOnServer2.forEach(regionInfo -> {
                if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                    try {
                        for (int i = 0; i < 2; ++i) {
                            RegionStatesCount regionStatesCount = (RegionStatesCount)((ClusterMetrics)admin.getClusterMetrics().get()).getTableRegionStatesCount().get(TableName.valueOf((String)tableName));
                            if (regionStatesCount.getRegionsInTransition() == 0 && regionStatesCount.getOpenRegions() == regionStatesCount.getTotalRegions()) {
                                admin.move(regionInfo.getEncodedNameAsBytes(), server1).get(3L, TimeUnit.SECONDS);
                                LOGGER.info("Moving region {} to {}", (Object)regionInfo.getRegionNameAsString(), (Object)server1);
                                break;
                            }
                            LOGGER.info("Table {} has some region(s) in RIT or not online", (Object)tableName);
                        }
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        LOGGER.error("Something went wrong", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Something went wrong..", (Throwable)e);
        }
    }

    private static class TestScanningResultPostValidResultCaller
    extends ScanningResultPostValidResultCaller {
        private TestScanningResultPostValidResultCaller() {
        }

        public void postValidRowProcess() {
            if (hasTestStarted && (countOfValidResults < 17 || countOfValidResults > 28 && countOfValidResults < 40)) {
                LOGGER.info("Moving regions of tables {}. current count of valid results: {}", SortOrderIT.TABLE_NAMES, (Object)countOfValidResults);
                countOfValidResults++;
                SortOrderIT.TABLE_NAMES.forEach(table -> {
                    try {
                        SortOrderWithRegionMovesIT.moveRegionsOfTable(table);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to move regions of table: {}", table);
                    }
                });
            }
        }
    }

    private static class TestScanningResultPostDummyResultCaller
    extends ScanningResultPostDummyResultCaller {
        private TestScanningResultPostDummyResultCaller() {
        }

        public void postDummyProcess() {
            if (hasTestStarted && countOfDummyResults++ % 3 == 0 && (countOfDummyResults < 17 || countOfDummyResults > 28 && countOfDummyResults < 40)) {
                LOGGER.info("Moving regions of tables {}. current count of dummy results: {}", SortOrderIT.TABLE_NAMES, (Object)countOfDummyResults);
                SortOrderIT.TABLE_NAMES.forEach(table -> {
                    try {
                        SortOrderWithRegionMovesIT.moveRegionsOfTable(table);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to move regions of table: {}", table);
                    }
                });
            }
        }
    }
}

