/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.util.HashMap;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledWithRegionMovesIT;
import org.apache.phoenix.end2end.SortOrderIT;
import org.apache.phoenix.iterate.ScanningResultPostValidResultCaller;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.StaleRegionBoundaryCacheException;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class SortOrderWithRegionMoves2IT
extends SortOrderIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortOrderWithRegionMoves2IT.class);
    private static int countOfValidResults = 0;
    protected static boolean hasTestStarted = false;

    @Before
    public void setUp() throws Exception {
        hasTestStarted = true;
        this.baseTableName = SortOrderWithRegionMoves2IT.generateUniqueName();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        countOfValidResults = 0;
        TABLE_NAMES.clear();
        hasTestStarted = false;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        props.put("phoenix.server.page.size.ms", Long.toString(0L));
        props.put("phoenix.tests.minicluster.numregionservers", String.valueOf(2));
        props.put("hbase.client.scanner.max.result.size", String.valueOf(1));
        props.put("phoenix.scanning.result.post.valid.process", TestScanningResultPostValidResultCaller.class.getName());
        SortOrderWithRegionMoves2IT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @AfterClass
    public static synchronized void freeResources() throws Exception {
        BaseTest.freeResourcesIfBeyondThreshold();
    }

    @Override
    @Test
    public void sumDescCompositePK() throws Exception {
        try {
            super.sumDescCompositePK();
        }
        catch (StaleRegionBoundaryCacheException e) {
            hasTestStarted = false;
            LOGGER.error("Rows could not be scanned because of stale region boundary. Try again.");
            super.sumDescCompositePK();
        }
    }

    @Override
    @Test
    public void queryDescDateWithExplicitOrderBy() throws Exception {
        try {
            super.queryDescDateWithExplicitOrderBy();
        }
        catch (StaleRegionBoundaryCacheException e) {
            hasTestStarted = false;
            LOGGER.error("Rows could not be scanned because of stale region boundary. Try again.");
            super.queryDescDateWithExplicitOrderBy();
        }
    }

    @Override
    @Test
    public void avgDescCompositePK() throws Exception {
        try {
            super.avgDescCompositePK();
        }
        catch (StaleRegionBoundaryCacheException e) {
            hasTestStarted = false;
            LOGGER.error("Rows could not be scanned because of stale region boundary. Try again.");
            super.avgDescCompositePK();
        }
    }

    @Override
    @Test
    public void countDescCompositePK() throws Exception {
        try {
            super.countDescCompositePK();
        }
        catch (StaleRegionBoundaryCacheException e) {
            hasTestStarted = false;
            LOGGER.error("Rows could not be scanned because of stale region boundary. Try again.");
            super.countDescCompositePK();
        }
    }

    @Override
    @Test
    public void descVarLengthDescPKGT() throws Exception {
        try {
            super.descVarLengthDescPKGT();
        }
        catch (StaleRegionBoundaryCacheException e) {
            hasTestStarted = false;
            LOGGER.error("Rows could not be scanned because of stale region boundary. Try again.");
            super.descVarLengthDescPKGT();
        }
    }

    @Override
    @Test
    public void havingSumDescCompositePK() throws Exception {
        try {
            super.havingSumDescCompositePK();
        }
        catch (StaleRegionBoundaryCacheException e) {
            hasTestStarted = false;
            LOGGER.error("Rows could not be scanned because of stale region boundary. Try again.");
            super.havingSumDescCompositePK();
        }
    }

    @Override
    @Test
    public void minDescCompositePK() throws Exception {
        try {
            super.minDescCompositePK();
        }
        catch (StaleRegionBoundaryCacheException e) {
            hasTestStarted = false;
            LOGGER.error("Rows could not be scanned because of stale region boundary. Try again.");
            super.minDescCompositePK();
        }
    }

    @Override
    @Test
    public void descVarLengthAscPKGT() throws Exception {
        try {
            super.descVarLengthAscPKGT();
        }
        catch (StaleRegionBoundaryCacheException e) {
            hasTestStarted = false;
            LOGGER.error("Rows could not be scanned because of stale region boundary. Try again.");
            super.descVarLengthAscPKGT();
        }
    }

    @Override
    @Test
    public void maxDescCompositePK() throws Exception {
        try {
            super.maxDescCompositePK();
        }
        catch (StaleRegionBoundaryCacheException e) {
            hasTestStarted = false;
            LOGGER.error("Rows could not be scanned because of stale region boundary. Try again.");
            super.maxDescCompositePK();
        }
    }

    private static class TestScanningResultPostValidResultCaller
    extends ScanningResultPostValidResultCaller {
        private TestScanningResultPostValidResultCaller() {
        }

        public void postValidRowProcess() {
            if (hasTestStarted && countOfValidResults <= 1) {
                LOGGER.info("Splitting regions of tables {}. current count of valid results: {}", SortOrderIT.TABLE_NAMES, (Object)countOfValidResults);
                countOfValidResults++;
                SortOrderIT.TABLE_NAMES.forEach(table -> {
                    try {
                        ParallelStatsDisabledWithRegionMovesIT.splitAllRegionsOfTable(table, 2);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to move regions of table: {}", table);
                    }
                });
            }
        }
    }
}

