/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class SignFunctionEnd2EndIT
extends ParallelStatsDisabledIT {
    private static final String KEY = "key";
    private String signedTableName;
    private String unsignedTableName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void initTable() throws Exception {
        this.signedTableName = SignFunctionEnd2EndIT.generateUniqueName();
        this.unsignedTableName = SignFunctionEnd2EndIT.generateUniqueName();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(SignFunctionEnd2EndIT.getUrl());
            String ddl = "CREATE TABLE " + this.signedTableName + " (k VARCHAR NOT NULL PRIMARY KEY, \"DEC\" DECIMAL, doub DOUBLE, fl FLOAT, inte INTEGER, lon BIGINT, smalli SMALLINT, tinyi TINYINT)";
            conn.createStatement().execute(ddl);
            ddl = "CREATE TABLE " + this.unsignedTableName + " (k VARCHAR NOT NULL PRIMARY KEY, doub UNSIGNED_DOUBLE, fl UNSIGNED_FLOAT, inte UNSIGNED_INT, lon UNSIGNED_LONG, smalli UNSIGNED_SMALLINT, tinyi UNSIGNED_TINYINT)";
            conn.createStatement().execute(ddl);
            conn.commit();
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    private void updateSignedTable(Connection conn, double data) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.signedTableName + " VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, KEY);
        Double d = data;
        stmt.setBigDecimal(2, BigDecimal.valueOf(data));
        stmt.setDouble(3, d);
        stmt.setFloat(4, d.floatValue());
        stmt.setInt(5, d.intValue());
        stmt.setLong(6, d.longValue());
        stmt.setShort(7, d.shortValue());
        stmt.setByte(8, d.byteValue());
        stmt.executeUpdate();
        conn.commit();
    }

    private void updateUnsignedTable(Connection conn, double data) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.unsignedTableName + " VALUES (?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, KEY);
        Double d = data;
        stmt.setDouble(2, d);
        stmt.setFloat(3, d.floatValue());
        stmt.setInt(4, d.intValue());
        stmt.setLong(5, d.longValue());
        stmt.setShort(6, d.shortValue());
        stmt.setByte(7, d.byteValue());
        stmt.executeUpdate();
        conn.commit();
    }

    private void testSignedNumberSpec(Connection conn, double data, int expected) throws Exception {
        this.updateSignedTable(conn, data);
        ResultSet rs = conn.createStatement().executeQuery("SELECT SIGN(\"DEC\"),SIGN(doub),SIGN(fl),SIGN(inte),SIGN(lon),SIGN(smalli),SIGN(tinyi) FROM " + this.signedTableName);
        Assert.assertTrue((boolean)rs.next());
        for (int i = 1; i <= 7; ++i) {
            Assert.assertEquals((long)rs.getInt(i), (long)expected);
        }
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        PreparedStatement stmt = conn.prepareStatement("SELECT k FROM " + this.signedTableName + " WHERE SIGN(\"DEC\")=? AND SIGN(doub)=? AND SIGN(fl)=? AND SIGN(inte)=? AND SIGN(lon)=? AND SIGN(smalli)=? AND SIGN(tinyi)=?");
        for (int i = 1; i <= 7; ++i) {
            stmt.setInt(i, expected);
        }
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)KEY, (Object)rs.getString(1));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
    }

    private void testUnsignedNumberSpec(Connection conn, double data, int expected) throws Exception {
        this.updateUnsignedTable(conn, data);
        ResultSet rs = conn.createStatement().executeQuery("SELECT SIGN(doub),SIGN(fl),SIGN(inte),SIGN(lon),SIGN(smalli),SIGN(tinyi) FROM " + this.unsignedTableName);
        Assert.assertTrue((boolean)rs.next());
        for (int i = 1; i <= 6; ++i) {
            Assert.assertEquals((long)rs.getInt(i), (long)expected);
        }
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        PreparedStatement stmt = conn.prepareStatement("SELECT k FROM " + this.unsignedTableName + " WHERE SIGN(doub)=? AND SIGN(fl)=? AND SIGN(inte)=? AND SIGN(lon)=? AND SIGN(smalli)=? AND SIGN(tinyi)=?");
        for (int i = 1; i <= 6; ++i) {
            stmt.setInt(i, expected);
        }
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)KEY, (Object)rs.getString(1));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
    }

    @Test
    public void testSignedNumber() throws Exception {
        Connection conn = DriverManager.getConnection(SignFunctionEnd2EndIT.getUrl());
        this.testSignedNumberSpec(conn, 0.0, 0);
        this.testSignedNumberSpec(conn, 1.0, 1);
        this.testSignedNumberSpec(conn, -1.0, -1);
        this.testSignedNumberSpec(conn, 123.1234, 1);
        this.testSignedNumberSpec(conn, -123.1234, -1);
    }

    @Test
    public void testUnsignedNumber() throws Exception {
        Connection conn = DriverManager.getConnection(SignFunctionEnd2EndIT.getUrl());
        this.testUnsignedNumberSpec(conn, 0.0, 0);
        this.testUnsignedNumberSpec(conn, 1.0, 1);
        this.testUnsignedNumberSpec(conn, 123.1234, 1);
    }
}

