/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ShowCreateTableIT
extends ParallelStatsDisabledIT {
    @Test
    public void testShowCreateTableBasic() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(ShowCreateTableIT.getUrl(), props);
        String tableName = ShowCreateTableIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER, INT2 INTEGER)";
        conn.createStatement().execute(ddl);
        ResultSet rs = conn.createStatement().executeQuery("SHOW CREATE TABLE " + tableName);
        Assert.assertTrue((boolean)rs.next());
        String expected = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER, INT2 INTEGER) IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN'";
        Assert.assertTrue((String)("Expected: :" + expected + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).equals(expected));
    }

    @Test
    public void testShowCreateTableLowerCase() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(ShowCreateTableIT.getUrl(), props);
        String tableName = "lowercasetbl1";
        String ddl = "CREATE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER)";
        conn.createStatement().execute(ddl);
        ResultSet rs = conn.createStatement().executeQuery("SHOW CREATE TABLE \"" + tableName + "\"");
        Assert.assertTrue((boolean)rs.next());
        String expected = "CREATE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER) IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN'";
        Assert.assertTrue((String)("Expected: :" + expected + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).equals(expected));
    }

    @Test
    public void testShowCreateTableUpperCase() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(ShowCreateTableIT.getUrl(), props);
        String tableName = ShowCreateTableIT.generateUniqueName();
        String schemaName = ShowCreateTableIT.generateUniqueName();
        String tableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String ddl = "CREATE TABLE " + tableFullName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER)";
        conn.createStatement().execute(ddl);
        ResultSet rs = conn.createStatement().executeQuery("SHOW CREATE TABLE " + tableFullName);
        Assert.assertTrue((boolean)rs.next());
        String expected = "CREATE TABLE " + tableFullName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER) IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN'";
        Assert.assertTrue((String)("Expected: :" + expected + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).equals(expected));
    }

    @Test
    public void testShowCreateTableDefaultFamily() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(ShowCreateTableIT.getUrl(), props);
        String tableName = ShowCreateTableIT.generateUniqueName();
        String ddl = "CREATE IMMUTABLE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT1 INTEGER, INT2 INTEGER, a.INT3 INTEGER, \"A\".INT4 INTEGER, \"b\".INT5 INTEGER, \"B\".INT6 INTEGER) DEFAULT_COLUMN_FAMILY='dF'";
        conn.createStatement().execute(ddl);
        ResultSet rs = conn.createStatement().executeQuery("SHOW CREATE TABLE " + tableName);
        Assert.assertTrue((boolean)rs.next());
        String expected = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, \"dF\".INT1 INTEGER, \"dF\".INT2 INTEGER, A.INT3 INTEGER, A.INT4 INTEGER, \"b\".INT5 INTEGER, B.INT6 INTEGER) IMMUTABLE_ROWS=true, DEFAULT_COLUMN_FAMILY='dF'";
        Assert.assertTrue((String)("Expected: :" + expected + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).equals(expected));
    }

    @Test
    public void testShowCreateTableDefaultFamilyNonConsecutive() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(ShowCreateTableIT.getUrl(), props);
        String tableName = ShowCreateTableIT.generateUniqueName();
        String ddl = "CREATE IMMUTABLE TABLE \"" + tableName + "\"(K VARCHAR NOT NULL PRIMARY KEY, INT1 INTEGER, INT2 INTEGER, a.INT3 INTEGER, \"A\".INT4 INTEGER, \"b\".INT5 INTEGER, \"B\".INT6 INTEGER) DEFAULT_COLUMN_FAMILY='dF'";
        conn.createStatement().execute(ddl);
        String dropInt2 = "ALTER TABLE " + tableName + " DROP COLUMN INT2, INT4, INT5";
        conn.createStatement().execute(dropInt2);
        ResultSet rs = conn.createStatement().executeQuery("SHOW CREATE TABLE " + tableName);
        Assert.assertTrue((boolean)rs.next());
        String expected = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, \"dF\".INT1 INTEGER ENCODED_QUALIFIER " + 11 + ", A.INT3 INTEGER ENCODED_QUALIFIER " + 11 + ", B.INT6 INTEGER) IMMUTABLE_ROWS=true, DEFAULT_COLUMN_FAMILY='dF' COLUMN_QUALIFIER_COUNTER ('A'=" + 13 + ", 'dF'=" + 13 + ")";
        Assert.assertTrue((String)("Expected: :" + expected + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).equals(expected));
    }

    @Test
    public void testShowCreateTableCounter() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(ShowCreateTableIT.getUrl(), props);
        String tableName = ShowCreateTableIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER ENCODED_QUALIFIER " + 11 + ", INT2 INTEGER ENCODED_QUALIFIER " + 12 + ") IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN' COLUMN_QUALIFIER_COUNTER ('" + "0" + "'=" + 14 + ")";
        conn.createStatement().execute(ddl);
        ResultSet rs = conn.createStatement().executeQuery("SHOW CREATE TABLE " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((String)("Expected: :" + ddl + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).equals(ddl));
    }

    @Test
    public void testShowCreateTableColumnQualifierNonConsecutive() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(ShowCreateTableIT.getUrl(), props);
        String tableName = ShowCreateTableIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER, INT2 INTEGER, INT3 INTEGER)";
        conn.createStatement().execute(ddl);
        String dropInt2 = "ALTER TABLE " + tableName + " DROP COLUMN INT3";
        conn.createStatement().execute(dropInt2);
        ResultSet rs = conn.createStatement().executeQuery("SHOW CREATE TABLE \"" + tableName + "\"");
        Assert.assertTrue((boolean)rs.next());
        String expected = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER ENCODED_QUALIFIER " + 11 + ", INT2 INTEGER ENCODED_QUALIFIER " + 12 + ") IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN' COLUMN_QUALIFIER_COUNTER ('" + "0" + "'=" + 14 + ")";
        Assert.assertTrue((String)("Expected: :" + expected + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).equals(expected));
        tableName = ShowCreateTableIT.generateUniqueName();
        ddl = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER, INT2 INTEGER, INT3 INTEGER)";
        conn.createStatement().execute(ddl);
        dropInt2 = "ALTER TABLE " + tableName + " DROP COLUMN INT";
        conn.createStatement().execute(dropInt2);
        rs = conn.createStatement().executeQuery("SHOW CREATE TABLE \"" + tableName + "\"");
        Assert.assertTrue((boolean)rs.next());
        expected = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, INT2 INTEGER ENCODED_QUALIFIER " + 12 + ", INT3 INTEGER ENCODED_QUALIFIER " + 13 + ") IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN'";
        Assert.assertTrue((String)("Expected: :" + expected + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).equals(expected));
        tableName = ShowCreateTableIT.generateUniqueName();
        ddl = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER, INT2 INTEGER, INT3 INTEGER)";
        conn.createStatement().execute(ddl);
        dropInt2 = "ALTER TABLE " + tableName + " DROP COLUMN INT2";
        conn.createStatement().execute(dropInt2);
        rs = conn.createStatement().executeQuery("SHOW CREATE TABLE \"" + tableName + "\"");
        Assert.assertTrue((boolean)rs.next());
        expected = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER ENCODED_QUALIFIER " + 11 + ", INT3 INTEGER ENCODED_QUALIFIER " + 13 + ") IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN'";
        Assert.assertTrue((String)("Expected: :" + expected + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).equals(expected));
    }

    @Test
    public void testShowCreateTableColumnQualifierDropAndAdd() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(ShowCreateTableIT.getUrl(), props);
        String tableName = ShowCreateTableIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER, INT2 INTEGER, INT3 INTEGER)";
        conn.createStatement().execute(ddl);
        String dropInt3 = "ALTER TABLE " + tableName + " DROP COLUMN INT3";
        conn.createStatement().execute(dropInt3);
        String addInt4 = "ALTER TABLE " + tableName + " ADD INT4 INTEGER";
        conn.createStatement().execute(addInt4);
        ResultSet rs = conn.createStatement().executeQuery("SHOW CREATE TABLE \"" + tableName + "\"");
        Assert.assertTrue((boolean)rs.next());
        String expected = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER ENCODED_QUALIFIER " + 11 + ", INT2 INTEGER ENCODED_QUALIFIER " + 12 + ", INT4 INTEGER ENCODED_QUALIFIER " + 14 + ") IMMUTABLE_STORAGE_SCHEME='ONE_CELL_PER_COLUMN'";
        Assert.assertTrue((String)("Expected: :" + expected + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).equals(expected));
    }

    @Test
    public void testShowCreateTableColumnQualifierMultipleFamilies() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(ShowCreateTableIT.getUrl(), props);
        String tableName = ShowCreateTableIT.generateUniqueName();
        String ddl = "CREATE IMMUTABLE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, A.INT INTEGER, B.INT2 INTEGER) IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS";
        conn.createStatement().execute(ddl);
        ResultSet rs = conn.createStatement().executeQuery("SHOW CREATE TABLE \"" + tableName + "\"");
        Assert.assertTrue((boolean)rs.next());
        String expected = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, A.INT INTEGER, B.INT2 INTEGER) IMMUTABLE_ROWS=true";
        Assert.assertTrue((String)("Expected: :" + expected + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).equals(expected));
    }

    @Test
    public void testShowCreateTableColumnQualifierMultipleFamiliesNonConsecutive() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(ShowCreateTableIT.getUrl(), props);
        String tableName = ShowCreateTableIT.generateUniqueName();
        String ddl = "CREATE IMMUTABLE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, A.INT INTEGER, A.INT2 INTEGER, B.INT3 INTEGER, B.INT4 INTEGER) IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS";
        conn.createStatement().execute(ddl);
        String dropInt = "ALTER TABLE " + tableName + " DROP COLUMN INT4";
        conn.createStatement().execute(dropInt);
        ResultSet rs = conn.createStatement().executeQuery("SHOW CREATE TABLE \"" + tableName + "\"");
        Assert.assertTrue((boolean)rs.next());
        String expected = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, A.INT INTEGER, A.INT2 INTEGER, B.INT3 INTEGER ENCODED_QUALIFIER " + 11 + ") IMMUTABLE_ROWS=true COLUMN_QUALIFIER_COUNTER ('B'=" + 13 + ")";
        Assert.assertTrue((String)("Expected: :" + expected + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).equals(expected));
        tableName = ShowCreateTableIT.generateUniqueName();
        ddl = "CREATE IMMUTABLE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, A.INT INTEGER, A.INT2 INTEGER, B.INT3 INTEGER, B.INT4 INTEGER) IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS";
        conn.createStatement().execute(ddl);
        dropInt = "ALTER TABLE " + tableName + " DROP COLUMN INT2, INT3";
        conn.createStatement().execute(dropInt);
        rs = conn.createStatement().executeQuery("SHOW CREATE TABLE \"" + tableName + "\"");
        Assert.assertTrue((boolean)rs.next());
        expected = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, A.INT INTEGER ENCODED_QUALIFIER " + 11 + ", B.INT4 INTEGER ENCODED_QUALIFIER " + 12 + ") IMMUTABLE_ROWS=true COLUMN_QUALIFIER_COUNTER ('A'=" + 13 + ")";
        Assert.assertTrue((String)("Expected: :" + expected + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).equals(expected));
    }

    @Test
    public void testShowCreateTableView() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(ShowCreateTableIT.getUrl(), props);
        String tableName = ShowCreateTableIT.generateUniqueName();
        String viewName = ShowCreateTableIT.generateUniqueName();
        String schemaName = ShowCreateTableIT.generateUniqueName();
        String tableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
        String viewFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)viewName);
        String ddl = "CREATE TABLE " + tableFullName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER)";
        conn.createStatement().execute(ddl);
        String ddlView = "CREATE VIEW " + viewFullName + " AS SELECT * FROM " + tableFullName;
        conn.createStatement().execute(ddlView);
        ResultSet rs = conn.createStatement().executeQuery("SHOW CREATE TABLE " + viewFullName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((String)("Expected: :" + ddlView + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).contains(ddlView));
    }

    @Test
    public void testShowCreateTableIndex() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(ShowCreateTableIT.getUrl(), props);
        String tableName = ShowCreateTableIT.generateUniqueName();
        String indexname = ShowCreateTableIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER)";
        conn.createStatement().execute(ddl);
        String createIndex = "CREATE INDEX " + indexname + " ON " + tableName + "(K DESC)";
        conn.createStatement().execute(createIndex);
        ResultSet rs = conn.createStatement().executeQuery("SHOW CREATE TABLE " + indexname);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((String)("Expected: " + createIndex + "\nResult: " + rs.getString(1)), (boolean)rs.getString(1).contains(createIndex));
    }

    @Test
    public void testShowCreateTableUsingGetResultSet() throws Exception {
        block24: {
            Properties props = new Properties();
            Connection conn = DriverManager.getConnection(ShowCreateTableIT.getUrl(), props);
            String tableName = ShowCreateTableIT.generateUniqueName();
            String schemaName = ShowCreateTableIT.generateUniqueName();
            String tableFullName = SchemaUtil.getQualifiedTableName((String)schemaName, (String)tableName);
            String ddl = "CREATE TABLE " + tableFullName + "(K VARCHAR NOT NULL PRIMARY KEY, INT INTEGER)";
            conn.createStatement().execute(ddl);
            try (Statement statement = conn.createStatement();){
                boolean execute = statement.execute("SHOW CREATE TABLE " + tableFullName);
                if (!execute) break block24;
                try (ResultSet rs = statement.getResultSet();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertTrue((boolean)rs.getString(1).contains(tableFullName));
                }
            }
        }
    }
}

