/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class SetPropertyIT
extends ParallelStatsDisabledIT {
    private String schemaName;
    private String dataTableName;
    private String viewName;
    private String dataTableFullName;
    private String tableDDLOptions;
    private final boolean columnEncoded;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        SetPropertyIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    public SetPropertyIT(boolean columnEncoded) {
        this.columnEncoded = columnEncoded;
        this.tableDDLOptions = columnEncoded ? "" : "COLUMN_ENCODED_BYTES=0";
    }

    @Before
    public void setupTableNames() throws Exception {
        this.schemaName = "";
        this.dataTableName = SetPropertyIT.generateUniqueName();
        this.dataTableFullName = SchemaUtil.getTableName((String)this.schemaName, (String)this.dataTableName);
        this.viewName = SetPropertyIT.generateUniqueName();
    }

    private String generateDDLOptions(String options) {
        StringBuilder sb = new StringBuilder();
        if (!options.isEmpty()) {
            sb.append(options);
        }
        if (!this.tableDDLOptions.isEmpty()) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(this.tableDDLOptions);
        }
        return sb.toString();
    }

    @Test
    public void testSetHColumnProperties() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) " + this.generateDDLOptions("SALT_BUCKETS = 8");
        Connection conn1 = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        ddl = "ALTER TABLE " + this.dataTableFullName + " SET REPLICATION_SCOPE=1";
        conn1.createStatement().execute(ddl);
        try (Admin admin = conn1.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName)).getColumnFamilies();
            Assert.assertEquals((long)1L, (long)columnFamilies.length);
            Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
            Assert.assertEquals((long)1L, (long)columnFamilies[0].getScope());
        }
    }

    @Test
    public void testSetHTableProperties() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) " + this.generateDDLOptions("SALT_BUCKETS = 8");
        Connection conn1 = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        ddl = "ALTER TABLE " + this.dataTableFullName + " SET COMPACTION_ENABLED=FALSE";
        conn1.createStatement().execute(ddl);
        try (Admin admin = conn1.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
            Assert.assertEquals((long)1L, (long)tableDesc.getColumnFamilies().length);
            Assert.assertEquals((Object)"0", (Object)tableDesc.getColumnFamilies()[0].getNameAsString());
            Assert.assertEquals((Object)Boolean.toString(false), (Object)tableDesc.getValue("COMPACTION_ENABLED"));
        }
    }

    @Test
    public void testSetHTableAndHColumnProperties() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) " + this.generateDDLOptions("SALT_BUCKETS = 8");
        Connection conn1 = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        ddl = "ALTER TABLE " + this.dataTableFullName + " SET COMPACTION_ENABLED = FALSE, REPLICATION_SCOPE = 1";
        conn1.createStatement().execute(ddl);
        try (Admin admin = conn1.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
            ColumnFamilyDescriptor[] columnFamilies = tableDesc.getColumnFamilies();
            Assert.assertEquals((long)1L, (long)columnFamilies.length);
            Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
            Assert.assertEquals((long)1L, (long)columnFamilies[0].getScope());
            Assert.assertEquals((Object)false, (Object)tableDesc.isCompactionEnabled());
        }
    }

    @Test
    public void testSetHTableHColumnAndPhoenixTableProperties() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCF1.CREATION_TIME BIGINT,\nCF2.LAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) " + this.generateDDLOptions("IMMUTABLE_ROWS=true" + (!this.columnEncoded ? ",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : ""));
        Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        SetPropertyIT.assertImmutableRows(conn, this.dataTableFullName, true);
        ddl = "ALTER TABLE " + this.dataTableFullName + " SET COMPACTION_ENABLED = FALSE, VERSIONS = 10";
        conn.createStatement().execute(ddl);
        ddl = "ALTER TABLE " + this.dataTableFullName + " SET COMPACTION_ENABLED = FALSE, CF1.MIN_VERSIONS = 1, CF2.MIN_VERSIONS = 3, MIN_VERSIONS = 8, CF1.BLOCKSIZE = 50000, KEEP_DELETED_CELLS = false";
        conn.createStatement().execute(ddl);
        try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
            ColumnFamilyDescriptor[] columnFamilies = tableDesc.getColumnFamilies();
            Assert.assertEquals((long)3L, (long)columnFamilies.length);
            Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
            Assert.assertEquals((long)8L, (long)columnFamilies[0].getMinVersions());
            Assert.assertEquals((long)10L, (long)columnFamilies[0].getMaxVersions());
            Assert.assertEquals((long)65536L, (long)columnFamilies[0].getBlocksize());
            Assert.assertEquals((Object)KeepDeletedCells.FALSE, (Object)columnFamilies[0].getKeepDeletedCells());
            Assert.assertEquals((Object)"CF1", (Object)columnFamilies[1].getNameAsString());
            Assert.assertEquals((long)1L, (long)columnFamilies[1].getMinVersions());
            Assert.assertEquals((long)10L, (long)columnFamilies[1].getMaxVersions());
            Assert.assertEquals((long)50000L, (long)columnFamilies[1].getBlocksize());
            Assert.assertEquals((Object)KeepDeletedCells.FALSE, (Object)columnFamilies[1].getKeepDeletedCells());
            Assert.assertEquals((Object)"CF2", (Object)columnFamilies[2].getNameAsString());
            Assert.assertEquals((long)3L, (long)columnFamilies[2].getMinVersions());
            Assert.assertEquals((long)10L, (long)columnFamilies[2].getMaxVersions());
            Assert.assertEquals((long)65536L, (long)columnFamilies[2].getBlocksize());
            Assert.assertEquals((Object)KeepDeletedCells.FALSE, (Object)columnFamilies[2].getKeepDeletedCells());
            Assert.assertEquals((Object)Boolean.toString(false), (Object)tableDesc.getValue("COMPACTION_ENABLED"));
        }
    }

    @Test
    public void testSpecifyingColumnFamilyForHTablePropertyFails() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) " + this.generateDDLOptions("SALT_BUCKETS = 8");
        Connection conn1 = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        ddl = "ALTER TABLE " + this.dataTableFullName + " SET CF.COMPACTION_ENABLED = FALSE";
        try {
            conn1.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testSpecifyingColumnFamilyForPhoenixTablePropertyFails() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) " + this.generateDDLOptions("SALT_BUCKETS = 8");
        Connection conn1 = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        ddl = "ALTER TABLE " + this.dataTableFullName + " SET CF.DISABLE_WAL = TRUE";
        try {
            conn1.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testSpecifyingColumnFamilyForTTLFails() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nCF.LAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) " + this.generateDDLOptions("SALT_BUCKETS = 8");
        Connection conn1 = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        ddl = "ALTER TABLE " + this.dataTableFullName + " SET CF.TTL = 86400";
        try {
            conn1.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_PROPERTY.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testSetPropertyNeedsColumnFamilyToExist() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) " + this.generateDDLOptions("SALT_BUCKETS = 8");
        Connection conn1 = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        ddl = "ALTER TABLE " + this.dataTableFullName + " SET CF.BLOCKSIZE = 50000";
        try {
            conn1.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.COLUMN_FAMILY_NOT_FOUND.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testSetDefaultColumnFamilyNotAllowed() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) " + this.generateDDLOptions(" SALT_BUCKETS = 8");
        Connection conn1 = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        ddl = "ALTER TABLE " + this.dataTableFullName + " SET DEFAULT_COLUMN_FAMILY = 'A'";
        try {
            conn1.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.DEFAULT_COLUMN_FAMILY_ONLY_ON_CREATE_TABLE.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testSetHColumnOrHTablePropertiesOnViewsNotAllowed() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) " + this.generateDDLOptions("SALT_BUCKETS = 8");
        Connection conn1 = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + this.viewName + "  AS SELECT * FROM " + this.dataTableFullName + " WHERE CREATION_TIME = 1";
        conn1.createStatement().execute(ddl);
        ddl = "ALTER VIEW " + this.viewName + " SET REPLICATION_SCOPE = 1";
        try {
            conn1.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.VIEW_WITH_PROPERTIES.getErrorCode(), (long)e.getErrorCode());
        }
        ddl = "ALTER VIEW " + this.viewName + " SET COMPACTION_ENABLED = FALSE";
        try {
            conn1.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.VIEW_WITH_PROPERTIES.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testSetForSomePhoenixTablePropertiesOnViewsAllowed() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) " + this.generateDDLOptions("SALT_BUCKETS = 8");
        Connection conn1 = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn1.createStatement().execute(ddl);
        String viewFullName = SchemaUtil.getTableName((String)this.schemaName, (String)SetPropertyIT.generateUniqueName());
        ddl = "CREATE VIEW " + viewFullName + " AS SELECT * FROM " + this.dataTableFullName + " WHERE CREATION_TIME = 1";
        conn1.createStatement().execute(ddl);
        ddl = "ALTER VIEW " + viewFullName + " SET UPDATE_CACHE_FREQUENCY = 10";
        conn1.createStatement().execute(ddl);
        conn1.createStatement().execute("SELECT * FROM " + viewFullName);
        PhoenixConnection pconn = conn1.unwrap(PhoenixConnection.class);
        Assert.assertEquals((long)10L, (long)pconn.getTable(new PTableKey(pconn.getTenantId(), viewFullName)).getUpdateCacheFrequency());
        ddl = "ALTER VIEW " + viewFullName + " SET UPDATE_CACHE_FREQUENCY = 20";
        conn1.createStatement().execute(ddl);
        conn1.createStatement().execute("SELECT * FROM " + viewFullName);
        pconn = conn1.unwrap(PhoenixConnection.class);
        Assert.assertEquals((long)20L, (long)pconn.getTable(new PTableKey(pconn.getTenantId(), viewFullName)).getUpdateCacheFrequency());
        SetPropertyIT.assertImmutableRows(conn1, viewFullName, false);
        ddl = "ALTER VIEW " + viewFullName + " SET DISABLE_WAL = TRUE";
        try {
            conn1.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.VIEW_WITH_PROPERTIES.getErrorCode(), (long)e.getErrorCode());
        }
        ddl = "ALTER VIEW " + viewFullName + " SET THROW_INDEX_WRITE_FAILURE = FALSE";
        try {
            conn1.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.VIEW_WITH_PROPERTIES.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testSettingPropertiesWhenTableHasDefaultColFamilySpecified() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE  " + this.dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nCF.LAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) " + this.generateDDLOptions("IMMUTABLE_ROWS=true, DEFAULT_COLUMN_FAMILY = 'XYZ'" + (!this.columnEncoded ? ",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : ""));
        Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        SetPropertyIT.assertImmutableRows(conn, this.dataTableFullName, true);
        ddl = "ALTER TABLE  " + this.dataTableFullName + " SET COMPACTION_ENABLED = FALSE, CF.BLOCKSIZE=50000, IMMUTABLE_ROWS = TRUE, TTL=1000";
        conn.createStatement().execute(ddl);
        SetPropertyIT.assertImmutableRows(conn, this.dataTableFullName, true);
        try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
            ColumnFamilyDescriptor[] columnFamilies = tableDesc.getColumnFamilies();
            Assert.assertEquals((long)2L, (long)columnFamilies.length);
            Assert.assertEquals((Object)"CF", (Object)columnFamilies[0].getNameAsString());
            Assert.assertEquals((long)0L, (long)columnFamilies[0].getScope());
            Assert.assertEquals((long)1000L, (long)columnFamilies[0].getTimeToLive());
            Assert.assertEquals((long)50000L, (long)columnFamilies[0].getBlocksize());
            Assert.assertEquals((Object)"XYZ", (Object)columnFamilies[1].getNameAsString());
            Assert.assertEquals((long)0L, (long)columnFamilies[1].getScope());
            Assert.assertEquals((long)1000L, (long)columnFamilies[1].getTimeToLive());
            Assert.assertEquals((long)65536L, (long)columnFamilies[1].getBlocksize());
            Assert.assertEquals((Object)Boolean.toString(false), (Object)tableDesc.getValue("COMPACTION_ENABLED"));
            TestUtil.assertTTLValue(conn, this.dataTableFullName, (TTLExpression)new LiteralTTLExpression(1000));
        }
    }

    private static void assertImmutableRows(Connection conn, String fullTableName, boolean expectedValue) throws SQLException {
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        Assert.assertEquals((Object)expectedValue, (Object)pconn.getTable(new PTableKey(pconn.getTenantId(), fullTableName)).isImmutableRows());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetPropertyAndAddColumnForExistingColumnFamily() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + "  (a_string varchar not null, col1 integer, CF.col2 integer  CONSTRAINT pk PRIMARY KEY (a_string)) " + this.tableDDLOptions;
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("ALTER TABLE " + this.dataTableFullName + " ADD CF.col3 integer CF.IN_MEMORY=true");
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName)).getColumnFamilies();
                Assert.assertEquals((long)2L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
                Assert.assertFalse((boolean)columnFamilies[0].isInMemory());
                Assert.assertEquals((Object)"CF", (Object)columnFamilies[1].getNameAsString());
                Assert.assertTrue((boolean)columnFamilies[1].isInMemory());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetPropertyAndAddColumnForNewAndExistingColumnFamily() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + "   (a_string varchar not null, col1 integer, CF1.col2 integer  CONSTRAINT pk PRIMARY KEY (a_string)) " + this.tableDDLOptions;
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("ALTER TABLE " + this.dataTableFullName + " ADD col4 integer, CF1.col5 integer, CF2.col6 integer IN_MEMORY=true, REPLICATION_SCOPE=1, CF2.IN_MEMORY=false ");
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName)).getColumnFamilies();
                Assert.assertEquals((long)3L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
                Assert.assertTrue((boolean)columnFamilies[0].isInMemory());
                Assert.assertEquals((long)1L, (long)columnFamilies[0].getScope());
                Assert.assertEquals((Object)"CF1", (Object)columnFamilies[1].getNameAsString());
                Assert.assertTrue((boolean)columnFamilies[1].isInMemory());
                Assert.assertEquals((long)1L, (long)columnFamilies[1].getScope());
                Assert.assertEquals((Object)"CF2", (Object)columnFamilies[2].getNameAsString());
                Assert.assertFalse((boolean)columnFamilies[2].isInMemory());
                Assert.assertEquals((long)1L, (long)columnFamilies[2].getScope());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetPropertyAndAddColumnWhenTableHasExplicitDefaultColumnFamily() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + "   (a_string varchar not null, col1 integer, CF1.col2 integer  CONSTRAINT pk PRIMARY KEY (a_string)) " + this.generateDDLOptions("DEFAULT_COLUMN_FAMILY = 'XYZ'");
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("ALTER TABLE " + this.dataTableFullName + " ADD col4 integer, CF1.col5 integer, CF2.col6 integer IN_MEMORY=true, CF1.BLOCKSIZE=50000, CF2.IN_MEMORY=false, REPLICATION_SCOPE=1 ");
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName)).getColumnFamilies();
                Assert.assertEquals((long)3L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"CF1", (Object)columnFamilies[0].getNameAsString());
                Assert.assertTrue((boolean)columnFamilies[0].isInMemory());
                Assert.assertEquals((long)1L, (long)columnFamilies[0].getScope());
                Assert.assertEquals((long)50000L, (long)columnFamilies[0].getBlocksize());
                Assert.assertEquals((Object)"CF2", (Object)columnFamilies[1].getNameAsString());
                Assert.assertFalse((boolean)columnFamilies[1].isInMemory());
                Assert.assertEquals((long)1L, (long)columnFamilies[1].getScope());
                Assert.assertEquals((Object)"XYZ", (Object)columnFamilies[2].getNameAsString());
                Assert.assertTrue((boolean)columnFamilies[2].isInMemory());
                Assert.assertEquals((long)1L, (long)columnFamilies[2].getScope());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetPropertyAndAddColumnFailsForColumnFamilyNotPresentInAddCol() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + "   (a_string varchar not null, col1 integer, CF1.col2 integer  CONSTRAINT pk PRIMARY KEY (a_string)) " + this.generateDDLOptions("DEFAULT_COLUMN_FAMILY = 'XYZ'");
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            try {
                conn.createStatement().execute("ALTER TABLE " + this.dataTableFullName + " ADD col4 integer CF1.BLOCKSIZE=50000, XYZ.IN_MEMORY=true ");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_PROPERTY_FOR_COLUMN_NOT_ADDED.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetPropertyAndAddColumnForDifferentColumnFamilies() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + "  (a_string varchar not null, col1 integer, CF1.col2 integer, CF2.col3 integer  CONSTRAINT pk PRIMARY KEY (a_string)) " + this.generateDDLOptions("DEFAULT_COLUMN_FAMILY = 'XYZ' ");
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("ALTER TABLE " + this.dataTableFullName + " ADD col4 integer, CF1.col5 integer, CF2.col6 integer, CF3.col7 integer CF1.BLOCKSIZE=50000, CF1.IN_MEMORY=false, IN_MEMORY=true ");
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName)).getColumnFamilies();
                Assert.assertEquals((long)4L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"CF1", (Object)columnFamilies[0].getNameAsString());
                Assert.assertFalse((boolean)columnFamilies[0].isInMemory());
                Assert.assertEquals((long)0L, (long)columnFamilies[0].getScope());
                Assert.assertEquals((long)50000L, (long)columnFamilies[0].getBlocksize());
                Assert.assertEquals((Object)"CF2", (Object)columnFamilies[1].getNameAsString());
                Assert.assertTrue((boolean)columnFamilies[1].isInMemory());
                Assert.assertEquals((long)0L, (long)columnFamilies[1].getScope());
                Assert.assertEquals((Object)"CF3", (Object)columnFamilies[2].getNameAsString());
                Assert.assertTrue((boolean)columnFamilies[2].isInMemory());
                Assert.assertEquals((long)0L, (long)columnFamilies[2].getScope());
                Assert.assertEquals((Object)"XYZ", (Object)columnFamilies[3].getNameAsString());
                Assert.assertTrue((boolean)columnFamilies[3].isInMemory());
                Assert.assertEquals((long)0L, (long)columnFamilies[3].getScope());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetPropertyAndAddColumnUsingDefaultColumnFamilySpecifier() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + "  (a_string varchar not null, col1 integer, CF1.col2 integer  CONSTRAINT pk PRIMARY KEY (a_string)) " + this.generateDDLOptions("DEFAULT_COLUMN_FAMILY = 'XYZ'");
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("ALTER TABLE " + this.dataTableFullName + " ADD col4 integer REPLICATION_SCOPE=1, XYZ.BLOCKSIZE=50000");
            conn.createStatement().execute("ALTER TABLE " + this.dataTableFullName + " ADD XYZ.col5 integer IN_MEMORY=true ");
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName)).getColumnFamilies();
                Assert.assertEquals((long)2L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"CF1", (Object)columnFamilies[0].getNameAsString());
                Assert.assertFalse((boolean)columnFamilies[0].isInMemory());
                Assert.assertEquals((long)1L, (long)columnFamilies[0].getScope());
                Assert.assertEquals((long)65536L, (long)columnFamilies[0].getBlocksize());
                Assert.assertEquals((Object)"XYZ", (Object)columnFamilies[1].getNameAsString());
                Assert.assertTrue((boolean)columnFamilies[1].isInMemory());
                Assert.assertEquals((long)1L, (long)columnFamilies[1].getScope());
                Assert.assertEquals((long)50000L, (long)columnFamilies[1].getBlocksize());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetPropertyAndAddColumnForDefaultColumnFamily() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn.setAutoCommit(false);
        String ddl = "CREATE TABLE " + this.dataTableFullName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string)) " + this.tableDDLOptions;
        try {
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("ALTER TABLE " + this.dataTableFullName + " ADD col2 integer IN_MEMORY=true");
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName)).getColumnFamilies();
                Assert.assertEquals((long)1L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
                Assert.assertTrue((boolean)columnFamilies[0].isInMemory());
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddNewColumnFamilyProperties() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + this.dataTableFullName + "  (a_string varchar not null, col1 integer, cf1.col2 integer, col3 integer , cf2.col4 integer   CONSTRAINT pk PRIMARY KEY (a_string)) " + this.generateDDLOptions("immutable_rows=true , SALT_BUCKETS=3 " + (!this.columnEncoded ? ",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : "")));
            String ddl = "Alter table " + this.dataTableFullName + " add cf3.col5 integer, cf4.col6 integer in_memory=true";
            conn.createStatement().execute(ddl);
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                Assert.assertTrue((boolean)tableDesc.isCompactionEnabled());
                ColumnFamilyDescriptor[] columnFamilies = tableDesc.getColumnFamilies();
                Assert.assertEquals((long)5L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
                Assert.assertFalse((boolean)columnFamilies[0].isInMemory());
                Assert.assertEquals((Object)"CF1", (Object)columnFamilies[1].getNameAsString());
                Assert.assertFalse((boolean)columnFamilies[1].isInMemory());
                Assert.assertEquals((Object)"CF2", (Object)columnFamilies[2].getNameAsString());
                Assert.assertFalse((boolean)columnFamilies[2].isInMemory());
                Assert.assertEquals((Object)"CF3", (Object)columnFamilies[3].getNameAsString());
                Assert.assertTrue((boolean)columnFamilies[3].isInMemory());
                Assert.assertEquals((Object)"CF4", (Object)columnFamilies[4].getNameAsString());
                Assert.assertTrue((boolean)columnFamilies[4].isInMemory());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddProperyToExistingColumnFamily() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + this.dataTableFullName + "  (a_string varchar not null, col1 integer, cf1.col2 integer, col3 integer , cf2.col4 integer   CONSTRAINT pk PRIMARY KEY (a_string)) " + this.generateDDLOptions("immutable_rows=true , SALT_BUCKETS=3 " + (!this.columnEncoded ? ",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : "")));
            String ddl = "Alter table " + this.dataTableFullName + " add cf1.col5 integer in_memory=true";
            conn.createStatement().execute(ddl);
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                Assert.assertTrue((boolean)tableDesc.isCompactionEnabled());
                ColumnFamilyDescriptor[] columnFamilies = tableDesc.getColumnFamilies();
                Assert.assertEquals((long)3L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
                Assert.assertFalse((boolean)columnFamilies[0].isInMemory());
                Assert.assertEquals((Object)"CF1", (Object)columnFamilies[1].getNameAsString());
                Assert.assertTrue((boolean)columnFamilies[1].isInMemory());
                Assert.assertEquals((Object)"CF2", (Object)columnFamilies[2].getNameAsString());
                Assert.assertFalse((boolean)columnFamilies[2].isInMemory());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddTTLToExistingColumnFamily() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            String ddl = "CREATE TABLE " + this.dataTableFullName + " (pk char(2) not null primary key, col1 integer, b.col1 integer) " + this.tableDDLOptions + " SPLIT ON ('EA','EZ') ";
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " add b.col2 varchar ttl=30";
            conn.createStatement().execute(ddl);
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingTTLWhenAddingColumnNotAllowed() throws Exception {
        String ddl;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn.setAutoCommit(false);
        try {
            ddl = "CREATE TABLE " + this.dataTableFullName + " (pk char(2) not null primary key) " + this.generateDDLOptions("TTL=100") + " SPLIT ON ('EA','EZ')";
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " add col1 varchar ttl=30";
            conn.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_TABLE_PROPERTY_ADD_COLUMN.getErrorCode(), (long)e.getErrorCode());
        }
        try {
            ddl = "ALTER TABLE " + this.dataTableFullName + " add col1 varchar a.ttl=30";
            conn.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_PROPERTY.getErrorCode(), (long)e.getErrorCode());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetTTLForTableWithOnlyPKCols() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            ColumnFamilyDescriptor[] columnFamilies;
            TableDescriptor tableDesc;
            String ddl = "create table " + this.dataTableFullName + " ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2) ) " + this.generateDDLOptions("TTL=86400, SALT_BUCKETS = 4, DEFAULT_COLUMN_FAMILY='XYZ'");
            conn.createStatement().execute(ddl);
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                columnFamilies = tableDesc.getColumnFamilies();
                Assert.assertEquals((long)1L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"XYZ", (Object)columnFamilies[0].getNameAsString());
                Assert.assertEquals((long)86400L, (long)columnFamilies[0].getTimeToLive());
                TestUtil.assertTTLValue(conn, this.dataTableFullName, (TTLExpression)new LiteralTTLExpression(86400));
            }
            ddl = "ALTER TABLE " + this.dataTableFullName + " SET TTL=30";
            conn.createStatement().execute(ddl);
            conn.commit();
            admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            var5_5 = null;
            try {
                tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                columnFamilies = tableDesc.getColumnFamilies();
                Assert.assertEquals((long)1L, (long)columnFamilies.length);
                Assert.assertEquals((long)30L, (long)columnFamilies[0].getTimeToLive());
                Assert.assertEquals((Object)"XYZ", (Object)columnFamilies[0].getNameAsString());
                TestUtil.assertTTLValue(conn, this.dataTableFullName, (TTLExpression)new LiteralTTLExpression(30));
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (var5_5 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetTTLForTableWithForeverAndNoneValue() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            ColumnFamilyDescriptor[] columnFamilies;
            TableDescriptor tableDesc;
            String ddl = "create table " + this.dataTableFullName + " ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2) ) " + this.generateDDLOptions("TTL=NONE, SALT_BUCKETS = 4, DEFAULT_COLUMN_FAMILY='XYZ'");
            conn.createStatement().execute(ddl);
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                columnFamilies = tableDesc.getColumnFamilies();
                Assert.assertEquals((long)1L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"XYZ", (Object)columnFamilies[0].getNameAsString());
                Assert.assertEquals((long)Integer.MAX_VALUE, (long)columnFamilies[0].getTimeToLive());
                Assert.assertEquals((Object)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED, (Object)conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, this.dataTableFullName)).getTTLExpression());
            }
            ddl = "ALTER TABLE " + this.dataTableFullName + " SET TTL=FOREVER";
            conn.createStatement().execute(ddl);
            conn.commit();
            admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            var5_5 = null;
            try {
                tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                columnFamilies = tableDesc.getColumnFamilies();
                Assert.assertEquals((long)1L, (long)columnFamilies.length);
                Assert.assertEquals((long)Integer.MAX_VALUE, (long)columnFamilies[0].getTimeToLive());
                Assert.assertEquals((Object)"XYZ", (Object)columnFamilies[0].getNameAsString());
                Assert.assertEquals((Object)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED, (Object)conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, this.dataTableFullName)).getTTLExpression());
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (var5_5 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetHColumnPropertyForTableWithOnlyPKCols1() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            String ddl = "create table " + this.dataTableFullName + " ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2) ) " + this.generateDDLOptions("TTL=86400, SALT_BUCKETS = 4, DEFAULT_COLUMN_FAMILY='XYZ'");
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " SET IN_MEMORY=true";
            conn.createStatement().execute(ddl);
            conn.commit();
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                ColumnFamilyDescriptor[] columnFamilies = tableDesc.getColumnFamilies();
                Assert.assertEquals((long)1L, (long)columnFamilies.length);
                Assert.assertEquals((Object)true, (Object)columnFamilies[0].isInMemory());
                Assert.assertEquals((Object)"XYZ", (Object)columnFamilies[0].getNameAsString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetHColumnPropertyForTableWithOnlyPKCols2() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            String ddl = "create table " + this.dataTableFullName + " ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2) ) " + this.generateDDLOptions("TTL=86400, SALT_BUCKETS = 4");
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " SET IN_MEMORY=true";
            conn.createStatement().execute(ddl);
            conn.commit();
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                ColumnFamilyDescriptor[] columnFamilies = tableDesc.getColumnFamilies();
                Assert.assertEquals((long)1L, (long)columnFamilies.length);
                Assert.assertEquals((Object)true, (Object)columnFamilies[0].isInMemory());
                Assert.assertEquals((Object)"0", (Object)columnFamilies[0].getNameAsString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetHColumnPropertyAndAddColumnForDefaultCFForTableWithOnlyPKCols() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            String ddl = "create table " + this.dataTableFullName + " ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2) ) " + this.generateDDLOptions("TTL=86400, SALT_BUCKETS = 4, DEFAULT_COLUMN_FAMILY='XYZ'");
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD COL3 INTEGER IN_MEMORY=true";
            conn.createStatement().execute(ddl);
            conn.commit();
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                ColumnFamilyDescriptor[] columnFamilies = tableDesc.getColumnFamilies();
                Assert.assertEquals((long)1L, (long)columnFamilies.length);
                Assert.assertEquals((Object)true, (Object)columnFamilies[0].isInMemory());
                Assert.assertEquals((Object)"XYZ", (Object)columnFamilies[0].getNameAsString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetHColumnPropertyAndAddColumnForNewCFForTableWithOnlyPKCols() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            String ddl = "create table " + this.dataTableFullName + " ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2) ) " + this.generateDDLOptions("TTL=86400, SALT_BUCKETS = 4, DEFAULT_COLUMN_FAMILY='XYZ'");
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD NEWCF.COL3 INTEGER IN_MEMORY=true";
            conn.createStatement().execute(ddl);
            conn.commit();
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                ColumnFamilyDescriptor[] columnFamilies = tableDesc.getColumnFamilies();
                Assert.assertEquals((long)2L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"NEWCF", (Object)columnFamilies[0].getNameAsString());
                Assert.assertEquals((Object)true, (Object)columnFamilies[0].isInMemory());
                Assert.assertEquals((Object)"XYZ", (Object)columnFamilies[1].getNameAsString());
                Assert.assertEquals((Object)false, (Object)columnFamilies[1].isInMemory());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTTLAssignmentForNewEmptyCF() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            ColumnFamilyDescriptor[] columnFamilies;
            TableDescriptor tableDesc;
            String ddl = "create table " + this.dataTableFullName + " ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2) ) " + this.generateDDLOptions("TTL=86400, SALT_BUCKETS = 4, DEFAULT_COLUMN_FAMILY='XYZ'");
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD NEWCF.COL3 INTEGER IN_MEMORY=true";
            conn.createStatement().execute(ddl);
            conn.commit();
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                columnFamilies = tableDesc.getColumnFamilies();
                Assert.assertEquals((long)2L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"NEWCF", (Object)columnFamilies[0].getNameAsString());
                Assert.assertEquals((Object)true, (Object)columnFamilies[0].isInMemory());
                Assert.assertEquals((long)86400L, (long)columnFamilies[0].getTimeToLive());
                Assert.assertEquals((Object)"XYZ", (Object)columnFamilies[1].getNameAsString());
                Assert.assertEquals((Object)false, (Object)columnFamilies[1].isInMemory());
                Assert.assertEquals((long)86400L, (long)columnFamilies[1].getTimeToLive());
                TestUtil.assertTTLValue(conn, this.dataTableFullName, (TTLExpression)new LiteralTTLExpression(86400));
            }
            ddl = "ALTER TABLE " + this.dataTableFullName + " SET TTL=1000";
            conn.createStatement().execute(ddl);
            conn.commit();
            admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            var5_5 = null;
            try {
                tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                columnFamilies = tableDesc.getColumnFamilies();
                Assert.assertEquals((long)2L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"NEWCF", (Object)columnFamilies[0].getNameAsString());
                Assert.assertEquals((Object)true, (Object)columnFamilies[0].isInMemory());
                Assert.assertEquals((long)1000L, (long)columnFamilies[0].getTimeToLive());
                Assert.assertEquals((Object)"XYZ", (Object)columnFamilies[1].getNameAsString());
                Assert.assertEquals((Object)false, (Object)columnFamilies[1].isInMemory());
                Assert.assertEquals((long)1000L, (long)columnFamilies[1].getTimeToLive());
                TestUtil.assertTTLValue(conn, this.dataTableFullName, (TTLExpression)new LiteralTTLExpression(1000));
            }
            catch (Throwable tableDesc2) {
                var5_5 = tableDesc2;
                throw tableDesc2;
            }
            finally {
                if (admin != null) {
                    if (var5_5 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable tableDesc2) {
                            var5_5.addSuppressed(tableDesc2);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD COL3 INTEGER";
            conn.createStatement().execute(ddl);
            conn.commit();
            admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            var5_5 = null;
            try {
                tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                columnFamilies = tableDesc.getColumnFamilies();
                Assert.assertEquals((long)2L, (long)columnFamilies.length);
                Assert.assertEquals((Object)"NEWCF", (Object)columnFamilies[0].getNameAsString());
                Assert.assertEquals((Object)true, (Object)columnFamilies[0].isInMemory());
                Assert.assertEquals((long)1000L, (long)columnFamilies[0].getTimeToLive());
                Assert.assertEquals((Object)"XYZ", (Object)columnFamilies[1].getNameAsString());
                Assert.assertEquals((Object)false, (Object)columnFamilies[1].isInMemory());
                Assert.assertEquals((long)1000L, (long)columnFamilies[1].getTimeToLive());
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (var5_5 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingNotHColumnNorPhoenixPropertyEndsUpAsHTableProperty() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);){
            String ddl = "create table " + this.dataTableFullName + " ( id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2) ) " + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            ddl = "ALTER TABLE " + this.dataTableFullName + " ADD NEWCF.COL3 INTEGER NEWCF.UNKNOWN_PROP='ABC'";
            try {
                conn.createStatement().execute(ddl);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_TABLE_PROPERTY_ADD_COLUMN.getErrorCode(), (long)e.getErrorCode());
            }
            ddl = "ALTER TABLE " + this.dataTableFullName + " SET UNKNOWN_PROP='ABC'";
            conn.createStatement().execute(ddl);
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                TableDescriptor tableDesc = admin.getDescriptor(TableName.valueOf((String)this.dataTableFullName));
                Assert.assertEquals((Object)"ABC", (Object)tableDesc.getValue("UNKNOWN_PROP"));
            }
        }
    }

    @Test
    public void testAlterImmutableRowsPropertyForOneCellPerKeyValueColumnStorageScheme() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nCONSTRAINT PK PRIMARY KEY (ID)) " + this.tableDDLOptions;
        Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        SetPropertyIT.assertImmutableRows(conn, this.dataTableFullName, false);
        ddl = "ALTER TABLE " + this.dataTableFullName + " SET IMMUTABLE_ROWS = true";
        conn.createStatement().execute(ddl);
        SetPropertyIT.assertImmutableRows(conn, this.dataTableFullName, true);
    }

    @Test
    @Ignore(value="We changed this behaviour and mutable tables can have columnencodedbytes")
    public void testAlterImmutableRowsPropertyForOneCellPerColumnFamilyStorageScheme() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String ddl = "CREATE TABLE " + this.dataTableFullName + " (\nID VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nCONSTRAINT PK PRIMARY KEY (ID)) " + this.generateDDLOptions("COLUMN_ENCODED_BYTES=4, IMMUTABLE_ROWS=true" + (!this.columnEncoded ? ",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : ""));
        Connection conn = DriverManager.getConnection(SetPropertyIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        SetPropertyIT.assertImmutableRows(conn, this.dataTableFullName, true);
        try {
            ddl = "ALTER TABLE " + this.dataTableFullName + " SET IMMUTABLE_ROWS = false";
            conn.createStatement().execute(ddl);
            if (this.columnEncoded) {
                Assert.fail();
            }
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_ALTER_IMMUTABLE_ROWS_PROPERTY.getErrorCode(), (long)e.getErrorCode());
        }
        SetPropertyIT.assertImmutableRows(conn, this.dataTableFullName, this.columnEncoded);
    }
}

