/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.iterate.ScanningResultPostDummyResultCaller;
import org.apache.phoenix.iterate.ScanningResultPostValidResultCaller;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ServerPagingWithRegionMovesIT
extends ParallelStatsDisabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerPagingWithRegionMovesIT.class);
    private static boolean hasTestStarted = false;
    private static int countOfDummyResults = 0;
    private static int countOfValidResults = 0;
    private static final List<String> TABLE_NAMES = Collections.synchronizedList(new ArrayList());

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)2);
        props.put("phoenix.server.page.size.ms", Long.toString(0L));
        props.put("phoenix.query.request.metrics.enabled", String.valueOf(true));
        props.put("phoenix.tests.minicluster.numregionservers", String.valueOf(2));
        props.put("hbase.client.scanner.max.result.size", String.valueOf(1));
        props.put("phoenix.scanning.result.post.dummy.process", TestScanningResultPostDummyResultCaller.class.getName());
        props.put("phoenix.scanning.result.post.valid.process", TestScanningResultPostValidResultCaller.class.getName());
        ServerPagingWithRegionMovesIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @After
    public void tearDown() throws Exception {
        TABLE_NAMES.clear();
        hasTestStarted = false;
        countOfDummyResults = 0;
        countOfValidResults = 0;
    }

    private void assertServerPagingMetric(String tableName, ResultSet rs, boolean isPaged) throws SQLException {
        Map metrics = PhoenixRuntime.getRequestReadMetricInfo((ResultSet)rs);
        for (Map.Entry entry : metrics.entrySet()) {
            Assert.assertEquals((String)String.format("Got %s", entry.getKey()), (Object)tableName, entry.getKey());
            Map metricValues = (Map)entry.getValue();
            Long pagedRowsCntr = (Long)metricValues.get(MetricType.PAGED_ROWS_COUNTER);
            Assert.assertNotNull((Object)pagedRowsCntr);
            if (isPaged) {
                Assert.assertTrue((String)String.format("Got %d", pagedRowsCntr), (pagedRowsCntr > 0L ? 1 : 0) != 0);
                continue;
            }
            Assert.assertEquals((String)String.format("Got %d", pagedRowsCntr), (long)0L, (long)pagedRowsCntr);
        }
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_PAGED_ROWS_COUNTER.getMetric().getValue() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testOrderByNonAggregation() throws Exception {
        hasTestStarted = true;
        String tablename = ServerPagingWithRegionMovesIT.generateUniqueName();
        String tenantId = ServerPagingWithRegionMovesIT.getOrganizationId();
        Date D1 = DateUtil.parseDate((String)"1970-01-01 00:58:00");
        Date D2 = DateUtil.parseDate((String)"1970-01-01 01:02:00");
        Date D3 = DateUtil.parseDate((String)"1970-01-01 01:30:00");
        Date D4 = DateUtil.parseDate((String)"1970-01-01 01:45:00");
        Date D5 = DateUtil.parseDate((String)"1970-01-01 02:00:00");
        Date D6 = DateUtil.parseDate((String)"1970-01-01 04:00:00");
        String F1 = "A";
        String F2 = "B";
        String F3 = "C";
        String R1 = "R1";
        String R2 = "R2";
        byte[][] splits = new byte[][]{ByteUtil.concat((byte[])Bytes.toBytes((String)tenantId), (byte[][])new byte[][]{PDate.INSTANCE.toBytes((Object)D3)}), ByteUtil.concat((byte[])Bytes.toBytes((String)tenantId), (byte[][])new byte[][]{PDate.INSTANCE.toBytes((Object)D5)})};
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ServerPagingWithRegionMovesIT.getUrl(), props);){
            String ddl = "create table " + tablename + "   (organization_id char(15) not null,    date date not null,    feature char(1) not null,    unique_users integer not null,\n    transactions bigint,\n    region varchar,\n    CONSTRAINT pk PRIMARY KEY (organization_id, \"DATE\", feature, unique_users))";
            TABLE_NAMES.add(tablename);
            StringBuilder buf = new StringBuilder(ddl);
            if (splits != null) {
                buf.append(" SPLIT ON (");
                for (int i = 0; i < splits.length; ++i) {
                    buf.append("'").append(Bytes.toString((byte[])splits[i])).append("'").append(",");
                }
                buf.setCharAt(buf.length() - 1, ')');
            }
            ddl = buf.toString();
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tablename + " (    ORGANIZATION_ID,     \"DATE\",     FEATURE,     UNIQUE_USERS,     TRANSACTIONS,     REGION) VALUES (?, ?, ?, ?, ?, ?)");
            stmt.setString(1, tenantId);
            stmt.setDate(2, D1);
            stmt.setString(3, "A");
            stmt.setInt(4, 10);
            stmt.setLong(5, 100L);
            stmt.setString(6, "R2");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setDate(2, D2);
            stmt.setString(3, "A");
            stmt.setInt(4, 20);
            stmt.setLong(5, 200L);
            stmt.setString(6, null);
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setDate(2, D3);
            stmt.setString(3, "A");
            stmt.setInt(4, 30);
            stmt.setLong(5, 300L);
            stmt.setString(6, "R1");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setDate(2, D4);
            stmt.setString(3, "B");
            stmt.setInt(4, 40);
            stmt.setLong(5, 400L);
            stmt.setString(6, "R1");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setDate(2, D5);
            stmt.setString(3, "C");
            stmt.setInt(4, 50);
            stmt.setLong(5, 500L);
            stmt.setString(6, "R2");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setDate(2, D6);
            stmt.setString(3, "A");
            stmt.setInt(4, 60);
            stmt.setLong(5, 600L);
            stmt.setString(6, null);
            stmt.execute();
            conn.commit();
        }
        String query = "SELECT \"DATE\", transactions t FROM " + tablename + " WHERE organization_id=? AND unique_users <= 30 ORDER BY t DESC LIMIT 2";
        try (Connection conn = DriverManager.getConnection(ServerPagingWithRegionMovesIT.getUrl(), props);
             PreparedStatement statement = conn.prepareStatement(query);){
            TestUtil.dumpTable(conn, TableName.valueOf((String)tablename));
            statement.setString(1, tenantId);
            try (ResultSet rs = statement.executeQuery();){
                ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)D3.getTime(), (long)rs.getDate(1).getTime());
                ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                Assert.assertTrue((boolean)rs.next());
                ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                Assert.assertEquals((long)D2.getTime(), (long)rs.getDate(1).getTime());
                Assert.assertFalse((boolean)rs.next());
                this.assertServerPagingMetric(tablename, rs, true);
            }
        }
    }

    private static void moveRegionsOfTable(String tableName) throws IOException {
        List regionsOnServer2;
        List regionsOnServer1;
        Admin admin = ServerPagingWithRegionMovesIT.getUtility().getAdmin();
        ArrayList servers = new ArrayList(admin.getRegionServers());
        ServerName server1 = (ServerName)servers.get(0);
        ServerName server2 = (ServerName)servers.get(1);
        try {
            regionsOnServer1 = admin.getRegions(server1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            regionsOnServer2 = admin.getRegions(server2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        regionsOnServer1.forEach(regionInfo -> {
            if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                try {
                    admin.move(regionInfo.getEncodedNameAsBytes(), server2);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        regionsOnServer2.forEach(regionInfo -> {
            if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                try {
                    admin.move(regionInfo.getEncodedNameAsBytes(), server1);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static void moveAllRegions() throws IOException {
        List regionsOnServer2;
        List regionsOnServer1;
        Admin admin = ServerPagingWithRegionMovesIT.getUtility().getAdmin();
        ArrayList servers = new ArrayList(admin.getRegionServers());
        ServerName server1 = (ServerName)servers.get(0);
        ServerName server2 = (ServerName)servers.get(1);
        try {
            regionsOnServer1 = admin.getRegions(server1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            regionsOnServer2 = admin.getRegions(server2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        regionsOnServer1.forEach(regionInfo -> {
            try {
                admin.move(regionInfo.getEncodedNameAsBytes(), server2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        regionsOnServer2.forEach(regionInfo -> {
            try {
                admin.move(regionInfo.getEncodedNameAsBytes(), server1);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testLimitOffsetWithSplit() throws Exception {
        hasTestStarted = true;
        String tablename = ServerPagingWithRegionMovesIT.generateUniqueName();
        String[] STRINGS = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        String ddl = "CREATE TABLE " + tablename + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nC3.k3 INTEGER,\nC2.v1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2)) SPLIT ON ('e','i','o')";
        TABLE_NAMES.add(tablename);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ServerPagingWithRegionMovesIT.getUrl(), props);){
            int i;
            ServerPagingWithRegionMovesIT.createTestTable(ServerPagingWithRegionMovesIT.getUrl(), ddl);
            for (int i2 = 0; i2 < 26; ++i2) {
                conn.createStatement().execute("UPSERT INTO " + tablename + " values('" + STRINGS[i2] + "'," + i2 + "," + (i2 + 1) + "," + (i2 + 2) + ",'" + STRINGS[25 - i2] + "')");
            }
            conn.commit();
            int limit = 10;
            int offset = 8;
            ResultSet rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " order by t_id limit " + limit + " offset " + offset);
            for (i = 0; i < limit; ++i) {
                if (i % 3 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)("Expected string didn't match for i = " + i), (Object)STRINGS[offset + i], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, true);
            int filterCond = 10;
            rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " where k2 > " + filterCond + " order by t_id limit " + limit + " offset " + offset);
            limit = 5;
            for (i = 0; i < limit; ++i) {
                if (i % 4 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)("Expected string didn't match for i = " + i), (Object)STRINGS[offset + filterCond + i], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, true);
            limit = 35;
            rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " union all SELECT t_id from " + tablename + " offset " + offset + " FETCH FIRST " + limit + " rows only");
            i = 0;
            while (i++ < STRINGS.length - offset) {
                if (i % 3 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)STRINGS[offset + i - 1], (Object)rs.getString(1));
            }
            i = 0;
            while (i++ < limit - STRINGS.length - offset) {
                if (i % 3 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)STRINGS[i - 1], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, true);
            limit = 1;
            offset = 1;
            rs = conn.createStatement().executeQuery("SELECT k2 from " + tablename + " order by k2 desc limit " + limit + " offset " + offset);
            ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)25L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            this.assertServerPagingMetric(tablename, rs, true);
        }
    }

    @Test
    public void testLimitOffsetWithoutSplit() throws Exception {
        hasTestStarted = true;
        String tablename = ServerPagingWithRegionMovesIT.generateUniqueName();
        String[] STRINGS = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        String ddl = "CREATE TABLE " + tablename + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nC3.k3 INTEGER,\nC2.v1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2))";
        TABLE_NAMES.add(tablename);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ServerPagingWithRegionMovesIT.getUrl(), props);){
            int i;
            ServerPagingWithRegionMovesIT.createTestTable(ServerPagingWithRegionMovesIT.getUrl(), ddl);
            for (int i2 = 0; i2 < 26; ++i2) {
                conn.createStatement().execute("UPSERT INTO " + tablename + " values('" + STRINGS[i2] + "'," + i2 + "," + (i2 + 1) + "," + (i2 + 2) + ",'" + STRINGS[25 - i2] + "')");
            }
            conn.commit();
            int limit = 10;
            int offset = 8;
            ResultSet rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " order by t_id limit " + limit + " offset " + offset);
            for (i = 0; i < limit; ++i) {
                if (i % 3 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)("Expected string didn't match for i = " + i), (Object)STRINGS[offset + i], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, false);
            int filterCond = 10;
            rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " where k2 > " + filterCond + " order by t_id limit " + limit + " offset " + offset);
            limit = 5;
            for (i = 0; i < limit; ++i) {
                if (i % 4 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)("Expected string didn't match for i = " + i), (Object)STRINGS[offset + filterCond + i], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, false);
            limit = 35;
            rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " union all SELECT t_id from " + tablename + " offset " + offset + " FETCH FIRST " + limit + " rows only");
            i = 0;
            while (i++ < STRINGS.length - offset) {
                if (i % 3 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)STRINGS[offset + i - 1], (Object)rs.getString(1));
            }
            i = 0;
            while (i++ < limit - STRINGS.length - offset) {
                if (i % 3 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)STRINGS[i - 1], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, false);
            limit = 1;
            offset = 1;
            rs = conn.createStatement().executeQuery("SELECT k2 from " + tablename + " order by k2 desc limit " + limit + " offset " + offset);
            ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)25L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            this.assertServerPagingMetric(tablename, rs, true);
        }
    }

    @Test
    public void testLimitOffsetWithSplit2() throws Exception {
        hasTestStarted = true;
        String tablename = ServerPagingWithRegionMovesIT.generateUniqueName();
        String[] STRINGS = new String[]{"a_xyz", "b_xyz", "c_xyz", "d_xyz", "e_xyz", "f_xyz", "g_xyz", "h_xyz", "i_xyz", "j_xyz", "k_xyz", "l_xyz", "m_xyz", "n_xyz", "o_xyz", "p_xyz", "q_xyz", "r_xyz", "s_xyz", "t_xyz", "u_xyz", "v_xyz", "w_xyz", "x_xyz", "y_xyz", "z_xyz"};
        String ddl = "CREATE TABLE " + tablename + " (t_id VARCHAR,\nk1 INTEGER,\nk2 INTEGER,\nC3.k3 INTEGER,\nC2.v1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id)) SPLIT ON ('e123','i123','o123')";
        TABLE_NAMES.add(tablename);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ServerPagingWithRegionMovesIT.getUrl(), props);){
            int i;
            ServerPagingWithRegionMovesIT.createTestTable(ServerPagingWithRegionMovesIT.getUrl(), ddl);
            for (int i2 = 0; i2 < 26; ++i2) {
                conn.createStatement().execute("UPSERT INTO " + tablename + " values('" + STRINGS[i2] + "'," + (i2 + 1) * 2 + "," + (i2 + 1) * 3 + "," + (i2 + 2) * 2 + ",'" + STRINGS[25 - i2] + "')");
            }
            conn.commit();
            int limit = 10;
            int offset = 8;
            ResultSet rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " order by t_id limit " + limit + " offset " + offset);
            for (i = 0; i < limit; ++i) {
                if (i % 3 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)("Expected string didn't match for i = " + i), (Object)STRINGS[offset + i], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, true);
            int filterCond = 30;
            rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " where k2 > " + filterCond + " order by t_id limit " + limit + " offset " + offset);
            limit = 5;
            for (i = 0; i < limit; ++i) {
                if (i % 4 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)("Expected string didn't match for i = " + i), (Object)STRINGS[offset + 10 + i], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, true);
            limit = 35;
            rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " union all SELECT t_id from " + tablename + " offset " + offset + " FETCH FIRST " + limit + " rows only");
            i = 0;
            while (i++ < STRINGS.length - offset) {
                if (i % 3 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)STRINGS[offset + i - 1], (Object)rs.getString(1));
            }
            i = 0;
            while (i++ < limit - STRINGS.length - offset) {
                if (i % 3 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)STRINGS[i - 1], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, true);
            limit = 1;
            offset = 1;
            rs = conn.createStatement().executeQuery("SELECT k2 from " + tablename + " order by k2 desc limit " + limit + " offset " + offset);
            ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)75L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            this.assertServerPagingMetric(tablename, rs, true);
        }
    }

    @Test
    public void testLimitOffsetWithoutSplit2() throws Exception {
        hasTestStarted = true;
        String tablename = ServerPagingWithRegionMovesIT.generateUniqueName();
        String[] STRINGS = new String[]{"a_xyz", "b_xyz", "c_xyz", "d_xyz", "e_xyz", "f_xyz", "g_xyz", "h_xyz", "i_xyz", "j_xyz", "k_xyz", "l_xyz", "m_xyz", "n_xyz", "o_xyz", "p_xyz", "q_xyz", "r_xyz", "s_xyz", "t_xyz", "u_xyz", "v_xyz", "w_xyz", "x_xyz", "y_xyz", "z_xyz"};
        String ddl = "CREATE TABLE " + tablename + " (t_id VARCHAR,\nk1 INTEGER,\nk2 INTEGER,\nC3.k3 INTEGER,\nC2.v1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id))";
        TABLE_NAMES.add(tablename);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ServerPagingWithRegionMovesIT.getUrl(), props);){
            int i;
            ServerPagingWithRegionMovesIT.createTestTable(ServerPagingWithRegionMovesIT.getUrl(), ddl);
            for (int i2 = 0; i2 < 26; ++i2) {
                conn.createStatement().execute("UPSERT INTO " + tablename + " values('" + STRINGS[i2] + "'," + (i2 + 1) * 2 + "," + (i2 + 1) * 3 + "," + (i2 + 2) * 2 + ",'" + STRINGS[25 - i2] + "')");
            }
            conn.commit();
            int limit = 10;
            int offset = 8;
            ResultSet rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " order by t_id limit " + limit + " offset " + offset);
            for (i = 0; i < limit; ++i) {
                if (i % 3 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)("Expected string didn't match for i = " + i), (Object)STRINGS[offset + i], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, false);
            int filterCond = 30;
            rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " where k2 > " + filterCond + " order by t_id limit " + limit + " offset " + offset);
            limit = 5;
            for (i = 0; i < limit; ++i) {
                if (i % 4 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)("Expected string didn't match for i = " + i), (Object)STRINGS[offset + 10 + i], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, false);
            limit = 35;
            rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " union all SELECT t_id from " + tablename + " offset " + offset + " FETCH FIRST " + limit + " rows only");
            i = 0;
            while (i++ < STRINGS.length - offset) {
                if (i % 3 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)STRINGS[offset + i - 1], (Object)rs.getString(1));
            }
            i = 0;
            while (i++ < limit - STRINGS.length - offset) {
                if (i % 3 == 0) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                }
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)STRINGS[i - 1], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, false);
            limit = 1;
            offset = 1;
            rs = conn.createStatement().executeQuery("SELECT k2 from " + tablename + " order by k2 desc limit " + limit + " offset " + offset);
            ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)75L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            this.assertServerPagingMetric(tablename, rs, true);
        }
    }

    @Test
    public void testGroupBy() throws Exception {
        hasTestStarted = true;
        String tablename = ServerPagingWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(tablename);
        String ddl = "CREATE TABLE " + tablename + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER CONSTRAINT pk PRIMARY KEY (t_id, k1)) ";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ServerPagingWithRegionMovesIT.getUrl(), props);){
            ServerPagingWithRegionMovesIT.createTestTable(ServerPagingWithRegionMovesIT.getUrl(), ddl);
            for (int i = 0; i < 8; ++i) {
                conn.createStatement().execute("UPSERT INTO " + tablename + " values('tenant1'," + i + "," + (i + 1) + ")");
            }
            conn.createStatement().execute("UPSERT INTO " + tablename + " values('tenant1', 10, 2)");
            conn.createStatement().execute("UPSERT INTO " + tablename + " values('tenant1', 11, 2)");
            conn.createStatement().execute("UPSERT INTO " + tablename + " values('tenant1', 12, 3)");
            conn.createStatement().execute("UPSERT INTO " + tablename + " values('tenant1', 13, 3)");
            conn.createStatement().execute("UPSERT INTO " + tablename + " values('tenant1', 14, 4)");
            conn.createStatement().execute("UPSERT INTO " + tablename + " values('tenant1', 15, 4)");
            conn.createStatement().execute("UPSERT INTO " + tablename + " values('tenant1', 16, 4)");
            conn.createStatement().execute("UPSERT INTO " + tablename + " values('tenant1', 17, 5)");
            conn.createStatement().execute("UPSERT INTO " + tablename + " values('tenant1', 18, 5)");
            conn.commit();
            TestUtil.dumpTable(conn, TableName.valueOf((String)tablename));
            ResultSet rs = conn.createStatement().executeQuery("SELECT k2, count(*) FROM " + tablename + " where t_id = 'tenant1' group by k2");
            ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((long)4L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)7L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)8L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            this.assertServerPagingMetric(tablename, rs, true);
        }
    }

    @Test
    public void testGroupByWithIndex() throws Exception {
        hasTestStarted = true;
        String tablename = ServerPagingWithRegionMovesIT.generateUniqueName();
        String indexName = ServerPagingWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(tablename);
        TABLE_NAMES.add(indexName);
        String ddl = "CREATE TABLE " + tablename + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER CONSTRAINT pk PRIMARY KEY (t_id, k1)) ";
        String indexDDl = "CREATE INDEX IF NOT EXISTS " + indexName + " ON " + tablename + "(k2)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ServerPagingWithRegionMovesIT.getUrl(), props);){
            ServerPagingWithRegionMovesIT.createTestTable(ServerPagingWithRegionMovesIT.getUrl(), ddl);
            ServerPagingWithRegionMovesIT.createTestTable(ServerPagingWithRegionMovesIT.getUrl(), indexDDl);
            for (int i = 0; i < 8; ++i) {
                conn.createStatement().execute("UPSERT INTO " + tablename + " values('tenant1'," + i + "," + (i + 1) + ")");
            }
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + tablename + " where t_id = 'tenant1' AND (k2 IN (5,6) or k2 is null) group by k2=6");
            boolean moveRegions = true;
            ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
            ServerPagingWithRegionMovesIT.moveRegionsOfTable(indexName);
            while (rs.next()) {
                if (moveRegions) {
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(tablename);
                    ServerPagingWithRegionMovesIT.moveRegionsOfTable(indexName);
                    moveRegions = false;
                } else {
                    moveRegions = true;
                }
                Assert.assertEquals((long)1L, (long)rs.getInt(1));
            }
            Assert.assertFalse((boolean)rs.next());
            this.assertServerPagingMetric(indexName, rs, true);
        }
    }

    private static class TestScanningResultPostDummyResultCaller
    extends ScanningResultPostDummyResultCaller {
        private TestScanningResultPostDummyResultCaller() {
        }

        public void postDummyProcess() {
            if (hasTestStarted && countOfDummyResults++ % 3 == 0 && (countOfDummyResults < 17 || countOfDummyResults > 28 && countOfDummyResults < 40)) {
                LOGGER.info("Moving regions of tables {}. current count of dummy results: {}", (Object)TABLE_NAMES, (Object)countOfDummyResults);
                TABLE_NAMES.forEach(table -> {
                    try {
                        ServerPagingWithRegionMovesIT.moveRegionsOfTable(table);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    private static class TestScanningResultPostValidResultCaller
    extends ScanningResultPostValidResultCaller {
        private TestScanningResultPostValidResultCaller() {
        }

        public void postValidRowProcess() {
            if (hasTestStarted && countOfValidResults++ % 2 == 0 && (countOfValidResults < 17 || countOfValidResults > 28 && countOfValidResults < 40)) {
                LOGGER.info("Moving regions of tables {}. current count of valid results: {}", (Object)TABLE_NAMES, (Object)countOfValidResults);
                TABLE_NAMES.forEach(table -> {
                    try {
                        ServerPagingWithRegionMovesIT.moveRegionsOfTable(table);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to move regions of table: {}", table);
                    }
                });
            }
        }
    }
}

