/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.PagingRegionScanner;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.index.GlobalIndexCheckerIT;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ServerPagingIT
extends ParallelStatsDisabledIT {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)2);
        props.put("phoenix.server.page.size.ms", Long.toString(0L));
        props.put("phoenix.query.request.metrics.enabled", String.valueOf(true));
        ServerPagingIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    private void assertServerPagingMetric(String tableName, ResultSet rs, boolean isPaged) throws SQLException {
        Map metrics = PhoenixRuntime.getRequestReadMetricInfo((ResultSet)rs);
        for (Map.Entry entry : metrics.entrySet()) {
            Assert.assertEquals((String)String.format("Got %s", entry.getKey()), (Object)tableName, entry.getKey());
            Map metricValues = (Map)entry.getValue();
            Long pagedRowsCntr = (Long)metricValues.get(MetricType.PAGED_ROWS_COUNTER);
            Assert.assertNotNull((Object)pagedRowsCntr);
            if (isPaged) {
                Assert.assertTrue((String)String.format("Got %d", (long)pagedRowsCntr), (pagedRowsCntr > 0L ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)String.format("Got %d", (long)pagedRowsCntr), (pagedRowsCntr == 0L ? 1 : 0) != 0);
        }
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_PAGED_ROWS_COUNTER.getMetric().getValue() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testScanWithLimit() throws Exception {
        String tablename = "T_" + ServerPagingIT.generateUniqueName();
        String indexName = "I_" + ServerPagingIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ServerPagingIT.getUrl(), props);){
            int j;
            int i;
            String ddl = "create table " + tablename + "(id1 integer not null, id2 integer not null, val varchar constraint pk primary key (id1, id2))";
            conn.createStatement().execute(ddl);
            conn.commit();
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tablename + " VALUES(?, ?, ?)");
            for (i = 0; i < 5; ++i) {
                for (j = 0; j < 10; ++j) {
                    stmt.setInt(1, i);
                    stmt.setInt(2, j);
                    stmt.setString(3, "abcdefghijklmnopqrstuvwxyz");
                    stmt.executeUpdate();
                }
                conn.commit();
            }
            stmt = conn.prepareStatement("delete from " + tablename + " where id1 = ? and id2 = ?");
            for (i = 0; i < 4; ++i) {
                for (j = 0; j < 10; ++j) {
                    stmt.setInt(1, i);
                    stmt.setInt(2, j);
                    stmt.executeUpdate();
                }
                conn.commit();
            }
            int limit = 10;
            stmt = conn.prepareStatement("select * from " + tablename + " where id1 >= 3 limit " + limit);
            try (ResultSet rs = stmt.executeQuery();){
                int expectedRowCount = 0;
                int expectedId1 = 4;
                int expectedId2 = 0;
                while (rs.next()) {
                    ++expectedRowCount;
                    Assert.assertEquals((long)expectedId1, (long)rs.getInt(1));
                    Assert.assertEquals((long)expectedId2, (long)rs.getInt(2));
                    ++expectedId2;
                }
                Assert.assertEquals((long)expectedRowCount, (long)limit);
                this.assertServerPagingMetric(tablename, rs, true);
            }
            ddl = "create index " + indexName + " ON " + tablename + " (id2, id1) INCLUDE (val)";
            conn.createStatement().execute(ddl);
            conn.commit();
            stmt = conn.prepareStatement("select * from " + tablename + " limit " + limit);
            rs = stmt.executeQuery();
            var10_13 = null;
            try {
                PhoenixResultSet prs = rs.unwrap(PhoenixResultSet.class);
                String explainPlan = QueryUtil.getExplainPlan((ResultIterator)prs.getUnderlyingIterator());
                Assert.assertTrue((boolean)explainPlan.contains(indexName));
                int expectedRowCount = 0;
                int expectedId1 = 4;
                int expectedId2 = 0;
                while (rs.next()) {
                    ++expectedRowCount;
                    Assert.assertEquals((long)expectedId1, (long)rs.getInt(1));
                    Assert.assertEquals((long)expectedId2, (long)rs.getInt(2));
                    ++expectedId2;
                }
                Assert.assertEquals((long)expectedRowCount, (long)limit);
                this.assertServerPagingMetric(indexName, rs, true);
            }
            catch (Throwable throwable) {
                var10_13 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var10_13 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var10_13.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test
    public void testOrderByNonAggregation() throws Exception {
        String tablename = ServerPagingIT.generateUniqueName();
        String tenantId = ServerPagingIT.getOrganizationId();
        Date D1 = DateUtil.parseDate((String)"1970-01-01 00:58:00");
        Date D2 = DateUtil.parseDate((String)"1970-01-01 01:02:00");
        Date D3 = DateUtil.parseDate((String)"1970-01-01 01:30:00");
        Date D4 = DateUtil.parseDate((String)"1970-01-01 01:45:00");
        Date D5 = DateUtil.parseDate((String)"1970-01-01 02:00:00");
        Date D6 = DateUtil.parseDate((String)"1970-01-01 04:00:00");
        String F1 = "A";
        String F2 = "B";
        String F3 = "C";
        String R1 = "R1";
        String R2 = "R2";
        byte[][] splits = new byte[][]{ByteUtil.concat((byte[])Bytes.toBytes((String)tenantId), (byte[][])new byte[][]{PDate.INSTANCE.toBytes((Object)D3)}), ByteUtil.concat((byte[])Bytes.toBytes((String)tenantId), (byte[][])new byte[][]{PDate.INSTANCE.toBytes((Object)D5)})};
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ServerPagingIT.getUrl(), props);){
            String ddl = "create table " + tablename + "   (organization_id char(15) not null,    date date not null,    feature char(1) not null,    unique_users integer not null,\n    transactions bigint,\n    region varchar,\n    CONSTRAINT pk PRIMARY KEY (organization_id, \"DATE\", feature, unique_users))";
            StringBuilder buf = new StringBuilder(ddl);
            if (splits != null) {
                buf.append(" SPLIT ON (");
                for (int i = 0; i < splits.length; ++i) {
                    buf.append("'").append(Bytes.toString((byte[])splits[i])).append("'").append(",");
                }
                buf.setCharAt(buf.length() - 1, ')');
            }
            ddl = buf.toString();
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tablename + " (    ORGANIZATION_ID,     \"DATE\",     FEATURE,     UNIQUE_USERS,     TRANSACTIONS,     REGION) VALUES (?, ?, ?, ?, ?, ?)");
            stmt.setString(1, tenantId);
            stmt.setDate(2, D1);
            stmt.setString(3, "A");
            stmt.setInt(4, 10);
            stmt.setLong(5, 100L);
            stmt.setString(6, "R2");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setDate(2, D2);
            stmt.setString(3, "A");
            stmt.setInt(4, 20);
            stmt.setLong(5, 200L);
            stmt.setString(6, null);
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setDate(2, D3);
            stmt.setString(3, "A");
            stmt.setInt(4, 30);
            stmt.setLong(5, 300L);
            stmt.setString(6, "R1");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setDate(2, D4);
            stmt.setString(3, "B");
            stmt.setInt(4, 40);
            stmt.setLong(5, 400L);
            stmt.setString(6, "R1");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setDate(2, D5);
            stmt.setString(3, "C");
            stmt.setInt(4, 50);
            stmt.setLong(5, 500L);
            stmt.setString(6, "R2");
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setDate(2, D6);
            stmt.setString(3, "A");
            stmt.setInt(4, 60);
            stmt.setLong(5, 600L);
            stmt.setString(6, null);
            stmt.execute();
            conn.commit();
        }
        String query = "SELECT \"DATE\", transactions t FROM " + tablename + " WHERE organization_id=? AND unique_users <= 30 ORDER BY t DESC LIMIT 2";
        try (Connection conn = DriverManager.getConnection(ServerPagingIT.getUrl(), props);
             PreparedStatement statement = conn.prepareStatement(query);){
            statement.setString(1, tenantId);
            try (ResultSet rs = statement.executeQuery();){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)D3.getTime(), (long)rs.getDate(1).getTime());
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)D2.getTime(), (long)rs.getDate(1).getTime());
                Assert.assertFalse((boolean)rs.next());
                this.assertServerPagingMetric(tablename, rs, true);
            }
        }
    }

    @Test
    public void testLimitOffset() throws SQLException {
        String tablename = ServerPagingIT.generateUniqueName();
        String[] STRINGS = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        String ddl = "CREATE TABLE " + tablename + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nC3.k3 INTEGER,\nC2.v1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2)) SPLIT ON ('e','i','o')";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ServerPagingIT.getUrl(), props);){
            int i;
            ServerPagingIT.createTestTable(ServerPagingIT.getUrl(), ddl);
            for (int i2 = 0; i2 < 26; ++i2) {
                conn.createStatement().execute("UPSERT INTO " + tablename + " values('" + STRINGS[i2] + "'," + i2 + "," + (i2 + 1) + "," + (i2 + 2) + ",'" + STRINGS[25 - i2] + "')");
            }
            conn.commit();
            int limit = 10;
            int offset = 8;
            ResultSet rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " order by t_id limit " + limit + " offset " + offset);
            for (i = 0; i < limit; ++i) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)("Expected string didn't match for i = " + i), (Object)STRINGS[offset + i], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, true);
            int filterCond = 10;
            rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " where k2 > " + filterCond + " order by t_id limit " + limit + " offset " + offset);
            limit = 5;
            for (i = 0; i < limit; ++i) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)("Expected string didn't match for i = " + i), (Object)STRINGS[offset + filterCond + i], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, true);
            limit = 35;
            rs = conn.createStatement().executeQuery("SELECT t_id from " + tablename + " union all SELECT t_id from " + tablename + " offset " + offset + " FETCH FIRST " + limit + " rows only");
            i = 0;
            while (i++ < STRINGS.length - offset) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)STRINGS[offset + i - 1], (Object)rs.getString(1));
            }
            i = 0;
            while (i++ < limit - STRINGS.length - offset) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)STRINGS[i - 1], (Object)rs.getString(1));
            }
            this.assertServerPagingMetric(tablename, rs, true);
            limit = 1;
            offset = 1;
            rs = conn.createStatement().executeQuery("SELECT k2 from " + tablename + " order by k2 desc limit " + limit + " offset " + offset);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)25L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            this.assertServerPagingMetric(tablename, rs, true);
        }
    }

    @Test
    public void testGroupBy() throws SQLException {
        String tablename = ServerPagingIT.generateUniqueName();
        String indexName = ServerPagingIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tablename + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER CONSTRAINT pk PRIMARY KEY (t_id, k1)) ";
        String indexDDl = "CREATE INDEX IF NOT EXISTS " + indexName + " ON " + tablename + "(k2)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ServerPagingIT.getUrl(), props);){
            ServerPagingIT.createTestTable(ServerPagingIT.getUrl(), ddl);
            ServerPagingIT.createTestTable(ServerPagingIT.getUrl(), indexDDl);
            for (int i = 0; i < 8; ++i) {
                conn.createStatement().execute("UPSERT INTO " + tablename + " values('tenant1'," + i + "," + (i + 1) + ")");
            }
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + tablename + " where t_id = 'tenant1' AND (k2 IN (5,6) or k2 is null) group by k2=6");
            while (rs.next()) {
                Assert.assertEquals((long)1L, (long)rs.getInt(1));
            }
            Assert.assertFalse((boolean)rs.next());
            this.assertServerPagingMetric(indexName, rs, true);
        }
    }

    @Test
    public void testUncoveredQuery() throws Exception {
        String dataTableName = ServerPagingIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(ServerPagingIT.getUrl());){
            String indexTableName = ServerPagingIT.generateUniqueName();
            conn.createStatement().execute("CREATE UNCOVERED INDEX " + indexTableName + " on " + dataTableName + " (val1) ");
            int limit = 10;
            String selectSql = "SELECT  val2, val3 from " + dataTableName + " WHERE val1 = 'bc' AND (val2 = 'bcd' OR val3 ='bcde') LIMIT " + limit;
            GlobalIndexCheckerIT.assertExplainPlanWithLimit(conn, selectSql, dataTableName, indexTableName, limit);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            this.assertServerPagingMetric(indexTableName, rs, true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('c', 'ab','cde', 'cdef')");
            conn.commit();
            selectSql = "SELECT count(val3) from " + dataTableName + " where val1 > '0' GROUP BY val1";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT count(val3) from " + dataTableName + " where val1 > '0'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            selectSql = "SELECT val3 from " + dataTableName + " where val1 > '0' ORDER BY val1";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"cdef", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testNumberOfRPCsWithPaging() throws SQLException {
        int i;
        Connection conn = DriverManager.getConnection(ServerPagingIT.getUrl());
        String tableName = ServerPagingIT.generateUniqueName();
        PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
        stmt.execute("CREATE TABLE " + tableName + " (A UNSIGNED_LONG NOT NULL PRIMARY KEY, Z UNSIGNED_LONG)");
        for (i = 1; i <= 200; ++i) {
            String sql = String.format("UPSERT INTO %s VALUES (%d, %d)", tableName, i, i);
            stmt.execute(sql);
        }
        conn.commit();
        for (i = 1; i <= 200; i += 2) {
            stmt.execute("DELETE FROM " + tableName + " WHERE A = " + i);
            conn.commit();
        }
        ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);
        while (rs.next()) {
        }
        Map metrics = PhoenixRuntime.getRequestReadMetricInfo((ResultSet)rs);
        long numRpc = this.getMetricValue(metrics, MetricType.COUNT_RPC_CALLS);
        Assert.assertEquals((long)101L, (long)numRpc);
    }

    @Test
    public void testBloomFilterDefaults() throws Exception {
        String dataTableName = ServerPagingIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(ServerPagingIT.getUrl());){
            PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
            TableDescriptor td = pconn.getQueryServices().getTableDescriptor(Bytes.toBytes((String)dataTableName));
            BloomType bloomType = td.getColumnFamilies()[0].getBloomFilterType();
            Assert.assertEquals((Object)BloomType.ROW, (Object)bloomType);
            Assert.assertFalse((boolean)PagingRegionScanner.useBloomFilterForMultiKeyPointLookup((TableDescriptor)td));
            String ddl = String.format("alter table %s set \"%s\" = true", dataTableName, "phoenix.bloomfilter.multikey.pointlookup");
            conn.createStatement().execute(ddl);
            td = pconn.getQueryServices().getTableDescriptor(Bytes.toBytes((String)dataTableName));
            Assert.assertTrue((boolean)PagingRegionScanner.useBloomFilterForMultiKeyPointLookup((TableDescriptor)td));
        }
    }

    private void populateTable(String tableName) throws Exception {
        Connection conn = DriverManager.getConnection(ServerPagingIT.getUrl());
        conn.createStatement().execute("create table " + tableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))");
        conn.createStatement().execute("upsert into " + tableName + " values ('a', 'ab', 'abc', 'abcd')");
        conn.commit();
        conn.createStatement().execute("upsert into " + tableName + " values ('b', 'bc', 'bcd', 'bcde')");
        conn.commit();
        conn.close();
    }

    private long getMetricValue(Map<String, Map<MetricType, Long>> metrics, MetricType type) {
        long result = 0L;
        for (Map.Entry<String, Map<MetricType, Long>> entry : metrics.entrySet()) {
            Long val = entry.getValue().get(type);
            if (val == null) continue;
            result += val.longValue();
        }
        return result;
    }
}

