/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.phoenix.cache.ServerMetadataCacheImpl;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.util.SchemaUtil;

public class ServerMetadataCacheTestImpl
extends ServerMetadataCacheImpl {
    private static volatile Map<ServerName, ServerMetadataCacheTestImpl> INSTANCES = new HashMap<ServerName, ServerMetadataCacheTestImpl>();
    private Connection connectionForTesting;

    ServerMetadataCacheTestImpl(Configuration conf) {
        super(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerMetadataCacheTestImpl getInstance(Configuration conf, ServerName serverName) {
        ServerMetadataCacheTestImpl result = INSTANCES.get(serverName);
        if (result != null) return result;
        Class<ServerMetadataCacheTestImpl> clazz = ServerMetadataCacheTestImpl.class;
        synchronized (ServerMetadataCacheTestImpl.class) {
            result = INSTANCES.get(serverName);
            if (result != null) return result;
            result = new ServerMetadataCacheTestImpl(conf);
            INSTANCES.put(serverName, result);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public static void setInstance(ServerName serverName, ServerMetadataCacheTestImpl cache) {
        INSTANCES.put(serverName, cache);
    }

    public Long getLastDDLTimestampForTableFromCacheOnly(byte[] tenantID, byte[] schemaName, byte[] tableName) {
        byte[] tableKey = SchemaUtil.getTableKey((byte[])tenantID, (byte[])schemaName, (byte[])tableName);
        ImmutableBytesPtr tableKeyPtr = new ImmutableBytesPtr(tableKey);
        return (Long)this.lastDDLTimestampMap.getIfPresent((Object)tableKeyPtr);
    }

    public void setConnectionForTesting(Connection connection) {
        this.connectionForTesting = connection;
    }

    public static void resetCache() {
        INSTANCES.clear();
    }

    protected Connection getConnection(Properties properties) throws SQLException {
        return this.connectionForTesting != null ? this.connectionForTesting : super.getConnection(properties);
    }
}

