/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class SerialIteratorsIT
extends ParallelStatsDisabledIT {
    private String tableName = SerialIteratorsIT.generateUniqueName();
    private final String[] strings = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private final String ddl = "CREATE TABLE " + this.tableName + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nC3.k3 INTEGER,\nC2.v1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2)) SPLIT ON ('e','i','o')";

    private static Connection getConnection() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.query.force.rowkeyorder", Boolean.toString(false));
        Connection conn = DriverManager.getConnection(SerialIteratorsIT.getUrl(), props);
        return conn;
    }

    @Test
    public void testConcatenatingSerialIterators() throws Exception {
        Connection conn = SerialIteratorsIT.getConnection();
        SerialIteratorsIT.createTestTable(SerialIteratorsIT.getUrl(), this.ddl);
        this.initTableValues(conn);
        String query = "SELECT t_id from " + this.tableName + " order by t_id desc limit " + 10;
        PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
        ResultSet rs = stmt.executeQuery(query);
        int i = 25;
        while (i >= 16) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)this.strings[i--], (Object)rs.getString(1));
        }
        query = "SELECT t_id from " + this.tableName + " order by t_id limit " + 10;
        stmt = conn.createStatement().unwrap(PhoenixStatement.class);
        rs = stmt.executeQuery(query);
        i = 0;
        while (i < 10) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)this.strings[i++], (Object)rs.getString(1));
        }
        conn.close();
    }

    private void initTableValues(Connection conn) throws SQLException {
        for (int i = 0; i < 26; ++i) {
            conn.createStatement().execute("UPSERT INTO " + this.tableName + " values('" + this.strings[i] + "'," + i + "," + (i + 1) + "," + (i + 2) + ",'" + this.strings[25 - i] + "')");
        }
        conn.commit();
    }
}

