/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Properties;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.SequenceNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class SequencePointInTimeIT
extends BaseTest {
    private static final String SCHEMA_NAME = "S";

    private static String generateSequenceNameWithSchema() {
        return SchemaUtil.getTableName((String)SCHEMA_NAME, (String)SequencePointInTimeIT.generateUniqueSequenceName());
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)5);
        props.put("phoenix.system.default.keep.deleted.cells", Boolean.TRUE.toString());
        props.put("phoenix.system.default.max.versions", "5");
        SequencePointInTimeIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testPointInTimeSequence() throws Exception {
        String seqName = SequencePointInTimeIT.generateSequenceNameWithSchema();
        Properties scnProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        scnProps.put("CurrentSCN", Long.toString(EnvironmentEdgeManager.currentTimeMillis()));
        Connection beforeSeqConn = DriverManager.getConnection(SequencePointInTimeIT.getUrl(), scnProps);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SequencePointInTimeIT.getUrl(), props);
        conn.createStatement().execute("CREATE SEQUENCE " + seqName + "");
        try {
            beforeSeqConn.createStatement().executeQuery("SELECT next value for " + seqName);
            Assert.fail();
        }
        catch (SequenceNotFoundException e) {
            beforeSeqConn.close();
        }
        scnProps.put("CurrentSCN", Long.toString(EnvironmentEdgeManager.currentTimeMillis()));
        Connection afterSeqConn = DriverManager.getConnection(SequencePointInTimeIT.getUrl(), scnProps);
        ResultSet rs = conn.createStatement().executeQuery("SELECT next value for " + seqName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = conn.createStatement().executeQuery("SELECT next value for " + seqName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        conn.createStatement().execute("DROP SEQUENCE " + seqName + "");
        rs = afterSeqConn.createStatement().executeQuery("SELECT next value for " + seqName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        try {
            rs = conn.createStatement().executeQuery("SELECT next value for " + seqName);
            Assert.fail();
        }
        catch (SequenceNotFoundException sequenceNotFoundException) {
            // empty catch block
        }
        conn.createStatement().execute("CREATE SEQUENCE " + seqName);
        rs = conn.createStatement().executeQuery("SELECT next value for " + seqName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = afterSeqConn.createStatement().executeQuery("SELECT next value for " + seqName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        afterSeqConn.close();
    }
}

