/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.export.SchemaRegistryRepository;
import org.apache.phoenix.schema.export.SchemaWriter;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class SchemaRegistryFailureIT
extends ParallelStatsDisabledIT {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("org.apache.phoenix.export.schemaregistry.impl", ExplodingSchemaRegistryRepository.class.getName());
        SchemaRegistryFailureIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testFailedCreateRollback() throws Exception {
        String schemaName = "S_" + SchemaRegistryFailureIT.generateUniqueName();
        String tableName = "T_" + SchemaRegistryFailureIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(SchemaRegistryFailureIT.getUrl());){
            String ddl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) MULTI_TENANT=true, CHANGE_DETECTION_ENABLED=true";
            try {
                conn.createStatement().execute(ddl);
                Assert.fail((String)"Should have thrown SQLException");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.ERROR_WRITING_TO_SCHEMA_REGISTRY.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                PTable table = conn.getTable(fullTableName);
                Assert.fail((String)"Shouldn't have found the table because it shouldn't have been created");
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testFailedAlterRollback() throws Exception {
        String schemaName = "S_" + SchemaRegistryFailureIT.generateUniqueName();
        String tableName = "T_" + SchemaRegistryFailureIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(SchemaRegistryFailureIT.getUrl());){
            String ddl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) MULTI_TENANT=true";
            conn.createStatement().execute(ddl);
            String alterDdl = "ALTER TABLE " + fullTableName + " SET CHANGE_DETECTION_ENABLED=true";
            try {
                conn.createStatement().execute(alterDdl);
                Assert.fail((String)"Should have failed because of schema registry exception");
            }
            catch (SQLException se) {
                Assert.assertEquals((long)SQLExceptionCode.ERROR_WRITING_TO_SCHEMA_REGISTRY.getErrorCode(), (long)se.getErrorCode());
            }
            PTable table = conn.getTable(fullTableName);
            Assert.assertFalse((boolean)table.isChangeDetectionEnabled());
        }
    }

    public static class ExplodingSchemaRegistryRepository
    implements SchemaRegistryRepository {
        public void init(Configuration conf) throws IOException {
        }

        public String exportSchema(SchemaWriter writer, PTable table) throws IOException {
            throw new IOException("I always explode!");
        }

        public String getSchemaById(String schemaId) {
            return null;
        }

        public String getSchemaByTable(PTable table) {
            return null;
        }

        public void close() throws IOException {
        }
    }
}

