/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.iterate.ScanningResultPostDummyResultCaller;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ScanUncommittedWithRegionMovesIT
extends ParallelStatsDisabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanUncommittedWithRegionMovesIT.class);
    private static boolean hasTestStarted = false;
    private static int countOfDummyResults = 0;
    private static final Set<String> TABLE_NAMES = new HashSet<String>();

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)2);
        props.put("phoenix.server.page.size.ms", Long.toString(0L));
        props.put("phoenix.query.request.metrics.enabled", String.valueOf(true));
        props.put("phoenix.tests.minicluster.numregionservers", String.valueOf(2));
        props.put("hbase.client.scanner.max.result.size", String.valueOf(1));
        props.put("phoenix.scanning.result.post.dummy.process", TestScanningResultPostDummyResultCaller.class.getName());
        ScanUncommittedWithRegionMovesIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @After
    public void tearDown() throws Exception {
        TABLE_NAMES.clear();
        hasTestStarted = false;
        countOfDummyResults = 0;
    }

    private static void moveRegionsOfTable(String tableName) throws IOException {
        List regionsOnServer2;
        List regionsOnServer1;
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            return;
        }
        Admin admin = ScanUncommittedWithRegionMovesIT.getUtility().getAdmin();
        ArrayList servers = new ArrayList(admin.getRegionServers());
        ServerName server1 = (ServerName)servers.get(0);
        ServerName server2 = (ServerName)servers.get(1);
        try {
            regionsOnServer1 = admin.getRegions(server1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            regionsOnServer2 = admin.getRegions(server2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        regionsOnServer1.forEach(regionInfo -> {
            if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                try {
                    admin.move(regionInfo.getEncodedNameAsBytes(), server2);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        regionsOnServer2.forEach(regionInfo -> {
            if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                try {
                    admin.move(regionInfo.getEncodedNameAsBytes(), server1);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testUncoveredIndex() throws Exception {
        hasTestStarted = true;
        String dataTableName = ScanUncommittedWithRegionMovesIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(ScanUncommittedWithRegionMovesIT.getUrl());){
            String indexTableName = ScanUncommittedWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE UNCOVERED INDEX " + indexTableName + " on " + dataTableName + " (val1) ");
            ScanUncommittedWithRegionMovesIT.populateTableWithAdditionalRows(dataTableName, conn);
            conn.commit();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            String selectSql = "SELECT  val2, val3 from " + dataTableName + " WHERE val1 IS NOT NULL";
            try (ResultSet rs = conn.createStatement().executeQuery(selectSql);){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
                Assert.assertEquals((Object)"abcd", (Object)rs.getString(2));
                ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(dataTableName);
                ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(indexTableName);
                try (Connection newConn = DriverManager.getConnection(ScanUncommittedWithRegionMovesIT.getUrl());){
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('c1', 'cd1','cde1', 'cdef1')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('g1', 'gh1','gh11', 'gh111')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('l', 'lm','lmn', 'lmno')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('m', 'mn','mno', 'mnop')");
                    newConn.commit();
                }
                ScanUncommittedWithRegionMovesIT.assertRowsWithOldScanner(dataTableName, indexTableName, rs, true);
            }
            rs = conn.createStatement().executeQuery(selectSql);
            var7_9 = null;
            try {
                ScanUncommittedWithRegionMovesIT.assertRowsWithNewScanner(dataTableName, indexTableName, rs, true);
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var7_9 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test
    public void testCoveredIndex() throws Exception {
        hasTestStarted = true;
        String dataTableName = ScanUncommittedWithRegionMovesIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(ScanUncommittedWithRegionMovesIT.getUrl());){
            String indexTableName = ScanUncommittedWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) INCLUDE (val2, val3)");
            ScanUncommittedWithRegionMovesIT.populateTableWithAdditionalRows(dataTableName, conn);
            conn.commit();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            String selectSql = "SELECT  val2, val3 from " + dataTableName + " WHERE val1 IS NOT NULL";
            try (ResultSet rs = conn.createStatement().executeQuery(selectSql);){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
                Assert.assertEquals((Object)"abcd", (Object)rs.getString(2));
                ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(dataTableName);
                ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(indexTableName);
                try (Connection newConn = DriverManager.getConnection(ScanUncommittedWithRegionMovesIT.getUrl());){
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('c1', 'cd1','cde1', 'cdef1')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('g1', 'gh1','gh11', 'gh111')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('l', 'lm','lmn', 'lmno')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('m', 'mn','mno', 'mnop')");
                    newConn.commit();
                }
                ScanUncommittedWithRegionMovesIT.assertRowsWithOldScanner(dataTableName, indexTableName, rs, true);
            }
            rs = conn.createStatement().executeQuery(selectSql);
            var7_9 = null;
            try {
                ScanUncommittedWithRegionMovesIT.assertRowsWithNewScanner(dataTableName, indexTableName, rs, true);
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var7_9 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test
    public void testNoIndex() throws Exception {
        hasTestStarted = true;
        String dataTableName = ScanUncommittedWithRegionMovesIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(ScanUncommittedWithRegionMovesIT.getUrl());){
            ScanUncommittedWithRegionMovesIT.populateTableWithAdditionalRows(dataTableName, conn);
            conn.commit();
            TABLE_NAMES.add(dataTableName);
            String selectSql = "SELECT  val2, val3 from " + dataTableName + " WHERE val1 IS NOT NULL";
            try (ResultSet rs = conn.createStatement().executeQuery(selectSql);){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
                Assert.assertEquals((Object)"abcd", (Object)rs.getString(2));
                ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(dataTableName);
                try (Connection newConn = DriverManager.getConnection(ScanUncommittedWithRegionMovesIT.getUrl());){
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('c1', 'cd1','cde1', 'cdef1')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('g1', 'gh1','gh11', 'gh111')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('l', 'lm','lmn', 'lmno')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('m', 'mn','mno', 'mnop')");
                    newConn.commit();
                }
                ScanUncommittedWithRegionMovesIT.assertRowsWithOldScanner(dataTableName, "", rs, true);
            }
            rs = conn.createStatement().executeQuery(selectSql);
            var6_8 = null;
            try {
                ScanUncommittedWithRegionMovesIT.assertRowsWithNewScanner(dataTableName, "", rs, true);
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var6_8 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test
    public void testUncoveredIndex2() throws Exception {
        hasTestStarted = true;
        String dataTableName = ScanUncommittedWithRegionMovesIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(ScanUncommittedWithRegionMovesIT.getUrl());){
            String indexTableName = ScanUncommittedWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE UNCOVERED INDEX " + indexTableName + " on " + dataTableName + " (val1) ");
            ScanUncommittedWithRegionMovesIT.populateTableWithAdditionalRows(dataTableName, conn);
            conn.commit();
            String selectSql = "SELECT  val2, val3 from " + dataTableName + " WHERE val1 IS NOT NULL";
            try (ResultSet rs = conn.createStatement().executeQuery(selectSql);){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
                Assert.assertEquals((Object)"abcd", (Object)rs.getString(2));
                try (Connection newConn = DriverManager.getConnection(ScanUncommittedWithRegionMovesIT.getUrl());){
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('c1', 'cd1','cde1', 'cdef1')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('g1', 'gh1','gh11', 'gh111')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('l', 'lm','lmn', 'lmno')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('m', 'mn','mno', 'mnop')");
                    newConn.commit();
                }
                ScanUncommittedWithRegionMovesIT.assertRowsWithOldScanner(dataTableName, indexTableName, rs, false);
            }
            rs = conn.createStatement().executeQuery(selectSql);
            var7_9 = null;
            try {
                ScanUncommittedWithRegionMovesIT.assertRowsWithNewScanner(dataTableName, indexTableName, rs, false);
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var7_9 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test
    public void testCoveredIndex2() throws Exception {
        hasTestStarted = true;
        String dataTableName = ScanUncommittedWithRegionMovesIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(ScanUncommittedWithRegionMovesIT.getUrl());){
            String indexTableName = ScanUncommittedWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) INCLUDE (val2, val3)");
            ScanUncommittedWithRegionMovesIT.populateTableWithAdditionalRows(dataTableName, conn);
            conn.commit();
            String selectSql = "SELECT  val2, val3 from " + dataTableName + " WHERE val1 IS NOT NULL";
            try (ResultSet rs = conn.createStatement().executeQuery(selectSql);){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
                Assert.assertEquals((Object)"abcd", (Object)rs.getString(2));
                try (Connection newConn = DriverManager.getConnection(ScanUncommittedWithRegionMovesIT.getUrl());){
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('c1', 'cd1','cde1', 'cdef1')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('g1', 'gh1','gh11', 'gh111')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('l', 'lm','lmn', 'lmno')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('m', 'mn','mno', 'mnop')");
                    newConn.commit();
                }
                ScanUncommittedWithRegionMovesIT.assertRowsWithOldScanner(dataTableName, indexTableName, rs, false);
            }
            rs = conn.createStatement().executeQuery(selectSql);
            var7_9 = null;
            try {
                ScanUncommittedWithRegionMovesIT.assertRowsWithNewScanner(dataTableName, indexTableName, rs, false);
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var7_9 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test
    public void testNoIndex2() throws Exception {
        hasTestStarted = true;
        String dataTableName = ScanUncommittedWithRegionMovesIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(ScanUncommittedWithRegionMovesIT.getUrl());){
            ScanUncommittedWithRegionMovesIT.populateTableWithAdditionalRows(dataTableName, conn);
            conn.commit();
            TABLE_NAMES.add(dataTableName);
            String selectSql = "SELECT  val2, val3 from " + dataTableName + " WHERE val1 IS NOT NULL";
            try (ResultSet rs = conn.createStatement().executeQuery(selectSql);){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
                Assert.assertEquals((Object)"abcd", (Object)rs.getString(2));
                try (Connection newConn = DriverManager.getConnection(ScanUncommittedWithRegionMovesIT.getUrl());){
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('c1', 'cd1','cde1', 'cdef1')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('g1', 'gh1','gh11', 'gh111')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('l', 'lm','lmn', 'lmno')");
                    newConn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('m', 'mn','mno', 'mnop')");
                    newConn.commit();
                }
                ScanUncommittedWithRegionMovesIT.assertRowsWithOldScanner(dataTableName, "", rs, false);
            }
            rs = conn.createStatement().executeQuery(selectSql);
            var6_8 = null;
            try {
                ScanUncommittedWithRegionMovesIT.assertRowsWithNewScanner(dataTableName, "", rs, false);
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var6_8 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    private static void populateTableWithAdditionalRows(String dataTableName, Connection conn) throws SQLException {
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('c', 'cd','cde', 'cdef')");
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('d', 'de','de1', 'de11')");
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('e', 'ef','ef1', 'ef11')");
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('f', 'fg','fg1', 'fg11')");
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('g', 'gh','gh1', 'gh11')");
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('h', 'hi','hi1', 'hi11')");
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('i', 'ij','ij1', 'ij11')");
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('j', 'jk','jk1', 'jk11')");
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('k', 'kl','kl1', 'kl11')");
    }

    private static void assertRowsWithNewScanner(String dataTableName, String indexTableName, ResultSet rs, boolean moveRegions) throws SQLException, IOException {
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
        Assert.assertEquals((Object)"abcd", (Object)rs.getString(2));
        if (moveRegions) {
            ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(indexTableName);
        }
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"bcd", (Object)rs.getString(1));
        Assert.assertEquals((Object)"bcde", (Object)rs.getString(2));
        if (moveRegions) {
            ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(indexTableName);
        }
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"cde", (Object)rs.getString(1));
        Assert.assertEquals((Object)"cdef", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"cde1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"cdef1", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"de1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"de11", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ef1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"ef11", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"fg1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"fg11", (Object)rs.getString(2));
        if (moveRegions) {
            ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(indexTableName);
        }
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"gh1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"gh11", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"gh11", (Object)rs.getString(1));
        Assert.assertEquals((Object)"gh111", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"hi1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"hi11", (Object)rs.getString(2));
        if (moveRegions) {
            ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(indexTableName);
        }
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ij1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"ij11", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"jk1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"jk11", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"kl1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"kl11", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"lmn", (Object)rs.getString(1));
        Assert.assertEquals((Object)"lmno", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"mno", (Object)rs.getString(1));
        Assert.assertEquals((Object)"mnop", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    private static void assertRowsWithOldScanner(String dataTableName, String indexTableName, ResultSet rs, boolean moveRegions) throws SQLException, IOException {
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"bcd", (Object)rs.getString(1));
        Assert.assertEquals((Object)"bcde", (Object)rs.getString(2));
        if (moveRegions) {
            ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(indexTableName);
        }
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"cde", (Object)rs.getString(1));
        Assert.assertEquals((Object)"cdef", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"de1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"de11", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ef1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"ef11", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"fg1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"fg11", (Object)rs.getString(2));
        if (moveRegions) {
            ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(indexTableName);
        }
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"gh1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"gh11", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"hi1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"hi11", (Object)rs.getString(2));
        if (moveRegions) {
            ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(indexTableName);
        }
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ij1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"ij11", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"jk1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"jk11", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"kl1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"kl11", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    private void populateTable(String tableName) throws Exception {
        Connection conn = DriverManager.getConnection(ScanUncommittedWithRegionMovesIT.getUrl());
        conn.createStatement().execute("create table " + tableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10)) SPLIT ON ('d', 'h', 'k')");
        conn.createStatement().execute("upsert into " + tableName + " values ('a', 'ab', 'abc', 'abcd')");
        conn.commit();
        conn.createStatement().execute("upsert into " + tableName + " values ('b', 'bc', 'bcd', 'bcde')");
        conn.commit();
        conn.close();
    }

    private static class TestScanningResultPostDummyResultCaller
    extends ScanningResultPostDummyResultCaller {
        private TestScanningResultPostDummyResultCaller() {
        }

        public void postDummyProcess() {
            if (hasTestStarted && countOfDummyResults++ % 5 == 0 && (countOfDummyResults < 17 || countOfDummyResults > 28 && countOfDummyResults < 40)) {
                LOGGER.info("Moving regions of tables {}. current count of dummy results: {}", (Object)TABLE_NAMES, (Object)countOfDummyResults);
                TABLE_NAMES.forEach(table -> {
                    try {
                        ScanUncommittedWithRegionMovesIT.moveRegionsOfTable(table);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }
}

