/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ScanBoundaryFunction2IT
extends ParallelStatsDisabledIT {
    private String tableName;
    private String fullTableName;

    @Before
    public void setUp() throws Exception {
        this.tableName = ScanBoundaryFunction2IT.generateUniqueName();
        this.fullTableName = "\"" + this.tableName + "\"";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunction2IT.getUrl(), props);){
            String createTableSql = "CREATE TABLE " + this.fullTableName + " (PK1 INTEGER NOT NULL, PK2 VARCHAR NOT NULL, COL1 VARCHAR, COL2 INTEGER, CONSTRAINT PK PRIMARY KEY (PK1, PK2))";
            conn.createStatement().execute(createTableSql);
            String upsertSql = "UPSERT INTO " + this.fullTableName + " (PK1, PK2, COL1, COL2) VALUES (?, ?, ?, ?)";
            try (PreparedStatement stmt = conn.prepareStatement(upsertSql);){
                for (int i = 1; i <= 30; ++i) {
                    int pk1 = (i - 1) % 3 + 1;
                    String pk2 = String.format("KEY_%03d", i);
                    stmt.setInt(1, pk1);
                    stmt.setString(2, pk2);
                    stmt.setString(3, "Value_" + i);
                    stmt.setInt(4, i * 10);
                    stmt.executeUpdate();
                }
            }
            conn.commit();
        }
    }

    @Test
    public void testScanStartKeyOnlyWithCompositePK() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunction2IT.getUrl(), props);){
            String sql = "SELECT PK1, PK2 FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                byte[] compositeKeyBytes = this.createCompositeKeyBytes(2, "KEY_010");
                stmt.setBytes(1, compositeKeyBytes);
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertArrayEquals((String)"SCAN_START_KEY should set scan start row to composite key", (byte[])compositeKeyBytes, (byte[])scan.getStartRow());
                Assert.assertEquals((String)"SCAN_END_KEY not specified, so stop row should be empty", (long)0L, (long)scan.getStopRow().length);
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        results.add(rs.getInt(1) + ":" + rs.getString(2));
                    }
                    Assert.assertEquals((long)17L, (long)results.size());
                    Assert.assertEquals((Object)"2:KEY_011", results.get(0));
                    Assert.assertEquals((Object)"3:KEY_030", results.get(16));
                }
            }
        }
    }

    @Test
    public void testScanEndKeyOnlyWithCompositePK() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunction2IT.getUrl(), props);){
            String sql = "SELECT PK1, PK2 FROM " + this.fullTableName + " WHERE SCAN_END_KEY() = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                byte[] compositeKeyBytes = this.createCompositeKeyBytes(2, "KEY_020");
                stmt.setBytes(1, compositeKeyBytes);
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertEquals((String)"SCAN_START_KEY not specified, so start row should be empty", (long)0L, (long)scan.getStartRow().length);
                Assert.assertArrayEquals((String)"SCAN_END_KEY should set scan stop row to composite key", (byte[])compositeKeyBytes, (byte[])scan.getStopRow());
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        results.add(rs.getInt(1) + ":" + rs.getString(2));
                    }
                    Assert.assertEquals((long)16L, (long)results.size());
                    Assert.assertEquals((Object)"1:KEY_001", results.get(0));
                    Assert.assertEquals((Object)"2:KEY_017", results.get(15));
                }
            }
        }
    }

    @Test
    public void testScanBothBoundariesWithCompositePK() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunction2IT.getUrl(), props);){
            String sql = "SELECT PK1, PK2 FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                byte[] startKeyBytes = this.createCompositeKeyBytes(1, "KEY_015");
                byte[] endKeyBytes = this.createCompositeKeyBytes(3, "KEY_005");
                stmt.setBytes(1, startKeyBytes);
                stmt.setBytes(2, endKeyBytes);
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertArrayEquals((String)"SCAN_START_KEY should set scan start row to first composite key", (byte[])startKeyBytes, (byte[])scan.getStartRow());
                Assert.assertArrayEquals((String)"SCAN_END_KEY should set scan stop row to second composite key", (byte[])endKeyBytes, (byte[])scan.getStopRow());
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        results.add(rs.getInt(1) + ":" + rs.getString(2));
                    }
                    Assert.assertEquals((long)16L, (long)results.size());
                    Assert.assertEquals((Object)"1:KEY_016", results.get(0));
                    Assert.assertEquals((Object)"3:KEY_003", results.get(15));
                }
            }
        }
    }

    @Test
    public void testScanEndWithPkFilters1() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunction2IT.getUrl(), props);){
            String sql = "SELECT PK1, PK2, COL2 FROM " + this.fullTableName + " WHERE SCAN_END_KEY() = ? AND (PK1 = ? AND PK2 > ?)";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                byte[] startKeyBytes = this.createCompositeKeyBytes(1, "KEY_001");
                byte[] endKeyBytes = this.createCompositeKeyBytes(3, "KEY_030");
                stmt.setBytes(1, endKeyBytes);
                stmt.setInt(2, 2);
                stmt.setString(3, "KEY_005");
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                byte[] combinedKeyBytes = this.createCompositeKeyBytes(2, "KEY_005");
                byte[] expectedScanStartKeyBytes = new byte[combinedKeyBytes.length + 1];
                System.arraycopy(combinedKeyBytes, 0, expectedScanStartKeyBytes, 0, combinedKeyBytes.length);
                expectedScanStartKeyBytes[expectedScanStartKeyBytes.length - 1] = 1;
                Assert.assertArrayEquals((String)"SCAN_START_KEY should set scan start row as PK1 value", (byte[])expectedScanStartKeyBytes, (byte[])scan.getStartRow());
                Assert.assertArrayEquals((String)"SCAN_END_KEY should set scan stop row with composite PK filter", (byte[])PInteger.INSTANCE.toBytes((Object)3), (byte[])scan.getStopRow());
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        int pk1 = rs.getInt(1);
                        String pk2 = rs.getString(2);
                        results.add(pk1 + ":" + pk2);
                        Assert.assertEquals((String)"All results should have PK1 = 2", (long)2L, (long)pk1);
                    }
                    Assert.assertEquals((long)8L, (long)results.size());
                    Assert.assertEquals((Object)"2:KEY_008", results.get(0));
                    Assert.assertEquals((Object)"2:KEY_029", results.get(7));
                }
            }
        }
    }

    @Test
    public void testScanEndWithPkFilters2() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunction2IT.getUrl(), props);){
            String sql = "SELECT PK1, PK2, COL2 FROM " + this.fullTableName + " WHERE SCAN_END_KEY() = ? AND (PK1 > ?)";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                byte[] endKeyBytes = this.createCompositeKeyBytes(3, "KEY_025");
                stmt.setBytes(1, endKeyBytes);
                stmt.setInt(2, 2);
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertArrayEquals((String)"SCAN_START_KEY should set scan start row as PK1 value", (byte[])PInteger.INSTANCE.toBytes((Object)3), (byte[])scan.getStartRow());
                Assert.assertArrayEquals((String)"SCAN_END_KEY should set scan stop row with SCAN_END_KEY", (byte[])endKeyBytes, (byte[])scan.getStopRow());
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        int pk1 = rs.getInt(1);
                        String pk2 = rs.getString(2);
                        results.add(pk1 + ":" + pk2);
                    }
                    Assert.assertEquals((long)8L, (long)results.size());
                    Assert.assertEquals((Object)"3:KEY_003", results.get(0));
                    Assert.assertEquals((Object)"3:KEY_024", results.get(7));
                }
            }
        }
    }

    @Test
    public void testScanBoundariesFailWithCompositePK() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunction2IT.getUrl(), props);){
            String sql = "SELECT PK1, PK2 FROM " + this.fullTableName + " WHERE SCAN_START_KEY() != ?";
            PreparedStatement stmt = conn.prepareStatement(sql);
            Throwable throwable = null;
            try {
                stmt.setBytes(1, this.createCompositeKeyBytes(1, "KEY_010"));
                try {
                    PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                    ResultSet rs = stmt.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        try {
                            rs.next();
                            throw new AssertionError((Object)"Should not reach here");
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (rs != null) {
                            if (throwable2 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                            } else {
                                rs.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    Assert.assertTrue((String)"ScanStartKeyFunction should not be instantiated", (boolean)e.getMessage().contains("java.lang.InstantiationException: org.apache.phoenix.expression.function.ScanStartKeyFunction"));
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                try {
                    throwable = throwable7;
                    throw throwable7;
                }
                catch (Throwable throwable8) {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                    throw throwable8;
                }
            }
        }
    }

    private byte[] createCompositeKeyBytes(int pk1, String pk2) {
        byte[] pk1Bytes = PInteger.INSTANCE.toBytes((Object)pk1);
        byte[] pk2Bytes = PVarchar.INSTANCE.toBytes((Object)pk2);
        byte[] result = new byte[pk1Bytes.length + pk2Bytes.length];
        System.arraycopy(pk1Bytes, 0, result, 0, pk1Bytes.length);
        System.arraycopy(pk2Bytes, 0, result, pk1Bytes.length, pk2Bytes.length);
        return result;
    }
}

