/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class SCNIT
extends ParallelStatsDisabledIT {
    @Test
    public void testReadBeforeDelete() throws Exception {
        ResultSet rs;
        long timeAfterDelete;
        long timeBeforeDelete;
        String schemaName = SCNIT.generateUniqueName();
        String tableName = SCNIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (Connection conn = DriverManager.getConnection(SCNIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v VARCHAR)");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','aa')");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('b','bb')");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('c','cc')");
            conn.commit();
            timeBeforeDelete = EnvironmentEdgeManager.currentTime() + 1L;
            Thread.sleep(2L);
            conn.createStatement().execute("DELETE FROM " + fullTableName + " WHERE k = 'b'");
            conn.commit();
            timeAfterDelete = EnvironmentEdgeManager.currentTime() + 1L;
        }
        Properties props = new Properties();
        props.setProperty("CurrentSCN", Long.toString(timeBeforeDelete));
        try (Connection connscn = DriverManager.getConnection(SCNIT.getUrl(), props);){
            rs = connscn.createStatement().executeQuery("select * from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
        }
        props.clear();
        props.setProperty("CurrentSCN", Long.toString(timeAfterDelete));
        connscn = DriverManager.getConnection(SCNIT.getUrl(), props);
        var10_10 = null;
        try {
            rs = connscn.createStatement().executeQuery("select * from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (connscn != null) {
                if (var10_10 != null) {
                    try {
                        connscn.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    connscn.close();
                }
            }
        }
    }

    @Test
    public void testSCNWithTTL() throws Exception {
        int ttl = 2;
        String fullTableName = this.createTableWithTTL(ttl);
        Thread.sleep(ttl * 1000 + 1000);
        Properties props = new Properties();
        props.setProperty("CurrentSCN", Long.toString(EnvironmentEdgeManager.currentTime() - 1000L));
        try (Connection connscn = DriverManager.getConnection(SCNIT.getUrl(), props);){
            ResultSet rs = connscn.createStatement().executeQuery("select * from " + fullTableName);
            Assert.assertFalse((boolean)rs.next());
            rs.close();
        }
    }

    private String createTableWithTTL(int ttl) throws SQLException, InterruptedException {
        String schemaName = SCNIT.generateUniqueName();
        String tableName = SCNIT.generateUniqueName();
        StringBuilder optionsBuilder = new StringBuilder();
        if (ttl > 0) {
            optionsBuilder.append("TTL=");
            optionsBuilder.append(ttl);
        }
        String ddlOptions = optionsBuilder.toString();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (Connection conn = DriverManager.getConnection(SCNIT.getUrl());){
            conn.createStatement().execute(String.format("CREATE TABLE %s(k VARCHAR PRIMARY KEY, f.v VARCHAR) %s", fullTableName, ddlOptions));
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('a','aa')");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('b','bb')");
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES('c','cc')");
            conn.commit();
        }
        return fullTableName;
    }
}

