/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowValueConstructorOffsetNotCoercibleException;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class RowValueConstructorOffsetIT
extends ParallelStatsDisabledIT {
    private static final String SIMPLE_DDL = "CREATE TABLE %s (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nv1 INTEGER,\nv2 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2)) ";
    private static final String DATA_DDL = "CREATE TABLE %s (k1 TINYINT NOT NULL,\nk2 TINYINT NOT NULL,\nk3 TINYINT NOT NULL,\nv1 INTEGER,\nCONSTRAINT pk PRIMARY KEY (k1, k2, k3)) ";
    private static final String TABLE_NAME = "T_" + RowValueConstructorOffsetIT.generateUniqueName();
    private static final String TABLE_ROW_KEY = "t_id, k1, k2";
    private static final String GOOD_TABLE_ROW_KEY_VALUE = "'a', 1, 2";
    private static final String DATA_TABLE_NAME = "T_" + RowValueConstructorOffsetIT.generateUniqueName();
    private static final String DATA_ROW_KEY = "k1, k2, k3";
    private static final String GOOD_DATA_ROW_KEY_VALUE = "2, 3, 0";
    private static final String INDEX_NAME = "INDEX_" + TABLE_NAME;
    private static final String DATA_INDEX_NAME = "INDEX_" + DATA_TABLE_NAME;
    private static final String DATA_INDEX_ROW_KEY = "k2, k1, k3";
    private static Connection conn = null;

    @BeforeClass
    public static synchronized void init() throws SQLException {
        conn = DriverManager.getConnection(RowValueConstructorOffsetIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        String dataTableDDL = String.format(DATA_DDL, DATA_TABLE_NAME);
        try (Statement statement = conn.createStatement();){
            statement.execute(dataTableDDL);
        }
        statement = conn.createStatement();
        var2_2 = null;
        try {
            statement.execute(String.format(SIMPLE_DDL, TABLE_NAME));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (statement != null) {
                if (var2_2 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    statement.close();
                }
            }
        }
        conn.commit();
        String upsertDML = String.format("UPSERT INTO %s VALUES(?,?,?,?)", DATA_TABLE_NAME);
        int nRows = 0;
        try (PreparedStatement ps = conn.prepareStatement(upsertDML);){
            for (int k1 = 0; k1 < 4; ++k1) {
                ps.setInt(1, k1);
                for (int k2 = 0; k2 < 4; ++k2) {
                    ps.setInt(2, k2);
                    for (int k3 = 0; k3 < 4; ++k3) {
                        ps.setInt(3, k3);
                        ps.setInt(4, nRows);
                        int result = ps.executeUpdate();
                        Assert.assertEquals((long)1L, (long)result);
                        ++nRows;
                    }
                }
            }
            conn.commit();
        }
        String createIndex = "CREATE INDEX IF NOT EXISTS " + INDEX_NAME + " ON " + TABLE_NAME + " (k2 DESC,k1)";
        try (Statement statement = conn.createStatement();){
            statement.execute(createIndex);
        }
        String createDataIndex = "CREATE INDEX IF NOT EXISTS " + DATA_INDEX_NAME + " ON " + DATA_TABLE_NAME + " (k2 DESC,k1)";
        try (Statement statement = conn.createStatement();){
            statement.execute(createDataIndex);
        }
        conn.commit();
    }

    @AfterClass
    public static synchronized void cleanup() {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testRVCOffsetNotCoercible() throws SQLException {
        String failureSql = String.format("SELECT %s FROM %s OFFSET (%s)=('a', 'ab', 2)", TABLE_ROW_KEY, TABLE_NAME, TABLE_ROW_KEY);
        try (Statement statement = conn.createStatement();){
            statement.execute(failureSql);
            Assert.fail((String)"Should not allow non coercible values to PK in RVC Offset");
        }
        catch (RowValueConstructorOffsetNotCoercibleException e) {
            return;
        }
    }

    @Test
    public void testRVCOffsetNotAllowNonPKOrderBy() throws SQLException {
        String failureSql = String.format("SELECT %s, v1 FROM %s ORDER BY v1 OFFSET (%s)=(%s)", TABLE_ROW_KEY, TABLE_NAME, TABLE_ROW_KEY, GOOD_TABLE_ROW_KEY_VALUE);
        try (Statement statement = conn.createStatement();){
            statement.execute(failureSql);
            Assert.fail((String)"Should not allow no PK order by with RVC Offset");
        }
        catch (RowValueConstructorOffsetNotCoercibleException e) {
            return;
        }
    }

    @Test
    public void testRVCOffsetNotAllowPartialPKOrderBy() throws SQLException {
        String failureSql = String.format("SELECT %s FROM %s ORDER BY k1 OFFSET (%s)=(%s)", TABLE_ROW_KEY, TABLE_NAME, TABLE_ROW_KEY, GOOD_TABLE_ROW_KEY_VALUE);
        try (Statement statement = conn.createStatement();){
            statement.execute(failureSql);
            Assert.fail((String)"Should not allow partial PK order by with RVC Offset");
        }
        catch (RowValueConstructorOffsetNotCoercibleException e) {
            return;
        }
    }

    @Test
    public void testRVCOffsetSamePKDifferentSortOrderBy() throws SQLException {
        String failureSql = String.format("SELECT %s FROM %s ORDER BY t_id DESC, k1, k2 OFFSET (%s)=(%s)", TABLE_ROW_KEY, TABLE_NAME, TABLE_ROW_KEY, GOOD_TABLE_ROW_KEY_VALUE);
        try (Statement statement = conn.createStatement();){
            statement.execute(failureSql);
            Assert.fail((String)"Should not allow different PK order by with RVC Offset");
        }
        catch (RowValueConstructorOffsetNotCoercibleException e) {
            return;
        }
    }

    @Test
    public void testRVCOffsetNotAllowedInJoins() throws SQLException {
        String tableName2 = "T_" + RowValueConstructorOffsetIT.generateUniqueName();
        RowValueConstructorOffsetIT.createTestTable(RowValueConstructorOffsetIT.getUrl(), String.format(SIMPLE_DDL, tableName2));
        String failureSql = String.format("SELECT T1.k1,T2.k2 FROM %s AS T1, %s AS T2 WHERE T1.t_id=T2.t_id OFFSET (T1.t_id, T1.k1, T1.k2)=('a', 1, 2)", TABLE_NAME, tableName2);
        try (Statement statement = conn.createStatement();){
            statement.execute(failureSql);
            Assert.fail((String)"Should not have JOIN in RVC Offset");
        }
        catch (SQLException e) {
            return;
        }
    }

    @Test
    public void testRVCOffsetNotAllowedInSubQuery() throws SQLException {
        String failureSql = String.format("SELECT B.k2 FROM (SELECT %s FROM %s OFFSET (%s)=(%s)) AS B", TABLE_ROW_KEY, TABLE_NAME, TABLE_ROW_KEY, GOOD_TABLE_ROW_KEY_VALUE);
        try (Statement statement = conn.createStatement();){
            statement.execute(failureSql);
            Assert.fail((String)"Should not have subquery with RVC Offset");
        }
        catch (SQLException e) {
            return;
        }
    }

    @Test
    public void testRVCOffsetNotAllowedOnSubQuery() throws SQLException {
        String failureSql = String.format("SELECT * FROM (SELECT T_ID,K1,K2 AS COL3 FROM %s ORDER BY K1 LIMIT 2) AS B OFFSET (%s)=(%s)", TABLE_NAME, TABLE_ROW_KEY, GOOD_TABLE_ROW_KEY_VALUE);
        try (Statement statement = conn.createStatement();){
            statement.execute(failureSql);
            Assert.fail((String)"Should not have subquery with RVC Offset");
        }
        catch (SQLException e) {
            return;
        }
    }

    @Test
    public void testRVCOffsetLiteral() throws SQLException {
        String failureSql = String.format("SELECT * FROM %s OFFSET (%s)=('a', 1, k2)", TABLE_NAME, TABLE_ROW_KEY);
        try (Statement statement = conn.createStatement();){
            statement.execute(failureSql);
            Assert.fail((String)"Should not have allowed column in RVC Offset");
        }
        catch (RowValueConstructorOffsetNotCoercibleException e) {
            return;
        }
    }

    @Test
    public void testRVCOffsetAggregate() {
        String failureSql = String.format("SELECT count(*) FROM %s  OFFSET (%s)=(%s)", TABLE_NAME, TABLE_ROW_KEY, GOOD_TABLE_ROW_KEY_VALUE);
        try (Statement statement = conn.createStatement();){
            statement.execute(failureSql);
            Assert.fail((String)"Should not have allowed aggregate with RVC Offset");
        }
        catch (SQLException e) {
            return;
        }
    }

    @Test
    public void testRVCOffsetPartialKey() throws SQLException {
        String failureSql = String.format("SELECT * FROM %s  OFFSET (%s)=('a', 1)", TABLE_NAME, TABLE_ROW_KEY);
        try (Statement statement = conn.createStatement();){
            statement.execute(failureSql);
            Assert.fail((String)"Should not have allowed partial Key RVC Offset");
        }
        catch (RowValueConstructorOffsetNotCoercibleException e) {
            return;
        }
    }

    @Test
    public void testRVCOffsetMoreThanKey() throws SQLException {
        String failureSql = String.format("SELECT * FROM %s OFFSET (%s)=('a', 1, 2, 3)", TABLE_NAME, TABLE_ROW_KEY);
        try (Statement statement = conn.createStatement();){
            statement.execute(failureSql);
            Assert.fail((String)"Should not have allowed more than pk columns in Key RVC Offset");
        }
        catch (RowValueConstructorOffsetNotCoercibleException e) {
            return;
        }
    }

    @Test
    public void testRVCOffsetLHSDoesNotMatchTable() throws SQLException {
        String failureSql = String.format("SELECT * FROM %s LIMIT 2 OFFSET (k1,k2)=(%s)", TABLE_NAME, GOOD_TABLE_ROW_KEY_VALUE);
        try (Statement statement = conn.createStatement();){
            statement.execute(failureSql);
            Assert.fail((String)"Should not have allowed the LHS to not be the same as the pk");
        }
        catch (RowValueConstructorOffsetNotCoercibleException e) {
            return;
        }
    }

    @Test
    public void testSimpleRVCOffsetLookup() throws SQLException {
        String sql = String.format("SELECT * FROM %s LIMIT 3 OFFSET (%s)=(%s)", DATA_TABLE_NAME, DATA_ROW_KEY, GOOD_DATA_ROW_KEY_VALUE);
        try (Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(sql);){
            Assert.assertTrue((boolean)rs.next());
            int k1 = rs.getInt(1);
            int k2 = rs.getInt(2);
            int k3 = rs.getInt(3);
            Assert.assertEquals((long)2L, (long)k1);
            Assert.assertEquals((long)3L, (long)k2);
            Assert.assertEquals((long)1L, (long)k3);
            Assert.assertTrue((boolean)rs.next());
            k1 = rs.getInt(1);
            k2 = rs.getInt(2);
            k3 = rs.getInt(3);
            Assert.assertEquals((long)2L, (long)k1);
            Assert.assertEquals((long)3L, (long)k2);
            Assert.assertEquals((long)2L, (long)k3);
            Assert.assertTrue((boolean)rs.next());
            k1 = rs.getInt(1);
            k2 = rs.getInt(2);
            k3 = rs.getInt(3);
            Assert.assertEquals((long)2L, (long)k1);
            Assert.assertEquals((long)3L, (long)k2);
            Assert.assertEquals((long)3L, (long)k3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testBindsRVCOffsetLookup() throws SQLException {
        String sql = String.format("SELECT * FROM %s LIMIT 2 OFFSET (%s)=(?, ?, ?)", DATA_TABLE_NAME, DATA_ROW_KEY);
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setInt(1, 2);
            ps.setInt(2, 3);
            ps.setInt(3, 1);
            try (ResultSet rs = ps.executeQuery();){
                Assert.assertTrue((boolean)rs.next());
                int k1 = rs.getInt(1);
                int k2 = rs.getInt(2);
                int k3 = rs.getInt(3);
                Assert.assertEquals((long)2L, (long)k1);
                Assert.assertEquals((long)3L, (long)k2);
                Assert.assertEquals((long)2L, (long)k3);
                Assert.assertTrue((boolean)rs.next());
                k1 = rs.getInt(1);
                k2 = rs.getInt(2);
                k3 = rs.getInt(3);
                Assert.assertEquals((long)2L, (long)k1);
                Assert.assertEquals((long)3L, (long)k2);
                Assert.assertEquals((long)3L, (long)k3);
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    @Test
    public void testWhereClauseRVCOffsetLookup() throws SQLException {
        String sql = String.format("SELECT * FROM %s WHERE (k1,k2,k3)=(3,3,3) LIMIT 2 OFFSET (%s)=(%s)", DATA_TABLE_NAME, DATA_ROW_KEY, GOOD_DATA_ROW_KEY_VALUE);
        try (Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(sql);){
            Assert.assertTrue((boolean)rs.next());
            int k1 = rs.getInt(1);
            int k2 = rs.getInt(2);
            int k3 = rs.getInt(3);
            Assert.assertEquals((long)3L, (long)k1);
            Assert.assertEquals((long)3L, (long)k2);
            Assert.assertEquals((long)3L, (long)k3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSaltedTableRVCOffsetOrderBy() throws SQLException {
        Throwable throwable;
        ResultSet rs;
        String saltedTableName = "T_" + RowValueConstructorOffsetIT.generateUniqueName();
        String saltedDDL = String.format("CREATE TABLE %s (k1 TINYINT NOT NULL,\nk2 TINYINT NOT NULL,\nk3 TINYINT NOT NULL,\nv1 INTEGER,\nCONSTRAINT pk PRIMARY KEY (k1, k2, k3)) SALT_BUCKETS=4", saltedTableName);
        try (Statement statement = conn.createStatement();){
            statement.execute(saltedDDL);
        }
        conn.commit();
        String sql = "SELECT * FROM " + saltedTableName + " ORDER BY K1,K2,K3 LIMIT 2 OFFSET (k1,k2,k3)=(2, 3, 1)";
        try (Statement statement = conn.createStatement();){
            rs = statement.executeQuery(sql);
            throwable = null;
            try {
                statement.executeQuery(sql);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        sql = "SELECT * FROM " + saltedTableName + " ORDER BY K2,K1,K3 LIMIT 2 OFFSET (k1,k2,k3)=(2, 3, 1)";
        try {
            statement = conn.createStatement();
            var5_8 = null;
            try {
                rs = statement.executeQuery(sql);
                throwable = null;
                try {
                    Assert.fail();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var5_8 = throwable6;
                throw throwable6;
            }
            finally {
                if (statement != null) {
                    if (var5_8 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable7) {
                            var5_8.addSuppressed(throwable7);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (RowValueConstructorOffsetNotCoercibleException e) {
            return;
        }
    }

    @Test
    public void testSaltedTableRVCOffset() throws SQLException {
        String saltedTableName = "T_" + RowValueConstructorOffsetIT.generateUniqueName();
        String saltedDDL = String.format("CREATE TABLE %s (k1 TINYINT NOT NULL,\nk2 TINYINT NOT NULL,\nk3 TINYINT NOT NULL,\nv1 INTEGER,\nCONSTRAINT pk PRIMARY KEY (k1, k2, k3)) SALT_BUCKETS=4", saltedTableName);
        try (Statement statement = conn.createStatement();){
            statement.execute(saltedDDL);
            conn.commit();
        }
        String upsertDML = String.format("UPSERT INTO %s VALUES(?,?,?,?)", saltedTableName);
        int nRows = 0;
        try (PreparedStatement ps = conn.prepareStatement(upsertDML);){
            for (int k1 = 0; k1 < 4; ++k1) {
                ps.setInt(1, k1);
                for (int k2 = 0; k2 < 4; ++k2) {
                    ps.setInt(2, k2);
                    for (int k3 = 0; k3 < 4; ++k3) {
                        ps.setInt(3, k3);
                        ps.setInt(4, nRows);
                        int result = ps.executeUpdate();
                        Assert.assertEquals((long)1L, (long)result);
                        ++nRows;
                    }
                }
            }
            conn.commit();
        }
        String sql = String.format("SELECT * FROM " + saltedTableName + " ORDER BY %s LIMIT 3 OFFSET (%s)=(%s)", DATA_ROW_KEY, DATA_ROW_KEY, GOOD_DATA_ROW_KEY_VALUE);
        try (Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(sql);){
            Assert.assertTrue((boolean)rs.next());
            int k1 = rs.getInt(1);
            int k2 = rs.getInt(2);
            int k3 = rs.getInt(3);
            Assert.assertEquals((long)2L, (long)k1);
            Assert.assertEquals((long)3L, (long)k2);
            Assert.assertEquals((long)1L, (long)k3);
            Assert.assertTrue((boolean)rs.next());
            k1 = rs.getInt(1);
            k2 = rs.getInt(2);
            k3 = rs.getInt(3);
            Assert.assertEquals((long)2L, (long)k1);
            Assert.assertEquals((long)3L, (long)k2);
            Assert.assertEquals((long)2L, (long)k3);
            Assert.assertTrue((boolean)rs.next());
            k1 = rs.getInt(1);
            k2 = rs.getInt(2);
            k3 = rs.getInt(3);
            Assert.assertEquals((long)2L, (long)k1);
            Assert.assertEquals((long)3L, (long)k2);
            Assert.assertEquals((long)3L, (long)k3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testGlobalViewRVCOffset() throws SQLException {
        String viewName1 = "V_" + RowValueConstructorOffsetIT.generateUniqueName();
        String viewDDL = "CREATE VIEW " + viewName1 + " AS SELECT * FROM " + DATA_TABLE_NAME;
        try (Statement statement = conn.createStatement();){
            statement.execute(viewDDL);
            conn.commit();
        }
        String sql = "SELECT  k2,k1,k3 FROM " + viewName1 + " LIMIT 3 OFFSET (k2,k1,k3)=(3, 3, 1)";
        try (Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(sql);){
            Assert.assertTrue((boolean)rs.next());
            int k2 = rs.getInt(1);
            int k1 = rs.getInt(2);
            int k3 = rs.getInt(3);
            Assert.assertEquals((long)3L, (long)k2);
            Assert.assertEquals((long)3L, (long)k1);
            Assert.assertEquals((long)2L, (long)k3);
            Assert.assertTrue((boolean)rs.next());
            k2 = rs.getInt(1);
            k1 = rs.getInt(2);
            k3 = rs.getInt(3);
            Assert.assertEquals((long)3L, (long)k2);
            Assert.assertEquals((long)3L, (long)k1);
            Assert.assertEquals((long)3L, (long)k3);
            Assert.assertTrue((boolean)rs.next());
            k2 = rs.getInt(1);
            k1 = rs.getInt(2);
            k3 = rs.getInt(3);
            Assert.assertEquals((long)2L, (long)k2);
            Assert.assertEquals((long)0L, (long)k1);
            Assert.assertEquals((long)0L, (long)k3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void parameterizedTenantTestCase(boolean isSalted) throws SQLException {
        String multiTenantDataTableName = "T_" + RowValueConstructorOffsetIT.generateUniqueName();
        String multiTenantDDL = "CREATE TABLE %s (tenant_id VARCHAR NOT NULL, k1 TINYINT NOT NULL,\nk2 TINYINT NOT NULL,\nk3 TINYINT NOT NULL,\nv1 INTEGER,\nCONSTRAINT pk PRIMARY KEY (tenant_id, k1, k2, k3)) MULTI_TENANT=true";
        if (isSalted) {
            multiTenantDDL = multiTenantDDL + ", SALT_BUCKETS=4";
        }
        try (Statement statement = conn.createStatement();){
            statement.execute(String.format(multiTenantDDL, multiTenantDataTableName));
            conn.commit();
        }
        String tenantId2 = "tenant2";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("TenantId", tenantId2);
        try (Connection tenant2Connection = DriverManager.getConnection(RowValueConstructorOffsetIT.getUrl(), props);){
            Throwable throwable;
            ResultSet rs;
            String viewName = multiTenantDataTableName + "_" + tenantId2;
            try (Statement statement = tenant2Connection.createStatement();){
                statement.execute("CREATE VIEW " + viewName + " ( vk1 INTEGER NOT NULL, vv1 INTEGER, CONSTRAINT PKVIEW PRIMARY KEY(vk1))  AS SELECT * FROM " + multiTenantDataTableName);
            }
            String viewIndexName = viewName + "_Index1";
            try (Statement statement = tenant2Connection.createStatement();){
                statement.execute("CREATE INDEX " + viewIndexName + " ON " + viewName + " ( vv1 ) ");
            }
            String upsertDML = String.format("UPSERT INTO %s VALUES(?,?,?,?,?,?)", viewName);
            int tenantRows = 0;
            try (PreparedStatement tps = tenant2Connection.prepareStatement(upsertDML);){
                for (int k1 = 0; k1 < 4; ++k1) {
                    tps.setInt(1, k1);
                    for (int k2 = 0; k2 < 4; ++k2) {
                        tps.setInt(2, k2);
                        for (int k3 = 0; k3 < 4; ++k3) {
                            tps.setInt(3, k3);
                            for (int vk1 = 0; vk1 < 4; ++vk1) {
                                tps.setInt(4, tenantRows);
                                tps.setInt(5, vk1);
                                tps.setInt(6, -tenantRows);
                                int result = tps.executeUpdate();
                                Assert.assertEquals((long)1L, (long)result);
                                ++tenantRows;
                            }
                        }
                    }
                }
                tenant2Connection.commit();
            }
            String sql = "SELECT k1,k2,k3,vk1 FROM " + viewName + "  LIMIT 2 OFFSET (k1,k2,k3,vk1)=(2, 3, 1, 2)";
            try (Statement statement = tenant2Connection.createStatement();){
                rs = statement.executeQuery(sql);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)rs.next());
                    int k1 = rs.getInt(1);
                    int k2 = rs.getInt(2);
                    int k3 = rs.getInt(3);
                    int vk1 = rs.getInt(4);
                    Assert.assertEquals((long)2L, (long)k1);
                    Assert.assertEquals((long)3L, (long)k2);
                    Assert.assertEquals((long)1L, (long)k3);
                    Assert.assertEquals((long)3L, (long)vk1);
                    Assert.assertTrue((boolean)rs.next());
                    k1 = rs.getInt(1);
                    k2 = rs.getInt(2);
                    k3 = rs.getInt(3);
                    vk1 = rs.getInt(4);
                    Assert.assertEquals((long)2L, (long)k1);
                    Assert.assertEquals((long)3L, (long)k2);
                    Assert.assertEquals((long)2L, (long)k3);
                    Assert.assertEquals((long)0L, (long)vk1);
                    Assert.assertFalse((boolean)rs.next());
                }
                catch (Throwable k1) {
                    throwable = k1;
                    throw k1;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable k1) {
                                throwable.addSuppressed(k1);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            sql = "SELECT vv1,k1,k2,k3,vk1 FROM " + viewName + " ORDER BY vv1 LIMIT 2 OFFSET (vv1,k1,k2,k3,vk1)=(-184,2, 3, 2, 0)";
            statement = tenant2Connection.createStatement();
            var14_31 = null;
            try {
                rs = statement.executeQuery(sql);
                throwable = null;
                try {
                    Assert.assertTrue((boolean)rs.next());
                    int vv1 = rs.getInt(1);
                    int k1 = rs.getInt(2);
                    int k2 = rs.getInt(3);
                    int k3 = rs.getInt(4);
                    int vk1 = rs.getInt(5);
                    Assert.assertEquals((long)-183L, (long)vv1);
                    Assert.assertEquals((long)2L, (long)k1);
                    Assert.assertEquals((long)3L, (long)k2);
                    Assert.assertEquals((long)1L, (long)k3);
                    Assert.assertEquals((long)3L, (long)vk1);
                    Assert.assertTrue((boolean)rs.next());
                    vv1 = rs.getInt(1);
                    k1 = rs.getInt(2);
                    k2 = rs.getInt(3);
                    k3 = rs.getInt(4);
                    vk1 = rs.getInt(5);
                    Assert.assertEquals((long)-182L, (long)vv1);
                    Assert.assertEquals((long)2L, (long)k1);
                    Assert.assertEquals((long)3L, (long)k2);
                    Assert.assertEquals((long)1L, (long)k3);
                    Assert.assertEquals((long)2L, (long)vk1);
                    Assert.assertFalse((boolean)rs.next());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                var14_31 = throwable4;
                throw throwable4;
            }
            finally {
                if (statement != null) {
                    if (var14_31 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable5) {
                            var14_31.addSuppressed(throwable5);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
    }

    @Test
    public void testTenantRVCOffset() throws SQLException {
        this.parameterizedTenantTestCase(false);
    }

    @Test
    public void testSaltedViewIndexRVCOffset() throws SQLException {
        this.parameterizedTenantTestCase(true);
    }

    @Test
    public void testViewIndexRVCOffset() throws SQLException {
        String multiTenantDataTableName = "T_" + RowValueConstructorOffsetIT.generateUniqueName();
        String multiTenantDDL = String.format("CREATE TABLE %s (tenant_id VARCHAR NOT NULL, k1 TINYINT NOT NULL,\nk2 TINYINT NOT NULL,\nk3 TINYINT NOT NULL,\nv1 INTEGER,\nCONSTRAINT pk PRIMARY KEY (tenant_id, k1, k2, k3)) MULTI_TENANT=true", multiTenantDataTableName);
        try (Statement statement = conn.createStatement();){
            statement.execute(multiTenantDDL);
            conn.commit();
        }
        String tenantId2 = "tenant2";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("TenantId", tenantId2);
        try (Connection tenant2Connection = DriverManager.getConnection(RowValueConstructorOffsetIT.getUrl(), props);){
            String viewName = multiTenantDataTableName + "_" + tenantId2;
            try (Statement statement = tenant2Connection.createStatement();){
                statement.execute("CREATE VIEW " + viewName + " ( vk1 INTEGER NOT NULL, vv1 INTEGER, CONSTRAINT PKVIEW PRIMARY KEY(vk1))  AS SELECT * FROM " + multiTenantDataTableName);
            }
            String viewIndexName = viewName + "_Index1";
            try (Statement statement = tenant2Connection.createStatement();){
                statement.execute("CREATE INDEX " + viewIndexName + " ON " + viewName + " ( vv1 ) ");
            }
            String upsertDML = String.format("UPSERT INTO %s VALUES(?,?,?,?,?,?)", viewName);
            int tenantRows = 0;
            try (PreparedStatement tps = tenant2Connection.prepareStatement(upsertDML);){
                for (int k1 = 0; k1 < 4; ++k1) {
                    tps.setInt(1, k1);
                    for (int k2 = 0; k2 < 4; ++k2) {
                        tps.setInt(2, k2);
                        for (int k3 = 0; k3 < 4; ++k3) {
                            tps.setInt(3, k3);
                            tps.setInt(4, tenantRows);
                            for (int vk1 = 0; vk1 < 4; ++vk1) {
                                tps.setInt(5, vk1);
                                tps.setInt(6, -tenantRows);
                                int result = tps.executeUpdate();
                                Assert.assertEquals((long)1L, (long)result);
                                ++tenantRows;
                            }
                        }
                    }
                }
                tenant2Connection.commit();
            }
            String sql = "SELECT vv1,k1,k2,k3,vk1 FROM " + viewName + " ORDER BY vv1 LIMIT 3 OFFSET (vv1,k1,k2,k3,vk1)=(-196, 3,0,0,1)";
            try (Statement statement = tenant2Connection.createStatement();
                 ResultSet rs = statement.executeQuery(sql);){
                Assert.assertTrue((boolean)rs.next());
                int vv1 = rs.getInt(1);
                int k1 = rs.getInt(2);
                int k2 = rs.getInt(3);
                int k3 = rs.getInt(4);
                int vk1 = rs.getInt(5);
                Assert.assertEquals((long)-196L, (long)vv1);
                Assert.assertEquals((long)3L, (long)k1);
                Assert.assertEquals((long)0L, (long)k2);
                Assert.assertEquals((long)1L, (long)k3);
                Assert.assertEquals((long)0L, (long)vk1);
                Assert.assertTrue((boolean)rs.next());
                vv1 = rs.getInt(1);
                k1 = rs.getInt(2);
                k2 = rs.getInt(3);
                k3 = rs.getInt(4);
                vk1 = rs.getInt(5);
                Assert.assertEquals((long)-195L, (long)vv1);
                Assert.assertEquals((long)3L, (long)k1);
                Assert.assertEquals((long)0L, (long)k2);
                Assert.assertEquals((long)0L, (long)k3);
                Assert.assertEquals((long)3L, (long)vk1);
                Assert.assertTrue((boolean)rs.next());
                vv1 = rs.getInt(1);
                k1 = rs.getInt(2);
                k2 = rs.getInt(3);
                k3 = rs.getInt(4);
                vk1 = rs.getInt(5);
                Assert.assertEquals((long)-194L, (long)vv1);
                Assert.assertEquals((long)3L, (long)k1);
                Assert.assertEquals((long)0L, (long)k2);
                Assert.assertEquals((long)0L, (long)k3);
                Assert.assertEquals((long)2L, (long)vk1);
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    @Test
    public void testIndexRVCOffset() throws SQLException {
        String sql = String.format("SELECT %s FROM %s LIMIT 3 OFFSET (%s)=(3, 3, 1)", DATA_INDEX_ROW_KEY, DATA_TABLE_NAME, DATA_INDEX_ROW_KEY);
        try (Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(sql);){
            Assert.assertTrue((boolean)rs.next());
            int k2 = rs.getInt(1);
            int k1 = rs.getInt(2);
            int k3 = rs.getInt(3);
            Assert.assertEquals((long)3L, (long)k2);
            Assert.assertEquals((long)3L, (long)k1);
            Assert.assertEquals((long)2L, (long)k3);
            Assert.assertTrue((boolean)rs.next());
            k2 = rs.getInt(1);
            k1 = rs.getInt(2);
            k3 = rs.getInt(3);
            Assert.assertEquals((long)3L, (long)k2);
            Assert.assertEquals((long)3L, (long)k1);
            Assert.assertEquals((long)3L, (long)k3);
            Assert.assertTrue((boolean)rs.next());
            k2 = rs.getInt(1);
            k1 = rs.getInt(2);
            k3 = rs.getInt(3);
            Assert.assertEquals((long)2L, (long)k2);
            Assert.assertEquals((long)0L, (long)k1);
            Assert.assertEquals((long)0L, (long)k3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUncoveredIndexRVCOffsetFails() throws SQLException {
        String sql = "SELECT  k2,k1,k3,v1 FROM " + DATA_TABLE_NAME + " LIMIT 3 OFFSET (k2,k1,k3)=(3, 3, 2)";
        try (Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(sql);){
            Assert.fail((String)"Should not have allowed uncovered index access with RVC Offset without hinting to index.");
        }
        catch (RowValueConstructorOffsetNotCoercibleException e) {
            return;
        }
    }

    @Test
    public void testIndexSaltedBaseTableRVCOffset() throws SQLException {
        String saltedTableName = "T_" + RowValueConstructorOffsetIT.generateUniqueName();
        String saltedDDL = String.format("CREATE TABLE %s (k1 TINYINT NOT NULL,\nk2 TINYINT NOT NULL,\nk3 TINYINT NOT NULL,\nv1 INTEGER,\nCONSTRAINT pk PRIMARY KEY (k1, k2, k3)) SALT_BUCKETS=4", saltedTableName);
        try (Statement statement = conn.createStatement();){
            statement.execute(saltedDDL);
            conn.commit();
        }
        String indexName = "I_" + RowValueConstructorOffsetIT.generateUniqueName();
        String indexDDL = String.format("CREATE INDEX %s ON %s (v1,k2)", indexName, saltedTableName);
        try (Statement statement = conn.createStatement();){
            statement.execute(indexDDL);
            conn.commit();
        }
        String upsertDML = String.format("UPSERT INTO %s VALUES(?,?,?,?)", saltedTableName);
        int nRows = 0;
        try (PreparedStatement ps = conn.prepareStatement(upsertDML);){
            for (int k1 = 0; k1 < 4; ++k1) {
                ps.setInt(1, k1);
                for (int k2 = 0; k2 < 4; ++k2) {
                    ps.setInt(2, k2);
                    for (int k3 = 0; k3 < 4; ++k3) {
                        ps.setInt(3, k3);
                        ps.setInt(4, nRows);
                        int result = ps.executeUpdate();
                        Assert.assertEquals((long)1L, (long)result);
                        ++nRows;
                    }
                }
            }
            conn.commit();
        }
        String sql = "SELECT v1,k2,k1,k3 FROM " + saltedTableName + " LIMIT 3 OFFSET (v1,k2,k1,k3)=(8, 2, 0, 0)";
        try (Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(sql);){
            Assert.assertTrue((boolean)rs.next());
            int v1 = rs.getInt(1);
            int k2 = rs.getInt(2);
            int k1 = rs.getInt(3);
            int k3 = rs.getInt(4);
            Assert.assertEquals((long)9L, (long)v1);
            Assert.assertEquals((long)2L, (long)k2);
            Assert.assertEquals((long)0L, (long)k1);
            Assert.assertEquals((long)1L, (long)k3);
            Assert.assertTrue((boolean)rs.next());
            v1 = rs.getInt(1);
            k2 = rs.getInt(2);
            k1 = rs.getInt(3);
            k3 = rs.getInt(4);
            Assert.assertEquals((long)10L, (long)v1);
            Assert.assertEquals((long)2L, (long)k2);
            Assert.assertEquals((long)0L, (long)k1);
            Assert.assertEquals((long)2L, (long)k3);
            Assert.assertTrue((boolean)rs.next());
            v1 = rs.getInt(1);
            k2 = rs.getInt(2);
            k1 = rs.getInt(3);
            k3 = rs.getInt(4);
            Assert.assertEquals((long)11L, (long)v1);
            Assert.assertEquals((long)2L, (long)k2);
            Assert.assertEquals((long)0L, (long)k1);
            Assert.assertEquals((long)3L, (long)k3);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testIndexMultiColumnsMultiIndexesRVCOffset() throws SQLException {
        Throwable throwable;
        ResultSet rs;
        String ddlTemplate = "CREATE TABLE %s (k1 TINYINT NOT NULL,\nk2 TINYINT NOT NULL,\nk3 TINYINT NOT NULL,\nk4 TINYINT NOT NULL,\nk5 TINYINT NOT NULL,\nk6 TINYINT NOT NULL,\nv1 INTEGER,\nv2 INTEGER,\nv3 INTEGER,\nv4 INTEGER,\nCONSTRAINT pk PRIMARY KEY (k1, k2, k3, k4, k5, k6)) ";
        String longKeyTableName = "T_" + RowValueConstructorOffsetIT.generateUniqueName();
        String longKeyIndex1Name = "INDEX_1_" + longKeyTableName;
        String longKeyIndex2Name = "INDEX_2_" + longKeyTableName;
        String ddl = String.format(ddlTemplate, longKeyTableName);
        try (Statement statement = conn.createStatement();){
            statement.execute(ddl);
        }
        String createIndex1 = "CREATE INDEX IF NOT EXISTS " + longKeyIndex1Name + " ON " + longKeyTableName + " (k2 ,v1, k4)";
        String createIndex2 = "CREATE INDEX IF NOT EXISTS " + longKeyIndex2Name + " ON " + longKeyTableName + " (v1, v3)";
        try (Statement statement = conn.createStatement();){
            statement.execute(createIndex1);
        }
        statement = conn.createStatement();
        var9_12 = null;
        try {
            statement.execute(createIndex2);
        }
        catch (Throwable throwable2) {
            var9_12 = throwable2;
            throw throwable2;
        }
        finally {
            if (statement != null) {
                if (var9_12 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable3) {
                        var9_12.addSuppressed(throwable3);
                    }
                } else {
                    statement.close();
                }
            }
        }
        String sql = "SELECT  k2,v1,k4 FROM " + longKeyTableName + " LIMIT 3 OFFSET (k2,v1,k4,k1,k3,k5,k6)=(2,-1,4,1,3,5,6)";
        try (Statement statement = conn.createStatement();){
            rs = statement.executeQuery(sql);
            throwable = null;
            if (rs != null) {
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    rs.close();
                }
            }
        }
        sql = "SELECT  v1,v3 FROM " + longKeyTableName + " LIMIT 3 OFFSET (v1,v3,k1,k2,k3,k4,k5,k6)=(-1,-3,1,2,3,4,5,6)";
        statement = conn.createStatement();
        var10_18 = null;
        try {
            rs = statement.executeQuery(sql);
            throwable = null;
            if (rs != null) {
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable6) {
            var10_18 = throwable6;
            throw throwable6;
        }
        finally {
            if (statement != null) {
                if (var10_18 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable7) {
                        var10_18.addSuppressed(throwable7);
                    }
                } else {
                    statement.close();
                }
            }
        }
    }

    @Test
    public void testIndexMultiColumnsMultiIndexesVariableLengthNullLiteralsRVCOffset() throws SQLException {
        String ddlTemplate = "CREATE TABLE %s (k1 VARCHAR,\nk2 VARCHAR,\nk3 VARCHAR,\nk4 VARCHAR,\nk5 VARCHAR,\nk6 VARCHAR,\nv1 VARCHAR,\nv2 VARCHAR,\nv3 VARCHAR,\nv4 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (k1, k2, k3, k4, k5, k6)) ";
        String longKeyTableName = "T_" + RowValueConstructorOffsetIT.generateUniqueName();
        String longKeyIndex1Name = "INDEX_1_" + longKeyTableName;
        String ddl = String.format(ddlTemplate, longKeyTableName);
        try (Statement statement = conn.createStatement();){
            statement.execute(ddl);
        }
        String createIndex1 = "CREATE INDEX IF NOT EXISTS " + longKeyIndex1Name + " ON " + longKeyTableName + " (k2 ,v1, k4)";
        try (Statement statement = conn.createStatement();){
            statement.execute(createIndex1);
        }
        String sql0 = "SELECT  v1,v3 FROM " + longKeyTableName + " LIMIT 3 OFFSET (k1 ,k2, k3, k4, k5, k6)=('0','1',null,null,null,'2')";
        try (Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(sql0);){
            PhoenixResultSet phoenixResultSet = rs.unwrap(PhoenixResultSet.class);
            Assert.assertEquals((long)1L, (long)phoenixResultSet.getStatement().getQueryPlan().getScans().size());
            Assert.assertEquals((long)1L, (long)((List)phoenixResultSet.getStatement().getQueryPlan().getScans().get(0)).size());
            byte[] startRow = ((Scan)((List)phoenixResultSet.getStatement().getQueryPlan().getScans().get(0)).get(0)).getStartRow();
            byte[] expectedRow = new byte[]{48, 0, 49, 0, 0, 0, 0, 50, 1};
            Assert.assertArrayEquals((byte[])expectedRow, (byte[])startRow);
        }
        String sql = "SELECT  k2,v1,k4 FROM " + longKeyTableName + " LIMIT 3 OFFSET (k2,v1,k4,k1,k3,k5,k6)=('2',null,'4','1','3','5','6')";
        try (Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(sql);){
            PhoenixResultSet phoenixResultSet = rs.unwrap(PhoenixResultSet.class);
            Assert.assertEquals((long)1L, (long)phoenixResultSet.getStatement().getQueryPlan().getScans().size());
            Assert.assertEquals((long)1L, (long)((List)phoenixResultSet.getStatement().getQueryPlan().getScans().get(0)).size());
            byte[] startRow = ((Scan)((List)phoenixResultSet.getStatement().getQueryPlan().getScans().get(0)).get(0)).getStartRow();
            byte[] expectedRow = new byte[]{50, 0, 0, 52, 0, 49, 0, 51, 0, 53, 0, 54, 1};
            Assert.assertArrayEquals((byte[])expectedRow, (byte[])startRow);
        }
    }

    @Test
    public void testIndexMultiColumnsIndexedFixedLengthNullLiteralsRVCOffset() throws SQLException {
        String ddlTemplate = "CREATE TABLE %s (k1 VARCHAR,\nv1 TINYINT,\nv2 TINYINT,\nv3 TINYINT,\nv4 TINYINT,\nCONSTRAINT pk PRIMARY KEY (k1)) ";
        String longKeyTableName = "T_" + RowValueConstructorOffsetIT.generateUniqueName();
        String longKeyIndex1Name = "INDEX_1_" + longKeyTableName;
        String ddl = String.format(ddlTemplate, longKeyTableName);
        try (Statement statement = conn.createStatement();){
            statement.execute(ddl);
        }
        String createIndex1 = "CREATE INDEX IF NOT EXISTS " + longKeyIndex1Name + " ON " + longKeyTableName + " (v1, k1, v2, v3)";
        try (Statement statement = conn.createStatement();){
            statement.execute(createIndex1);
        }
        String sql0 = "SELECT  v1,v3 FROM " + longKeyTableName + " LIMIT 3 OFFSET (k1)=('-1')";
        try (Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(sql0);){
            PhoenixResultSet phoenixResultSet = rs.unwrap(PhoenixResultSet.class);
            Assert.assertEquals((long)1L, (long)phoenixResultSet.getStatement().getQueryPlan().getScans().size());
            Assert.assertEquals((long)1L, (long)((List)phoenixResultSet.getStatement().getQueryPlan().getScans().get(0)).size());
            byte[] startRow = ((Scan)((List)phoenixResultSet.getStatement().getQueryPlan().getScans().get(0)).get(0)).getStartRow();
            byte[] expectedRow = new byte[]{45, 49, 1};
            Assert.assertArrayEquals((byte[])expectedRow, (byte[])startRow);
        }
        String sql = "SELECT  v1,v3 FROM " + longKeyTableName + " LIMIT 3 OFFSET (v1, k1, v2, v3)=(null,'a',null,0)";
        try (Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(sql);){
            PhoenixResultSet phoenixResultSet = rs.unwrap(PhoenixResultSet.class);
            Assert.assertEquals((long)1L, (long)phoenixResultSet.getStatement().getQueryPlan().getScans().size());
            Assert.assertEquals((long)1L, (long)((List)phoenixResultSet.getStatement().getQueryPlan().getScans().get(0)).size());
            byte[] startRow = ((Scan)((List)phoenixResultSet.getStatement().getQueryPlan().getScans().get(0)).get(0)).getStartRow();
            byte[] expectedRow = new byte[]{0, 97, 0, 0, -128, 1};
            Assert.assertArrayEquals((byte[])expectedRow, (byte[])startRow);
        }
    }

    @Test
    public void testOffsetExplain() throws SQLException {
        String sql = "EXPLAIN SELECT * FROM " + DATA_TABLE_NAME + "  LIMIT 2 OFFSET (k1,k2,k3)=(2, 3, 2)";
        try (Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(sql);){
            StringBuilder explainStringBuilder = new StringBuilder();
            while (rs.next()) {
                String explain = rs.getString(1);
                explainStringBuilder.append(explain);
            }
            Assert.assertTrue((boolean)explainStringBuilder.toString().contains("With RVC Offset"));
        }
    }

    @Test
    public void testGlobalIndexViewAccess() throws Exception {
        String tableName = RowValueConstructorOffsetIT.generateUniqueName();
        String indexName = RowValueConstructorOffsetIT.generateUniqueName();
        String viewName = RowValueConstructorOffsetIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + "(\n    ORGANIZATION_ID CHAR(15) NOT NULL,\n    PARENT_KEY_PREFIX CHAR(3) NOT NULL,\n    PARENT_ID CHAR(15) NOT NULL,\n    CREATED_DATE DATE NOT NULL,\n    DATA VARCHAR   \n    CONSTRAINT PK PRIMARY KEY \n    (\n        ORGANIZATION_ID, \n        PARENT_KEY_PREFIX,\n        PARENT_ID,\n        CREATED_DATE\n    )\n) MULTI_TENANT=true";
        String indexSyncDDL = "CREATE INDEX IF NOT EXISTS " + indexName + "\nON " + tableName + " (PARENT_KEY_PREFIX, CREATED_DATE, PARENT_ID)\nINCLUDE (DATA)";
        String viewDDL = "CREATE VIEW IF NOT EXISTS " + viewName + "\nAS SELECT * FROM " + tableName;
        try (Statement statement = conn.createStatement();){
            statement.execute(ddl);
            statement.execute(indexSyncDDL);
            conn.commit();
        }
        String tenantId2 = "tenant2";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("TenantId", tenantId2);
        try (Connection tenantConnection = DriverManager.getConnection(RowValueConstructorOffsetIT.getUrl(), props);){
            try (Statement statement = tenantConnection.createStatement();){
                statement.execute(viewDDL);
            }
            String baseQuery = "SELECT PARENT_ID,PARENT_KEY_PREFIX,CREATED_DATE,PARENT_ID,DATA\nFROM " + viewName + " LIMIT 2\n";
            try (PreparedStatement statement = tenantConnection.prepareStatement(baseQuery);){
                QueryPlan plan = PhoenixRuntime.getOptimizedQueryPlan((PreparedStatement)statement);
                Assert.assertEquals((Object)PTableType.INDEX, (Object)plan.getTableRef().getTable().getType());
            }
            String query = "SELECT PARENT_ID,PARENT_KEY_PREFIX,CREATED_DATE,PARENT_ID,DATA\nFROM " + viewName + "\nLIMIT 2\nOFFSET (PARENT_KEY_PREFIX,CREATED_DATE,PARENT_ID) = (?,?,?)\n";
            try (PreparedStatement statement = tenantConnection.prepareStatement(query);){
                statement.setString(1, "a");
                statement.setDate(2, new Date(0L));
                statement.setString(3, "b");
                ResultSet rs = statement.executeQuery(query);
                QueryPlan plan = PhoenixRuntime.getOptimizedQueryPlan((PreparedStatement)statement);
                Assert.assertEquals((Object)PTableType.INDEX, (Object)plan.getTableRef().getTable().getType());
            }
        }
    }

    @Test
    public void rvcOffsetTrailingVariableLengthKeyTest() throws Exception {
        String tableName = RowValueConstructorOffsetIT.generateUniqueName();
        String ddl = String.format("CREATE TABLE IF NOT EXISTS %s (\n ORGANIZATION_ID VARCHAR(15), \n TEST_ID VARCHAR(15), \n CREATED_DATE DATE, \n LAST_UPDATE DATE\n CONSTRAINT TEST_SCHEMA_PK PRIMARY KEY (ORGANIZATION_ID, TEST_ID) \n)", tableName);
        try (Statement statement = conn.createStatement();){
            statement.execute(ddl);
        }
        String upsert = "UPSERT INTO %s(ORGANIZATION_ID,TEST_ID) VALUES (%s,%s)";
        ArrayList<String> upserts = new ArrayList<String>();
        upserts.add(String.format(upsert, tableName, "'1'", "'1'"));
        upserts.add(String.format(upsert, tableName, "'1'", "'10'"));
        upserts.add(String.format(upsert, tableName, "'2'", "'2'"));
        for (String sql : upserts) {
            Statement statement = conn.createStatement();
            Throwable throwable = null;
            try {
                statement.execute(sql);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                statement.close();
            }
        }
        conn.commit();
        String query = String.format("SELECT * FROM %s OFFSET (ORGANIZATION_ID,TEST_ID) = ('1','1')", tableName);
        try (Statement statement = conn.createStatement();
             ResultSet rs2 = statement.executeQuery(query);){
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((Object)"1", (Object)rs2.getString(1));
            Assert.assertEquals((Object)"10", (Object)rs2.getString(2));
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((Object)"2", (Object)rs2.getString(1));
            Assert.assertEquals((Object)"2", (Object)rs2.getString(2));
            Assert.assertFalse((boolean)rs2.next());
        }
    }

    @Test
    public void rvcOffsetTrailingNullKeyTest() throws Exception {
        Throwable throwable;
        Object statement;
        String tableName = RowValueConstructorOffsetIT.generateUniqueName();
        String ddl = String.format("CREATE TABLE IF NOT EXISTS %s (\n ORGANIZATION_ID VARCHAR(15), \n TEST_ID VARCHAR(15), \n CREATED_DATE DATE, \n LAST_UPDATE DATE\n CONSTRAINT TEST_SCHEMA_PK PRIMARY KEY (ORGANIZATION_ID, TEST_ID) \n)", tableName);
        try (Statement statement2 = conn.createStatement();){
            statement2.execute(ddl);
        }
        String upsert = "UPSERT INTO %s(ORGANIZATION_ID,TEST_ID) VALUES (%s,%s)";
        ArrayList<String> upserts = new ArrayList<String>();
        upserts.add(String.format(upsert, tableName, "'0'", "null"));
        upserts.add(String.format(upsert, tableName, "'1'", "null"));
        upserts.add(String.format(upsert, tableName, "'1'", "'1'"));
        upserts.add(String.format(upsert, tableName, "'1'", "'10'"));
        upserts.add(String.format(upsert, tableName, "'2'", "null"));
        for (String sql : upserts) {
            statement = conn.createStatement();
            throwable = null;
            try {
                statement.execute(sql);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                statement.close();
            }
        }
        conn.commit();
        String query = String.format("SELECT * FROM %s OFFSET (ORGANIZATION_ID,TEST_ID) = ('1',null)", tableName);
        Statement statement3 = conn.createStatement();
        statement = null;
        try (ResultSet rs2 = statement3.executeQuery(query);){
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((Object)"1", (Object)rs2.getString(1));
            Assert.assertEquals((Object)"1", (Object)rs2.getString(2));
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((Object)"1", (Object)rs2.getString(1));
            Assert.assertEquals((Object)"10", (Object)rs2.getString(2));
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((Object)"2", (Object)rs2.getString(1));
            Assert.assertNull((Object)rs2.getString(2));
            Assert.assertFalse((boolean)rs2.next());
        }
        catch (Throwable throwable4) {
            statement = throwable4;
            throw throwable4;
        }
        finally {
            if (statement3 != null) {
                if (statement != null) {
                    try {
                        statement3.close();
                    }
                    catch (Throwable throwable5) {
                        ((Throwable)statement).addSuppressed(throwable5);
                    }
                } else {
                    statement3.close();
                }
            }
        }
        String preparedQuery = String.format("SELECT * FROM %s OFFSET (ORGANIZATION_ID,TEST_ID) = (?,?)", tableName);
        statement = conn.prepareStatement(preparedQuery);
        throwable = null;
        try {
            statement.setString(1, "1");
            statement.setString(2, null);
            try (ResultSet rs2 = statement.executeQuery();){
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"1", (Object)rs2.getString(1));
                Assert.assertEquals((Object)"1", (Object)rs2.getString(2));
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"1", (Object)rs2.getString(1));
                Assert.assertEquals((Object)"10", (Object)rs2.getString(2));
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"2", (Object)rs2.getString(1));
                Assert.assertNull((Object)rs2.getString(2));
                Assert.assertFalse((boolean)rs2.next());
            }
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            if (statement != null) {
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    statement.close();
                }
            }
        }
    }

    @Test
    public void testRVCOffsetWithNotApplicableIndexHint() throws Exception {
        String sql = String.format("SELECT /*+ INDEX(%s %s)*/ %s FROM %s WHERE t_id = 'b' AND k1 = 2 AND k2 = 3 OFFSET (%s)=('a', 1, 2)", TABLE_NAME, INDEX_NAME, TABLE_ROW_KEY, TABLE_NAME, TABLE_ROW_KEY);
        try (Statement statement = conn.createStatement();){
            ResultSet rs = statement.executeQuery("EXPLAIN " + sql);
            String actualQueryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)actualQueryPlan.contains("POINT LOOKUP ON 1 KEY OVER " + TABLE_NAME));
        }
    }

    @Test
    public void testRVCOffsetWithNotApplicableDataPlanAndPointLookup() throws Exception {
        String failureSql = String.format("SELECT %s FROM %s WHERE t_id = 'b' AND k1 = 2 AND k2 = 3 OFFSET (%s)=('a', 'ab', 2)", TABLE_ROW_KEY, TABLE_NAME, TABLE_ROW_KEY);
        try (Statement statement = conn.createStatement();){
            statement.execute(failureSql);
            Assert.fail((String)"Should not allow non coercible values to PK in RVC Offset");
        }
        catch (RowValueConstructorOffsetNotCoercibleException rowValueConstructorOffsetNotCoercibleException) {
            // empty catch block
        }
    }
}

