/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class RowValueConstructorIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowValueConstructorInWhereWithEqualsExpression() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + tableName + " WHERE ?=organization_id  AND (a_integer, x_integer) = (7, 5)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                Assert.assertTrue((rs.getInt(1) == 7 ? 1 : 0) != 0);
                Assert.assertTrue((rs.getInt(2) == 5 ? 1 : 0) != 0);
                ++count;
            }
            Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowValueConstructorInWhereWithGreaterThanExpression() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + tableName + " WHERE ?=organization_id  AND (a_integer, x_integer) >= (4, 4)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                Assert.assertTrue((rs.getInt(1) >= 4 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)(rs.getInt(1) == 4 ? rs.getInt(2) >= 4 : rs.getInt(2) >= 0));
                ++count;
            }
            Assert.assertEquals((long)5L, (long)count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowValueConstructorInWhereWithUnEqualNumberArgs() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + tableName + " WHERE ?=organization_id  AND (a_integer, x_integer, y_integer) >= (7, 5)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                Assert.assertTrue((rs.getInt(1) >= 7 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)(rs.getInt(1) == 7 ? rs.getInt(2) >= 5 : rs.getInt(2) >= 0));
                ++count;
            }
            Assert.assertTrue((count == 3 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindVarsInRowValueConstructor() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + tableName + " WHERE ?=organization_id  AND (a_integer, x_integer) = (?, ?)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setInt(2, 7);
            statement.setInt(3, 5);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                Assert.assertTrue((rs.getInt(1) == 7 ? 1 : 0) != 0);
                Assert.assertTrue((rs.getInt(2) == 5 ? 1 : 0) != 0);
                ++count;
            }
            Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowValueConstructorOnLHSAndLiteralExpressionOnRHS() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + tableName + " WHERE ?=organization_id  AND (a_integer, x_integer) >= 7";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            Assert.assertTrue((count == 3 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowValueConstructorOnRHSLiteralExpressionOnLHS() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + tableName + " WHERE ?=organization_id  AND 7 <= (a_integer, x_integer)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            Assert.assertTrue((count == 3 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowValueConstructorOnLHSBuiltInFunctionOperatingOnIntegerLiteralRHS() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + tableName + " WHERE ?=organization_id  AND (a_integer, x_integer) >= to_number('7')";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            Assert.assertEquals((long)3L, (long)count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowValueConstructorOnRHSWithBuiltInFunctionOperatingOnIntegerLiteralOnLHS() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + tableName + " WHERE ?=organization_id  AND to_number('7') <= (a_integer, x_integer)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            Assert.assertEquals((long)3L, (long)count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowValueConstructorOnLHSWithBuiltInFunctionOperatingOnColumnRefOnRHS() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String upsertQuery = "UPSERT INTO " + tableName + " (organization_id, entity_id, a_string) values (?, ?, ?)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(true);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(upsertQuery);
            statement.setString(1, tenantId);
            statement.setString(2, "00A123122312312");
            statement.setString(3, "1");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00A223122312312");
            statement.setString(3, "1");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00A323122312312");
            statement.setString(3, "1");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00A423122312312");
            statement.setString(3, "1");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00B523122312312");
            statement.setString(3, "1");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00B623122312312");
            statement.setString(3, "1");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00B723122312312");
            statement.setString(3, "7");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00B823122312312");
            statement.setString(3, "7");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00C923122312312");
            statement.setString(3, "7");
            statement.executeUpdate();
            conn.commit();
            statement = conn.prepareStatement("select a_string from " + tableName + " where organization_id = ? and (6, x_integer) <= to_number(a_string)");
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            Assert.assertTrue((count == 3 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowValueConstructorOnRHSWithBuiltInFunctionOperatingOnColumnRefOnLHS() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String upsertQuery = "UPSERT INTO " + tableName + "(organization_id, entity_id, a_string) values (?, ?, ?)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(true);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(upsertQuery);
            statement.setString(1, tenantId);
            statement.setString(2, "00A123122312312");
            statement.setString(3, "1");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00A223122312312");
            statement.setString(3, "1");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00A323122312312");
            statement.setString(3, "1");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00A423122312312");
            statement.setString(3, "1");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00B523122312312");
            statement.setString(3, "1");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00B623122312312");
            statement.setString(3, "1");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00B723122312312");
            statement.setString(3, "7");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00B823122312312");
            statement.setString(3, "7");
            statement.executeUpdate();
            statement.setString(1, tenantId);
            statement.setString(2, "00C923122312312");
            statement.setString(3, "7");
            statement.executeUpdate();
            conn.commit();
            statement = conn.prepareStatement("select a_string from " + tableName + " where organization_id = ? and to_number(a_string) >= (6, 6)");
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            Assert.assertEquals((long)3L, (long)count);
        }
    }

    @Test
    public void testQueryMoreWithInListRowValueConstructor() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        Date date = new Date(System.currentTimeMillis());
        String tableName = RowValueConstructorIT.initEntityHistoryTableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), date, null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);
        PreparedStatement statement = conn.prepareStatement("select parent_id from " + tableName + " WHERE (organization_id, parent_id, created_date, entity_history_id) IN ((?, ?, ?, ?),(?,?,?,?))");
        statement.setString(1, tenantId);
        statement.setString(2, "0500x0000000003");
        statement.setDate(3, date);
        statement.setString(4, "017x00000000003");
        statement.setString(5, tenantId);
        statement.setString(6, "0500x0000000007");
        statement.setDate(7, date);
        statement.setString(8, "017x00000000007");
        ResultSet rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"0500x0000000003", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"0500x0000000007", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testQueryMoreFunctionalityUsingAllPKColsInRowValueConstructor() throws Exception {
        this._testQueryMoreFunctionalityUsingAllPkColsInRowValueConstructor(false);
    }

    @Test
    public void testQueryMoreFunctionalityUsingAllPKColsInRowValueConstructor_Salted() throws Exception {
        this._testQueryMoreFunctionalityUsingAllPkColsInRowValueConstructor(true);
    }

    private void _testQueryMoreFunctionalityUsingAllPkColsInRowValueConstructor(boolean salted) throws Exception, SQLException {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        Date date = new Date(System.currentTimeMillis());
        String tableName = salted ? RowValueConstructorIT.initSaltedEntityHistoryTableValues(null, tenantId, null, date, null) : RowValueConstructorIT.initEntityHistoryTableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), date, null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);
        String startingOrgId = tenantId;
        String startingParentId = "0500x0000000001";
        Date startingDate = date;
        String startingEntityHistId = "017x00000000001";
        PreparedStatement statement = null;
        statement = conn.prepareStatement("select organization_id, parent_id, created_date, entity_history_id, old_value, new_value from " + tableName + " WHERE (organization_id, parent_id, created_date, entity_history_id) > (?, ?, ?, ?) ORDER BY organization_id, parent_id, created_date, entity_history_id LIMIT 3 ");
        statement.setString(1, startingOrgId);
        statement.setString(2, startingParentId);
        statement.setDate(3, startingDate);
        statement.setString(4, startingEntityHistId);
        ResultSet rs = statement.executeQuery();
        int count = 0;
        int i = 1;
        while (rs.next()) {
            Assert.assertTrue((boolean)rs.getString(2).equals(TestUtil.PARENTIDS.get(i)));
            Assert.assertTrue((boolean)rs.getString(4).equals(TestUtil.ENTITYHISTIDS.get(i)));
            ++i;
            if (++count != 3) continue;
            startingOrgId = rs.getString(1);
            startingParentId = rs.getString(2);
            startingDate = rs.getDate(3);
            startingEntityHistId = rs.getString(4);
        }
        Assert.assertTrue((String)"Number of rows returned: ", (count == 3 ? 1 : 0) != 0);
        statement.setString(1, startingOrgId);
        statement.setString(2, startingParentId);
        statement.setDate(3, startingDate);
        statement.setString(4, startingEntityHistId);
        rs = statement.executeQuery();
        while (rs.next()) {
            Assert.assertTrue((boolean)rs.getString(2).equals(TestUtil.PARENTIDS.get(i)));
            Assert.assertTrue((boolean)rs.getString(4).equals(TestUtil.ENTITYHISTIDS.get(i)));
            ++i;
            ++count;
        }
        Assert.assertTrue((String)"Number of rows returned: ", (count == 6 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryMoreWithSubsetofPKColsInRowValueConstructor() throws Exception {
        this._testQueryMoreWithSubsetofPKColsInRowValueConstructor(false);
    }

    @Test
    public void testQueryMoreWithSubsetofPKColsInRowValueConstructor_salted() throws Exception {
        this._testQueryMoreWithSubsetofPKColsInRowValueConstructor(true);
    }

    private void _testQueryMoreWithSubsetofPKColsInRowValueConstructor(boolean salted) throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        Date date = new Date(System.currentTimeMillis());
        String tableName = salted ? RowValueConstructorIT.initSaltedEntityHistoryTableValues(null, tenantId, null, date, null) : RowValueConstructorIT.initEntityHistoryTableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), date, null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);
        String startingOrgId = tenantId;
        String startingParentId = "0500x0000000001";
        String startingEntityHistId = "017x00000000001";
        PreparedStatement statement = null;
        statement = conn.prepareStatement("select organization_id, parent_id, created_date, entity_history_id, old_value, new_value from " + tableName + " WHERE (organization_id, parent_id, entity_history_id) > (?, ?, ?) ORDER BY organization_id, parent_id, entity_history_id LIMIT 3 ");
        statement.setString(1, startingOrgId);
        statement.setString(2, startingParentId);
        statement.setString(3, startingEntityHistId);
        ResultSet rs = statement.executeQuery();
        int count = 0;
        int i = 1;
        while (rs.next()) {
            Assert.assertTrue((boolean)rs.getString(2).equals(TestUtil.PARENTIDS.get(i)));
            Assert.assertTrue((boolean)rs.getString(4).equals(TestUtil.ENTITYHISTIDS.get(i)));
            ++i;
            if (++count != 3) continue;
            startingOrgId = rs.getString(1);
            startingParentId = rs.getString(2);
            startingEntityHistId = rs.getString(4);
        }
        Assert.assertTrue((String)("Number of rows returned: " + count), (count == 3 ? 1 : 0) != 0);
        statement.setString(1, startingOrgId);
        statement.setString(2, startingParentId);
        statement.setString(3, startingEntityHistId);
        rs = statement.executeQuery();
        while (rs.next()) {
            Assert.assertTrue((boolean)rs.getString(2).equals(TestUtil.PARENTIDS.get(i)));
            Assert.assertTrue((boolean)rs.getString(4).equals(TestUtil.ENTITYHISTIDS.get(i)));
            ++i;
            ++count;
        }
        Assert.assertTrue((String)("Number of rows returned: " + count), (count == 6 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryMoreWithLeadingPKColSkippedInRowValueConstructor() throws Exception {
        this._testQueryMoreWithLeadingPKColSkippedInRowValueConstructor(false);
    }

    @Test
    public void testQueryMoreWithLeadingPKColSkippedInRowValueConstructor_salted() throws Exception {
        this._testQueryMoreWithLeadingPKColSkippedInRowValueConstructor(true);
    }

    private void _testQueryMoreWithLeadingPKColSkippedInRowValueConstructor(boolean salted) throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        Date date = new Date(System.currentTimeMillis());
        String tableName = salted ? RowValueConstructorIT.initSaltedEntityHistoryTableValues(null, tenantId, null, date, null) : RowValueConstructorIT.initEntityHistoryTableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), date, null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);
        String startingParentId = "0500x0000000001";
        Date startingDate = date;
        String startingEntityHistId = "017x00000000001";
        PreparedStatement statement = null;
        statement = conn.prepareStatement("select organization_id, parent_id, created_date, entity_history_id, old_value, new_value from " + tableName + " WHERE (parent_id, created_date, entity_history_id) > (?, ?, ?) ORDER BY parent_id, created_date, entity_history_id LIMIT 3 ");
        statement.setString(1, startingParentId);
        statement.setDate(2, startingDate);
        statement.setString(3, startingEntityHistId);
        ResultSet rs = statement.executeQuery();
        int count = 0;
        int i = 1;
        while (rs.next()) {
            Assert.assertTrue((boolean)rs.getString(2).equals(TestUtil.PARENTIDS.get(i)));
            Assert.assertTrue((boolean)rs.getString(4).equals(TestUtil.ENTITYHISTIDS.get(i)));
            ++i;
            if (++count != 3) continue;
            startingParentId = rs.getString(2);
            startingDate = rs.getDate(3);
            startingEntityHistId = rs.getString(4);
        }
        Assert.assertTrue((String)("Number of rows returned: " + count), (count == 3 ? 1 : 0) != 0);
        statement.setString(1, startingParentId);
        statement.setDate(2, startingDate);
        statement.setString(3, startingEntityHistId);
        rs = statement.executeQuery();
        while (rs.next()) {
            Assert.assertTrue((boolean)rs.getString(2).equals(TestUtil.PARENTIDS.get(i)));
            Assert.assertTrue((boolean)rs.getString(4).equals(TestUtil.ENTITYHISTIDS.get(i)));
            ++i;
            ++count;
        }
        Assert.assertTrue((String)("Number of rows returned: " + count), (count == 6 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRVCWithNonLeadingPkColsOfTypesIntegerAndString() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, a_string FROM " + tableName + " WHERE ?=organization_id  AND (a_integer, a_string) <= (5, 'a')";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                Assert.assertTrue((rs.getInt(1) <= 5 ? 1 : 0) != 0);
                Assert.assertTrue((rs.getString(2).compareTo("a") == 0 ? 1 : 0) != 0);
                ++count;
            }
            Assert.assertTrue((count == 4 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRVCWithNonLeadingPkColsOfTypesTimeStampAndString() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String updateStmt = "upsert into " + tableName + "(    ORGANIZATION_ID,     ENTITY_ID,     A_TIMESTAMP) VALUES (?, ?, ?)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection upsertConn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);
        upsertConn.setAutoCommit(true);
        PreparedStatement stmt = upsertConn.prepareStatement(updateStmt);
        stmt.setString(1, tenantId);
        stmt.setString(2, "00A423122312312");
        Timestamp tsValue = new Timestamp(System.nanoTime());
        stmt.setTimestamp(3, tsValue);
        stmt.execute();
        String query = "SELECT a_timestamp, a_string FROM " + tableName + " WHERE ?=organization_id  AND (a_timestamp, a_string) = (?, 'a')";
        props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setTimestamp(2, tsValue);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                Assert.assertTrue((boolean)rs.getTimestamp(1).equals(tsValue));
                Assert.assertTrue((rs.getString(2).compareTo("a") == 0 ? 1 : 0) != 0);
                ++count;
            }
            Assert.assertTrue((count == 1 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedRVCBasic() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String[] queries = new String[]{"SELECT organization_id, entity_id, a_string FROM " + tableName + " WHERE ((organization_id, entity_id), a_string) >= ((?, ?), ?)", "SELECT organization_id, entity_id, a_string FROM " + tableName + " WHERE (organization_id, entity_id, a_string) >= (?, ?, ?)", "SELECT organization_id, entity_id, a_string FROM " + tableName + " WHERE (organization_id, (entity_id, a_string)) >= (?, (?, ?))"};
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Statement statement = null;
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            try {
                for (int i = 0; i <= 2; ++i) {
                    statement = conn.prepareStatement(queries[i]);
                    statement.setString(1, tenantId);
                    statement.setString(2, "00A123122312312");
                    statement.setString(3, "a");
                    ResultSet rs = statement.executeQuery();
                    int count = 0;
                    while (rs.next()) {
                        ++count;
                    }
                    Assert.assertEquals((long)9L, (long)count);
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRVCWithInListClausePossibleNullValues() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String query = "SELECT x_integer, y_integer FROM " + tableName + " WHERE ? = organization_id AND (x_integer, y_integer) IN ((5))";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            Assert.assertEquals((long)0L, (long)rs.getInt(2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRVCWithInListClauseUsingSubsetOfPKColsInOrder() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String query = "SELECT organization_id, entity_id FROM " + tableName + " WHERE (organization_id, entity_id) IN (('" + tenantId + "')) AND x_integer = 5";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Statement statement = null;
        try (Connection conn = null;){
            try {
                conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);
                statement = conn.prepareStatement(query);
                ResultSet rs = statement.executeQuery();
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRVCWithCeilAndFloorNeededForDecimal() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), null, null, RowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, x_integer FROM " + tableName + " WHERE ?=organization_id  AND (a_integer, x_integer) < (8.6, 4.5) AND (a_integer, x_integer) > (6.8, 4)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
                Assert.assertEquals((long)7L, (long)rs.getInt(1));
                Assert.assertEquals((long)5L, (long)rs.getInt(2));
            }
            Assert.assertEquals((long)1L, (long)count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRVCWithCeilAndFloorNeededForTimestamp() throws Exception {
        String tenantId = RowValueConstructorIT.getOrganizationId();
        Date dateUpserted = DateUtil.parseDate((String)"2012-01-01 14:25:28");
        dateUpserted = new Date(dateUpserted.getTime() + 660L);
        String tableName = RowValueConstructorIT.initATableValues(null, tenantId, RowValueConstructorIT.getDefaultSplits(tenantId), dateUpserted, null, RowValueConstructorIT.getUrl(), null);
        String query = "SELECT a_integer, a_date FROM " + tableName + " WHERE ?=organization_id  AND (a_integer, a_date) <= (9, ?) AND (a_integer, a_date) >= (6, ?)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            Timestamp timestampWithNanos = DateUtil.getTimestamp((long)(dateUpserted.getTime() + 172800000L), (int)300);
            timestampWithNanos.setNanos(0);
            statement.setTimestamp(2, timestampWithNanos);
            statement.setTimestamp(3, timestampWithNanos);
            ResultSet rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            Assert.assertEquals((long)3L, (long)count);
        }
    }

    @Test
    public void testRVCWithMultiCompKeysForIn() throws Exception {
        String tableName = RowValueConstructorIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);
        conn.createStatement().execute("CREATE TABLE " + tableName + " (pk1 varchar, pk2 varchar, constraint pk primary key (pk1,pk2))");
        conn.close();
        conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);
        conn.setAutoCommit(true);
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a','a')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('b','b')");
        conn.close();
        conn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE (pk1,pk2) IN (('a','a'),('b','b'))");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"a", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((Object)"b", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    private Connection nextConnection(String url) throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        return DriverManager.getConnection(url, props);
    }

    @Test
    public void testInListOfRVC1() throws Exception {
        String tenantId = "ABC";
        String tableName = RowValueConstructorIT.generateUniqueName();
        String viewName = RowValueConstructorIT.generateUniqueName();
        String tenantSpecificUrl = RowValueConstructorIT.getUrl() + ";" + "TenantId" + '=' + tenantId;
        String baseTableDDL = "CREATE TABLE " + tableName + " (tenantId varchar(5) NOT NULL, pk2 varchar(5) NOT NULL, pk3 INTEGER NOT NULL, c1 INTEGER constraint pk primary key (tenantId,pk2,pk3)) MULTI_TENANT=true";
        RowValueConstructorIT.createTestTable(RowValueConstructorIT.getUrl(), baseTableDDL, null, null);
        String tenantTableDDL = "CREATE VIEW " + viewName + " (tenant_col VARCHAR) AS SELECT *\n                FROM " + tableName;
        RowValueConstructorIT.createTestTable(tenantSpecificUrl, tenantTableDDL, null, null);
        Connection conn = this.nextConnection(tenantSpecificUrl);
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo1', 1, 1)");
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo2', 2, 2)");
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo3', 3, 3)");
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo4', 4, 4)");
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo5', 5, 5)");
        conn.commit();
        conn.close();
        conn = this.nextConnection(tenantSpecificUrl);
        PreparedStatement stmt = conn.prepareStatement("select pk2, pk3 from " + viewName + " WHERE (pk2, pk3) IN ((?, ?), (?, ?)) ORDER BY pk2");
        stmt.setString(1, "helo3");
        stmt.setInt(2, 3);
        stmt.setString(3, "helo5");
        stmt.setInt(4, 5);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo3", (Object)rs.getString(1));
        Assert.assertEquals((long)3L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo5", (Object)rs.getString(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
        conn.close();
    }

    @Test
    public void testInListOfRVC2() throws Exception {
        String tenantId = "ABC";
        String tableName = RowValueConstructorIT.generateUniqueName();
        String viewName = RowValueConstructorIT.generateUniqueName();
        String tenantSpecificUrl = RowValueConstructorIT.getUrl() + ";" + "TenantId" + '=' + tenantId;
        String baseTableDDL = "CREATE TABLE " + tableName + " (tenantId varchar(5) NOT NULL, pk2 varchar(5) NOT NULL, pk3 INTEGER NOT NULL, c1 INTEGER constraint pk primary key (tenantId,pk2,pk3)) MULTI_TENANT=true";
        RowValueConstructorIT.createTestTable(RowValueConstructorIT.getUrl(), baseTableDDL, null, null);
        String tenantTableDDL = "CREATE VIEW " + viewName + " (tenant_col VARCHAR) AS SELECT *\n                FROM " + tableName;
        RowValueConstructorIT.createTestTable(tenantSpecificUrl, tenantTableDDL, null, null);
        Connection conn = this.nextConnection(tenantSpecificUrl);
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo1', 1, 1)");
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo2', 2, 2)");
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo3', 3, 3)");
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo4', 4, 4)");
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo5', 5, 5)");
        conn.commit();
        conn.close();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("select pk2, pk3 from " + tableName + " WHERE (tenantId, pk2, pk3) IN ((?, ?, ?), (?, ?, ?)) ORDER BY pk2");
        stmt.setString(1, tenantId);
        stmt.setString(2, "helo3");
        stmt.setInt(3, 3);
        stmt.setString(4, tenantId);
        stmt.setString(5, "helo5");
        stmt.setInt(6, 5);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo3", (Object)rs.getString(1));
        Assert.assertEquals((long)3L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo5", (Object)rs.getString(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
        conn.close();
    }

    @Test
    public void testInListOfRVC3() throws Exception {
        String tenantId = "ABC";
        String tableName = RowValueConstructorIT.generateUniqueName();
        String tableDDL = "CREATE TABLE " + tableName + " (tenantId varchar(5) NOT NULL, pk2 varchar(5) NOT NULL, pk3 INTEGER NOT NULL, c1 INTEGER constraint pk primary key (tenantId,pk2,pk3))";
        RowValueConstructorIT.createTestTable(RowValueConstructorIT.getUrl(), tableDDL, null, null);
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo1', 1, 1)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo2', 2, 2)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo3', 3, 3)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo4', 4, 4)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo5', 5, 5)");
        conn.commit();
        conn.close();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("select pk2, pk3 from " + tableName + " WHERE (tenantId, pk2, pk3) IN ((?, ?, ?), (?, ?, ?)) ORDER BY pk2");
        stmt.setString(1, tenantId);
        stmt.setString(2, "helo3");
        stmt.setInt(3, 3);
        stmt.setString(4, tenantId);
        stmt.setString(5, "helo5");
        stmt.setInt(6, 5);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo3", (Object)rs.getString(1));
        Assert.assertEquals((long)3L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo5", (Object)rs.getString(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
        conn.close();
    }

    @Test
    public void testInListOfRVC4() throws Exception {
        String tenantId = "ABC";
        String tableName = RowValueConstructorIT.generateUniqueName();
        String viewName = RowValueConstructorIT.generateUniqueName();
        String tenantSpecificUrl = RowValueConstructorIT.getUrl() + ";" + "TenantId" + '=' + tenantId;
        String baseTableDDL = "CREATE TABLE " + tableName + " (tenantId varchar(5) NOT NULL, pk2 varchar(5) NOT NULL, pk3 INTEGER NOT NULL, c1 INTEGER constraint pk primary key (tenantId,pk2,pk3)) SALT_BUCKETS=4, MULTI_TENANT=true";
        RowValueConstructorIT.createTestTable(RowValueConstructorIT.getUrl(), baseTableDDL, null, null);
        String tenantTableDDL = "CREATE VIEW " + viewName + " (tenant_col VARCHAR) AS SELECT *\n                FROM " + tableName;
        RowValueConstructorIT.createTestTable(tenantSpecificUrl, tenantTableDDL, null, null);
        Connection conn = this.nextConnection(tenantSpecificUrl);
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo1', 1, 1)");
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo2', 2, 2)");
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo3', 3, 3)");
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo4', 4, 4)");
        conn.createStatement().executeUpdate("upsert into " + viewName + " (pk2, pk3, c1) values ('helo5', 5, 5)");
        conn.commit();
        conn.close();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("select pk2, pk3 from " + tableName + " WHERE (tenantId, pk2, pk3) IN ((?, ?, ?), (?, ?, ?)) ORDER BY pk2");
        stmt.setString(1, tenantId);
        stmt.setString(2, "helo3");
        stmt.setInt(3, 3);
        stmt.setString(4, tenantId);
        stmt.setString(5, "helo5");
        stmt.setInt(6, 5);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo3", (Object)rs.getString(1));
        Assert.assertEquals((long)3L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo5", (Object)rs.getString(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
        conn.close();
    }

    @Test
    public void testInListOfRVC5() throws Exception {
        String tenantId = "ABC";
        String tableName = RowValueConstructorIT.generateUniqueName();
        String tableDDL = "CREATE TABLE " + tableName + " (tenantId varchar(5) NOT NULL, pk2 varchar(5) NOT NULL, pk3 INTEGER NOT NULL, c1 INTEGER constraint pk primary key (tenantId,pk2,pk3)) SALT_BUCKETS=4";
        RowValueConstructorIT.createTestTable(RowValueConstructorIT.getUrl(), tableDDL, null, null);
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo1', 1, 1)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo2', 2, 2)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo3', 3, 3)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo4', 4, 4)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo5', 5, 5)");
        conn.commit();
        conn.close();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("select pk2, pk3 from " + tableName + " WHERE (tenantId, pk2, pk3) IN ((?, ?, ?), (?, ?, ?)) ORDER BY pk2");
        stmt.setString(1, tenantId);
        stmt.setString(2, "helo3");
        stmt.setInt(3, 3);
        stmt.setString(4, tenantId);
        stmt.setString(5, "helo5");
        stmt.setInt(6, 5);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo3", (Object)rs.getString(1));
        Assert.assertEquals((long)3L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo5", (Object)rs.getString(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
        conn.close();
    }

    @Test
    public void testInListOfRVCColumnValuesSmallerLengthThanSchema() throws Exception {
        String tenantId = "ABC";
        String tableName = RowValueConstructorIT.generateUniqueName();
        String tableDDL = "CREATE TABLE " + tableName + " (tenantId char(15) NOT NULL, pk2 char(15) NOT NULL, pk3 INTEGER NOT NULL, c1 INTEGER constraint pk primary key (tenantId,pk2,pk3))";
        RowValueConstructorIT.createTestTable(RowValueConstructorIT.getUrl(), tableDDL, null, null);
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'hel1', 1, 1)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'hel2', 2, 2)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'hel3', 3, 3)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'hel4', 4, 4)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'hel5', 5, 5)");
        conn.commit();
        conn.close();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("select pk2, pk3 from " + tableName + " WHERE (tenantId, pk2, pk3) IN ((?, ?, ?), (?, ?, ?)) ORDER BY PK2");
        stmt.setString(1, tenantId);
        stmt.setString(2, "hel3");
        stmt.setInt(3, 3);
        stmt.setString(4, tenantId);
        stmt.setString(5, "hel5");
        stmt.setInt(6, 5);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"hel3", (Object)rs.getString(1));
        Assert.assertEquals((long)3L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"hel5", (Object)rs.getString(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
        conn.close();
    }

    @Test
    public void testRVCWithColumnValuesOfSmallerLengthThanSchema() throws Exception {
        this.testRVCWithComparisonOps(true);
    }

    @Test
    public void testRVCWithColumnValuesEqualToLengthInSchema() throws Exception {
        this.testRVCWithComparisonOps(false);
    }

    private void testRVCWithComparisonOps(boolean columnValueLengthSmaller) throws Exception {
        String tenantId = "ABC";
        String tableName = RowValueConstructorIT.generateUniqueName();
        String tableDDLFormat = "CREATE TABLE " + tableName + " (tenantId char(%s) NOT NULL, pk2 char(%s) NOT NULL, pk3 INTEGER NOT NULL, c1 INTEGER constraint pk primary key (tenantId,pk2,pk3))";
        String tableDDL = columnValueLengthSmaller ? String.format(tableDDLFormat, 15, 15) : String.format(tableDDLFormat, 3, 5);
        RowValueConstructorIT.createTestTable(RowValueConstructorIT.getUrl(), tableDDL, null, null);
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo1', 1, 1)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo2', 2, 2)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo3', 3, 3)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo4', 4, 4)");
        conn.createStatement().executeUpdate("upsert into " + tableName + " (tenantId, pk2, pk3, c1) values ('ABC', 'helo5', 5, 5)");
        conn.commit();
        conn.close();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("select pk2, pk3 from " + tableName + " WHERE (tenantId, pk2, pk3) > (?, ?, ?)");
        stmt.setString(1, tenantId);
        stmt.setString(2, "helo3");
        stmt.setInt(3, 3);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo4", (Object)rs.getString(1));
        Assert.assertEquals((long)4L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo5", (Object)rs.getString(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.prepareStatement("select pk2, pk3 from " + tableName + " WHERE (tenantId, pk2, pk3) >= (?, ?, ?)");
        stmt.setString(1, tenantId);
        stmt.setString(2, "helo4");
        stmt.setInt(3, 4);
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo4", (Object)rs.getString(1));
        Assert.assertEquals((long)4L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo5", (Object)rs.getString(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.prepareStatement("select pk2, pk3 from " + tableName + " WHERE (tenantId, pk2, pk3) < (?, ?, ?)");
        stmt.setString(1, tenantId);
        stmt.setString(2, "helo2");
        stmt.setInt(3, 2);
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo1", (Object)rs.getString(1));
        Assert.assertEquals((long)1L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.prepareStatement("select pk2, pk3 from " + tableName + " WHERE (tenantId, pk2, pk3) <= (?, ?, ?)");
        stmt.setString(1, tenantId);
        stmt.setString(2, "helo2");
        stmt.setInt(3, 2);
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo1", (Object)rs.getString(1));
        Assert.assertEquals((long)1L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo2", (Object)rs.getString(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.prepareStatement("select pk2, pk3 from " + tableName + " WHERE (tenantId, pk2, pk3) = (?, ?, ?)");
        stmt.setString(1, tenantId);
        stmt.setString(2, "helo4");
        stmt.setInt(3, 4);
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo4", (Object)rs.getString(1));
        Assert.assertEquals((long)4L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForceSkipScan() throws Exception {
        String tempTableWithCompositePK = RowValueConstructorIT.generateUniqueName();
        try (Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + tempTableWithCompositePK + "   (col0 INTEGER NOT NULL,     col1 INTEGER NOT NULL,     col2 INTEGER NOT NULL,     col3 INTEGER    CONSTRAINT pk PRIMARY KEY (col0, col1, col2))    SALT_BUCKETS=4");
            conn.close();
            conn = this.nextConnection(RowValueConstructorIT.getUrl());
            PreparedStatement upsertStmt = conn.prepareStatement("upsert into " + tempTableWithCompositePK + "(col0, col1, col2, col3) values (?, ?, ?, ?)");
            for (int i = 0; i < 3; ++i) {
                upsertStmt.setInt(1, i + 1);
                upsertStmt.setInt(2, i + 2);
                upsertStmt.setInt(3, i + 3);
                upsertStmt.setInt(4, i + 5);
                upsertStmt.execute();
            }
            conn.commit();
            conn.close();
            conn = this.nextConnection(RowValueConstructorIT.getUrl());
            String query = "SELECT * FROM " + tempTableWithCompositePK + " WHERE (col0, col1) in ((2, 3), (3, 4), (4, 5))";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)rs.getInt(1), (long)2L);
            Assert.assertEquals((long)rs.getInt(2), (long)3L);
            Assert.assertEquals((long)rs.getInt(3), (long)4L);
            Assert.assertEquals((long)rs.getInt(4), (long)6L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)rs.getInt(1), (long)3L);
            Assert.assertEquals((long)rs.getInt(2), (long)4L);
            Assert.assertEquals((long)rs.getInt(3), (long)5L);
            Assert.assertEquals((long)rs.getInt(4), (long)7L);
            Assert.assertFalse((boolean)rs.next());
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 4-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"SKIP SCAN ON 12 KEYS ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)tempTableWithCompositePK, (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)" [X'00',2] - [X'03',4]", (Object)explainPlanAttributes.getKeyRanges());
            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
        }
    }

    @Test
    public void testComparisonAgainstRVCCombinedWithOrAnd_1() throws Exception {
        String tableDDL = "CREATE TABLE RVC1 (tenantId char(15) NOT NULL, pk2 char(15) NOT NULL, pk3 INTEGER NOT NULL, c1 INTEGER constraint pk primary key (tenantId,pk2,pk3)) SALT_BUCKETS = 4";
        RowValueConstructorIT.createTestTable(RowValueConstructorIT.getUrl(), tableDDL, null, null);
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        conn.createStatement().executeUpdate("upsert into RVC1 (tenantId, pk2, pk3, c1) values ('ABC', 'helo1', 1, 1)");
        conn.createStatement().executeUpdate("upsert into RVC1 (tenantId, pk2, pk3, c1) values ('ABC', 'helo2', 2, 2)");
        conn.createStatement().executeUpdate("upsert into RVC1 (tenantId, pk2, pk3, c1) values ('DEF', 'helo3', 3, 3)");
        conn.commit();
        conn.close();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("select pk2, pk3 from RVC1 WHERE (tenantId = ? OR tenantId = ?) AND (tenantId, pk2, pk3) > (?, ?, ?) LIMIT 100");
        stmt.setString(1, "ABC");
        stmt.setString(2, "DEF");
        stmt.setString(3, "ABC");
        stmt.setString(4, "helo1");
        stmt.setInt(5, 1);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo2", (Object)rs.getString(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo3", (Object)rs.getString(1));
        Assert.assertEquals((long)3L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.prepareStatement("select pk2, pk3 from RVC1 WHERE tenantId = ? AND (tenantId, pk2, pk3) BETWEEN (?, ?, ?) AND (?, ?, ?) LIMIT 100");
        stmt.setString(1, "ABC");
        stmt.setString(2, "ABC");
        stmt.setString(3, "helo2");
        stmt.setInt(4, 2);
        stmt.setString(5, "DEF");
        stmt.setString(6, "helo3");
        stmt.setInt(7, 3);
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo2", (Object)rs.getString(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testComparisonAgainstRVCCombinedWithOrAnd_2() throws Exception {
        String tenantId = "ABC";
        String tenantSpecificUrl = RowValueConstructorIT.getUrl() + ";" + "TenantId" + '=' + tenantId;
        String baseTableDDL = "CREATE TABLE RVC2 (tenant_id char(15) NOT NULL, pk2 char(15) NOT NULL, pk3 INTEGER NOT NULL, c1 INTEGER constraint pk primary key (tenant_id,pk2,pk3)) MULTI_TENANT=true, SALT_BUCKETS = 4";
        RowValueConstructorIT.createTestTable(RowValueConstructorIT.getUrl(), baseTableDDL, null, null);
        String tenantTableDDL = "CREATE VIEW t_view AS SELECT * FROM RVC2";
        RowValueConstructorIT.createTestTable(tenantSpecificUrl, tenantTableDDL, null, null);
        Connection conn = this.nextConnection(tenantSpecificUrl);
        conn.createStatement().executeUpdate("upsert into t_view (pk2, pk3, c1) values ('helo1', 1, 1)");
        conn.createStatement().executeUpdate("upsert into t_view (pk2, pk3, c1) values ('helo2', 2, 2)");
        conn.createStatement().executeUpdate("upsert into t_view (pk2, pk3, c1) values ('helo3', 3, 3)");
        conn.commit();
        conn.close();
        conn = this.nextConnection(tenantSpecificUrl);
        PreparedStatement stmt = conn.prepareStatement("select pk2, pk3 from t_view WHERE (pk2 = ? OR pk2 = ?) AND (pk2, pk3) > (?, ?) LIMIT 100");
        stmt.setString(1, "helo1");
        stmt.setString(2, "helo3");
        stmt.setString(3, "helo1");
        stmt.setInt(4, 1);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"helo3", (Object)rs.getString(1));
        Assert.assertEquals((long)3L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testRVCWithRowKeyNotLeading() throws Exception {
        String ddl = "CREATE TABLE sorttest4 (rownum BIGINT primary key, name varchar(16), age integer)";
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        conn.createStatement().execute(ddl);
        conn.close();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String dml = "UPSERT INTO sorttest4 (rownum, name, age) values (?, ?, ?)";
        PreparedStatement stmt = conn.prepareStatement(dml);
        stmt.setInt(1, 1);
        stmt.setString(2, "A");
        stmt.setInt(3, 1);
        stmt.executeUpdate();
        stmt.setInt(1, 2);
        stmt.setString(2, "B");
        stmt.setInt(3, 2);
        stmt.executeUpdate();
        conn.commit();
        conn.close();
        String query = "SELECT rownum, name, age FROM sorttest4 where (age, rownum) < (2, 2)";
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery(query);
        int numRecords = 0;
        while (rs.next()) {
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"A", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            ++numRecords;
        }
        Assert.assertEquals((long)1L, (long)numRecords);
    }

    @Test
    public void testRVCInView() throws Exception {
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        conn.createStatement().execute("CREATE TABLE TEST_TABLE.TEST1 (\nPK1 CHAR(3) NOT NULL, \nPK2 CHAR(3) NOT NULL,\nDATA1 CHAR(10)\nCONSTRAINT PK PRIMARY KEY (PK1, PK2))");
        conn.close();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        conn.createStatement().execute("CREATE VIEW TEST_TABLE.FOO AS SELECT * FROM TEST_TABLE.TEST1 WHERE PK1 = 'FOO'");
        conn.close();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        conn.createStatement().execute("UPSERT INTO TEST_TABLE.TEST1 VALUES('FOO','001','SOMEDATA')");
        conn.createStatement().execute("UPSERT INTO TEST_TABLE.TEST1 VALUES('FOO','002','SOMEDATA')");
        conn.createStatement().execute("UPSERT INTO TEST_TABLE.TEST1 VALUES('FOO','003','SOMEDATA')");
        conn.createStatement().execute("UPSERT INTO TEST_TABLE.TEST1 VALUES('FOO','004','SOMEDATA')");
        conn.createStatement().execute("UPSERT INTO TEST_TABLE.TEST1 VALUES('FOO','005','SOMEDATA')");
        conn.commit();
        conn.close();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST_TABLE.FOO WHERE PK2 < '004' AND (PK1,PK2) > ('FOO','002') LIMIT 2");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"003", (Object)rs.getString("PK2"));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testCountDistinct1() throws Exception {
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String tableName = RowValueConstructorIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (region_name VARCHAR PRIMARY KEY, a INTEGER, b INTEGER)";
        conn.createStatement().execute(ddl);
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (region_name, a, b) VALUES('a', 6,3)");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (region_name, a, b) VALUES('b', 2,4)");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (region_name, a, b) VALUES('c', 6,3)");
        stmt.execute();
        conn.commit();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(DISTINCT (a,b)) from " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        conn.close();
    }

    @Test
    public void testCountDistinct2() throws Exception {
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String tableName = RowValueConstructorIT.generateUniqueName();
        String ddl = "CREATE TABLE  " + tableName + "  (region_name VARCHAR PRIMARY KEY, a VARCHAR, b VARCHAR)";
        conn.createStatement().execute(ddl);
        conn.commit();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (region_name, a, b) VALUES('a', 'fooo','abc')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (region_name, a, b) VALUES('b', 'off','bac')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (region_name, a, b) VALUES('c', 'fooo', 'abc')");
        stmt.execute();
        conn.commit();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(DISTINCT (a,b)) from  " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
    }

    @Test
    public void testCountDistinct3() throws Exception {
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String tableName = "testCountDistinct3rvc";
        String ddl = "CREATE TABLE  " + tableName + "  (region_name VARCHAR PRIMARY KEY, a Boolean, b Boolean)";
        conn.createStatement().execute(ddl);
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (region_name, a, b) VALUES('a', true, true)");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (region_name, a, b) VALUES('b', true, False)");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (region_name, a, b) VALUES('c', true, true)");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (region_name, a, b) VALUES('d', true, false)");
        stmt.execute();
        conn.commit();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(DISTINCT (a,b)) from  " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
    }

    @Test
    public void testCountDistinct4() throws Exception {
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String tableName = RowValueConstructorIT.generateUniqueName();
        String ddl = "CREATE TABLE  " + tableName + "  (region_name VARCHAR PRIMARY KEY, a VARCHAR, b VARCHAR)";
        conn.createStatement().execute(ddl);
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (region_name, a, b) VALUES('a', 'fooo','abc')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (region_name, a, b) VALUES('b', 'off','bac')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (region_name, a, b) VALUES('c', 'foo', 'abc')");
        stmt.execute();
        conn.commit();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(DISTINCT (a,b)) from  " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
    }

    @Test
    public void testRVCRequiringExtractNodeClear() throws Exception {
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String tableName = RowValueConstructorIT.generateUniqueName();
        String ddl = "CREATE TABLE  " + tableName + "  (k1 VARCHAR, k2 VARCHAR, k3 VARCHAR, k4 VARCHAR, CONSTRAINT pk PRIMARY KEY (k1,k2,k3,k4))";
        conn.createStatement().execute(ddl);
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES('a','b','c','d')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES('b', 'b', 'c', 'e')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES('c', 'b','c','f')");
        stmt.execute();
        conn.commit();
        TestUtil.dumpTable(conn, TableName.valueOf((String)tableName));
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1 from  " + tableName + " WHERE k1 IN ('a','c') AND (k2,k3) IN (('b','c'),('f','g')) AND k4 > 'c'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"c", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testRVCRequiringExtractNodeVarBinary() throws Exception {
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String tableName = RowValueConstructorIT.generateUniqueName();
        String ddl = "CREATE TABLE  " + tableName + "  (k1 VARBINARY_ENCODED, k2 VARBINARY_ENCODED, k3 VARBINARY_ENCODED, k4 VARBINARY_ENCODED, CONSTRAINT pk PRIMARY KEY (k1,k2,k3,k4))";
        conn.createStatement().execute(ddl);
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES(?,?,?,?)");
        stmt.setBytes(1, Bytes.toBytes((int)97));
        stmt.setBytes(2, Bytes.toBytes((int)98));
        stmt.setBytes(3, Bytes.toBytes((int)99));
        stmt.setBytes(4, Bytes.toBytes((int)100));
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES(?,?,?,?)");
        stmt.setBytes(1, Bytes.toBytes((int)98));
        stmt.setBytes(2, Bytes.toBytes((int)98));
        stmt.setBytes(3, Bytes.toBytes((int)99));
        stmt.setBytes(4, Bytes.toBytes((int)101));
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES(?,?,?,?)");
        stmt.setBytes(1, Bytes.toBytes((int)99));
        stmt.setBytes(2, Bytes.toBytes((int)98));
        stmt.setBytes(3, Bytes.toBytes((int)99));
        stmt.setBytes(4, Bytes.toBytes((int)102));
        stmt.execute();
        conn.commit();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        stmt = conn.prepareStatement("SELECT k1 from  " + tableName + " WHERE k1 IN (?,?) AND (k2,k3) IN ((?,?),(?,?)) AND k4 > ?");
        stmt.setBytes(1, Bytes.toBytes((int)97));
        stmt.setBytes(2, Bytes.toBytes((int)99));
        stmt.setBytes(3, Bytes.toBytes((int)98));
        stmt.setBytes(4, Bytes.toBytes((int)99));
        stmt.setBytes(5, Bytes.toBytes((int)102));
        stmt.setBytes(6, Bytes.toBytes((int)103));
        stmt.setBytes(7, Bytes.toBytes((int)99));
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((int)97), (byte[])rs.getBytes(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((int)99), (byte[])rs.getBytes(1));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.prepareStatement("SELECT k1, k2, k3 from  " + tableName + " WHERE ((k1, k2), k3) >= ((?, ?), ?)");
        stmt.setBytes(1, Bytes.toBytes((int)98));
        stmt.setBytes(2, Bytes.toBytes((int)98));
        stmt.setBytes(3, Bytes.toBytes((int)98));
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((int)98), (byte[])rs.getBytes(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((int)99), (byte[])rs.getBytes(1));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.prepareStatement("SELECT k1, k2, k3, k4 from  " + tableName + " WHERE (k1, k2, k3) >= (?, ?, ?)");
        stmt.setBytes(1, Bytes.toBytes((int)98));
        stmt.setBytes(2, Bytes.toBytes((int)98));
        stmt.setBytes(3, Bytes.toBytes((int)98));
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((int)98), (byte[])rs.getBytes(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((int)99), (byte[])rs.getBytes(1));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.prepareStatement("SELECT k1, k2, k3 from  " + tableName + " WHERE (k1, (k2, k3)) >= (?, (?, ?))");
        stmt.setBytes(1, Bytes.toBytes((int)98));
        stmt.setBytes(2, Bytes.toBytes((int)98));
        stmt.setBytes(3, Bytes.toBytes((int)98));
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((int)98), (byte[])rs.getBytes(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((int)99), (byte[])rs.getBytes(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testRVCRequiringExtractNodeVarBinary2() throws Exception {
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String tableName = RowValueConstructorIT.generateUniqueName();
        String ddl = "CREATE TABLE  " + tableName + "  (k1 VARBINARY_ENCODED, k2 VARBINARY_ENCODED, k3 VARBINARY_ENCODED, k4 VARBINARY_ENCODED CONSTRAINT pk PRIMARY KEY (k1,k2,k3))";
        conn.createStatement().execute(ddl);
        byte[] b1 = new byte[]{34, 58, 38, 0, 40, -13, 34, 0};
        byte[] b2 = new byte[]{35, 58, 38, 0, 40, -13, 34, 0};
        byte[] b3 = new byte[]{36, 58, 38, 0, 40, -13, 34, 0};
        byte[] b4 = new byte[]{37, 58, 38, 0, 40, -13, 34, 0};
        byte[] b5 = new byte[]{38, 58, 38, 0, 40, -13, 34, 0};
        byte[] b6 = new byte[]{39, 58, 38, 0, 40, -13, 34, 0};
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES(?,?,?,?)");
        stmt.setBytes(1, b1);
        stmt.setBytes(2, b2);
        stmt.setBytes(3, b3);
        stmt.setBytes(4, b4);
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES(?,?,?,?)");
        stmt.setBytes(1, b2);
        stmt.setBytes(2, b2);
        stmt.setBytes(3, b3);
        stmt.setBytes(4, b5);
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES(?,?,?,?)");
        stmt.setBytes(1, b3);
        stmt.setBytes(2, b2);
        stmt.setBytes(3, b3);
        stmt.setBytes(4, b6);
        stmt.execute();
        conn.commit();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        stmt = conn.prepareStatement("SELECT k1, k2, k4 from  " + tableName + " WHERE ((k1, k2), k4) >= ((?, ?), ?)");
        stmt.setBytes(1, b2);
        stmt.setBytes(2, b2);
        stmt.setBytes(3, b3);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])b2, (byte[])rs.getBytes(1));
        Assert.assertArrayEquals((byte[])b2, (byte[])rs.getBytes(2));
        Assert.assertArrayEquals((byte[])b5, (byte[])rs.getBytes(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])b3, (byte[])rs.getBytes(1));
        Assert.assertArrayEquals((byte[])b2, (byte[])rs.getBytes(2));
        Assert.assertArrayEquals((byte[])b6, (byte[])rs.getBytes(3));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.prepareStatement("SELECT k1, k2, k4 from  " + tableName + " WHERE (k1, k2, k4) >= (?, ?, ?)");
        stmt.setBytes(1, b2);
        stmt.setBytes(2, b2);
        stmt.setBytes(3, b3);
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])b2, (byte[])rs.getBytes(1));
        Assert.assertArrayEquals((byte[])b2, (byte[])rs.getBytes(2));
        Assert.assertArrayEquals((byte[])b5, (byte[])rs.getBytes(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])b3, (byte[])rs.getBytes(1));
        Assert.assertArrayEquals((byte[])b2, (byte[])rs.getBytes(2));
        Assert.assertArrayEquals((byte[])b6, (byte[])rs.getBytes(3));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.prepareStatement("SELECT k1, k2, k4 from  " + tableName + " WHERE (k1, (k2, k4)) >= (?, (?, ?))");
        stmt.setBytes(1, b2);
        stmt.setBytes(2, b2);
        stmt.setBytes(3, b4);
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])b2, (byte[])rs.getBytes(1));
        Assert.assertArrayEquals((byte[])b2, (byte[])rs.getBytes(2));
        Assert.assertArrayEquals((byte[])b5, (byte[])rs.getBytes(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])b3, (byte[])rs.getBytes(1));
        Assert.assertArrayEquals((byte[])b2, (byte[])rs.getBytes(2));
        Assert.assertArrayEquals((byte[])b6, (byte[])rs.getBytes(3));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testRVCRequiringNoSkipScan() throws Exception {
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String tableName = RowValueConstructorIT.generateUniqueName();
        String ddl = "CREATE TABLE  " + tableName + "  (k1 VARCHAR, k2 VARCHAR, k3 VARCHAR, k4 VARCHAR, CONSTRAINT pk PRIMARY KEY (k1,k2,k3,k4))";
        conn.createStatement().execute(ddl);
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES('','','a')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES('', '', 'a', 'a')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES('', '','b')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES('', '','b','a')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES('a', '','c')");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " VALUES('a', '','c', 'a')");
        stmt.execute();
        conn.commit();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1,k3,k4 from  " + tableName + " WHERE (k1,k2,k3) IN (('','','a'),('','','b'),('a','','c')) AND k4 is not null");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals(null, (Object)rs.getString(1));
        Assert.assertEquals((Object)"a", (Object)rs.getString(2));
        Assert.assertEquals((Object)"a", (Object)rs.getString(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals(null, (Object)rs.getString(1));
        Assert.assertEquals((Object)"b", (Object)rs.getString(2));
        Assert.assertEquals((Object)"a", (Object)rs.getString(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"c", (Object)rs.getString(2));
        Assert.assertEquals((Object)"a", (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testRVCLastPkIsTable1stPkIndex() throws Exception {
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String tableName = RowValueConstructorIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (k1 VARCHAR, k2 VARCHAR, k3 VARCHAR, k4 VARCHAR, CONSTRAINT pk PRIMARY KEY (k1,k2,k3,k4))";
        conn.createStatement().execute(ddl);
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        ddl = "CREATE INDEX  " + tableName + "_idx ON " + tableName + " (k2, k3, k4, k1)";
        conn.createStatement().execute(ddl);
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String upsert = "UPSERT INTO " + tableName + " VALUES(?, ?, ?, ?)";
        PreparedStatement stmt = conn.prepareStatement(upsert);
        for (int i = 0; i < 5; ++i) {
            stmt.setString(1, "10" + i);
            stmt.setString(2, "20" + i);
            stmt.setString(3, "30" + i);
            stmt.setString(4, "40" + i);
            stmt.execute();
        }
        conn.commit();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String query = "SELECT k1, k2, k3, k4 FROM " + tableName + " WHERE k2 = '203'";
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"103", (Object)rs.getString(1));
        Assert.assertEquals((Object)"203", (Object)rs.getString(2));
        Assert.assertEquals((Object)"303", (Object)rs.getString(3));
        Assert.assertEquals((Object)"403", (Object)rs.getString(4));
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        query = "SELECT k1, k2, k3, k4 FROM " + tableName + " WHERE (k2, k3, k4, k1) > ('201', '301', '401', '101') AND k2 = '203'";
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"103", (Object)rs.getString(1));
        Assert.assertEquals((Object)"203", (Object)rs.getString(2));
        Assert.assertEquals((Object)"303", (Object)rs.getString(3));
        Assert.assertEquals((Object)"403", (Object)rs.getString(4));
    }

    @Test
    public void testMultiTenantRVC() throws Exception {
        Connection conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String tableName = "mtRVC";
        String ddl = "CREATE TABLE " + tableName + " (\n    pk1 VARCHAR NOT NULL,\n    pk2 DECIMAL NOT NULL,\n    v1 VARCHAR\n    CONSTRAINT PK PRIMARY KEY \n    (\n        pk1,\n        pk2\n    )\n) MULTI_TENANT=true,IMMUTABLE_ROWS=true";
        conn.createStatement().execute(ddl);
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        ddl = "CREATE INDEX  " + tableName + "_idx ON " + tableName + " (v1)";
        conn.createStatement().execute(ddl);
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String upsert = "UPSERT INTO " + tableName + " VALUES(?, ?, ?)";
        PreparedStatement stmt = conn.prepareStatement(upsert);
        stmt.setString(1, "a");
        stmt.setInt(2, 1);
        stmt.setString(3, "value");
        stmt.execute();
        stmt.setString(1, "a");
        stmt.setInt(2, 2);
        stmt.setString(3, "value");
        stmt.execute();
        conn.commit();
        conn = this.nextConnection(RowValueConstructorIT.getUrl());
        String query = "SELECT pk1, pk2, v1 FROM " + tableName + " WHERE pk1 = 'a' AND\n(pk1, pk2) > ('a', 1)\nORDER BY PK1, PK2\nLIMIT 2";
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertTrue((new BigDecimal("2").compareTo(rs.getBigDecimal(2)) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"value", (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testRVCWithAndClause() throws Exception {
        int numItemsInClause = 5;
        Properties tenantProps = new Properties();
        tenantProps.setProperty("TenantId", "tenant1");
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)("T_" + RowValueConstructorIT.generateUniqueName()));
        String fullViewName = SchemaUtil.getTableName((String)"S", (String)("V_" + RowValueConstructorIT.generateUniqueName()));
        try (Connection tenantConn = DriverManager.getConnection(RowValueConstructorIT.getUrl(), tenantProps);){
            tenantConn.setAutoCommit(false);
            this.createBaseTableAndTenantView(tenantConn, fullTableName, fullViewName);
            this.loadDataIntoTenantView(tenantConn, fullViewName);
            List<String> objectIdsList = this.selectObjectIdsForInClause(tenantConn, fullViewName, 5);
            StringBuilder querySb = this.generateQueryToTest(5, fullViewName);
            PreparedStatement ps = tenantConn.prepareStatement(querySb.toString());
            int numbBindVarsSet = 0;
            String objectId = null;
            for (int i = 0; i < 5; ++i) {
                objectId = objectIdsList.get(i);
                ps.setString(i + 1, objectId);
                ++numbBindVarsSet;
            }
            Assert.assertEquals((long)5L, (long)numbBindVarsSet);
            Assert.assertEquals((Object)"v1000", (Object)objectId);
            ps.setString(6, "z00");
            ps.setString(7, "v1000");
            ResultSet rs = ps.executeQuery();
            Assert.assertFalse((String)"Query should return no results as IN clause and RVC clause are disjoint sets", (boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTrailingSeparator() throws Exception {
        try (Connection conn = null;){
            conn = DriverManager.getConnection(RowValueConstructorIT.getUrl());
            conn.createStatement().execute("CREATE TABLE test2961 (\nACCOUNT_ID VARCHAR NOT NULL,\nBUCKET_ID VARCHAR NOT NULL,\nOBJECT_ID VARCHAR NOT NULL,\nOBJECT_VERSION VARCHAR NOT NULL,\nLOC VARCHAR,\nCONSTRAINT PK PRIMARY KEY (ACCOUNT_ID, BUCKET_ID, OBJECT_ID, OBJECT_VERSION DESC))");
            String sql = "SELECT  OBJ.ACCOUNT_ID from  test2961 as OBJ where (OBJ.ACCOUNT_ID, OBJ.BUCKET_ID, OBJ.OBJECT_ID, OBJ.OBJECT_VERSION) IN ((?,?,?,?),(?,?,?,?))";
            PhoenixPreparedStatement statement = conn.prepareStatement(sql).unwrap(PhoenixPreparedStatement.class);
            statement.setString(1, new String(new char[]{'\u0003'}));
            statement.setString(2, new String(new char[]{'7'}));
            statement.setString(3, new String(new char[]{'\''}));
            statement.setString(4, new String(new char[]{'\u0000'}));
            statement.setString(5, new String(new char[]{'S'}));
            statement.setString(6, new String(new char[]{'\u000f'}));
            statement.setString(7, new String(new char[]{'7'}));
            statement.setString(8, new String(new char[]{'\u0093'}));
            statement.optimizeQuery(sql);
        }
    }

    @Test
    public void testRVCConjunction() throws Exception {
        try (Connection conn = DriverManager.getConnection(RowValueConstructorIT.getUrl());){
            String tableName = RowValueConstructorIT.generateUniqueName();
            String ddl = String.format("create table %s(a varchar(10) not null, b varchar(10) not null, c varchar(10) not null constraint pk primary key(a, b, c))", tableName);
            String upsert = String.format("upsert into %s values(?, ?, ?)", tableName);
            try (Statement statement = conn.createStatement();){
                statement.execute(ddl);
            }
            statement = conn.prepareStatement(upsert);
            var7_9 = null;
            try {
                statement.setString(1, "abc");
                statement.setString(2, "def");
                statement.setString(3, "RRSQ_IMKKL");
                statement.executeUpdate();
                statement.setString(3, "RRS_ZYTDT");
                statement.executeUpdate();
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
            finally {
                if (statement != null) {
                    if (var7_9 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
            conn.commit();
            String conjunctionSelect = String.format("select A, B, C from %s where (A, B, C) > ('abc', 'def', 'RRSQ_IMKKL') AND C like 'RRS\\\\_%%'", tableName);
            try (Statement statement = conn.createStatement();
                 ResultSet rs = statement.executeQuery(conjunctionSelect);){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
                Assert.assertEquals((Object)"def", (Object)rs.getString(2));
                Assert.assertEquals((Object)"RRS_ZYTDT", (Object)rs.getString(3));
                PhoenixStatement phoenixStatement = statement.unwrap(PhoenixStatement.class);
                byte[] lowerBound = ((Scan)((List)phoenixStatement.getQueryPlan().getScans().get(0)).get(0)).getStartRow();
                byte[] expected = new byte[]{97, 98, 99, 0, 100, 101, 102, 0, 82, 82, 83, 95};
                Assert.assertArrayEquals((byte[])expected, (byte[])lowerBound);
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    private StringBuilder generateQueryToTest(int numItemsInClause, String fullViewName) {
        StringBuilder querySb = new StringBuilder("SELECT OBJECT_ID,OBJECT_DATA2,OBJECT_DATA FROM " + fullViewName);
        querySb.append(" WHERE ((");
        ArrayList orClauses = Lists.newArrayList();
        for (int i = 1; i < numItemsInClause + 1; ++i) {
            orClauses.add("OBJECT_ID = ?");
        }
        querySb.append(Joiner.on((String)" OR ").join((Iterable)orClauses));
        querySb.append(") AND (KEY_PREFIX,OBJECT_ID) >  (?,?)) ORDER BY OBJECT_ID LIMIT 125");
        System.out.println(querySb);
        return querySb;
    }

    private List<String> selectObjectIdsForInClause(Connection tenantConn, String fullViewName, int numItemsInClause) throws SQLException {
        String sqlForObjIds = "SELECT OBJECT_ID FROM " + fullViewName + " ORDER BY OBJECT_ID LIMIT " + numItemsInClause;
        PreparedStatement ps = tenantConn.prepareStatement(sqlForObjIds);
        ResultSet rs = ps.executeQuery();
        ArrayList objectIdsList = Lists.newArrayList();
        System.out.println("ObjectIds: ");
        while (rs.next()) {
            System.out.println("Object Id: " + rs.getString("OBJECT_ID"));
            objectIdsList.add(rs.getString("OBJECT_ID"));
        }
        Assert.assertEquals((long)numItemsInClause, (long)objectIdsList.size());
        return objectIdsList;
    }

    private void loadDataIntoTenantView(Connection tenantConn, String fullViewName) throws SQLException {
        for (int i = 0; i < 2000; ++i) {
            String objectId = "v" + i;
            String upsert = "UPSERT INTO " + fullViewName + " (OBJECT_ID, OBJECT_DATA, OBJECT_DATA2) VALUES ('" + objectId + "', 'data','data2')";
            PreparedStatement ps = tenantConn.prepareStatement(upsert);
            ps.executeUpdate();
        }
        tenantConn.commit();
        PreparedStatement selectStatement = tenantConn.prepareStatement("SELECT OBJECT_ID FROM " + fullViewName + " ORDER BY OBJECT_ID");
        ResultSet rs = selectStatement.executeQuery();
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((long)2000L, (long)count);
    }

    private void createBaseTableAndTenantView(Connection tenantConn, String fulTableName, String fullViewName) throws SQLException {
        String ddl = "CREATE TABLE IF NOT EXISTS " + fulTableName + " (TENANT_ID CHAR(15) NOT NULL, KEY_PREFIX CHAR(3) NOT NULL, CREATED_DATE DATE, CREATED_BY CHAR(15), SYSTEM_MODSTAMP DATE CONSTRAINT PK PRIMARY KEY (TENANT_ID,KEY_PREFIX)) VERSIONS=1, MULTI_TENANT=true, IMMUTABLE_ROWS=TRUE, REPLICATION_SCOPE=1";
        RowValueConstructorIT.createTestTable(RowValueConstructorIT.getUrl(), ddl);
        String tenantViewDdl = "CREATE VIEW IF NOT EXISTS " + fullViewName + " (OBJECT_ID VARCHAR(18) NOT NULL, OBJECT_DATA VARCHAR(131072), OBJECT_DATA2 VARCHAR(131072), CONSTRAINT PK PRIMARY KEY (OBJECT_ID)) AS SELECT * FROM " + fulTableName + " WHERE KEY_PREFIX = 'z00'";
        PreparedStatement stmt2 = tenantConn.prepareStatement(tenantViewDdl);
        stmt2.execute();
    }
}

