/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ReverseFunctionIT
extends ParallelStatsDisabledIT {
    private String initTable(Connection conn, String sortOrder, String s) throws Exception {
        String reverseTest = ReverseFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + reverseTest + " (pk VARCHAR NOT NULL PRIMARY KEY " + sortOrder + ", kv VARCHAR)";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + reverseTest + " VALUES(?)";
        PreparedStatement stmt = conn.prepareStatement(dml);
        stmt.setString(1, s);
        stmt.execute();
        conn.commit();
        return reverseTest;
    }

    private void testReverse(Connection conn, String s, String tableName) throws Exception {
        StringBuilder buf = new StringBuilder(s);
        String reverse = buf.reverse().toString();
        ResultSet rs = conn.createStatement().executeQuery("SELECT reverse(pk) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)reverse, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        PreparedStatement stmt = conn.prepareStatement("SELECT pk FROM " + tableName + " WHERE pk=reverse(?)");
        stmt.setString(1, reverse);
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)s, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSingleByteReverseAscending() throws Exception {
        Connection conn = DriverManager.getConnection(ReverseFunctionIT.getUrl());
        String s = "abc";
        String tableName = this.initTable(conn, "ASC", s);
        this.testReverse(conn, s, tableName);
    }

    @Test
    public void testMultiByteReverseAscending() throws Exception {
        Connection conn = DriverManager.getConnection(ReverseFunctionIT.getUrl());
        String s = "\u025a\u0266\u0270\u0278";
        String tableName = this.initTable(conn, "DESC", s);
        this.testReverse(conn, s, tableName);
    }

    @Test
    public void testSingleByteReverseDecending() throws Exception {
        Connection conn = DriverManager.getConnection(ReverseFunctionIT.getUrl());
        String s = "abc";
        String tableName = this.initTable(conn, "DESC", s);
        this.testReverse(conn, s, tableName);
    }

    @Test
    public void testMultiByteReverseDecending() throws Exception {
        Connection conn = DriverManager.getConnection(ReverseFunctionIT.getUrl());
        String s = "\u025a\u0266\u0270\u0278";
        String tableName = this.initTable(conn, "ASC", s);
        this.testReverse(conn, s, tableName);
    }

    @Test
    public void testNullReverse() throws Exception {
        Connection conn = DriverManager.getConnection(ReverseFunctionIT.getUrl());
        String s = "abc";
        String tableName = this.initTable(conn, "ASC", s);
        ResultSet rs = conn.createStatement().executeQuery("SELECT reverse(kv) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }
}

