/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class RenewLeaseIT
extends BaseTest {
    private static final long SCANNER_LEASE_TIMEOUT = 12000L;
    private static volatile boolean SLEEP_NOW = false;
    private static final String TABLE_NAME = RenewLeaseIT.generateUniqueName();

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)1);
        serverProps.put("hbase.coprocessor.region.classes", SleepingRegionObserver.class.getName());
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)1);
        serverProps.put("hbase.client.scanner.timeout.period", Long.toString(12000L));
        RenewLeaseIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaseDoesNotTimeout() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        conn.createStatement().execute("create table " + TABLE_NAME + "(k VARCHAR PRIMARY KEY)");
        SLEEP_NOW = true;
        try {
            ResultSet rs = conn.createStatement().executeQuery("select count(*) from " + TABLE_NAME);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
        }
        finally {
            SLEEP_NOW = false;
        }
    }

    public static class SleepingRegionObserver
    extends SimpleRegionObserver {
        public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
            try {
                if (SLEEP_NOW && ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString().equals(TABLE_NAME)) {
                    Thread.sleep(24000L);
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            return super.preScannerNext(c, s, results, limit, hasMore);
        }
    }
}

