/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class RegexpSubstrFunctionIT
extends ParallelStatsDisabledIT {
    private int id;
    String tableName;

    @Before
    public void doBeforeTestSetup() throws Exception {
        this.tableName = RegexpSubstrFunctionIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(RegexpSubstrFunctionIT.getUrl());
        TestUtil.createGroupByTestTable(conn, this.tableName);
        this.insertRow(conn, "Report1?1", 10);
        this.insertRow(conn, "Report1?2", 10);
        this.insertRow(conn, "Report2?1", 30);
        this.insertRow(conn, "Report3?2", 30);
        conn.commit();
        conn.close();
    }

    private void insertRow(Connection conn, String uri, int appcpu) throws SQLException {
        PreparedStatement statement = conn.prepareStatement("UPSERT INTO " + this.tableName + "(id, uri, appcpu) values (?,?,?)");
        statement.setString(1, "id" + this.id);
        statement.setString(2, uri);
        statement.setInt(3, appcpu);
        statement.executeUpdate();
        ++this.id;
    }

    private void testGroupByScanWithRegexpSubstr(Connection conn, Integer offset, String exceptedSubstr) throws Exception {
        String cmd = "select REGEXP_SUBSTR(uri, '[^\\\\?]+'" + (offset == null ? "" : ", " + offset) + ") suburi, sum(appcpu) sumcpu from " + this.tableName + " group by suburi";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(cmd);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("suburi"), (Object)(exceptedSubstr + "1"));
        Assert.assertEquals((long)rs.getInt("sumcpu"), (long)20L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("suburi"), (Object)(exceptedSubstr + "2"));
        Assert.assertEquals((long)rs.getInt("sumcpu"), (long)30L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("suburi"), (Object)(exceptedSubstr + "3"));
        Assert.assertEquals((long)rs.getInt("sumcpu"), (long)30L);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testGroupByScanWithRegexpSubstr() throws Exception {
        Connection conn = DriverManager.getConnection(RegexpSubstrFunctionIT.getUrl());
        this.testGroupByScanWithRegexpSubstr(conn, null, "Report");
        this.testGroupByScanWithRegexpSubstr(conn, 2, "eport");
        this.testGroupByScanWithRegexpSubstr(conn, -5, "rt");
        conn.close();
    }

    private void testFilterWithRegexSubstr(Connection conn, Integer offset, String exceptedSubstr) throws Exception {
        String cmd = "select id from " + this.tableName + " where REGEXP_SUBSTR(uri, '[^\\\\?]+'" + (offset == null ? "" : ", " + offset) + ") = '" + exceptedSubstr + "1'";
        ResultSet rs = conn.createStatement().executeQuery(cmd);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"id0", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"id1", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testFilterWithRegexSubstr() throws Exception {
        Connection conn = DriverManager.getConnection(RegexpSubstrFunctionIT.getUrl());
        this.testFilterWithRegexSubstr(conn, null, "Report");
        this.testFilterWithRegexSubstr(conn, 2, "eport");
        this.testFilterWithRegexSubstr(conn, -5, "rt");
        conn.close();
    }
}

