/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class ReadIsolationLevelIT
extends ParallelStatsEnabledIT {
    private static final String ENTITY_ID1 = "000000000000001";
    private static final String ENTITY_ID2 = "000000000000002";
    private static final String VALUE1 = "a";
    private static final String VALUE2 = "b";

    private static String initTableValues() throws Exception {
        String tenantId = ReadIsolationLevelIT.getOrganizationId();
        String tableName = ReadIsolationLevelIT.generateUniqueName();
        ReadIsolationLevelIT.ensureTableCreated(ReadIsolationLevelIT.getUrl(), tableName, "ATABLE");
        Properties props = new Properties();
        Connection upsertConn = DriverManager.getConnection(ReadIsolationLevelIT.getUrl(), props);
        PreparedStatement stmt = upsertConn.prepareStatement("upsert into " + tableName + " VALUES (?, ?, ?)");
        stmt.setString(1, tenantId);
        stmt.setString(2, ENTITY_ID1);
        stmt.setString(3, VALUE1);
        stmt.execute();
        stmt.setString(2, ENTITY_ID2);
        stmt.setString(3, VALUE2);
        stmt.execute();
        upsertConn.commit();
        upsertConn.close();
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatementReadIsolationLevel() throws Exception {
        String tableName = ReadIsolationLevelIT.initTableValues();
        String query = "SELECT A_STRING FROM " + tableName + " WHERE ORGANIZATION_ID=? AND ENTITY_ID=?";
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(ReadIsolationLevelIT.getUrl(), props);
        conn.setAutoCommit(true);
        Connection conn2 = DriverManager.getConnection(ReadIsolationLevelIT.getUrl(), props);
        long ts = EnvironmentEdgeManager.currentTimeMillis();
        props.setProperty("CurrentSCN", Long.toString(ts));
        Connection conn3 = DriverManager.getConnection(ReadIsolationLevelIT.getUrl(), props);
        try {
            String tenantId = ReadIsolationLevelIT.getOrganizationId();
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, ENTITY_ID1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)VALUE1, (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + " VALUES (?, ?, ?)");
            stmt.setString(1, tenantId);
            stmt.setString(2, ENTITY_ID1);
            stmt.setString(3, VALUE2);
            stmt.execute();
            PreparedStatement statement2 = conn2.prepareStatement(query);
            statement2.setString(1, tenantId);
            statement2.setString(2, ENTITY_ID1);
            rs = statement2.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)VALUE2, (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement statement3 = conn3.prepareStatement(query);
            statement3.setString(1, tenantId);
            statement3.setString(2, ENTITY_ID1);
            rs = statement3.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)VALUE1, (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
            conn2.close();
            conn3.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionReadIsolationLevel() throws Exception {
        String tableName = ReadIsolationLevelIT.initTableValues();
        String query = "SELECT A_STRING FROM " + tableName + " WHERE ORGANIZATION_ID=? AND ENTITY_ID=?";
        Connection conn = DriverManager.getConnection(ReadIsolationLevelIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        conn.setAutoCommit(true);
        long ts = EnvironmentEdgeManager.currentTimeMillis();
        String url = ReadIsolationLevelIT.getUrl() + ";" + "CurrentSCN" + "=" + (ts + 1L);
        Connection conn2 = DriverManager.getConnection(url, PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        try {
            String tenantId = ReadIsolationLevelIT.getOrganizationId();
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, ENTITY_ID1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)VALUE1, (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + " VALUES (?, ?, ?)");
            stmt.setString(1, tenantId);
            stmt.setString(2, ENTITY_ID1);
            stmt.setString(3, VALUE2);
            stmt.execute();
            PreparedStatement statement2 = conn2.prepareStatement(query);
            statement2.setString(1, tenantId);
            statement2.setString(2, ENTITY_ID1);
            rs = statement2.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)VALUE1, (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
            conn2.close();
        }
    }
}

