/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class RTrimFunctionIT
extends ParallelStatsDisabledIT {
    @Test
    public void testWithFixedLengthAscPK() throws Exception {
        this.testWithFixedLengthPK(SortOrder.ASC, Arrays.asList("b", "b ", "b  "));
    }

    @Test
    public void testWithFixedLengthDescPK() throws Exception {
        this.testWithFixedLengthPK(SortOrder.DESC, Arrays.asList("b  ", "b ", "b"));
    }

    private void testWithFixedLengthPK(SortOrder sortOrder, List<Object> expectedResults) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(RTrimFunctionIT.getUrl(), props);
        String tableName = RTrimFunctionIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + " ( k VARCHAR PRIMARY KEY " + (sortOrder == SortOrder.DESC ? "DESC" : "") + ")");
        conn.createStatement().execute("upsert into " + tableName + " (k) values ('a')");
        conn.createStatement().execute("upsert into " + tableName + " (k) values ('b')");
        conn.createStatement().execute("upsert into " + tableName + " (k) values ('b ')");
        conn.createStatement().execute("upsert into " + tableName + " (k) values ('b  ')");
        conn.createStatement().execute("upsert into " + tableName + " (k) values ('b  a')");
        conn.createStatement().execute("upsert into " + tableName + " (k) values (' b  ')");
        conn.createStatement().execute("upsert into " + tableName + " (k) values ('c')");
        conn.commit();
        String query = "select k from " + tableName + " WHERE rtrim(k)='b'";
        ResultSet rs = conn.createStatement().executeQuery(query);
        this.assertValueEqualsResultSet(rs, expectedResults);
        rs = conn.createStatement().executeQuery("explain " + query);
        Assert.assertTrue((boolean)QueryUtil.getExplainPlan((ResultSet)rs).contains("RANGE SCAN OVER " + tableName));
        conn.close();
    }
}

