/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class QueryWithOffsetIT
extends ParallelStatsDisabledIT {
    private static final String[] STRINGS = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private final boolean isSalted;
    private final String preSplit;
    private String ddl;
    private String tableName;

    public QueryWithOffsetIT(String preSplit) {
        this.isSalted = preSplit.startsWith(" SALT_BUCKETS");
        this.preSplit = preSplit;
    }

    @Before
    public void initTest() {
        this.tableName = "T_" + QueryWithOffsetIT.generateUniqueName();
        this.ddl = "CREATE TABLE " + this.tableName + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nC3.k3 INTEGER,\nC2.v1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2)) " + this.preSplit;
    }

    @Parameterized.Parameters(name="preSplit = {0}")
    public static synchronized Collection<String> data() {
        return Arrays.asList(" SPLIT ON ('e','i','o')", " SALT_BUCKETS=10");
    }

    @Test
    public void testLimitOffset() throws SQLException {
        int i;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(QueryWithOffsetIT.getUrl(), props);
        QueryWithOffsetIT.createTestTable(QueryWithOffsetIT.getUrl(), this.ddl);
        this.initTableValues(conn);
        int limit = 10;
        int offset = 10;
        this.updateStatistics(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT t_id from " + this.tableName + " order by t_id limit " + limit + " offset " + offset);
        for (i = 0; i < limit; ++i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((String)("Expected string didn't match for i = " + i), (Object)STRINGS[offset + i], (Object)rs.getString(1));
        }
        limit = 35;
        rs = conn.createStatement().executeQuery("SELECT t_id from " + this.tableName + " union all SELECT t_id from " + this.tableName + " offset " + offset + " FETCH FIRST " + limit + " rows only");
        i = 0;
        while (i++ < STRINGS.length - offset) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)STRINGS[offset + i - 1], (Object)rs.getString(1));
        }
        i = 0;
        while (i++ < limit - STRINGS.length - offset) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)STRINGS[i - 1], (Object)rs.getString(1));
        }
        limit = 1;
        offset = 1;
        rs = conn.createStatement().executeQuery("SELECT k2 from " + this.tableName + " order by k2 desc limit " + limit + " offset " + offset);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)25L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testOffsetSerialQueryExecutedOnServer() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(QueryWithOffsetIT.getUrl(), props);
        int offset = 10;
        QueryWithOffsetIT.createTestTable(QueryWithOffsetIT.getUrl(), this.ddl);
        this.initTableValues(conn);
        this.updateStatistics(conn);
        String query = "SELECT t_id from " + this.tableName + " offset " + offset;
        ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)this.tableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)"SERVER FILTER BY EMPTY COLUMN ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        if (!this.isSalted) {
            Assert.assertEquals((Object)"SERIAL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((long)offset, (long)explainPlanAttributes.getServerOffset().intValue());
        } else {
            Assert.assertEquals((Object)"PARALLEL 10-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            Assert.assertEquals((long)offset, (long)explainPlanAttributes.getClientOffset().intValue());
        }
        ResultSet rs = conn.createStatement().executeQuery(query);
        int i = 0;
        while (i++ < STRINGS.length - offset) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)STRINGS[offset + i - 1], (Object)rs.getString(1));
        }
        query = "SELECT t_id from " + this.tableName + " ORDER BY v1 offset " + offset;
        plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)this.tableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)"[C2.V1]", (Object)explainPlanAttributes.getServerSortedBy());
        Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
        Assert.assertEquals((long)offset, (long)explainPlanAttributes.getClientOffset().intValue());
        if (!this.isSalted) {
            Assert.assertEquals((Object)"PARALLEL 4-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        } else {
            Assert.assertEquals((Object)"PARALLEL 10-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        }
        conn.close();
    }

    @Test
    public void testOffsetWithoutLimit() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(QueryWithOffsetIT.getUrl(), props);
        int offset = 10;
        QueryWithOffsetIT.createTestTable(QueryWithOffsetIT.getUrl(), this.ddl);
        this.initTableValues(conn);
        this.updateStatistics(conn);
        int i = 0;
        ResultSet rs = conn.createStatement().executeQuery("SELECT t_id from " + this.tableName + " order by t_id offset " + offset + " row");
        while (i++ < STRINGS.length - offset) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)STRINGS[offset + i - 1], (Object)rs.getString(1));
        }
        rs = conn.createStatement().executeQuery("SELECT k3, count(*) from " + this.tableName + " group by k3 order by k3 desc offset " + offset + " row");
        i = 0;
        while (i++ < STRINGS.length - offset) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)(STRINGS.length - offset - i + 2), (long)rs.getInt(1));
        }
        rs = conn.createStatement().executeQuery("SELECT t_id from " + this.tableName + " union all SELECT t_id from " + this.tableName + " offset " + offset + " rows");
        i = 0;
        while (i++ < STRINGS.length - offset) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)STRINGS[offset + i - 1], (Object)rs.getString(1));
        }
        i = 0;
        while (i++ < STRINGS.length) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)STRINGS[i - 1], (Object)rs.getString(1));
        }
        conn.close();
    }

    @Test
    public void testMetaDataWithOffset() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(QueryWithOffsetIT.getUrl(), props);
        QueryWithOffsetIT.createTestTable(QueryWithOffsetIT.getUrl(), this.ddl);
        this.initTableValues(conn);
        this.updateStatistics(conn);
        PreparedStatement stmt = conn.prepareStatement("SELECT * from " + this.tableName + " offset ?");
        ParameterMetaData pmd = stmt.getParameterMetaData();
        Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
        Assert.assertEquals((long)4L, (long)pmd.getParameterType(1));
        stmt.setInt(1, 10);
        ResultSet rs = stmt.executeQuery();
        ResultSetMetaData md = rs.getMetaData();
        Assert.assertEquals((long)5L, (long)md.getColumnCount());
    }

    private void initTableValues(Connection conn) throws SQLException {
        for (int i = 0; i < 26; ++i) {
            conn.createStatement().execute("UPSERT INTO " + this.tableName + " values('" + STRINGS[i] + "'," + i + "," + (i + 1) + "," + (i + 2) + ",'" + STRINGS[25 - i] + "')");
        }
        conn.commit();
    }

    private void updateStatistics(Connection conn) throws SQLException {
        String query = "UPDATE STATISTICS " + this.tableName + " SET \"" + "phoenix.stats.guidepost.width" + "\"=" + Long.toString(500L);
        conn.createStatement().execute(query);
    }
}

