/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class QueryWithLimitIT
extends BaseTest {
    private String tableName;
    private static Map<String, String> props = Maps.newHashMapWithExpectedSize((int)5);

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        props.put("phoenix.stats.guidepost.width", Long.toString(50L));
        props.put("phoenix.query.queueSize", Integer.toString(1));
        props.put("phoenix.sequence.saltBuckets", Integer.toString(0));
        props.put("phoenix.query.threadPoolSize", Integer.toString(4));
        props.put("phoenix.log.saltBuckets", Integer.toString(0));
    }

    @Before
    public void setupDriver() throws Exception {
        QueryWithLimitIT.destroyDriver();
        QueryWithLimitIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
        this.tableName = QueryWithLimitIT.generateUniqueName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryWithLimitAndStats() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(QueryWithLimitIT.getUrl(), props);){
            conn.createStatement().execute("create table " + this.tableName + "\n   (i1 integer not null, i2 integer not null\n    CONSTRAINT pk PRIMARY KEY (i1,i2))");
            this.initTableValues(conn, 100);
            String query = "SELECT i1 FROM " + this.tableName + " LIMIT 1";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"SERIAL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)this.tableName, (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((long)1L, (long)explainPlanAttributes.getServerRowLimit().intValue());
            Assert.assertEquals((long)1L, (long)explainPlanAttributes.getClientRowLimit().intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryWithoutLimitFails() throws Exception {
        Properties connProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String query = "SELECT i1 FROM " + this.tableName;
        try (Connection conn = DriverManager.getConnection(QueryWithLimitIT.getUrl(), connProps);){
            conn.createStatement().execute("create table " + this.tableName + "\n   (i1 integer not null, i2 integer not null\n    CONSTRAINT pk PRIMARY KEY (i1,i2))");
            this.initTableValues(conn, 100);
            conn.createStatement().execute("UPDATE STATISTICS " + this.tableName);
            try {
                ResultSet rs = conn.createStatement().executeQuery(query);
                rs.next();
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof RejectedExecutionException));
            }
        }
        try {
            QueryWithLimitIT.destroyDriver();
            HashMap newProps = Maps.newHashMap(props);
            newProps.put("phoenix.query.queueSize", Integer.toString(-1));
            QueryWithLimitIT.setUpTestDriver(new ReadOnlyProps(newProps.entrySet().iterator()));
            try (Connection conn = DriverManager.getConnection(QueryWithLimitIT.getUrl(), connProps);){
                ResultSet rs = conn.createStatement().executeQuery(query);
                Assert.assertTrue((boolean)rs.next());
            }
        }
        finally {
            QueryWithLimitIT.destroyDriver();
        }
    }

    protected void initTableValues(Connection conn, int nRows) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("upsert into " + this.tableName + " VALUES (?, ?)");
        for (int i = 0; i < nRows; ++i) {
            stmt.setInt(1, i);
            stmt.setInt(2, i + 1);
            stmt.execute();
        }
        conn.commit();
    }
}

