/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PhoenixRuntime;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class QueryMoreIT
extends ParallelStatsDisabledIT {
    private final String TENANT_SPECIFIC_URL1 = QueryMoreIT.getUrl() + ';' + "TenantId" + "=tenant1";
    private String dataTableName;

    @Test
    public void testQueryMore1() throws Exception {
        this.testQueryMore(true, true);
    }

    @Test
    public void testQueryMore2() throws Exception {
        this.testQueryMore(false, true);
    }

    @Test
    public void testQueryMore3() throws Exception {
        this.testQueryMore(false, false);
    }

    @Test
    public void testQueryMore4() throws Exception {
        this.testQueryMore(true, false);
    }

    private void testQueryMore(boolean queryAgainstTenantSpecificView, boolean dataTableSalted) throws Exception {
        String[] tenantIds = new String[]{"T1_" + QueryMoreIT.generateUniqueName(), "T2_" + QueryMoreIT.generateUniqueName(), "T3_" + QueryMoreIT.generateUniqueName()};
        int numRowsPerTenant = 10;
        String cursorTableName = QueryMoreIT.generateUniqueName();
        String base_history_table = QueryMoreIT.generateUniqueName();
        this.dataTableName = base_history_table + (dataTableSalted ? "_SALTED" : "");
        String cursorTableDDL = "CREATE TABLE IF NOT EXISTS " + cursorTableName + " (\nTENANT_ID VARCHAR NOT NULL\n,QUERY_ID VARCHAR(15) NOT NULL,\nCURSOR_ORDER BIGINT NOT NULL \nCONSTRAINT CURSOR_TABLE_PK PRIMARY KEY (TENANT_ID, QUERY_ID, CURSOR_ORDER)) SALT_BUCKETS = 4, TTL=86400";
        String baseDataTableDDL = "CREATE TABLE IF NOT EXISTS " + this.dataTableName + " (\nTENANT_ID VARCHAR NOT NULL,\nPARENT_ID CHAR(15) NOT NULL,\nCREATED_DATE DATE NOT NULL,\nENTITY_HISTORY_ID CHAR(15) NOT NULL,\nDATA_TYPE VARCHAR,\nOLDVAL_STRING VARCHAR,\nNEWVAL_STRING VARCHAR\nCONSTRAINT PK PRIMARY KEY(TENANT_ID, PARENT_ID, CREATED_DATE DESC, ENTITY_HISTORY_ID)) VERSIONS = 1, MULTI_TENANT = true" + (dataTableSalted ? ", SALT_BUCKETS = 4" : "");
        Connection conn = DriverManager.getConnection(QueryMoreIT.getUrl());
        conn.createStatement().execute(cursorTableDDL);
        conn.createStatement().execute(baseDataTableDDL);
        conn.close();
        Map<String, List<String>> historyIdsPerTenant = this.createHistoryTableRows(this.dataTableName, tenantIds, numRowsPerTenant);
        String tenantId = tenantIds[0];
        String cursorQueryId = "00TcursrqueryId";
        String tableOrViewName = queryAgainstTenantSpecificView ? "HISTORY_TABLE_" + tenantId : this.dataTableName;
        Assert.assertEquals((long)numRowsPerTenant, (long)this.upsertSelectRecordsInCursorTableForTenant(tableOrViewName, queryAgainstTenantSpecificView, tenantId, cursorQueryId, cursorTableName));
        Connection conn2 = DriverManager.getConnection(QueryMoreIT.getUrl());
        ResultSet rs = conn2.createStatement().executeQuery("SELECT count(*) from " + cursorTableName);
        rs.next();
        Assert.assertEquals((long)numRowsPerTenant, (long)rs.getInt(1));
        conn2.close();
        int startOrder = 0;
        int endOrder = 5;
        int numRecordsThatShouldBeRetrieved = numRowsPerTenant / 2;
        String[] cursorIds = this.getRecordsOutofCursorTable(tableOrViewName, queryAgainstTenantSpecificView, tenantId, cursorQueryId, startOrder, endOrder, cursorTableName);
        Assert.assertEquals((long)numRecordsThatShouldBeRetrieved, (long)cursorIds.length);
        List<String> historyIds = this.doQueryMore(queryAgainstTenantSpecificView, tenantId, tableOrViewName, cursorIds);
        Assert.assertEquals(historyIdsPerTenant.get(tenantId).subList(startOrder, endOrder), historyIds);
        cursorIds = this.getRecordsOutofCursorTable(tableOrViewName, queryAgainstTenantSpecificView, tenantId, cursorQueryId, startOrder + numRecordsThatShouldBeRetrieved, endOrder + numRecordsThatShouldBeRetrieved, cursorTableName);
        Assert.assertEquals((long)numRecordsThatShouldBeRetrieved, (long)cursorIds.length);
        historyIds = this.doQueryMore(queryAgainstTenantSpecificView, tenantId, tableOrViewName, cursorIds);
        Assert.assertEquals(historyIdsPerTenant.get(tenantId).subList(startOrder + numRecordsThatShouldBeRetrieved, endOrder + numRecordsThatShouldBeRetrieved), historyIds);
        cursorIds = this.getRecordsOutofCursorTable(tableOrViewName, queryAgainstTenantSpecificView, tenantId, cursorQueryId, startOrder + 2 * numRecordsThatShouldBeRetrieved, endOrder + 2 * numRecordsThatShouldBeRetrieved, cursorTableName);
        Assert.assertEquals((long)0L, (long)cursorIds.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> createHistoryTableRows(String dataTableName, String[] tenantIds, int numRowsPerTenant) throws Exception {
        String upsertDML = "UPSERT INTO " + dataTableName + " VALUES (?, ?, ?, ?, ?, ?, ?)";
        HashMap<String, List<String>> historyIdsForTenant = new HashMap<String, List<String>>();
        try (Connection conn = DriverManager.getConnection(QueryMoreIT.getUrl());){
            PreparedStatement stmt = conn.prepareStatement(upsertDML);
            for (int j = 0; j < tenantIds.length; ++j) {
                ArrayList<String> historyIds = new ArrayList<String>();
                for (int i = 0; i < numRowsPerTenant; ++i) {
                    stmt.setString(1, tenantIds[j]);
                    String parentId = "parentId" + i;
                    stmt.setString(2, parentId);
                    stmt.setDate(3, new Date(100L));
                    String historyId = "historyId" + i;
                    stmt.setString(4, historyId);
                    stmt.setString(5, "datatype");
                    stmt.setString(6, "oldval");
                    stmt.setString(7, "newval");
                    stmt.executeUpdate();
                    historyIds.add(historyId);
                }
                historyIdsForTenant.put(tenantIds[j], historyIds);
            }
            conn.commit();
            HashMap<String, List<String>> hashMap = historyIdsForTenant;
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int upsertSelectRecordsInCursorTableForTenant(String tableOrViewName, boolean queryAgainstTenantView, String tenantId, String cursorQueryId, String cursorTable) throws Exception {
        String sequenceName = "\"" + tenantId + "_SEQ\"";
        Connection conn = queryAgainstTenantView ? this.getTenantSpecificConnection(tenantId) : DriverManager.getConnection(QueryMoreIT.getUrl());
        conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " CACHE " + Long.MAX_VALUE);
        conn.setAutoCommit(true);
        if (queryAgainstTenantView) {
            this.createTenantSpecificViewIfNecessary(tableOrViewName, conn);
        }
        try {
            int numRecords;
            String tenantIdFilter = queryAgainstTenantView ? "" : " WHERE TENANT_ID = ? ";
            String upsertSelectDML = "UPSERT INTO " + cursorTable + " (TENANT_ID, QUERY_ID, CURSOR_ORDER, PARENT_ID CHAR(15), CREATED_DATE DATE, ENTITY_HISTORY_ID CHAR(15)) SELECT ?, ?, NEXT VALUE FOR " + sequenceName + ", PARENT_ID, CREATED_DATE, ENTITY_HISTORY_ID  FROM " + tableOrViewName + tenantIdFilter;
            PreparedStatement stmt = conn.prepareStatement(upsertSelectDML);
            stmt.setString(1, tenantId);
            stmt.setString(2, cursorQueryId);
            if (!queryAgainstTenantView) {
                stmt.setString(3, tenantId);
            }
            int n = numRecords = stmt.executeUpdate();
            return n;
        }
        finally {
            try {
                conn.createStatement().execute("DROP SEQUENCE " + sequenceName);
            }
            finally {
                conn.close();
            }
        }
    }

    private Connection getTenantSpecificConnection(String tenantId) throws Exception {
        Properties props = new Properties();
        props.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(QueryMoreIT.getUrl(), props);
    }

    private String createTenantSpecificViewIfNecessary(String tenantViewName, Connection tenantConn) throws Exception {
        tenantConn.createStatement().execute("CREATE VIEW IF NOT EXISTS " + tenantViewName + " AS SELECT * FROM " + this.dataTableName);
        return tenantViewName;
    }

    private String[] getRecordsOutofCursorTable(String tableOrViewName, boolean queryAgainstTenantSpecificView, String tenantId, String cursorQueryId, int startOrder, int endOrder, String cursorTable) throws Exception {
        ArrayList columns;
        Connection conn = DriverManager.getConnection(QueryMoreIT.getUrl());
        ArrayList<String> pkIds = new ArrayList<String>();
        String cols = queryAgainstTenantSpecificView ? "PARENT_ID, CREATED_DATE, ENTITY_HISTORY_ID" : "TENANT_ID, PARENT_ID, CREATED_DATE, ENTITY_HISTORY_ID";
        String dynCols = queryAgainstTenantSpecificView ? "(PARENT_ID CHAR(15), CREATED_DATE DATE, ENTITY_HISTORY_ID CHAR(15))" : "(TENANT_ID CHAR(15), PARENT_ID CHAR(15), CREATED_DATE DATE, ENTITY_HISTORY_ID CHAR(15))";
        String selectCursorSql = "SELECT " + cols + " FROM " + cursorTable + " \n" + dynCols + " \nWHERE TENANT_ID = ? AND \nQUERY_ID = ? AND \nCURSOR_ORDER > ? AND \nCURSOR_ORDER <= ?";
        PreparedStatement stmt = conn.prepareStatement(selectCursorSql);
        stmt.setString(1, tenantId);
        stmt.setString(2, cursorQueryId);
        stmt.setInt(3, startOrder);
        stmt.setInt(4, endOrder);
        ResultSet rs = stmt.executeQuery();
        ArrayList arrayList = columns = queryAgainstTenantSpecificView ? Lists.newArrayList((Object[])new Pair[]{new Pair(null, (Object)"PARENT_ID"), new Pair(null, (Object)"CREATED_DATE"), new Pair(null, (Object)"ENTITY_HISTORY_ID")}) : Lists.newArrayList((Object[])new Pair[]{new Pair(null, (Object)"TENANT_ID"), new Pair(null, (Object)"PARENT_ID"), new Pair(null, (Object)"CREATED_DATE"), new Pair(null, (Object)"ENTITY_HISTORY_ID")});
        while (rs.next()) {
            Object[] values = new Object[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                values[i] = rs.getObject(i + 1);
            }
            conn = this.getTenantSpecificConnection(tenantId);
            pkIds.add(Bytes.toString((byte[])Base64.getEncoder().encode(PhoenixRuntime.encodeColumnValues((Connection)conn, (String)tableOrViewName.toUpperCase(), (Object[])values, (List)columns))));
        }
        return pkIds.toArray(new String[pkIds.size()]);
    }

    private List<String> doQueryMore(boolean queryAgainstTenantView, String tenantId, String tenantViewName, String[] cursorIds) throws Exception {
        Connection conn = queryAgainstTenantView ? this.getTenantSpecificConnection(tenantId) : DriverManager.getConnection(QueryMoreIT.getUrl());
        String tableName = queryAgainstTenantView ? tenantViewName : this.dataTableName;
        ArrayList columns = queryAgainstTenantView ? Lists.newArrayList((Object[])new Pair[]{new Pair(null, (Object)"PARENT_ID"), new Pair(null, (Object)"CREATED_DATE"), new Pair(null, (Object)"ENTITY_HISTORY_ID")}) : Lists.newArrayList((Object[])new Pair[]{new Pair(null, (Object)"TENANT_ID"), new Pair(null, (Object)"PARENT_ID"), new Pair(null, (Object)"CREATED_DATE"), new Pair(null, (Object)"ENTITY_HISTORY_ID")});
        StringBuilder sb = new StringBuilder();
        String where = queryAgainstTenantView ? " WHERE (PARENT_ID, CREATED_DATE, ENTITY_HISTORY_ID) IN " : " WHERE (TENANT_ID, PARENT_ID, CREATED_DATE, ENTITY_HISTORY_ID) IN ";
        sb.append("SELECT ENTITY_HISTORY_ID FROM " + tableName + where);
        int numPkCols = columns.size();
        String query = this.addRvcInBinds(sb, cursorIds.length, numPkCols);
        PreparedStatement stmt = conn.prepareStatement(query);
        int bindCounter = 1;
        for (int i = 0; i < cursorIds.length; ++i) {
            Object[] pkParts = PhoenixRuntime.decodeColumnValues((Connection)conn, (String)tableName.toUpperCase(), (byte[])Base64.getDecoder().decode(cursorIds[i]), (List)columns);
            for (int j = 0; j < pkParts.length; ++j) {
                stmt.setObject(bindCounter++, pkParts[j]);
            }
        }
        ResultSet rs = stmt.executeQuery();
        ArrayList<String> historyIds = new ArrayList<String>();
        while (rs.next()) {
            historyIds.add(rs.getString(1));
        }
        return historyIds;
    }

    private String addRvcInBinds(StringBuilder sb, int numRvcs, int numPkCols) {
        sb.append("(");
        for (int i = 0; i < numRvcs; ++i) {
            for (int j = 0; j < numPkCols; ++j) {
                if (j == 0) {
                    sb.append("(");
                }
                sb.append("?");
                if (j < numPkCols - 1) {
                    sb.append(",");
                    continue;
                }
                sb.append(")");
            }
            if (i >= numRvcs - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    @Test
    public void testSelectColumnMoreThanOnce() throws Exception {
        Date date = new Date(System.currentTimeMillis());
        QueryMoreIT.initEntityHistoryTableValues("abcd", QueryMoreIT.getDefaultSplits("abcd"), date, null);
        String query = "SELECT NEW_VALUE, NEW_VALUE FROM ENTITY_HISTORY LIMIT 1";
        ResultSet rs = DriverManager.getConnection(QueryMoreIT.getUrl()).createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        rs.getObject("NEW_VALUE");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testNullBigDecimalWithScale() throws Exception {
        String table = QueryMoreIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(QueryMoreIT.getUrl());
        conn.setAutoCommit(true);
        try (Statement stmt = conn.createStatement();){
            Assert.assertFalse((boolean)stmt.execute("CREATE TABLE IF NOT EXISTS " + table + " (\nPK VARCHAR(15) NOT NULL\n,\"DEC\" DECIMAL,\nCONSTRAINT TABLE_PK PRIMARY KEY (PK))"));
        }
        stmt = conn.prepareStatement("UPSERT INTO " + table + " (PK, \"DEC\") VALUES(?, ?)");
        var4_4 = null;
        try {
            stmt.setString(1, "key");
            stmt.setBigDecimal(2, null);
            Assert.assertFalse((boolean)stmt.execute());
            Assert.assertEquals((long)1L, (long)stmt.getUpdateCount());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var4_4 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        stmt = conn.createStatement();
        var4_4 = null;
        try {
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + table);
            Assert.assertNotNull((Object)rs);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"key", (Object)rs.getString(1));
            Assert.assertNull((Object)rs.getBigDecimal(2));
            Assert.assertNull((Object)rs.getBigDecimal(2, 10));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var4_4 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testRVCOnDescWithLeadingPKEquality() throws Exception {
        ResultSet rs2;
        Connection conn = DriverManager.getConnection(QueryMoreIT.getUrl());
        String fullTableName = QueryMoreIT.generateUniqueName();
        try (Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + fullTableName + "(\n    ORGANIZATION_ID CHAR(15) NOT NULL,\n    SCORE DOUBLE NOT NULL,\n    ENTITY_ID CHAR(15) NOT NULL\n    CONSTRAINT PAGE_SNAPSHOT_PK PRIMARY KEY (\n        ORGANIZATION_ID,\n        SCORE DESC,\n        ENTITY_ID DESC\n    )\n) MULTI_TENANT=TRUE");
        }
        conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES ('org1',3,'01')");
        conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES ('org1',2,'04')");
        conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES ('org1',2,'03')");
        conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES ('org1',1,'02')");
        conn.commit();
        stmt = conn.createStatement();
        var4_4 = null;
        try {
            rs2 = stmt.executeQuery("SELECT entity_id, score\nFROM " + fullTableName + "\nORDER BY ORGANIZATION_ID, score DESC, entity_id DESC\nLIMIT 3\nOFFSET  (ORGANIZATION_ID, SCORE, ENTITY_ID)=('org1', 2, '04')");
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((Object)"03", (Object)rs2.getString(1));
            Assert.assertEquals((double)2.0, (double)rs2.getDouble(2), (double)0.001);
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((Object)"02", (Object)rs2.getString(1));
            Assert.assertEquals((double)1.0, (double)rs2.getDouble(2), (double)0.001);
            Assert.assertFalse((boolean)rs2.next());
        }
        catch (Throwable rs2) {
            var4_4 = rs2;
            throw rs2;
        }
        finally {
            if (stmt != null) {
                if (var4_4 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs2) {
                        var4_4.addSuppressed(rs2);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        stmt = conn.createStatement();
        var4_4 = null;
        try {
            rs2 = stmt.executeQuery("SELECT entity_id, score\nFROM " + fullTableName + "\nWHERE ORGANIZATION_ID='org1'\nORDER BY organization_id, score DESC, entity_id DESC\nLIMIT 3\nOFFSET (ORGANIZATION_ID, SCORE, ENTITY_ID)=('org1', 2, '04')");
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((Object)"03", (Object)rs2.getString(1));
            Assert.assertEquals((double)2.0, (double)rs2.getDouble(2), (double)0.001);
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((Object)"02", (Object)rs2.getString(1));
            Assert.assertEquals((double)1.0, (double)rs2.getDouble(2), (double)0.001);
            Assert.assertFalse((boolean)rs2.next());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var4_4 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testSingleDescPKColumnComparison() throws Exception {
        Connection conn = DriverManager.getConnection(QueryMoreIT.getUrl());
        String fullTableName = QueryMoreIT.generateUniqueName();
        try (Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + fullTableName + "(\n    ORGANIZATION_ID CHAR(15) NOT NULL,\n    SCORE DOUBLE NOT NULL,\n    ENTITY_ID CHAR(15) NOT NULL\n    CONSTRAINT PAGE_SNAPSHOT_PK PRIMARY KEY (\n        ORGANIZATION_ID,\n        SCORE DESC,\n        ENTITY_ID DESC\n    )\n) MULTI_TENANT=TRUE");
        }
        conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES ('org1',3,'01')");
        conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES ('org1',2,'04')");
        conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES ('org1',2,'03')");
        conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES ('org1',1,'02')");
        conn.commit();
        stmt = conn.createStatement();
        var4_4 = null;
        try {
            ResultSet rs = stmt.executeQuery("SELECT entity_id, score\nFROM " + fullTableName + "\nWHERE organization_id = 'org1'\nAND score > 2.0\nORDER BY score DESC\nLIMIT 3");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"01", (Object)rs.getString(1));
            Assert.assertEquals((double)3.0, (double)rs.getDouble(2), (double)0.001);
            Assert.assertFalse((boolean)rs.next());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var4_4 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testMutationBatch() throws Exception {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("phoenix.mutate.batchSize", "10");
        connectionProperties.setProperty("phoenix.mutate.batchSizeBytes", "128");
        PhoenixConnection connection = (PhoenixConnection)DriverManager.getConnection(QueryMoreIT.getUrl(), connectionProperties);
        String fullTableName = QueryMoreIT.generateUniqueName();
        try (Statement stmt = connection.createStatement();){
            stmt.execute("CREATE TABLE " + fullTableName + "(\n    ORGANIZATION_ID CHAR(15) NOT NULL,\n    SCORE DOUBLE NOT NULL,\n    ENTITY_ID CHAR(15) NOT NULL\n    CONSTRAINT PAGE_SNAPSHOT_PK PRIMARY KEY (\n        ORGANIZATION_ID,\n        SCORE DESC,\n        ENTITY_ID DESC\n    )\n) MULTI_TENANT=TRUE");
        }
        this.upsertRows(connection, fullTableName);
        connection.commit();
        Assert.assertEquals((long)2L, (long)connection.getMutationState().getBatchCount());
        connectionProperties.setProperty("phoenix.mutate.batchSize", "2");
        connectionProperties.setProperty("phoenix.mutate.batchSizeBytes", "128");
        connection = (PhoenixConnection)DriverManager.getConnection(QueryMoreIT.getUrl(), connectionProperties);
        this.upsertRows(connection, fullTableName);
        connection.commit();
        Assert.assertEquals((long)2L, (long)connection.getMutationState().getBatchCount());
    }

    private void upsertRows(PhoenixConnection conn, String fullTableName) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("upsert into " + fullTableName + " (organization_id, entity_id, score) values (?,?,?)");
        for (int i = 0; i < 4; ++i) {
            stmt.setString(1, "AAAA" + i);
            stmt.setString(2, "BBBB" + i);
            stmt.setInt(3, 1);
            stmt.execute();
        }
    }

    @Test
    public void testRVCWithDescAndAscendingPK() throws Exception {
        Connection conn = DriverManager.getConnection(QueryMoreIT.getUrl());
        String fullTableName = QueryMoreIT.generateUniqueName();
        try (Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + fullTableName + "(\n    ORGANIZATION_ID CHAR(15) NOT NULL,\n    SCORE VARCHAR NOT NULL,\n    ENTITY_ID VARCHAR NOT NULL\n    CONSTRAINT PAGE_SNAPSHOT_PK PRIMARY KEY (\n        ORGANIZATION_ID,\n        SCORE DESC,\n        ENTITY_ID\n    )\n) MULTI_TENANT=TRUE");
        }
        conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES ('org1','c','1')");
        conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES ('org1','b','3')");
        conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES ('org1','b','4')");
        conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES ('org1','a','2')");
        conn.commit();
        stmt = conn.createStatement();
        var4_4 = null;
        try {
            ResultSet rs = stmt.executeQuery("SELECT score, entity_id \nFROM " + fullTableName + "\nORDER BY organization_id, score DESC, entity_id\nLIMIT 3\nOFFSET (ORGANIZATION_ID,SCORE,ENTITY_ID)=('org1','b','4')\n");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"2", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var4_4 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testRVCOnTenantViewThroughGlobalIdxOrderByDesc() throws Exception {
        Statement stmt;
        String fullTableName = QueryMoreIT.generateUniqueName();
        String fullViewName = QueryMoreIT.generateUniqueName();
        String tenantView = QueryMoreIT.generateUniqueName();
        String indexName = QueryMoreIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(QueryMoreIT.getUrl());){
            stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + "(\n    TENANT_ID CHAR(15) NOT NULL,\n    KEY_PREFIX CHAR(3) NOT NULL,\n    CREATED_DATE DATE,\n    CREATED_BY CHAR(15),\n    SYSTEM_MODSTAMP DATE\n    CONSTRAINT PK PRIMARY KEY (\n       TENANT_ID,       KEY_PREFIX\n)) MULTI_TENANT=TRUE");
            stmt.execute("CREATE VIEW " + fullViewName + "(\n    DATE_TIME1 DATE NOT NULL,\n    TEXT2 VARCHAR,\n    DOUBLE1 DECIMAL(12, 3),\n    IS_BOOLEAN BOOLEAN,\n    RELATIONSHIP_ID CHAR(15),\n    TEXT1 VARCHAR,\n    TEXT_READ_ONLY VARCHAR,\n    JSON1 VARCHAR,\n    IP_START_ADDRESS VARCHAR,\n    CONSTRAINT PKVIEW PRIMARY KEY\n    (\n        DATE_TIME1, TEXT2, TEXT1\n    )) AS SELECT * FROM " + fullTableName + "    WHERE KEY_PREFIX = '0CY'");
            stmt.execute("CREATE INDEX " + indexName + " ON " + fullViewName + " (TEXT1 DESC, TEXT2)\nINCLUDE (CREATED_BY,\n    RELATIONSHIP_ID,\n    JSON1,\n    DOUBLE1,\n    IS_BOOLEAN,\n    IP_START_ADDRESS,\n    CREATED_DATE,\n    SYSTEM_MODSTAMP,\n    TEXT_READ_ONLY)");
        }
        var6_6 = null;
        try (Connection viewConn = DriverManager.getConnection(this.TENANT_SPECIFIC_URL1);){
            stmt = viewConn.createStatement();
            stmt.execute("CREATE VIEW IF NOT EXISTS " + tenantView + " AS SELECT * FROM " + fullViewName);
            viewConn.createStatement().execute("UPSERT INTO " + tenantView + "(DATE_TIME1, TEXT1, TEXT2)  VALUES (TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), 'd', '1')");
            viewConn.createStatement().execute("UPSERT INTO " + tenantView + "(DATE_TIME1, TEXT1, TEXT2)  VALUES (TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), 'c', '2')");
            viewConn.createStatement().execute("UPSERT INTO " + tenantView + "(DATE_TIME1, TEXT1, TEXT2)  VALUES (TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), 'b', '3')");
            viewConn.createStatement().execute("UPSERT INTO " + tenantView + "(DATE_TIME1, TEXT1, TEXT2)  VALUES (TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), 'b', '4')");
            viewConn.createStatement().execute("UPSERT INTO " + tenantView + "(DATE_TIME1, TEXT1, TEXT2)  VALUES (TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), 'a', '4')");
            viewConn.commit();
            ResultSet rs = stmt.executeQuery("SELECT TEXT1, TEXT2 FROM " + tenantView + " WHERE (TEXT1, TEXT2) > ('b', '3') ORDER BY TEXT1 DESC, TEXT2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"d", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"2", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"4", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
        catch (Throwable stmt2) {
            var6_6 = stmt2;
            throw stmt2;
        }
        conn = DriverManager.getConnection(QueryMoreIT.getUrl());
        var6_6 = null;
        try {
            ResultSet rs = conn.createStatement().executeQuery("SELECT TEXT1, TEXT2 FROM " + fullViewName + " WHERE (TEXT1, TEXT2) > ('b', '3') ORDER BY TEXT1 DESC, TEXT2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"d", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"2", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"4", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var6_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }
}

