/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.GroupedAggregateRegionObserver;
import org.apache.phoenix.coprocessor.ServerCachingEndpointImpl;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class QueryDatabaseMetaDataIT
extends ParallelStatsDisabledIT {
    private static void createMDTestTable(Connection conn, String tableName, String extraProps) throws SQLException {
        String ddl = "create table if not exists " + tableName + "   (id char(1) primary key,\n    a.col1 integer default 42,\n    b.col2 bigint,\n    b.col3 decimal,\n    b.col4 decimal(5),\n    b.col5 decimal(6,3))\n    a." + "VERSIONS" + "=" + 1 + ",a." + "DATA_BLOCK_ENCODING" + "='" + DataBlockEncoding.NONE + "'";
        if (extraProps != null && extraProps.length() > 0) {
            ddl = ddl + "," + extraProps;
        }
        conn.createStatement().execute(ddl);
    }

    @Before
    public void deleteMetadata() throws Exception {
        try (Connection conn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            String delete = "DELETE FROM SYSTEM.CATALOG WHERE TABLE_SCHEM IS NULL OR TABLE_SCHEM = '' OR TABLE_SCHEM != 'SYSTEM'";
            conn.createStatement().executeUpdate(delete);
            conn.commit();
            delete = "DELETE FROM \"SYSTEM\".\"SEQUENCE\"";
            conn.createStatement().executeUpdate(delete);
            conn.commit();
            conn.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
        }
    }

    @Test
    public void testMetadataTenantSpecific() throws SQLException {
        String tableName = QueryDatabaseMetaDataIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            String baseTableDdl = "CREATE TABLE %s (K1 VARCHAR NOT NULL, K2 VARCHAR NOT NULL, V VARCHAR CONSTRAINT PK PRIMARY KEY(K1, K2)) MULTI_TENANT=true";
            conn.createStatement().execute(String.format(baseTableDdl, tableName));
        }
        String tenantId = QueryDatabaseMetaDataIT.generateUniqueName();
        Properties tenantProps = new Properties();
        tenantProps.setProperty("TenantId", tenantId);
        try (Connection tenantConn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl(), tenantProps);){
            String viewName = QueryDatabaseMetaDataIT.generateUniqueName();
            String viewDdl = "CREATE VIEW %s AS SELECT * FROM %s";
            tenantConn.createStatement().execute(String.format(viewDdl, viewName, tableName));
            DatabaseMetaData dbmd = tenantConn.getMetaData();
            ResultSet rs = dbmd.getTables(tenantId, "", viewName, null);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("TABLE_NAME"), (Object)viewName);
            Assert.assertEquals((Object)PTableType.VIEW.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
        }
    }

    @Test
    public void testTableMetadataScan() throws SQLException {
        String tableAName = QueryDatabaseMetaDataIT.generateUniqueName() + "TABLE";
        String tableASchema = "";
        QueryDatabaseMetaDataIT.ensureTableCreated(QueryDatabaseMetaDataIT.getUrl(), tableAName, "ATABLE", null);
        String tableS = QueryDatabaseMetaDataIT.generateUniqueName() + "TABLE";
        QueryDatabaseMetaDataIT.ensureTableCreated(QueryDatabaseMetaDataIT.getUrl(), tableS, "STABLE", null);
        String tableC = QueryDatabaseMetaDataIT.generateUniqueName();
        String tableCSchema = QueryDatabaseMetaDataIT.generateUniqueName();
        QueryDatabaseMetaDataIT.ensureTableCreated(QueryDatabaseMetaDataIT.getUrl(), tableCSchema + "." + tableC, "CORE.CUSTOM_ENTITY_DATA", null);
        try (Connection conn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            DatabaseMetaData dbmd = conn.getMetaData();
            ResultSet rs = dbmd.getTables(null, tableASchema, tableAName, null);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("TABLE_NAME"), (Object)tableAName);
            Assert.assertEquals((Object)PTableType.TABLE.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertEquals((Object)rs.getString(3), (Object)tableAName);
            Assert.assertEquals((Object)PTableType.TABLE.toString(), (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
            rs = dbmd.getTables(null, null, null, null);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"CATALOG", (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.SYSTEM.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"CDC_STREAM", (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.SYSTEM.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"CDC_STREAM_STATUS", (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.SYSTEM.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"CHILD_LINK", (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.SYSTEM.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"FUNCTION", (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.SYSTEM.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"LOG", (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.SYSTEM.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"MUTEX", (Object)rs.getString("TABLE_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"SEQUENCE", (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.SYSTEM.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"STATS", (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.SYSTEM.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"TASK", (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.SYSTEM.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)"TRANSFORM", (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.SYSTEM.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(null, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)tableAName, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.TABLE.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(null, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)tableS, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.TABLE.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)tableCSchema, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)tableC, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.TABLE.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertEquals((Object)"false", (Object)rs.getString("TRANSACTIONAL"));
            Assert.assertEquals((Object)Boolean.FALSE, (Object)rs.getBoolean("IS_NAMESPACE_MAPPED"));
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
            rs = dbmd.getTables(null, tableCSchema, tableC, null);
            Assert.assertTrue((boolean)rs.next());
            try {
                rs.getString("RANDOM_COLUMN_NAME");
                Assert.fail();
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                // empty catch block
            }
            Assert.assertEquals((Object)tableCSchema, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)tableC, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.TABLE.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
            rs = dbmd.getTables(null, "", "%TABLE", new String[]{PTableType.TABLE.toString()});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(null, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)tableAName, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.TABLE.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(null, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)tableS, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.TABLE.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
        }
    }

    @Test
    public void testTableTypes() throws SQLException {
        try (Connection conn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            DatabaseMetaData dbmd = conn.getMetaData();
            ResultSet rs = dbmd.getTableTypes();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"INDEX", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SEQUENCE", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM TABLE", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"TABLE", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"VIEW", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
        }
    }

    @Test
    public void testSequenceMetadataScan() throws SQLException {
        try (Connection conn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            String schema1 = "B" + QueryDatabaseMetaDataIT.generateUniqueName();
            String seq1 = QueryDatabaseMetaDataIT.generateUniqueName();
            String seq1FullName = schema1 + "." + seq1;
            String schema2 = QueryDatabaseMetaDataIT.generateUniqueName();
            String seq2 = QueryDatabaseMetaDataIT.generateUniqueName();
            String seq2FullName = schema2 + "." + seq2;
            String schema3 = schema1;
            String seq3 = QueryDatabaseMetaDataIT.generateUniqueName();
            String seq3FullName = schema3 + "." + seq3;
            String schema4 = QueryDatabaseMetaDataIT.generateUniqueName();
            String seq4 = seq1;
            String seq4FullName = schema4 + "." + seq4;
            conn.createStatement().execute("CREATE SEQUENCE " + seq1FullName);
            conn.createStatement().execute("CREATE SEQUENCE " + seq2FullName);
            conn.createStatement().execute("CREATE SEQUENCE " + seq3FullName);
            conn.createStatement().execute("CREATE SEQUENCE " + seq4FullName);
            DatabaseMetaData dbmd = conn.getMetaData();
            ResultSet rs = dbmd.getTables(null, null, null, new String[]{"FOO"});
            Assert.assertFalse((boolean)rs.next());
            rs = dbmd.getTables(null, null, null, new String[]{"FOO", "SEQUENCE"});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema1, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)seq1, (Object)rs.getString("TABLE_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema3, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)seq3, (Object)rs.getString("TABLE_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema2, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)seq2, (Object)rs.getString("TABLE_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema4, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)seq4, (Object)rs.getString("TABLE_NAME"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
            String foo = QueryDatabaseMetaDataIT.generateUniqueName();
            String basSchema = QueryDatabaseMetaDataIT.generateUniqueName();
            String bas = QueryDatabaseMetaDataIT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE " + foo + " (k bigint primary key)");
            conn.createStatement().execute("CREATE TABLE " + basSchema + "." + bas + " (k bigint primary key)");
            dbmd = conn.getMetaData();
            rs = dbmd.getTables(null, null, null, new String[]{PTableType.TABLE.toString(), "SEQUENCE"});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema1, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)seq1, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)"SEQUENCE", (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema3, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)seq3, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)"SEQUENCE", (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema2, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)seq2, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)"SEQUENCE", (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema4, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)seq4, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)"SEQUENCE", (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString("TABLE_CAT"));
            Assert.assertNull((Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)foo, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.TABLE.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)basSchema, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)bas, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)PTableType.TABLE.toString(), (Object)rs.getString("TABLE_TYPE"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
            rs = dbmd.getTables(null, "B%", null, new String[]{"SEQUENCE"});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema1, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)seq1, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)"SEQUENCE", (Object)rs.getString("TABLE_TYPE"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)schema3, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)seq3, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)"SEQUENCE", (Object)rs.getString("TABLE_TYPE"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
        }
    }

    @Test
    public void testShowSchemas() throws SQLException {
        try (Connection conn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            ResultSet rs = conn.prepareStatement("show schemas").executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CATALOG"));
            Assert.assertFalse((boolean)rs.next());
            String schema = "showschemastest_" + QueryDatabaseMetaDataIT.generateUniqueName();
            String fullTable = schema + "." + QueryDatabaseMetaDataIT.generateUniqueName();
            QueryDatabaseMetaDataIT.ensureTableCreated(QueryDatabaseMetaDataIT.getUrl(), fullTable, "ENTITY_HISTORY", null);
            rs = conn.prepareStatement("show schemas").executeQuery();
            HashSet<String> schemas = new HashSet<String>();
            while (rs.next()) {
                schemas.add(rs.getString("TABLE_SCHEM"));
                Assert.assertEquals(null, (Object)rs.getString("TABLE_CATALOG"));
            }
            Assert.assertEquals((long)2L, (long)schemas.size());
            Assert.assertTrue((boolean)schemas.contains("SYSTEM"));
            Assert.assertTrue((boolean)schemas.contains(schema.toUpperCase()));
            rs = conn.prepareStatement("show schemas like 'SYST%'").executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CATALOG"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testShowTables() throws SQLException {
        try (Connection conn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            ResultSet rs = conn.prepareStatement("show tables in SYSTEM").executeQuery();
            HashSet<String> tables = new HashSet<String>();
            while (rs.next()) {
                tables.add(rs.getString("TABLE_NAME"));
                Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            }
            Assert.assertEquals((long)11L, (long)tables.size());
            Assert.assertTrue((boolean)tables.contains("CATALOG"));
            Assert.assertTrue((boolean)tables.contains("FUNCTION"));
            tables.clear();
            rs = conn.prepareStatement("show tables in SYSTEM like 'FUNC%'").executeQuery();
            while (rs.next()) {
                tables.add(rs.getString("TABLE_NAME"));
            }
            Assert.assertEquals((long)1L, (long)tables.size());
            Assert.assertTrue((boolean)tables.contains("FUNCTION"));
        }
    }

    @Test
    public void testSchemaMetadataScan() throws SQLException {
        String table1 = QueryDatabaseMetaDataIT.generateUniqueName();
        String schema1 = "Z_" + QueryDatabaseMetaDataIT.generateUniqueName();
        String fullTable1 = schema1 + "." + table1;
        QueryDatabaseMetaDataIT.ensureTableCreated(QueryDatabaseMetaDataIT.getUrl(), fullTable1, "CORE.CUSTOM_ENTITY_DATA", null);
        String fullTable2 = QueryDatabaseMetaDataIT.generateUniqueName();
        QueryDatabaseMetaDataIT.ensureTableCreated(QueryDatabaseMetaDataIT.getUrl(), fullTable2, "PTSDB", null);
        try (Connection conn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            DatabaseMetaData dbmd = conn.getMetaData();
            ResultSet rs = dbmd.getSchemas(null, schema1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)schema1);
            Assert.assertEquals((Object)rs.getString(2), null);
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
            rs = dbmd.getSchemas(null, "");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), null);
            Assert.assertEquals((Object)rs.getString(2), null);
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
            rs = dbmd.getSchemas(null, null);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(null, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CATALOG"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"SYSTEM", (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CATALOG"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)schema1, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CATALOG"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
        }
    }

    @Test
    public void testColumnMetadataScan() throws SQLException {
        Connection conn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());
        String table = QueryDatabaseMetaDataIT.generateUniqueName();
        QueryDatabaseMetaDataIT.createMDTestTable(conn, table, "");
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getColumns(null, "", table, null);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals(null, (Object)rs.getString("TABLE_CAT"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"id"), (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)0L, (long)rs.getShort("NULLABLE"));
        Assert.assertEquals((long)PChar.INSTANCE.getSqlType(), (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)1L, (long)rs.getInt("ORDINAL_POSITION"));
        Assert.assertEquals((long)1L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"a"), (Object)rs.getString("COLUMN_FAMILY"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col1"), (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((Object)"42", (Object)rs.getString("COLUMN_DEF"));
        Assert.assertEquals((long)1L, (long)rs.getShort("NULLABLE"));
        Assert.assertEquals((long)PInteger.INSTANCE.getSqlType(), (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)2L, (long)rs.getInt("ORDINAL_POSITION"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"b"), (Object)rs.getString("COLUMN_FAMILY"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col2"), (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals(null, (Object)rs.getString("COLUMN_DEF"));
        Assert.assertEquals((long)1L, (long)rs.getShort("NULLABLE"));
        Assert.assertEquals((long)PLong.INSTANCE.getSqlType(), (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)3L, (long)rs.getInt("ORDINAL_POSITION"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"b"), (Object)rs.getString("COLUMN_FAMILY"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col3"), (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)1L, (long)rs.getShort("NULLABLE"));
        Assert.assertEquals((long)PDecimal.INSTANCE.getSqlType(), (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)4L, (long)rs.getInt("ORDINAL_POSITION"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"b"), (Object)rs.getString("COLUMN_FAMILY"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col4"), (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)1L, (long)rs.getShort("NULLABLE"));
        Assert.assertEquals((long)PDecimal.INSTANCE.getSqlType(), (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)5L, (long)rs.getInt("ORDINAL_POSITION"));
        Assert.assertEquals((long)5L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"b"), (Object)rs.getString("COLUMN_FAMILY"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col5"), (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)1L, (long)rs.getShort("NULLABLE"));
        Assert.assertEquals((long)PDecimal.INSTANCE.getSqlType(), (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)6L, (long)rs.getInt("ORDINAL_POSITION"));
        Assert.assertEquals((long)6L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)3L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        Assert.assertTrue((boolean)rs.getStatement().isClosed());
        rs = dbmd.getColumns(null, "", table, "A.");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"a"), (Object)rs.getString("COLUMN_FAMILY"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col1"), (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)1L, (long)rs.getShort("NULLABLE"));
        Assert.assertEquals((long)PInteger.INSTANCE.getSqlType(), (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)2L, (long)rs.getInt("ORDINAL_POSITION"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        Assert.assertTrue((boolean)rs.getStatement().isClosed());
        rs = dbmd.getColumns("", "", table, "%.COL%");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"a"), (Object)rs.getString("COLUMN_FAMILY"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col1"), (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)1L, (long)rs.getShort("NULLABLE"));
        Assert.assertEquals((long)PInteger.INSTANCE.getSqlType(), (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)2L, (long)rs.getInt("ORDINAL_POSITION"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"b"), (Object)rs.getString("COLUMN_FAMILY"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col2"), (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)1L, (long)rs.getShort("NULLABLE"));
        Assert.assertEquals((long)PLong.INSTANCE.getSqlType(), (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)3L, (long)rs.getInt("ORDINAL_POSITION"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"b"), (Object)rs.getString("COLUMN_FAMILY"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col3"), (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)1L, (long)rs.getShort("NULLABLE"));
        Assert.assertEquals((long)PDecimal.INSTANCE.getSqlType(), (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)4L, (long)rs.getInt("ORDINAL_POSITION"));
        Assert.assertEquals((long)0L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"b"), (Object)rs.getString("COLUMN_FAMILY"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col4"), (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)1L, (long)rs.getShort("NULLABLE"));
        Assert.assertEquals((long)PDecimal.INSTANCE.getSqlType(), (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)5L, (long)rs.getInt("ORDINAL_POSITION"));
        Assert.assertEquals((long)5L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)0L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertFalse((boolean)rs.wasNull());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"b"), (Object)rs.getString("COLUMN_FAMILY"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col5"), (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)1L, (long)rs.getShort("NULLABLE"));
        Assert.assertEquals((long)PDecimal.INSTANCE.getSqlType(), (long)rs.getInt("DATA_TYPE"));
        Assert.assertEquals((long)6L, (long)rs.getInt("ORDINAL_POSITION"));
        Assert.assertEquals((long)6L, (long)rs.getInt("COLUMN_SIZE"));
        Assert.assertEquals((long)3L, (long)rs.getInt("DECIMAL_DIGITS"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        Assert.assertTrue((boolean)rs.getStatement().isClosed());
        rs = dbmd.getColumns("", "", table, "B.COL2");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"b"), (Object)rs.getString("COLUMN_FAMILY"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col2"), (Object)rs.getString("COLUMN_NAME"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        Assert.assertTrue((boolean)rs.getStatement().isClosed());
        String table2 = QueryDatabaseMetaDataIT.generateUniqueName();
        QueryDatabaseMetaDataIT.ensureTableCreated(QueryDatabaseMetaDataIT.getUrl(), table2, "TABLE_WITH_SALTING", null);
        rs = dbmd.getColumns("", "", table2, StringUtil.escapeLike((String)"A_INTEGER"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt("ORDINAL_POSITION"));
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        Assert.assertTrue((boolean)rs.getStatement().isClosed());
    }

    @Test
    public void testPrimaryKeyMetadataScan() throws SQLException {
        try (Connection conn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            String table1 = QueryDatabaseMetaDataIT.generateUniqueName();
            QueryDatabaseMetaDataIT.createMDTestTable(conn, table1, "");
            String schema2 = QueryDatabaseMetaDataIT.generateUniqueName();
            String table2 = QueryDatabaseMetaDataIT.generateUniqueName();
            String fullTable2 = schema2 + "." + table2;
            QueryDatabaseMetaDataIT.ensureTableCreated(QueryDatabaseMetaDataIT.getUrl(), fullTable2, "CORE.CUSTOM_ENTITY_DATA", null);
            DatabaseMetaData dbmd = conn.getMetaData();
            ResultSet rs = dbmd.getPrimaryKeys(null, "", table1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
            Assert.assertEquals((Object)table1, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"id"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((long)1L, (long)rs.getInt("KEY_SEQ"));
            Assert.assertEquals(null, (Object)rs.getString("PK_NAME"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
            rs = dbmd.getPrimaryKeys(null, schema2, table2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)schema2, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)table2, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"custom_entity_data_id"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((long)3L, (long)rs.getInt("KEY_SEQ"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"pk"), (Object)rs.getString("PK_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)schema2, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)table2, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"key_prefix"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((long)2L, (long)rs.getInt("KEY_SEQ"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"pk"), (Object)rs.getString("PK_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)schema2, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)table2, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"organization_id"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((long)1L, (long)rs.getInt("KEY_SEQ"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"pk"), (Object)rs.getString("PK_NAME"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
            rs = dbmd.getColumns("", schema2, table2, null);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)schema2, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)table2, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"organization_id"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((long)rs.getInt("COLUMN_SIZE"), (long)15L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)schema2, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)table2, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"key_prefix"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((long)rs.getInt("COLUMN_SIZE"), (long)3L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)schema2, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)table2, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"custom_entity_data_id"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertTrue((boolean)rs.next());
            rs = dbmd.getColumns("", schema2, table2, "KEY_PREFIX");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)schema2, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)table2, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"key_prefix"), (Object)rs.getString("COLUMN_NAME"));
            rs = dbmd.getColumns("", schema2, table2, "KEY_PREFIX");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)schema2, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)table2, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"key_prefix"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
            String table3 = QueryDatabaseMetaDataIT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE " + table3 + " (k INTEGER PRIMARY KEY, v VARCHAR) SALT_BUCKETS=3");
            dbmd = conn.getMetaData();
            rs = dbmd.getPrimaryKeys(null, "", table3);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(null, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)table3, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals(null, (Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)"K", (Object)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((long)1L, (long)rs.getInt("KEY_SEQ"));
            Assert.assertEquals(null, (Object)rs.getString("PK_NAME"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
        }
    }

    @Test
    public void testMultiTableColumnsMetadataScan() throws SQLException {
        try (Connection conn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            String table1 = "TEST" + QueryDatabaseMetaDataIT.generateUniqueName();
            String table2 = "TEST" + QueryDatabaseMetaDataIT.generateUniqueName();
            TestUtil.createGroupByTestTable(conn, table1);
            QueryDatabaseMetaDataIT.createMDTestTable(conn, table2, "");
            String table3 = QueryDatabaseMetaDataIT.generateUniqueName();
            QueryDatabaseMetaDataIT.ensureTableCreated(QueryDatabaseMetaDataIT.getUrl(), table3, "PTSDB", null);
            String table4 = QueryDatabaseMetaDataIT.generateUniqueName();
            QueryDatabaseMetaDataIT.ensureTableCreated(QueryDatabaseMetaDataIT.getUrl(), table4, "CORE.CUSTOM_ENTITY_DATA", null);
            DatabaseMetaData dbmd = conn.getMetaData();
            ResultSet rs = dbmd.getColumns(null, "", "%TEST%", null);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
            Assert.assertEquals((Object)rs.getString("TABLE_NAME"), (Object)table1);
            Assert.assertEquals(null, (Object)rs.getString("COLUMN_FAMILY"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"id"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
            Assert.assertEquals((Object)rs.getString("TABLE_NAME"), (Object)table1);
            Assert.assertEquals((Object)"0", (Object)rs.getString("COLUMN_FAMILY"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"uri"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
            Assert.assertEquals((Object)rs.getString("TABLE_NAME"), (Object)table1);
            Assert.assertEquals((Object)"0", (Object)rs.getString("COLUMN_FAMILY"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"appcpu"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
            Assert.assertEquals((Object)rs.getString("TABLE_NAME"), (Object)table2);
            Assert.assertEquals(null, (Object)rs.getString("COLUMN_FAMILY"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"id"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
            Assert.assertEquals((Object)rs.getString("TABLE_NAME"), (Object)table2);
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"a"), (Object)rs.getString("COLUMN_FAMILY"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col1"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
            Assert.assertEquals((Object)rs.getString("TABLE_NAME"), (Object)table2);
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"b"), (Object)rs.getString("COLUMN_FAMILY"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col2"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
            Assert.assertEquals((Object)rs.getString("TABLE_NAME"), (Object)table2);
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"b"), (Object)rs.getString("COLUMN_FAMILY"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col3"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
            Assert.assertEquals((Object)rs.getString("TABLE_NAME"), (Object)table2);
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"b"), (Object)rs.getString("COLUMN_FAMILY"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col4"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString("TABLE_SCHEM"), null);
            Assert.assertEquals((Object)rs.getString("TABLE_NAME"), (Object)table2);
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"b"), (Object)rs.getString("COLUMN_FAMILY"));
            Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)"col5"), (Object)rs.getString("COLUMN_NAME"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
        }
    }

    @Test
    public void testCreateOnExistingTable() throws Exception {
        try (PhoenixConnection pconn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl()).unwrap(PhoenixConnection.class);){
            String tableName = QueryDatabaseMetaDataIT.generateUniqueName();
            String schemaName = "";
            byte[] cfA = Bytes.toBytes((String)SchemaUtil.normalizeIdentifier((String)"a"));
            byte[] cfB = Bytes.toBytes((String)SchemaUtil.normalizeIdentifier((String)"b"));
            byte[] cfC = Bytes.toBytes((String)"c");
            byte[][] familyNames = new byte[][]{cfB, cfC};
            byte[] htableName = SchemaUtil.getTableNameAsBytes((String)schemaName, (String)tableName);
            Admin admin = pconn.getQueryServices().getAdmin();
            try {
                admin.disableTable(TableName.valueOf((byte[])htableName));
                admin.deleteTable(TableName.valueOf((byte[])htableName));
                admin.enableTable(TableName.valueOf((byte[])htableName));
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])htableName));
            for (byte[] familyName : familyNames) {
                builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])familyName));
            }
            admin.createTable(builder.build());
            QueryDatabaseMetaDataIT.createMDTestTable((Connection)pconn, tableName, "a.BLOCKSIZE=50000");
            TableDescriptor descriptor = admin.getDescriptor(TableName.valueOf((byte[])htableName));
            Assert.assertEquals((long)3L, (long)descriptor.getColumnFamilies().length);
            ColumnFamilyDescriptor cdA = descriptor.getColumnFamily(cfA);
            Assert.assertEquals((Object)ColumnFamilyDescriptorBuilder.DEFAULT_KEEP_DELETED, (Object)cdA.getKeepDeletedCells());
            Assert.assertNotEquals((long)65536L, (long)cdA.getBlocksize());
            Assert.assertEquals((Object)DataBlockEncoding.NONE, (Object)cdA.getDataBlockEncoding());
            Assert.assertEquals((long)1L, (long)cdA.getMaxVersions());
            ColumnFamilyDescriptor cdB = descriptor.getColumnFamily(cfB);
            Assert.assertEquals((Object)ColumnFamilyDescriptorBuilder.DEFAULT_KEEP_DELETED, (Object)cdB.getKeepDeletedCells());
            Assert.assertEquals((long)65536L, (long)cdB.getBlocksize());
            Assert.assertEquals((Object)DataBlockEncoding.NONE, (Object)cdB.getDataBlockEncoding());
            ColumnFamilyDescriptor cdC = descriptor.getColumnFamily(cfC);
            Assert.assertNotNull((String)"Column family not found", (Object)cdC);
            Assert.assertEquals((Object)ColumnFamilyDescriptorBuilder.DEFAULT_KEEP_DELETED, (Object)cdC.getKeepDeletedCells());
            Assert.assertEquals((long)65536L, (long)cdC.getBlocksize());
            Assert.assertFalse((SchemaUtil.DEFAULT_DATA_BLOCK_ENCODING == cdC.getDataBlockEncoding() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)descriptor.hasCoprocessor(UngroupedAggregateRegionObserver.class.getName()));
            Assert.assertTrue((boolean)descriptor.hasCoprocessor(GroupedAggregateRegionObserver.class.getName()));
            Assert.assertTrue((boolean)descriptor.hasCoprocessor(ServerCachingEndpointImpl.class.getName()));
            admin.close();
            int rowCount = 5;
            String upsert = "UPSERT INTO " + tableName + "(id,col1,col2) VALUES(?,?,?)";
            PreparedStatement ps = pconn.prepareStatement(upsert);
            for (int i = 0; i < rowCount; ++i) {
                ps.setString(1, Integer.toString(i));
                ps.setInt(2, i + 1);
                ps.setInt(3, i + 2);
                ps.execute();
            }
            pconn.commit();
            String query = "SELECT count(1) FROM " + tableName;
            ResultSet rs = pconn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)rowCount, (long)rs.getLong(1));
            query = "SELECT id, col1,col2 FROM " + tableName;
            rs = pconn.createStatement().executeQuery(query);
            for (int i = 0; i < rowCount; ++i) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)Integer.toString(i), (Object)rs.getString(1));
                Assert.assertEquals((long)(i + 1), (long)rs.getInt(2));
                Assert.assertEquals((long)(i + 2), (long)rs.getInt(3));
            }
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testCreateViewOnExistingTable() throws Exception {
        try (PhoenixConnection pconn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);){
            String tableName = QueryDatabaseMetaDataIT.generateUniqueName();
            String schemaName = "";
            byte[] cfB = Bytes.toBytes((String)SchemaUtil.normalizeIdentifier((String)"b"));
            byte[] cfC = Bytes.toBytes((String)"c");
            byte[][] familyNames = new byte[][]{cfB, cfC};
            byte[] htableName = SchemaUtil.getTableNameAsBytes((String)schemaName, (String)tableName);
            try (Admin admin = pconn.getQueryServices().getAdmin();){
                try {
                    admin.disableTable(TableName.valueOf((byte[])htableName));
                    admin.deleteTable(TableName.valueOf((byte[])htableName));
                }
                catch (TableNotFoundException tableNotFoundException) {
                    // empty catch block
                }
                TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])htableName));
                for (byte[] familyName : familyNames) {
                    builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])familyName));
                }
                admin.createTable(builder.build());
            }
            String createStmt = "create view " + QueryDatabaseMetaDataIT.generateUniqueName() + "  (id char(1) not null primary key,\n    a.col1 integer,\n    d.col2 bigint)\n";
            try {
                pconn.createStatement().execute(createStmt);
                Assert.fail();
            }
            catch (org.apache.phoenix.schema.TableNotFoundException tableNotFoundException) {
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
            createStmt = "create view " + tableName + "   (id char(1) not null primary key,\n    a.col1 integer,\n    b.col2 bigint)\n";
            try {
                pconn.createStatement().execute(createStmt);
                Assert.fail();
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
            createStmt = "create view " + tableName + "   (id char(1) not null primary key,\n    b.col1 integer,\n    c.col2 bigint)\n";
            try {
                pconn.createStatement().execute(createStmt);
                Assert.fail();
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
            createStmt = "create view " + tableName + "   (id char(1) not null primary key,\n    b.col1 integer,\n    \"c\".col2 bigint) IMMUTABLE_ROWS=true \n";
            pconn.createStatement().execute(createStmt);
            ResultSet rs = pconn.getMetaData().getTables(null, null, tableName, null);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)PTable.ViewType.MAPPED.name(), (Object)rs.getString("VIEW_TYPE"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
            String deleteStmt = "DELETE FROM " + tableName;
            PreparedStatement ps = pconn.prepareStatement(deleteStmt);
            try {
                ps.execute();
                Assert.fail();
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
            String upsert = "UPSERT INTO " + tableName + "(id,col1,col2) VALUES(?,?,?)";
            ps = pconn.prepareStatement(upsert);
            try {
                ps.setString(1, Integer.toString(0));
                ps.setInt(2, 1);
                ps.setInt(3, 2);
                ps.execute();
                Assert.fail();
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
            Table htable = pconn.getQueryServices().getTable(SchemaUtil.getTableNameAsBytes((String)schemaName, (String)tableName));
            Put put = new Put(Bytes.toBytes((String)"0"));
            put.addColumn(cfB, Bytes.toBytes((String)"COL1"), PInteger.INSTANCE.toBytes((Object)1));
            put.addColumn(cfC, Bytes.toBytes((String)"COL2"), PLong.INSTANCE.toBytes((Object)2));
            htable.put(put);
            pconn.createStatement().execute("CREATE INDEX idx ON " + tableName + "(B.COL1)");
            String select = "SELECT col1 FROM " + tableName + " WHERE col2=?";
            ps = pconn.prepareStatement(select);
            ps.setInt(1, 2);
            rs = ps.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            String dropTable = "DROP TABLE " + tableName;
            ps = pconn.prepareStatement(dropTable);
            try {
                ps.execute();
                Assert.fail();
            }
            catch (org.apache.phoenix.schema.TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            String alterView = "alter view " + tableName + " drop column \"c\".col2";
            pconn.createStatement().execute(alterView);
        }
    }

    @Test
    public void testAddKVColumnToExistingFamily() throws Throwable {
        String tenantId = QueryDatabaseMetaDataIT.getOrganizationId();
        String tableName = QueryDatabaseMetaDataIT.generateUniqueName();
        QueryDatabaseMetaDataIT.initATableValues(tableName, tenantId, QueryDatabaseMetaDataIT.getDefaultSplits(tenantId), null, null, QueryDatabaseMetaDataIT.getUrl(), null);
        try (Connection conn1 = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            conn1.createStatement().executeUpdate("ALTER TABLE " + tableName + " ADD z_integer integer");
            String query = "SELECT z_integer FROM " + tableName;
            Assert.assertTrue((boolean)conn1.prepareStatement(query).executeQuery().next());
        }
    }

    @Test
    public void testAddKVColumnToNewFamily() throws Exception {
        String tenantId = QueryDatabaseMetaDataIT.getOrganizationId();
        String tableName = QueryDatabaseMetaDataIT.initATableValues(null, tenantId, QueryDatabaseMetaDataIT.getDefaultSplits(tenantId), null, null, QueryDatabaseMetaDataIT.getUrl(), null);
        try (Connection conn1 = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            conn1.createStatement().executeUpdate("ALTER TABLE " + tableName + " ADD newcf.z_integer integer");
            String query = "SELECT z_integer FROM " + tableName;
            Assert.assertTrue((boolean)conn1.prepareStatement(query).executeQuery().next());
        }
    }

    @Test
    public void testAddPKColumn() throws Exception {
        String tenantId = QueryDatabaseMetaDataIT.getOrganizationId();
        String tableName = QueryDatabaseMetaDataIT.initATableValues(null, tenantId, QueryDatabaseMetaDataIT.getDefaultSplits(tenantId), null, null, QueryDatabaseMetaDataIT.getUrl(), null);
        try (Connection conn1 = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            try {
                conn1.createStatement().executeUpdate("ALTER TABLE " + tableName + " ADD z_string varchar not null primary key");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.NOT_NULLABLE_COLUMN_IN_ROW_KEY.getErrorCode(), (long)e.getErrorCode());
            }
            conn1.createStatement().executeUpdate("ALTER TABLE " + tableName + " ADD z_string varchar primary key");
            String query = "SELECT z_string FROM " + tableName;
            Assert.assertTrue((boolean)conn1.prepareStatement(query).executeQuery().next());
        }
    }

    @Test
    public void testDropKVColumn() throws Exception {
        String tenantId = QueryDatabaseMetaDataIT.getOrganizationId();
        String tableName = QueryDatabaseMetaDataIT.initATableValues(null, tenantId, QueryDatabaseMetaDataIT.getDefaultSplits(tenantId), null, null, QueryDatabaseMetaDataIT.getUrl(), null);
        try (Connection conn5 = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            Assert.assertTrue((boolean)conn5.createStatement().executeQuery("SELECT 1 FROM " + tableName + " WHERE b_string IS NOT NULL").next());
            conn5.createStatement().executeUpdate("ALTER TABLE " + tableName + " DROP COLUMN b_string");
            String query = "SELECT b_string FROM " + tableName;
            try {
                conn5.prepareStatement(query).executeQuery().next();
                Assert.fail();
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                // empty catch block
            }
            conn5.createStatement().executeUpdate("ALTER TABLE " + tableName + " ADD b_string VARCHAR");
            Assert.assertFalse((boolean)conn5.createStatement().executeQuery("SELECT 1 FROM  " + tableName + "  WHERE b_string IS NOT NULL").next());
        }
    }

    @Test
    public void testDropPKColumn() throws Exception {
        String tenantId = QueryDatabaseMetaDataIT.getOrganizationId();
        String tableName = QueryDatabaseMetaDataIT.initATableValues(QueryDatabaseMetaDataIT.generateUniqueName(), tenantId, QueryDatabaseMetaDataIT.getDefaultSplits(tenantId), null, null, QueryDatabaseMetaDataIT.getUrl(), null);
        try (Connection conn1 = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            conn1.createStatement().executeUpdate("ALTER TABLE " + tableName + " DROP COLUMN entity_id");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 506 (42817): Primary key column may not be dropped."));
        }
    }

    @Test
    public void testDropAllKVCols() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl(), props);){
            String tableName = QueryDatabaseMetaDataIT.generateUniqueName();
            QueryDatabaseMetaDataIT.createMDTestTable(conn, tableName, "");
            conn.createStatement().executeUpdate("UPSERT INTO " + tableName + " VALUES('a',1,1)");
            conn.createStatement().executeUpdate("UPSERT INTO " + tableName + " VALUES('b',2,2)");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT count(1) FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            conn.createStatement().executeUpdate("ALTER TABLE " + tableName + " DROP COLUMN col1");
            rs = conn.createStatement().executeQuery("SELECT count(1) FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            conn.createStatement().executeUpdate("ALTER TABLE " + tableName + " DROP COLUMN col2");
            rs = conn.createStatement().executeQuery("SELECT count(1) FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
        }
    }

    @Test
    public void testTableWithScemaMetadataScan() throws SQLException {
        try (Connection conn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());){
            String table1 = QueryDatabaseMetaDataIT.generateUniqueName();
            String schema1 = QueryDatabaseMetaDataIT.generateUniqueName();
            String fullTable1 = schema1 + "." + table1;
            String table2 = table1;
            conn.createStatement().execute("create table  " + fullTable1 + " (k varchar primary key)");
            conn.createStatement().execute("create table " + table2 + " (k varchar primary key)");
            DatabaseMetaData metaData = conn.getMetaData();
            ResultSet rs = metaData.getTables(null, schema1, table1, null);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)schema1, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)table1, (Object)rs.getString("TABLE_NAME"));
            Assert.assertFalse((boolean)rs.next());
            rs = metaData.getTables("", schema1, table1, null);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)schema1, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)table1, (Object)rs.getString("TABLE_NAME"));
            Assert.assertFalse((boolean)rs.next());
            rs = metaData.getTables("", null, table2, null);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(null, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)table2, (Object)rs.getString("TABLE_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)schema1, (Object)rs.getString("TABLE_SCHEM"));
            Assert.assertEquals((Object)table1, (Object)rs.getString("TABLE_NAME"));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            Assert.assertTrue((boolean)rs.getStatement().isClosed());
        }
    }

    @Test
    public void testRemarkColumn() throws SQLException {
        Connection conn = DriverManager.getConnection(QueryDatabaseMetaDataIT.getUrl());
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getColumns(null, null, null, null);
        Assert.assertTrue((boolean)rs.next());
        String remarks = rs.getString("REMARKS");
        Assert.assertNull((Object)remarks);
        remarks = rs.getString(12);
        Assert.assertNull((Object)remarks);
        boolean foundRemarksColumn = false;
        while (rs.next()) {
            String colName = rs.getString("COLUMN_NAME");
            if (!"REMARKS".equals(colName)) continue;
            foundRemarksColumn = true;
            break;
        }
        Assert.assertTrue((String)"Could not find REMARKS column", (boolean)foundRemarksColumn);
        rs.close();
        Assert.assertTrue((boolean)rs.getStatement().isClosed());
    }
}

