/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.index.IndexMetadataIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PropertiesInSyncIT
extends ParallelStatsDisabledIT {
    private static final String COL_FAM1 = "CF1";
    private static final String COL_FAM2 = "CF2";
    private static final String NEW_CF = "NEW_CF";
    private static final String DUMMY_PROP_VALUE = "dummy";
    private static final int INITIAL_TTL_VALUE = 700;
    private static final KeepDeletedCells INITIAL_KEEP_DELETED_CELLS_VALUE = KeepDeletedCells.TRUE;
    private static final int INITIAL_REPLICATION_SCOPE_VALUE = 1;
    private static final int INITIAL_UPDATE_CACHE_FREQUENCY = 100;
    private static final int INITIAL_UPDATE_CACHE_FREQUENCY_VIEWS = 900;
    private static final int MODIFIED_TTL_VALUE = 1000;
    private static final KeepDeletedCells MODIFIED_KEEP_DELETED_CELLS_VALUE = INITIAL_KEEP_DELETED_CELLS_VALUE == KeepDeletedCells.TRUE ? KeepDeletedCells.FALSE : KeepDeletedCells.TRUE;
    private static final int MODIFIED_REPLICATION_SCOPE_VALUE = 0;
    private static final int MODIFIED_UPDATE_CACHE_FREQUENCY = 400;
    private static final int MODIFIED_UPDATE_CACHE_FREQUENCY_VIEWS = 1200;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        PropertiesInSyncIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testDisallowSyncedPropsToBeSetColFamSpecificCreateTable() throws Exception {
        Connection conn = DriverManager.getConnection(PropertiesInSyncIT.getUrl(), new Properties());
        String tableName = PropertiesInSyncIT.generateUniqueName();
        for (String propName : MetaDataUtil.SYNCED_DATA_TABLE_AND_INDEX_COL_FAM_PROPERTIES) {
            try {
                conn.createStatement().execute("create table " + tableName + " (id INTEGER not null primary key, " + COL_FAM1 + ".name varchar(10), " + COL_FAM2 + ".flag boolean) " + COL_FAM1 + "." + propName + "=" + DUMMY_PROP_VALUE);
                Assert.fail((String)"Should fail with SQLException when setting synced property for a specific column family");
            }
            catch (SQLException sqlE) {
                Assert.assertEquals((String)"Should fail to set synced property for a specific column family", (long)SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_PROPERTY.getErrorCode(), (long)sqlE.getErrorCode());
            }
        }
        conn.close();
    }

    @Test
    public void testSyncedPropsAllColFamsCreateTable() throws Exception {
        Connection conn = DriverManager.getConnection(PropertiesInSyncIT.getUrl(), new Properties());
        String tableName = this.createBaseTableWithProps(conn);
        this.verifyHBaseColumnFamilyProperties(tableName, conn, false, false);
        conn.close();
    }

    @Test
    public void testDisallowSyncedPropsToBeSetCreateIndex() throws Exception {
        Connection conn = DriverManager.getConnection(PropertiesInSyncIT.getUrl(), new Properties());
        String tableName = this.createBaseTableWithProps(conn);
        String localIndexName = tableName + "_LOCAL_IDX";
        String globalIndexName = tableName + "_GLOBAL_IDX";
        String viewName = "VIEW_" + tableName;
        conn.createStatement().execute("create view " + viewName + " (new_col SMALLINT) as select * from " + tableName + " where id > 1");
        for (String propName : MetaDataUtil.SYNCED_DATA_TABLE_AND_INDEX_COL_FAM_PROPERTIES) {
            try {
                conn.createStatement().execute("create local index " + localIndexName + " on " + tableName + "(name) " + propName + "=" + DUMMY_PROP_VALUE);
                Assert.fail((String)"Should fail with SQLException when setting synced property for a local index");
            }
            catch (SQLException sqlE) {
                Assert.assertEquals((String)"Should fail to set synced property for a local index", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX.getErrorCode(), (long)sqlE.getErrorCode());
            }
            try {
                conn.createStatement().execute("create index " + globalIndexName + " on " + tableName + "(flag) " + propName + "=" + DUMMY_PROP_VALUE);
                Assert.fail((String)"Should fail with SQLException when setting synced property for a global index");
            }
            catch (SQLException sqlE) {
                Assert.assertEquals((String)"Should fail to set synced property for a global index", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX.getErrorCode(), (long)sqlE.getErrorCode());
            }
            try {
                conn.createStatement().execute("create index view_index on " + viewName + " (flag)" + propName + "=" + DUMMY_PROP_VALUE);
                Assert.fail((String)"Should fail with SQLException when setting synced property for a view index");
            }
            catch (SQLException sqlE) {
                Assert.assertEquals((String)"Should fail to set synced property for a view index", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX.getErrorCode(), (long)sqlE.getErrorCode());
            }
        }
        try {
            conn.createStatement().execute("create local index " + localIndexName + " on " + tableName + "(name) \"phoenix.max.lookback.age.seconds\"=12345");
            Assert.fail((String)"Should fail with SQLException when setting synced property for a local index");
        }
        catch (SQLException sqlE) {
            Assert.assertEquals((String)"Should fail to set synced property for a local index", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_MAX_LOOKBACK_FOR_INDEX.getErrorCode(), (long)sqlE.getErrorCode());
        }
        try {
            conn.createStatement().execute("create index " + globalIndexName + " on " + tableName + "(flag) \"phoenix.max.lookback.age.seconds\"=12345");
            Assert.fail((String)"Should fail with SQLException when setting synced property for a global index");
        }
        catch (SQLException sqlE) {
            Assert.assertEquals((String)"Should fail to set synced property for a global index", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_MAX_LOOKBACK_FOR_INDEX.getErrorCode(), (long)sqlE.getErrorCode());
        }
        try {
            conn.createStatement().execute("create index view_index on " + viewName + " (flag)\"phoenix.max.lookback.age.seconds\"=12345");
            Assert.fail((String)"Should fail with SQLException when setting synced property for a view index");
        }
        catch (SQLException sqlE) {
            Assert.assertEquals((String)"Should fail to set synced property for a view index", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_MAX_LOOKBACK_FOR_INDEX.getErrorCode(), (long)sqlE.getErrorCode());
        }
        conn.close();
    }

    @Test
    public void testSyncedPropsBaseTableCreateIndex() throws Exception {
        Connection conn = DriverManager.getConnection(PropertiesInSyncIT.getUrl(), new Properties());
        String tableName = this.createBaseTableWithProps(conn);
        this.createIndexTable(conn, tableName, PTable.IndexType.LOCAL).getSecond();
        String globalIndexName = (String)this.createIndexTable(conn, tableName, PTable.IndexType.GLOBAL).getSecond();
        this.verifyHBaseColumnFamilyProperties(tableName, conn, false, false);
        this.verifyHBaseColumnFamilyProperties(globalIndexName, conn, false, false);
        conn.close();
    }

    @Test
    public void testSyncedPropsBaseTableCreateViewIndex() throws Exception {
        Connection conn = DriverManager.getConnection(PropertiesInSyncIT.getUrl(), new Properties());
        String tableName = this.createBaseTableWithProps(conn);
        String viewIndexName = (String)this.createIndexTable(conn, tableName, null).getSecond();
        this.verifyHBaseColumnFamilyProperties(tableName, conn, false, false);
        this.verifyHBaseColumnFamilyProperties(viewIndexName, conn, false, false);
        conn.close();
    }

    @Test
    public void testDisallowSyncedPropsToBeSetColFamSpecificAlterTable() throws Exception {
        Connection conn = DriverManager.getConnection(PropertiesInSyncIT.getUrl(), new Properties());
        String tableName = this.createBaseTableWithProps(conn);
        StringBuilder alterAllSyncedPropsString = new StringBuilder();
        String modPropString = "CF1.%s=dummy,";
        for (String propName : MetaDataUtil.SYNCED_DATA_TABLE_AND_INDEX_COL_FAM_PROPERTIES) {
            try {
                conn.createStatement().execute("alter table " + tableName + " set " + COL_FAM1 + "." + propName + "=" + DUMMY_PROP_VALUE);
                Assert.fail((String)"Should fail with SQLException when altering synced property for a specific column family");
            }
            catch (SQLException sqlE) {
                Assert.assertEquals((String)"Should fail to alter synced property for a specific column family", (long)SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_PROPERTY.getErrorCode(), (long)sqlE.getErrorCode());
            }
            alterAllSyncedPropsString.append(String.format(modPropString, propName));
        }
        try {
            conn.createStatement().execute("alter table " + tableName + " set " + alterAllSyncedPropsString.substring(0, alterAllSyncedPropsString.length() - 1));
            Assert.fail((String)"Should fail with SQLException when altering synced properties for a specific column family");
        }
        catch (SQLException sqlE) {
            Assert.assertEquals((String)"Should fail to alter synced properties for a specific column family", (long)SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_PROPERTY.getErrorCode(), (long)sqlE.getErrorCode());
        }
        conn.close();
    }

    @Test
    public void testAlterSyncedPropsPropagateToAllIndexesAndViewIndex() throws Exception {
        Connection conn = DriverManager.getConnection(PropertiesInSyncIT.getUrl(), new Properties());
        String tableName = this.createBaseTableWithProps(conn);
        HashSet<Object> tablesToCheck = new HashSet<Object>();
        tablesToCheck.add(tableName);
        for (int i = 0; i < 2; ++i) {
            tablesToCheck.add(this.createIndexTable(conn, tableName, PTable.IndexType.LOCAL).getSecond());
            tablesToCheck.add(this.createIndexTable(conn, tableName, PTable.IndexType.GLOBAL).getSecond());
        }
        tablesToCheck.add(this.createIndexTable(conn, tableName, null).getSecond());
        conn.createStatement().execute("alter table " + tableName + " set TTL=" + 1000 + ",KEEP_DELETED_CELLS=" + MODIFIED_KEEP_DELETED_CELLS_VALUE + ",REPLICATION_SCOPE=" + 0);
        for (String string : tablesToCheck) {
            this.verifyHBaseColumnFamilyProperties(string, conn, true, false);
        }
        String newGlobalIndex = (String)this.createIndexTable(conn, tableName, PTable.IndexType.GLOBAL).getSecond();
        String string = (String)this.createIndexTable(conn, tableName, null).getSecond();
        this.verifyHBaseColumnFamilyProperties(newGlobalIndex, conn, true, false);
        this.verifyHBaseColumnFamilyProperties(string, conn, true, false);
        conn.close();
    }

    @Test
    public void testAlterTableAddColumnFamilyGetsSyncedProps() throws Exception {
        Connection conn = DriverManager.getConnection(PropertiesInSyncIT.getUrl(), new Properties());
        String tableName = this.createBaseTableWithProps(conn);
        for (String propName : MetaDataUtil.SYNCED_DATA_TABLE_AND_INDEX_COL_FAM_PROPERTIES) {
            try {
                conn.createStatement().execute("alter table " + tableName + " add " + NEW_CF + ".new_column varchar(2) " + NEW_CF + "." + propName + "=" + DUMMY_PROP_VALUE);
                Assert.fail((String)"Should fail with SQLException when altering synced property for a specific column family when adding a column");
            }
            catch (SQLException sQLException) {
                Assert.assertEquals((String)"Should fail to alter synced property for a specific column family when adding a column", (long)SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_PROPERTY.getErrorCode(), (long)sQLException.getErrorCode());
            }
        }
        HashSet<Object> tablesToCheck = new HashSet<Object>();
        tablesToCheck.add(tableName);
        for (int i = 0; i < 2; ++i) {
            tablesToCheck.add(this.createIndexTable(conn, tableName, PTable.IndexType.LOCAL).getSecond());
            tablesToCheck.add(this.createIndexTable(conn, tableName, PTable.IndexType.GLOBAL).getSecond());
        }
        tablesToCheck.add(this.createIndexTable(conn, tableName, null).getSecond());
        conn.createStatement().execute("alter table " + tableName + " add " + NEW_CF + ".new_column varchar(2) KEEP_DELETED_CELLS=" + MODIFIED_KEEP_DELETED_CELLS_VALUE + ",REPLICATION_SCOPE=" + 0 + ",BLOCKSIZE=300000");
        for (String string : tablesToCheck) {
            this.verifyHBaseColumnFamilyProperties(string, conn, true, true);
        }
        Throwable throwable = null;
        try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            ColumnFamilyDescriptor[] columnFamilies;
            for (ColumnFamilyDescriptor cfd : columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies()) {
                if (cfd.getNameAsString().equals(NEW_CF)) {
                    Assert.assertEquals((String)"Newly added column fmaily should have updated property", (long)300000L, (long)cfd.getBlocksize());
                    continue;
                }
                Assert.assertEquals((String)"Existing column families should have default value for property", (long)65536L, (long)cfd.getBlocksize());
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        conn.close();
    }

    @Test
    public void testDisallowAlterGlobalIndexTable() throws Exception {
        Connection conn = DriverManager.getConnection(PropertiesInSyncIT.getUrl(), new Properties());
        String tableName = this.createBaseTableWithProps(conn);
        String globalIndexName = (String)this.createIndexTable(conn, tableName, PTable.IndexType.GLOBAL).getSecond();
        for (String propName : MetaDataUtil.SYNCED_DATA_TABLE_AND_INDEX_COL_FAM_PROPERTIES) {
            try {
                conn.createStatement().execute("alter table " + globalIndexName + " set " + propName + "=" + 700);
                Assert.fail((String)"Should fail with SQLException when altering synced property for a global index");
            }
            catch (SQLException sqlE) {
                Assert.assertEquals((String)"Should fail to alter synced property for a global index", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX.getErrorCode(), (long)sqlE.getErrorCode());
            }
        }
        try {
            conn.createStatement().execute("alter table " + globalIndexName + " set \"phoenix.max.lookback.age.seconds\"=12345");
            Assert.fail((String)"Should fail with SQLException when altering synced property for a global index");
        }
        catch (SQLException sqlE) {
            Assert.assertEquals((String)"Should fail to alter synced property for a global index", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_MAX_LOOKBACK_FOR_INDEX.getErrorCode(), (long)sqlE.getErrorCode());
        }
        conn.close();
    }

    @Test
    public void testOldClientSyncPropsUpgradePath() throws Exception {
        Connection conn = DriverManager.getConnection(PropertiesInSyncIT.getUrl(), new Properties());
        String baseTableName = this.createBaseTableWithProps(conn);
        String baseTableName1 = this.createBaseTableWithProps(conn);
        HashSet<Object> createdTables = new HashSet<Object>();
        createdTables.add(baseTableName);
        createdTables.add(baseTableName1);
        for (int i = 0; i < 2; ++i) {
            createdTables.add(this.createIndexTable(conn, baseTableName, PTable.IndexType.GLOBAL).getSecond());
            createdTables.add(this.createIndexTable(conn, baseTableName, PTable.IndexType.LOCAL).getSecond());
            createdTables.add(this.createIndexTable(conn, baseTableName, null).getSecond());
            createdTables.add(this.createIndexTable(conn, baseTableName1, PTable.IndexType.GLOBAL).getSecond());
            createdTables.add(this.createIndexTable(conn, baseTableName1, PTable.IndexType.LOCAL).getSecond());
            createdTables.add(this.createIndexTable(conn, baseTableName1, null).getSecond());
        }
        for (String object : createdTables) {
            this.verifyHBaseColumnFamilyProperties(object, conn, false, false);
        }
        Throwable throwable = null;
        try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            for (String string : createdTables) {
                ColumnFamilyDescriptorBuilder cfdb;
                ColumnFamilyDescriptor defaultCF;
                TableDescriptor tableDescriptor;
                if (MetaDataUtil.isViewIndex((String)string)) {
                    tableDescriptor = conn.unwrap(PhoenixConnection.class).getQueryServices().getTableDescriptor(Bytes.toBytes((String)string));
                    defaultCF = tableDescriptor.getColumnFamily(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
                } else {
                    PTable table = conn.unwrap(PhoenixConnection.class).getTable(string);
                    tableDescriptor = conn.unwrap(PhoenixConnection.class).getQueryServices().getTableDescriptor(table.getPhysicalName().getBytes());
                    defaultCF = tableDescriptor.getColumnFamily(SchemaUtil.getEmptyColumnFamily((PTable)table));
                }
                TableDescriptorBuilder tableDescBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)tableDescriptor);
                if (string.equals(baseTableName) || string.equals(baseTableName1)) {
                    for (ColumnFamilyDescriptor cfd : tableDescriptor.getColumnFamilies()) {
                        if (cfd.equals(defaultCF)) continue;
                        cfdb = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)cfd);
                        this.modifySyncedPropsForCF(cfdb);
                        tableDescBuilder.modifyColumnFamily(cfdb.build());
                    }
                } else {
                    for (ColumnFamilyDescriptor cfd : tableDescriptor.getColumnFamilies()) {
                        cfdb = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)cfd);
                        this.modifySyncedPropsForCF(cfdb);
                        tableDescBuilder.modifyColumnFamily(cfdb.build());
                    }
                }
                admin.modifyTable(tableDescBuilder.build());
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        PhoenixConnection upgradeConn = conn.unwrap(PhoenixConnection.class);
        upgradeConn.setRunningUpgrade(true);
        UpgradeUtil.syncTableAndIndexProperties((PhoenixConnection)upgradeConn);
        for (String string : createdTables) {
            this.verifyHBaseColumnFamilyProperties(string, conn, false, false);
        }
        conn.close();
    }

    @Test
    public void testOldClientSyncUpdateCacheFreqUpgradePath() throws Exception {
        HashMap createdTablesAndViews = new HashMap();
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(PropertiesInSyncIT.getUrl(), new Properties());){
            String baseTableName = this.createBaseTableWithProps((Connection)conn);
            createdTablesAndViews.put(baseTableName, new HashSet());
            Set indexes = (Set)createdTablesAndViews.get(baseTableName);
            indexes.add(this.createIndexTable((Connection)conn, baseTableName, PTable.IndexType.GLOBAL).getSecond());
            indexes.add(this.createIndexTable((Connection)conn, baseTableName, PTable.IndexType.LOCAL).getFirst());
            String viewName = this.createViewOnBaseTableOrView((Connection)conn, baseTableName);
            createdTablesAndViews.put(viewName, new HashSet());
            indexes = (Set)createdTablesAndViews.get(viewName);
            indexes.add(this.createIndexTable((Connection)conn, viewName, PTable.IndexType.GLOBAL).getSecond());
            String viewName2 = this.createViewOnBaseTableOrView((Connection)conn, viewName);
            createdTablesAndViews.put(viewName2, new HashSet());
            indexes = (Set)createdTablesAndViews.get(viewName2);
            indexes.add(this.createIndexTable((Connection)conn, viewName2, PTable.IndexType.LOCAL).getFirst());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,UPDATE_CACHE_FREQUENCY) VALUES (?, ?, ?, ?)");
            for (String tableOrViewName : createdTablesAndViews.keySet()) {
                PTable base = conn.getTable(tableOrViewName);
                for (String indexTableName : (Set)createdTablesAndViews.get(tableOrViewName)) {
                    PTable index = conn.getTable(indexTableName);
                    PName tenantId = index.getTenantId();
                    stmt.setString(1, tenantId == null ? null : tenantId.getString());
                    stmt.setString(2, index.getSchemaName().getString());
                    stmt.setString(3, index.getTableName().getString());
                    stmt.setLong(4, base.getType() == PTableType.TABLE ? 400L : 1200L);
                    stmt.addBatch();
                }
            }
            stmt.executeBatch();
            conn.commit();
            conn.getQueryServices().clearCache();
            Iterator iterator = createdTablesAndViews.keySet().iterator();
            while (iterator.hasNext()) {
                String tableOrViewName;
                IndexMetadataIT.assertUpdateCacheFreq((Connection)conn, tableOrViewName, baseTableName.equals(tableOrViewName = (String)iterator.next()) ? 100L : 900L);
                for (String indexName : (Set)createdTablesAndViews.get(tableOrViewName)) {
                    IndexMetadataIT.assertUpdateCacheFreq((Connection)conn, indexName, baseTableName.equals(tableOrViewName) ? 400L : 1200L);
                }
            }
            PhoenixConnection upgradeConn = conn;
            upgradeConn.setRunningUpgrade(true);
            UpgradeUtil.syncUpdateCacheFreqAllIndexes((PhoenixConnection)upgradeConn, (PTable)conn.getTableNoCache(baseTableName));
            conn.getQueryServices().clearCache();
            for (String tableOrViewName : createdTablesAndViews.keySet()) {
                long expectedVal = baseTableName.equals(tableOrViewName) ? 100L : 900L;
                IndexMetadataIT.assertUpdateCacheFreq((Connection)conn, tableOrViewName, expectedVal);
                for (String indexOnTableOrView : (Set)createdTablesAndViews.get(tableOrViewName)) {
                    IndexMetadataIT.assertUpdateCacheFreq((Connection)conn, indexOnTableOrView, expectedVal);
                }
            }
        }
    }

    private void modifySyncedPropsForCF(ColumnFamilyDescriptorBuilder cfdb) throws SQLException {
        cfdb.setTimeToLive(1000);
        cfdb.setKeepDeletedCells(MODIFIED_KEEP_DELETED_CELLS_VALUE);
        cfdb.setScope(0);
    }

    private String createBaseTableWithProps(Connection conn) throws SQLException {
        String tableName = PropertiesInSyncIT.generateUniqueName();
        conn.createStatement().execute("create table " + tableName + " (id INTEGER not null primary key, type varchar(5), " + COL_FAM1 + ".name varchar(10), " + COL_FAM2 + ".flag boolean) TTL=" + 700 + ",KEEP_DELETED_CELLS=" + INITIAL_KEEP_DELETED_CELLS_VALUE + ",REPLICATION_SCOPE=" + 1 + ",UPDATE_CACHE_FREQUENCY=" + 100);
        return tableName;
    }

    private Pair<String, String> createIndexTable(Connection conn, String baseTableName, PTable.IndexType indexType) throws SQLException {
        if (indexType == null) {
            String viewName = this.createViewOnBaseTableOrView(conn, baseTableName);
            String viewIndexName = "_IDX_" + baseTableName;
            conn.createStatement().execute("create index view_index_" + PropertiesInSyncIT.generateUniqueName() + " on " + viewName + " (flag)");
            return new Pair((Object)viewIndexName, (Object)viewIndexName);
        }
        switch (indexType) {
            case LOCAL: {
                String localIndexName = baseTableName + "_LOCAL_" + PropertiesInSyncIT.generateUniqueName();
                conn.createStatement().execute("create local index " + localIndexName + " on " + baseTableName + "(flag)");
                return new Pair((Object)localIndexName, (Object)baseTableName);
            }
            case GLOBAL: {
                String globalIndexName = baseTableName + "_GLOBAL_" + PropertiesInSyncIT.generateUniqueName();
                conn.createStatement().execute("create index " + globalIndexName + " on " + baseTableName + "(name)");
                return new Pair((Object)globalIndexName, (Object)globalIndexName);
            }
        }
        return new Pair((Object)baseTableName, (Object)baseTableName);
    }

    private String createViewOnBaseTableOrView(Connection conn, String baseTableOrView) throws SQLException {
        String viewName = "VIEW_" + baseTableOrView + "_" + PropertiesInSyncIT.generateUniqueName();
        conn.createStatement().execute("create view " + viewName + " (" + PropertiesInSyncIT.generateUniqueName() + " SMALLINT) as select * from " + baseTableOrView + " where id > 1 UPDATE_CACHE_FREQUENCY=" + 900);
        return viewName;
    }

    private void verifyHBaseColumnFamilyProperties(String tableName, Connection conn, boolean propModified, boolean ignoreTTL) throws Exception {
        int expectedTTL = propModified ? 1000 : 700;
        KeepDeletedCells expectedKeepDeletedCells = propModified ? MODIFIED_KEEP_DELETED_CELLS_VALUE : INITIAL_KEEP_DELETED_CELLS_VALUE;
        int expectedReplicationScope = propModified ? 0 : 1;
        try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            ColumnFamilyDescriptor[] columnFamilies;
            for (ColumnFamilyDescriptor cfd : columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies()) {
                if (!ignoreTTL) {
                    Assert.assertEquals((String)"Mismatch in TTL", (long)expectedTTL, (long)cfd.getTimeToLive());
                }
                Assert.assertEquals((String)"Mismatch in KEEP_DELETED_CELLS", (Object)expectedKeepDeletedCells, (Object)cfd.getKeepDeletedCells());
                Assert.assertEquals((String)"Mismatch in REPLICATION_SCOPE", (long)expectedReplicationScope, (long)cfd.getScope());
            }
        }
    }
}

