/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Ordering;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ProductMetricsIT
extends ParallelStatsDisabledIT {
    private static final String PRODUCT_METRICS_NAME = "PRODUCT_METRICS";
    private static final String PRODUCT_METRICS_SCHEMA_NAME = "";
    private static final String DS1 = "1970-01-01 00:58:00";
    private static final String DS2 = "1970-01-01 01:02:00";
    private static final String DS3 = "1970-01-01 01:30:00";
    private static final String DS4 = "1970-01-01 01:45:00";
    private static final String DS5 = "1970-01-01 02:00:00";
    private static final String DS6 = "1970-01-01 04:00:00";
    private static final Date D1 = ProductMetricsIT.toDate("1970-01-01 00:58:00");
    private static final Date D2 = ProductMetricsIT.toDate("1970-01-01 01:02:00");
    private static final Date D3 = ProductMetricsIT.toDate("1970-01-01 01:30:00");
    private static final Date D4 = ProductMetricsIT.toDate("1970-01-01 01:45:00");
    private static final Date D5 = ProductMetricsIT.toDate("1970-01-01 02:00:00");
    private static final Date D6 = ProductMetricsIT.toDate("1970-01-01 04:00:00");
    private static final Object ROUND_1HR = ProductMetricsIT.toDate("1970-01-01 01:00:00");
    private static final Object ROUND_2HR = ProductMetricsIT.toDate("1970-01-01 02:00:00");
    private static final String F1 = "A";
    private static final String F2 = "B";
    private static final String F3 = "C";
    private static final String R1 = "R1";
    private static final String R2 = "R2";

    private static byte[][] getSplits(String tenantId) {
        return new byte[][]{ByteUtil.concat((byte[])Bytes.toBytes((String)tenantId), (byte[][])new byte[][]{PDate.INSTANCE.toBytes((Object)D3)}), ByteUtil.concat((byte[])Bytes.toBytes((String)tenantId), (byte[][])new byte[][]{PDate.INSTANCE.toBytes((Object)D5)})};
    }

    private static Date toDate(String dateString) {
        return DateUtil.parseDate((String)dateString);
    }

    private static void initTable(String tablename, byte[][] splits) throws Exception {
        ProductMetricsIT.ensureTableCreated(ProductMetricsIT.getUrl(), tablename, PRODUCT_METRICS_NAME, splits, null, null);
    }

    private static void assertNoRows(String tablename, Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("select 1 from " + tablename);
        Assert.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTableValues(String tablename, String tenantId, byte[][] splits) throws Exception {
        ProductMetricsIT.initTable(tablename, splits);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.assertNoRows(tablename, conn);
            ProductMetricsIT.initTableValues(tablename, conn, tenantId);
            conn.commit();
        }
    }

    private static void initTableValues(String tablename, Connection conn, String tenantId) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("upsert into " + tablename + " (    ORGANIZATION_ID,     \"DATE\",     FEATURE,     UNIQUE_USERS,     TRANSACTIONS,     CPU_UTILIZATION,     DB_UTILIZATION,     REGION,     IO_TIME)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, tenantId);
        stmt.setDate(2, D1);
        stmt.setString(3, F1);
        stmt.setInt(4, 10);
        stmt.setLong(5, 100L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(0.5));
        stmt.setBigDecimal(7, BigDecimal.valueOf(0.2));
        stmt.setString(8, R2);
        stmt.setNull(9, -5);
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setDate(2, D2);
        stmt.setString(3, F1);
        stmt.setInt(4, 20);
        stmt.setLong(5, 200L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(1.0));
        stmt.setBigDecimal(7, BigDecimal.valueOf(0.4));
        stmt.setString(8, null);
        stmt.setLong(9, 2000L);
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setDate(2, D3);
        stmt.setString(3, F1);
        stmt.setInt(4, 30);
        stmt.setLong(5, 300L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(2.5));
        stmt.setBigDecimal(7, BigDecimal.valueOf(0.6));
        stmt.setString(8, R1);
        stmt.setNull(9, -5);
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setDate(2, D4);
        stmt.setString(3, F2);
        stmt.setInt(4, 40);
        stmt.setLong(5, 400L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(3.0));
        stmt.setBigDecimal(7, BigDecimal.valueOf(0.8));
        stmt.setString(8, R1);
        stmt.setLong(9, 4000L);
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setDate(2, D5);
        stmt.setString(3, F3);
        stmt.setInt(4, 50);
        stmt.setLong(5, 500L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(3.5));
        stmt.setBigDecimal(7, BigDecimal.valueOf(1.2));
        stmt.setString(8, R2);
        stmt.setLong(9, 5000L);
        stmt.execute();
        stmt.setString(1, tenantId);
        stmt.setDate(2, D6);
        stmt.setString(3, F1);
        stmt.setInt(4, 60);
        stmt.setLong(5, 600L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(4.0));
        stmt.setBigDecimal(7, BigDecimal.valueOf(1.4));
        stmt.setString(8, null);
        stmt.setNull(9, -5);
        stmt.execute();
    }

    private static void initDateTableValues(String tablename, String tenantId, byte[][] splits, Date startDate) throws Exception {
        ProductMetricsIT.initDateTableValues(tablename, tenantId, splits, startDate, 2.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDateTableValues(String tablename, String tenantId, byte[][] splits, Date startDate, double dateIncrement) throws Exception {
        ProductMetricsIT.initTable(tablename, splits);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.assertNoRows(tablename, conn);
            ProductMetricsIT.initDateTableValues(tablename, conn, tenantId, startDate, dateIncrement);
            conn.commit();
        }
    }

    private static void initDateTableValues(String tablename, Connection conn, String tenantId, Date startDate, double dateIncrement) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("upsert into " + tablename + "(    ORGANIZATION_ID,     \"DATE\",     FEATURE,     UNIQUE_USERS,     TRANSACTIONS,     CPU_UTILIZATION,     DB_UTILIZATION,     REGION,     IO_TIME)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, tenantId);
        stmt.setDate(2, startDate);
        stmt.setString(3, F1);
        stmt.setInt(4, 10);
        stmt.setLong(5, 100L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(0.5));
        stmt.setBigDecimal(7, BigDecimal.valueOf(0.2));
        stmt.setString(8, R2);
        stmt.setNull(9, -5);
        stmt.execute();
        startDate = new Date(startDate.getTime() + (long)(8.64E7 * dateIncrement));
        stmt.setString(1, tenantId);
        stmt.setDate(2, startDate);
        stmt.setString(3, F2);
        stmt.setInt(4, 20);
        stmt.setLong(5, 200L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(1.0));
        stmt.setBigDecimal(7, BigDecimal.valueOf(0.4));
        stmt.setString(8, null);
        stmt.setLong(9, 2000L);
        stmt.execute();
        startDate = new Date(startDate.getTime() + (long)(8.64E7 * dateIncrement));
        stmt.setString(1, tenantId);
        stmt.setDate(2, startDate);
        stmt.setString(3, F3);
        stmt.setInt(4, 30);
        stmt.setLong(5, 300L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(2.5));
        stmt.setBigDecimal(7, BigDecimal.valueOf(0.6));
        stmt.setString(8, R1);
        stmt.setNull(9, -5);
        stmt.execute();
        startDate = new Date(startDate.getTime() + (long)(8.64E7 * dateIncrement));
        stmt.setString(1, tenantId);
        stmt.setDate(2, startDate);
        stmt.setString(3, "D");
        stmt.setInt(4, 40);
        stmt.setLong(5, 400L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(3.0));
        stmt.setBigDecimal(7, BigDecimal.valueOf(0.8));
        stmt.setString(8, R1);
        stmt.setLong(9, 4000L);
        stmt.execute();
        startDate = new Date(startDate.getTime() + (long)(8.64E7 * dateIncrement));
        stmt.setString(1, tenantId);
        stmt.setDate(2, startDate);
        stmt.setString(3, "E");
        stmt.setInt(4, 50);
        stmt.setLong(5, 500L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(3.5));
        stmt.setBigDecimal(7, BigDecimal.valueOf(1.2));
        stmt.setString(8, R2);
        stmt.setLong(9, 5000L);
        stmt.execute();
        startDate = new Date(startDate.getTime() + (long)(8.64E7 * dateIncrement));
        stmt.setString(1, tenantId);
        stmt.setDate(2, startDate);
        stmt.setString(3, "F");
        stmt.setInt(4, 60);
        stmt.setLong(5, 600L);
        stmt.setBigDecimal(6, BigDecimal.valueOf(4.0));
        stmt.setBigDecimal(7, BigDecimal.valueOf(1.4));
        stmt.setString(8, null);
        stmt.setNull(9, -5);
        stmt.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateRangeAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT count(1), feature f FROM " + tablename + " WHERE organization_id=? AND \"DATE\" >= to_date(?) AND \"DATE\" <= to_date(?) GROUP BY f";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, DS2);
            statement.setString(3, DS4);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            Assert.assertEquals((Object)F1, (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertEquals((Object)F2, (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableAliasSameAsTableName() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT sum(" + tablename + ".transactions) FROM " + tablename + " PRODUCT_METRICS";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2100L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartiallyEvaluableAnd() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT \"DATE\" FROM " + tablename + " WHERE organization_id=? AND unique_users >= 30 AND transactions >= 300 AND cpu_utilization > 2 AND db_utilization > 0.5 AND io_time = 4000";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)D4, (Object)rs.getDate(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartiallyEvaluableOr() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT \"DATE\" FROM " + tablename + " WHERE organization_id=? AND (transactions = 10000 OR unset_column = 5 OR io_time = 4000)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)D4, (Object)rs.getDate(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstantTrueHaving() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT count(1), feature FROM " + tablename + " WHERE organization_id=? AND \"DATE\" >= to_date(?) AND \"DATE\" <= to_date(?) GROUP BY feature HAVING 1=1";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, DS2);
            statement.setString(3, DS4);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            Assert.assertEquals((Object)F1, (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertEquals((Object)F2, (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstantFalseHaving() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT count(1), feature FROM " + tablename + " WHERE organization_id=? AND \"DATE\" >= to_date(?) AND \"DATE\" <= to_date(?) GROUP BY feature HAVING 1=1 and 0=1";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, DS2);
            statement.setString(3, DS4);
            ResultSet rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateRangeHavingAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT count(1), feature FROM " + tablename + " WHERE organization_id=? AND \"DATE\" >= to_date(?) AND \"DATE\" <= to_date(?) GROUP BY feature HAVING count(1) >= 2";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, DS2);
            statement.setString(3, DS4);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            Assert.assertEquals((Object)F1, (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateRangeSumLongAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT sum(transactions), feature FROM " + tablename + " WHERE organization_id=? AND \"DATE\" >= to_date(?) AND \"DATE\" <= to_date(?) GROUP BY feature";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, DS2);
            statement.setString(3, DS4);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)500L, (long)rs.getLong(1));
            Assert.assertEquals((Object)F1, (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)400L, (long)rs.getLong(1));
            Assert.assertEquals((Object)F2, (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRoundAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT round(\"DATE\",'hour',1) r,count(1) FROM " + tablename + " WHERE organization_id=? GROUP BY r";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Date d = rs.getDate(1);
            int c = rs.getInt(2);
            Assert.assertEquals((long)3600000L, (long)d.getTime());
            Assert.assertEquals((long)2L, (long)c);
            Assert.assertTrue((boolean)rs.next());
            d = rs.getDate(1);
            c = rs.getInt(2);
            Assert.assertEquals((long)0x6DDD00L, (long)d.getTime());
            Assert.assertEquals((long)3L, (long)c);
            Assert.assertTrue((boolean)rs.next());
            d = rs.getDate(1);
            c = rs.getInt(2);
            Assert.assertEquals((long)14400000L, (long)d.getTime());
            Assert.assertEquals((long)1L, (long)c);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRoundScan() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT round(\"DATE\",'hour') FROM " + tablename + " WHERE organization_id=?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Date d = rs.getDate(1);
            long t = 3600000L;
            Assert.assertEquals((long)t, (long)d.getTime());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)t, (long)d.getTime());
            Assert.assertTrue((boolean)rs.next());
            d = rs.getDate(1);
            t = 0x6DDD00L;
            Assert.assertEquals((long)t, (long)d.getTime());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)t, (long)d.getTime());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)t, (long)d.getTime());
            Assert.assertTrue((boolean)rs.next());
            d = rs.getDate(1);
            t = 14400000L;
            Assert.assertEquals((long)t, (long)d.getTime());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT trunc(\"DATE\",'hour'),count(1) FROM " + tablename + " WHERE organization_id=? GROUP BY trunc(\"DATE\",'hour')";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Date d = rs.getDate(1);
            int c = rs.getInt(2);
            Assert.assertEquals((long)0L, (long)d.getTime());
            Assert.assertEquals((long)1L, (long)c);
            Assert.assertTrue((boolean)rs.next());
            d = rs.getDate(1);
            c = rs.getInt(2);
            Assert.assertEquals((long)3600000L, (long)d.getTime());
            Assert.assertEquals((long)3L, (long)c);
            Assert.assertTrue((boolean)rs.next());
            d = rs.getDate(1);
            c = rs.getInt(2);
            Assert.assertEquals((long)0x6DDD00L, (long)d.getTime());
            Assert.assertEquals((long)1L, (long)c);
            Assert.assertTrue((boolean)rs.next());
            d = rs.getDate(1);
            c = rs.getInt(2);
            Assert.assertEquals((long)14400000L, (long)d.getTime());
            Assert.assertEquals((long)1L, (long)c);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT feature,sum(unique_users) FROM " + tablename + " WHERE organization_id=? AND transactions > 0 GROUP BY feature";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHavingAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT feature,sum(unique_users) FROM " + tablename + " WHERE organization_id=? AND transactions > 0 GROUP BY feature HAVING feature=?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, F1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstantSumAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT sum(1),sum(unique_users) FROM " + tablename + " WHERE organization_id=?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((long)210L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiDimAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT feature,region,sum(unique_users) FROM " + tablename + " WHERE organization_id=? GROUP BY feature,region";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F1, (Object)rs.getString(1));
            Assert.assertEquals(null, (Object)rs.getString(2));
            Assert.assertEquals((long)80L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F1, (Object)rs.getString(1));
            Assert.assertEquals((Object)R1, (Object)rs.getString(2));
            Assert.assertEquals((long)30L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F1, (Object)rs.getString(1));
            Assert.assertEquals((Object)R2, (Object)rs.getString(2));
            Assert.assertEquals((long)10L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F2, (Object)rs.getString(1));
            Assert.assertEquals((Object)R1, (Object)rs.getString(2));
            Assert.assertEquals((long)40L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F3, (Object)rs.getString(1));
            Assert.assertEquals((Object)R2, (Object)rs.getString(2));
            Assert.assertEquals((long)50L, (long)rs.getInt(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiDimRoundAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT round(\"DATE\",'hour',1),feature,sum(unique_users) FROM " + tablename + " WHERE organization_id=? GROUP BY round(\"DATE\",'hour',1),feature";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Date bucket1 = new Date(3600000L);
            Date bucket2 = new Date(0x6DDD00L);
            Date bucket3 = new Date(14400000L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)bucket1, (Object)rs.getDate(1));
            Assert.assertEquals((Object)F1, (Object)rs.getString(2));
            Assert.assertEquals((long)30L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)bucket2, (Object)rs.getDate(1));
            Assert.assertEquals((Object)F1, (Object)rs.getString(2));
            Assert.assertEquals((long)30L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)bucket2.getTime(), (long)rs.getDate(1).getTime());
            Assert.assertEquals((Object)F2, (Object)rs.getString(2));
            Assert.assertEquals((long)40L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)bucket2, (Object)rs.getDate(1));
            Assert.assertEquals((Object)F3, (Object)rs.getString(2));
            Assert.assertEquals((long)50L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)bucket3, (Object)rs.getDate(1));
            Assert.assertEquals((Object)F1, (Object)rs.getString(2));
            Assert.assertEquals((long)60L, (long)rs.getInt(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateRangeSumNumberUngroupedAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT sum(cpu_utilization) FROM " + tablename + " WHERE organization_id=? AND \"DATE\" >= to_date(?) AND \"DATE\" <= to_date(?)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, DS2);
            statement.setString(3, DS4);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(6.5), (Object)rs.getBigDecimal(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSumUngroupedAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT sum(unique_users),sum(cpu_utilization),sum(transactions),sum(db_utilization),sum(response_time) FROM " + tablename + " WHERE organization_id=?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)210L, (long)rs.getInt(1));
            Assert.assertEquals((Object)BigDecimal.valueOf(14.5), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((long)2100L, (long)rs.getLong(3));
            Assert.assertEquals((Object)BigDecimal.valueOf(4.6), (Object)rs.getBigDecimal(4));
            Assert.assertEquals((long)0L, (long)rs.getLong(5));
            Assert.assertEquals((Object)true, (Object)rs.wasNull());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResetColumnInSameTxn() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT sum(transactions) FROM " + tablename + " WHERE organization_id=?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);
        Connection upsertConn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);
        try {
            ProductMetricsIT.initTable(tablename, ProductMetricsIT.getSplits(tenantId));
            ProductMetricsIT.initTableValues(tablename, upsertConn, tenantId);
            PreparedStatement stmt = upsertConn.prepareStatement("upsert into " + tablename + "(    ORGANIZATION_ID,     \"DATE\",     FEATURE,     UNIQUE_USERS,    TRANSACTIONS) VALUES (?, ?, ?, ?, ?)");
            stmt.setString(1, tenantId);
            stmt.setDate(2, D1);
            stmt.setString(3, F1);
            stmt.setInt(4, 10);
            stmt.setInt(5, 200);
            stmt.execute();
            upsertConn.commit();
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2200L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSumUngroupedHavingAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT sum(unique_users),sum(cpu_utilization),sum(transactions),sum(db_utilization),sum(response_time) FROM " + tablename + " WHERE organization_id=? HAVING sum(unique_users) > 200 AND sum(db_utilization) > 4.5";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)210L, (long)rs.getInt(1));
            Assert.assertEquals((Object)BigDecimal.valueOf(14.5), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((long)2100L, (long)rs.getLong(3));
            Assert.assertEquals((Object)BigDecimal.valueOf(4.6), (Object)rs.getBigDecimal(4));
            Assert.assertEquals((long)0L, (long)rs.getLong(5));
            Assert.assertEquals((Object)true, (Object)rs.wasNull());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSumUngroupedHavingAggregation2() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT sum(unique_users),sum(cpu_utilization),sum(transactions),sum(db_utilization),sum(response_time) FROM " + tablename + " WHERE organization_id=? HAVING sum(unique_users) > 200 AND sum(db_utilization) > 5";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMinUngroupedAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT min(unique_users),min(cpu_utilization),min(transactions),min(db_utilization),min('X'),min(response_time) FROM " + tablename + " WHERE organization_id=?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)10L, (long)rs.getInt(1));
            Assert.assertEquals((Object)BigDecimal.valueOf(0.5), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((long)100L, (long)rs.getLong(3));
            Assert.assertEquals((Object)BigDecimal.valueOf(0.2), (Object)rs.getBigDecimal(4));
            Assert.assertEquals((Object)"X", (Object)rs.getString(5));
            Assert.assertEquals((long)0L, (long)rs.getLong(6));
            Assert.assertEquals((Object)true, (Object)rs.wasNull());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMinUngroupedAggregation1() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT min(cpu_utilization) FROM " + tablename + " WHERE organization_id=?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(0.5), (Object)rs.getBigDecimal(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxUngroupedAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT max(unique_users),max(cpu_utilization),max(transactions),max(db_utilization),max('X'),max(response_time) FROM " + tablename + " WHERE organization_id=?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)60L, (long)rs.getInt(1));
            Assert.assertEquals((Object)BigDecimal.valueOf(4L), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((long)600L, (long)rs.getLong(3));
            Assert.assertEquals((Object)BigDecimal.valueOf(1.4), (Object)rs.getBigDecimal(4));
            Assert.assertEquals((Object)"X", (Object)rs.getString(5));
            Assert.assertEquals((long)0L, (long)rs.getLong(6));
            Assert.assertEquals((Object)true, (Object)rs.wasNull());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxGroupedAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT feature,max(transactions) FROM " + tablename + " WHERE organization_id=? GROUP BY feature";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F1, (Object)rs.getString(1));
            Assert.assertEquals((long)600L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F2, (Object)rs.getString(1));
            Assert.assertEquals((long)400L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F3, (Object)rs.getString(1));
            Assert.assertEquals((long)500L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountUngroupedAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT count(1) FROM " + tablename;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountColumnUngroupedAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT count(io_time),sum(io_time),avg(io_time) FROM " + tablename + " WHERE organization_id=?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getLong(1));
            Assert.assertEquals((long)11000L, (long)rs.getLong(2));
            Assert.assertEquals((Object)new BigDecimal("3666.6666"), (Object)rs.getBigDecimal(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoRowsUngroupedAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT count(io_time),sum(io_time),avg(io_time),count(1) FROM " + tablename + " WHERE organization_id=? AND feature > ?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, F3);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.wasNull());
            Assert.assertEquals((long)0L, (long)rs.getLong(2));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals(null, (Object)rs.getBigDecimal(3));
            Assert.assertEquals((long)0L, (long)rs.getLong(4));
            Assert.assertFalse((boolean)rs.wasNull());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAvgUngroupedAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT avg(unique_users) FROM " + tablename + " WHERE organization_id=?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)BigDecimal.valueOf(35L), (Object)rs.getBigDecimal(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAvgUngroupedAggregationOnValueField() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT AVG(DB_UTILIZATION) FROM " + tablename + " WHERE organization_id=?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)new BigDecimal("0.7666666666"), (Object)rs.getBigDecimal(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLimitSumUngroupedAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT sum(unique_users),sum(cpu_utilization),sum(transactions),sum(db_utilization),sum(response_time) feature FROM " + tablename + " WHERE organization_id=? LIMIT 3";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)210L, (long)rs.getInt(1));
            Assert.assertEquals((Object)BigDecimal.valueOf(14.5), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((long)2100L, (long)rs.getLong(3));
            Assert.assertEquals((Object)BigDecimal.valueOf(4.6), (Object)rs.getBigDecimal(4));
            Assert.assertEquals((long)0L, (long)rs.getLong(5));
            Assert.assertEquals((Object)true, (Object)rs.wasNull());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSumGroupedAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT feature,sum(unique_users),sum(cpu_utilization),sum(transactions),sum(db_utilization),sum(response_time),count(1) c FROM " + tablename + " WHERE organization_id=? AND feature < ? GROUP BY feature";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, F3);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F1, (Object)rs.getString("feature"));
            Assert.assertEquals((long)120L, (long)rs.getInt("sum(unique_users)"));
            Assert.assertEquals((Object)BigDecimal.valueOf(8L), (Object)rs.getBigDecimal(3));
            Assert.assertEquals((long)1200L, (long)rs.getLong(4));
            Assert.assertEquals((Object)BigDecimal.valueOf(2.6), (Object)rs.getBigDecimal(5));
            Assert.assertEquals((long)0L, (long)rs.getLong(6));
            Assert.assertEquals((Object)true, (Object)rs.wasNull());
            Assert.assertEquals((long)4L, (long)rs.getLong("c"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F2, (Object)rs.getString("feature"));
            Assert.assertEquals((long)40L, (long)rs.getInt(2));
            Assert.assertEquals((Object)BigDecimal.valueOf(3L), (Object)rs.getBigDecimal(3));
            Assert.assertEquals((long)400L, (long)rs.getLong(4));
            Assert.assertEquals((Object)BigDecimal.valueOf(0.8), (Object)rs.getBigDecimal(5));
            Assert.assertEquals((long)0L, (long)rs.getLong(6));
            Assert.assertEquals((Object)true, (Object)rs.wasNull());
            Assert.assertEquals((long)1L, (long)rs.getLong("c"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDegenerateAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT count(1), feature FROM " + tablename + " WHERE organization_id=? AND \"DATE\" >= to_date(?) AND \"DATE\" <= to_date(?) GROUP BY feature";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, DS4);
            statement.setString(3, DS2);
            ResultSet rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFeatureDateRangeAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT feature,unique_users FROM " + tablename + " WHERE organization_id=? AND \"DATE\" >= to_date(?) AND feature > ?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, DS2);
            statement.setString(3, F2);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F3, (Object)rs.getString(1));
            Assert.assertEquals((long)50L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFeatureGTAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT feature,unique_users FROM " + tablename + " WHERE organization_id=? AND feature > ?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, F2);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F3, (Object)rs.getString(1));
            Assert.assertEquals((long)50L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFeatureGTEAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT feature,unique_users FROM " + tablename + " WHERE organization_id=? AND feature >= ?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, F2);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F2, (Object)rs.getString(1));
            Assert.assertEquals((long)40L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F3, (Object)rs.getString(1));
            Assert.assertEquals((long)50L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFeatureEQAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT feature,unique_users FROM " + tablename + " WHERE organization_id=? AND feature = ?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, F2);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F2, (Object)rs.getString(1));
            Assert.assertEquals((long)40L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFeatureLTAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT feature,unique_users FROM " + tablename + " WHERE organization_id=? AND feature < ?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, F2);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F1, (Object)rs.getString(1));
            Assert.assertEquals((long)10L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F1, (Object)rs.getString(1));
            Assert.assertEquals((long)20L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F1, (Object)rs.getString(1));
            Assert.assertEquals((long)30L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F1, (Object)rs.getString(1));
            Assert.assertEquals((long)60L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFeatureLTEAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT feature,unique_users FROM " + tablename + " WHERE organization_id=? AND feature <= ?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, F2);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F1, (Object)rs.getString(1));
            Assert.assertEquals((long)10L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F1, (Object)rs.getString(1));
            Assert.assertEquals((long)20L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F1, (Object)rs.getString(1));
            Assert.assertEquals((long)30L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F2, (Object)rs.getString(1));
            Assert.assertEquals((long)40L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F1, (Object)rs.getString(1));
            Assert.assertEquals((long)60L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrderByNonAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
        String query = "SELECT \"DATE\", transactions t FROM " + tablename + " WHERE organization_id=? AND unique_users <= 30 ORDER BY t DESC LIMIT 2";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)D3.getTime(), (long)rs.getDate(1).getTime());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)D2.getTime(), (long)rs.getDate(1).getTime());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrderByUngroupedAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT sum(unique_users) sumUsers,count(feature) FROM " + tablename + " WHERE organization_id=? ORDER BY 100000-sumUsers";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)210L, (long)rs.getInt(1));
            Assert.assertEquals((long)6L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrderByGroupedAggregation() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT feature,sum(unique_users) s,count(feature),round(\"DATE\",'hour',1) r FROM " + tablename + " WHERE organization_id=? GROUP BY feature, r ORDER BY 1 desc,feature desc,r,feature,s";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Object[][] expected = new Object[][]{{F3, 50, 1}, {F2, 40, 1}, {F1, 30, 2}, {F1, 30, 1}, {F1, 60, 1}};
            for (int i = 0; i < expected.length; ++i) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)expected[i][0], (Object)rs.getString(1));
                Assert.assertEquals((Object)expected[i][1], (Object)rs.getInt(2));
                Assert.assertEquals((Object)expected[i][2], (Object)rs.getInt(3));
            }
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrderByUnprojected() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT sum(unique_users), count(feature) c FROM " + tablename + " WHERE organization_id=? GROUP BY feature ORDER BY 100-c,feature";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            int[] expected = new int[]{120, 40, 50};
            for (int i = 0; i < expected.length; ++i) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)expected[i], (long)rs.getInt(1));
            }
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testOrderByNullColumns__nullsFirst() throws Exception {
        this.helpTestOrderByNullColumns(true);
    }

    @Test
    public void testOrderByNullColumns__nullsLast() throws Exception {
        this.helpTestOrderByNullColumns(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void helpTestOrderByNullColumns(boolean nullsFirst) throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT region FROM " + tablename + " WHERE organization_id=? GROUP BY region ORDER BY region nulls " + (nullsFirst ? "first" : "last");
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            ArrayList expected = Lists.newArrayList((Object[])new String[]{null, R1, R2});
            Ordering regionOrdering = Ordering.natural();
            regionOrdering = nullsFirst ? regionOrdering.nullsFirst() : regionOrdering.nullsLast();
            Collections.sort(expected, regionOrdering);
            for (String region : expected) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)region, (Object)rs.getString(1));
            }
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterOnTrailingKeyColumn() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);
        Admin admin = null;
        try {
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            admin.flush(TableName.valueOf((byte[])SchemaUtil.getTableNameAsBytes((String)PRODUCT_METRICS_SCHEMA_NAME, (String)tablename)));
            String query = "SELECT SUM(TRANSACTIONS) FROM " + tablename + " WHERE FEATURE=?";
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, F1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1200L, (long)rs.getInt(1));
        }
        finally {
            if (admin != null) {
                admin.close();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterOnTrailingKeyColumn2() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT organization_id, \"DATE\", feature FROM " + tablename + " WHERE substr(organization_id,1,3)=? AND \"DATE\" > to_date(?)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId.substring(0, 3));
            statement.setString(2, DS4);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)tenantId, (Object)rs.getString(1));
            Assert.assertEquals((long)D5.getTime(), (long)rs.getDate(2).getTime());
            Assert.assertEquals((Object)F3, (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)tenantId, (Object)rs.getString(1));
            Assert.assertEquals((Object)D6, (Object)rs.getDate(2));
            Assert.assertEquals((Object)F1, (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubstringNotEqual() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT organization_id, \"DATE\", feature FROM " + tablename + " WHERE organization_id=? AND \"DATE\" > to_date(?)";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId.substring(0, 3));
            statement.setString(2, DS4);
            ResultSet rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeyOrderedAggregation1() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT \"DATE\", sum(UNIQUE_USERS) FROM " + tablename + " WHERE \"DATE\" > to_date(?) GROUP BY organization_id, \"DATE\"";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, DS4);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)D5, (Object)rs.getDate(1));
            Assert.assertEquals((long)50L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)D6, (Object)rs.getDate(1));
            Assert.assertEquals((long)60L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeyOrderedAggregation2() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT \"DATE\", sum(UNIQUE_USERS) FROM " + tablename + " WHERE \"DATE\" < to_date(?) GROUP BY organization_id, \"DATE\"";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, DS4);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)D1, (Object)rs.getDate(1));
            Assert.assertEquals((long)10L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)D2, (Object)rs.getDate(1));
            Assert.assertEquals((long)20L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)D3, (Object)rs.getDate(1));
            Assert.assertEquals((long)30L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeyOrderedRoundAggregation1() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT round(\"DATE\",'HOUR'), sum(UNIQUE_USERS) FROM " + tablename + " WHERE \"DATE\" < to_date(?) GROUP BY organization_id, round(\"DATE\",'HOUR')";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, DS4);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)ROUND_1HR, (Object)rs.getDate(1));
            Assert.assertEquals((long)30L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)ROUND_2HR, (Object)rs.getDate(1));
            Assert.assertEquals((long)30L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeyOrderedRoundAggregation2() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT round(\"DATE\",'HOUR'), sum(UNIQUE_USERS) FROM " + tablename + " WHERE \"DATE\" <= to_date(?) GROUP BY organization_id, round(\"DATE\",'HOUR')";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, DS4);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)ROUND_1HR, (Object)rs.getDate(1));
            Assert.assertEquals((long)30L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)ROUND_2HR, (Object)rs.getDate(1));
            Assert.assertEquals((long)70L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEqualsRound() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT feature FROM " + tablename + " WHERE organization_id = ? and trunc(\"DATE\",'DAY')=?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            Date startDate = new Date(System.currentTimeMillis());
            Date equalDate = new Date((startDate.getTime() + 172800000L) / 86400000L * 86400000L);
            ProductMetricsIT.initDateTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId), startDate, 1.0);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setDate(2, equalDate);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F3, (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncateNotTraversableToFormScanKey() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String tenantId = ProductMetricsIT.getOrganizationId();
        String query = "SELECT feature FROM " + tablename + " WHERE organization_id = ? and TRUNC(\"DATE\",'DAY') <= ?";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            Date startDate = ProductMetricsIT.toDate("2013-01-01 00:00:00");
            ProductMetricsIT.initDateTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId), startDate, 0.5);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setDate(2, new Date(startDate.getTime() + 21600000L));
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F1, (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)F2, (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSaltedOrderBy() throws Exception {
        String tablename = ProductMetricsIT.generateUniqueName();
        String ddl = "create table " + tablename + "   (organization_id char(15) not null,    \"DATE\" date not null,    feature char(1) not null,    unique_users integer not null,\n    db_utilization decimal(31,10),\n    transactions bigint,\n    cpu_utilization decimal(31,10),\n    response_time bigint,\n    io_time bigint,\n    region varchar,\n    unset_column decimal(31,10)\n    CONSTRAINT pk PRIMARY KEY (organization_id, \"DATE\", feature, unique_users)) salt_buckets=3";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
        }
        String tenantId = ProductMetricsIT.getOrganizationId();
        Date startDate = new Date(System.currentTimeMillis());
        ProductMetricsIT.initDateTableValues(tablename, tenantId, ProductMetricsIT.getSplits(tenantId), startDate);
        props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);){
            ProductMetricsIT.initDateTableValues(tablename, conn, tenantId, new Date(startDate.getTime() + 864000000L), 2.0);
            ProductMetricsIT.initDateTableValues(tablename, conn, tenantId, new Date(startDate.getTime() + 1728000000L), 2.0);
            conn.commit();
        }
        props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn = DriverManager.getConnection(ProductMetricsIT.getUrl(), props);
        var7_10 = null;
        try {
            PreparedStatement statement = conn.prepareStatement("SELECT count(1) FROM " + tablename + " WHERE organization_id = ?");
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)18L, (long)rs.getLong(1));
            statement = conn.prepareStatement("SELECT \"DATE\" FROM " + tablename + " WHERE organization_id = ?  order by \"DATE\" desc limit 10");
            statement.setString(1, tenantId);
            rs = statement.executeQuery();
            java.util.Date date = null;
            int count = 0;
            while (rs.next()) {
                if (date != null) {
                    Assert.assertTrue((date.getTime() >= rs.getDate(1).getTime() ? 1 : 0) != 0);
                }
                ++count;
                date = rs.getDate(1);
            }
            Assert.assertEquals((long)10L, (long)count);
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var7_10 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var7_10.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }
}

