/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.iterate.ScanningResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ParallelStatsDisabledTest.class})
public class PreMatureTimelyAbortScanIt
extends ParallelStatsDisabledIT {
    private static final Logger LOG = LoggerFactory.getLogger(PreMatureTimelyAbortScanIt.class);

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        props.put("phoenix.server.page.size.ms", Integer.toString(0));
        PreMatureTimelyAbortScanIt.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    private String getUniqueUrl() {
        return url + PreMatureTimelyAbortScanIt.generateUniqueName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreMatureScannerAbortForCount() throws Exception {
        try (Connection conn = DriverManager.getConnection(this.getUniqueUrl());){
            conn.createStatement().execute("CREATE TABLE LONG_BUG (ID INTEGER PRIMARY KEY, AMOUNT DECIMAL) SALT_BUCKETS = 16 ");
        }
        conn = DriverManager.getConnection(this.getUniqueUrl());
        var2_4 = null;
        try {
            for (int i = 0; i < 100; ++i) {
                int amount = -50000 + i;
                String s = "UPSERT INTO LONG_BUG (ID, AMOUNT) VALUES( " + i + ", " + amount + ")";
                conn.createStatement().execute(s);
            }
            conn.commit();
        }
        catch (Throwable throwable) {
            var2_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        try {
            conn = DriverManager.getConnection(this.getUniqueUrl()).unwrap(PhoenixConnection.class);
            ScanningResultIterator.setIsScannerClosedForcefully((boolean)true);
            ResultSet resultSet = conn.createStatement().executeQuery("SELECT COUNT(*) FROM LONG_BUG WHERE ID % 2 = 0");
            conn.setIsClosing(true);
            resultSet.next();
            LOG.info("Count of modulus 2 for LONG_BUG :- " + resultSet.getInt(1));
            Assert.fail((String)"ResultSet should have been closed");
        }
        catch (SQLException sqe) {
            Assert.assertEquals((long)SQLExceptionCode.FAILED_KNOWINGLY_FOR_TEST.getErrorCode(), (long)sqe.getErrorCode());
        }
        catch (Exception e) {
            Assert.fail();
        }
        finally {
            ScanningResultIterator.setIsScannerClosedForcefully((boolean)false);
        }
    }
}

