/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class PowerFunctionEnd2EndIT
extends ParallelStatsDisabledIT {
    private static final String KEY = "key";
    private String signedTableName;
    private String unsignedTableName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void initTable() throws Exception {
        this.signedTableName = PowerFunctionEnd2EndIT.generateUniqueName();
        this.unsignedTableName = PowerFunctionEnd2EndIT.generateUniqueName();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(PowerFunctionEnd2EndIT.getUrl());
            String ddl = "CREATE TABLE " + this.signedTableName + " (k VARCHAR NOT NULL PRIMARY KEY, doub DOUBLE, fl FLOAT, inte INTEGER, lon BIGINT, smalli SMALLINT, tinyi TINYINT)";
            conn.createStatement().execute(ddl);
            ddl = "CREATE TABLE " + this.unsignedTableName + " (k VARCHAR NOT NULL PRIMARY KEY, doub UNSIGNED_DOUBLE, fl UNSIGNED_FLOAT, inte UNSIGNED_INT, lon UNSIGNED_LONG, smalli UNSIGNED_SMALLINT, tinyi UNSIGNED_TINYINT)";
            conn.createStatement().execute(ddl);
            conn.commit();
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    private void updateTableSpec(Connection conn, double data, String tableName) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, KEY);
        Double d = data;
        stmt.setDouble(2, d);
        stmt.setFloat(3, d.floatValue());
        stmt.setInt(4, d.intValue());
        stmt.setLong(5, d.longValue());
        stmt.setShort(6, d.shortValue());
        stmt.setByte(7, d.byteValue());
        stmt.executeUpdate();
        conn.commit();
    }

    private void testNumberSpec(Connection conn, double data, String tableName) throws Exception {
        this.updateTableSpec(conn, data, tableName);
        ResultSet rs = conn.createStatement().executeQuery("SELECT POWER(doub, 1.5),POWER(fl, 1.5),POWER(inte, 1.5),POWER(lon, 1.5),POWER(smalli, 1.5),POWER(tinyi, 1.5) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Double d = data;
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(1), Math.pow(d, 1.5)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(2), Math.pow(d.floatValue(), 1.5)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(3), Math.pow(d.intValue(), 1.5)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(4), Math.pow(d.longValue(), 1.5)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(5), Math.pow(d.shortValue(), 1.5)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(6), Math.pow(d.byteValue(), 1.5)));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        rs = conn.createStatement().executeQuery("SELECT POWER(doub, 2),POWER(fl, 2),POWER(inte, 2),POWER(lon, 2),POWER(smalli, 2),POWER(tinyi, 2) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        d = data;
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(1), Math.pow(d, 2.0)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(2), Math.pow(d.floatValue(), 2.0)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(3), Math.pow(d.intValue(), 2.0)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(4), Math.pow(d.longValue(), 2.0)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(5), Math.pow(d.shortValue(), 2.0)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(6), Math.pow(d.byteValue(), 2.0)));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        rs = conn.createStatement().executeQuery("SELECT POWER(doub,3),POWER(fl,3),POWER(inte,3),POWER(lon,3),POWER(smalli,3),POWER(tinyi,3) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        d = data;
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(1), Math.pow(d, 3.0)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(2), Math.pow(d.floatValue(), 3.0)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(3), Math.pow(d.intValue(), 3.0)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(4), Math.pow(d.longValue(), 3.0)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(5), Math.pow(d.shortValue(), 3.0)));
        Assert.assertTrue((boolean)PowerFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(6), Math.pow(d.byteValue(), 3.0)));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
    }

    @Test
    public void test() throws Exception {
        Connection conn = DriverManager.getConnection(PowerFunctionEnd2EndIT.getUrl());
        for (double d : new double[]{0.0, 1.0, -1.0, 123.1234, -123.1234}) {
            this.testNumberSpec(conn, d, this.signedTableName);
            if (!(d >= 0.0)) continue;
            this.testNumberSpec(conn, d, this.unsignedTableName);
        }
    }
}

