/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import com.google.protobuf.RpcController;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compat.hbase.ByteStringer;
import org.apache.phoenix.coprocessor.PhoenixRegionServerEndpoint;
import org.apache.phoenix.coprocessor.generated.RegionServerEndpointProtos;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.StaleMetadataCacheException;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PhoenixRegionServerEndpointIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        PhoenixRegionServerEndpointIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testValidateLastDDLTimestampNoException() throws SQLException {
        HRegionServer regionServer = utility.getMiniHBaseCluster().getRegionServer(0);
        PhoenixRegionServerEndpoint coprocessor = this.getPhoenixRegionServerEndpoint(regionServer);
        Assert.assertNotNull((Object)coprocessor);
        ServerRpcController controller = new ServerRpcController();
        String tableNameStr = PhoenixRegionServerEndpointIT.generateUniqueName();
        Properties props = new Properties();
        try (Connection conn = DriverManager.getConnection(PhoenixRegionServerEndpointIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = this.getCreateTableStmt(tableNameStr);
            conn.createStatement().execute(ddl);
            conn.commit();
            PTable pTable = PhoenixRuntime.getTable((Connection)conn, (String)tableNameStr);
            long lastDDLTimestamp = pTable.getLastDDLTimestamp();
            RegionServerEndpointProtos.ValidateLastDDLTimestampRequest request = this.getRequest(HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, tableNameStr.getBytes(StandardCharsets.UTF_8), lastDDLTimestamp);
            coprocessor.validateLastDDLTimestamp((RpcController)controller, request, null);
            Assert.assertFalse((boolean)controller.failed());
        }
    }

    @Test
    public void testValidateLastDDLTimestampWithException() throws SQLException {
        HRegionServer regionServer = utility.getMiniHBaseCluster().getRegionServer(0);
        PhoenixRegionServerEndpoint coprocessor = this.getPhoenixRegionServerEndpoint(regionServer);
        Assert.assertNotNull((Object)coprocessor);
        ServerRpcController controller = new ServerRpcController();
        String tableNameStr = PhoenixRegionServerEndpointIT.generateUniqueName();
        Properties props = new Properties();
        try (Connection conn = DriverManager.getConnection(PhoenixRegionServerEndpointIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = this.getCreateTableStmt(tableNameStr);
            conn.createStatement().execute(ddl);
            conn.commit();
            PTable pTable = PhoenixRuntime.getTable((Connection)conn, (String)tableNameStr);
            long lastDDLTimestamp = pTable.getLastDDLTimestamp();
            RegionServerEndpointProtos.ValidateLastDDLTimestampRequest request = this.getRequest(HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, tableNameStr.getBytes(StandardCharsets.UTF_8), lastDDLTimestamp - 1L);
            coprocessor.validateLastDDLTimestamp((RpcController)controller, request, null);
            Assert.assertTrue((boolean)controller.failed());
            IOException exception = controller.getFailedOn();
            SQLException parsedException = ClientUtil.parseRemoteException((Throwable)exception);
            Assert.assertTrue((boolean)(parsedException instanceof StaleMetadataCacheException));
        }
    }

    @Test
    public void testValidateLastDDLTimestampWithTenantID() throws SQLException {
        HRegionServer regionServer = utility.getMiniHBaseCluster().getRegionServer(0);
        PhoenixRegionServerEndpoint coprocessor = this.getPhoenixRegionServerEndpoint(regionServer);
        Assert.assertNotNull((Object)coprocessor);
        ServerRpcController controller = new ServerRpcController();
        String tableNameStr = PhoenixRegionServerEndpointIT.generateUniqueName();
        Properties props = new Properties();
        try (Connection conn = DriverManager.getConnection(PhoenixRegionServerEndpointIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = this.getCreateTableStmt(tableNameStr);
            conn.createStatement().execute(ddl);
        }
        String tenantId = "T_" + PhoenixRegionServerEndpointIT.generateUniqueName();
        Properties tenantProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        tenantProps.setProperty("TenantId", tenantId);
        String whereClause = " WHERE COL1 = 1000";
        String tenantViewNameStr = PhoenixRegionServerEndpointIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(PhoenixRegionServerEndpointIT.getUrl(), tenantProps);){
            conn.createStatement().execute(this.getCreateViewStmt(tenantViewNameStr, tableNameStr, whereClause));
            PTable tenantViewTable = PhoenixRuntime.getTableNoCache((Connection)conn, (String)tenantViewNameStr);
            byte[] tenantIDBytes = Bytes.toBytes((String)tenantId);
            byte[] tenantViewNameBytes = Bytes.toBytes((String)tenantViewNameStr);
            long lastDDLTimestamp = tenantViewTable.getLastDDLTimestamp();
            RegionServerEndpointProtos.ValidateLastDDLTimestampRequest request = this.getRequest(tenantIDBytes, HConstants.EMPTY_BYTE_ARRAY, tenantViewNameBytes, lastDDLTimestamp);
            coprocessor.validateLastDDLTimestamp((RpcController)controller, request, null);
            Assert.assertFalse((boolean)controller.failed());
        }
    }

    @Test
    public void testInvalidateHAGroupStoreClient() {
        HRegionServer regionServer = utility.getMiniHBaseCluster().getRegionServer(0);
        PhoenixRegionServerEndpoint coprocessor = this.getPhoenixRegionServerEndpoint(regionServer);
        Assert.assertNotNull((Object)coprocessor);
        ServerRpcController controller = new ServerRpcController();
        RegionServerEndpointProtos.InvalidateHAGroupStoreClientRequest request = RegionServerEndpointProtos.InvalidateHAGroupStoreClientRequest.newBuilder().build();
        coprocessor.invalidateHAGroupStoreClient((RpcController)controller, request, null);
        Assert.assertFalse((boolean)controller.failed());
    }

    private String getCreateTableStmt(String tableName) {
        return "CREATE TABLE " + tableName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string)) ";
    }

    private String getCreateViewStmt(String viewName, String fullTableName, String whereClause) {
        String viewStmt = "CREATE VIEW " + viewName + " AS SELECT * FROM " + fullTableName + whereClause;
        return viewStmt;
    }

    private PhoenixRegionServerEndpoint getPhoenixRegionServerEndpoint(HRegionServer regionServer) {
        PhoenixRegionServerEndpoint coproc = (PhoenixRegionServerEndpoint)regionServer.getRegionServerCoprocessorHost().findCoprocessor(PhoenixRegionServerEndpoint.class);
        return coproc;
    }

    private RegionServerEndpointProtos.ValidateLastDDLTimestampRequest getRequest(byte[] tenantID, byte[] schemaName, byte[] tableName, long lastDDLTimestamp) {
        RegionServerEndpointProtos.ValidateLastDDLTimestampRequest.Builder requestBuilder = RegionServerEndpointProtos.ValidateLastDDLTimestampRequest.newBuilder();
        RegionServerEndpointProtos.LastDDLTimestampRequest.Builder innerBuilder = RegionServerEndpointProtos.LastDDLTimestampRequest.newBuilder();
        innerBuilder.setTenantId(ByteStringer.wrap((byte[])tenantID));
        innerBuilder.setSchemaName(ByteStringer.wrap((byte[])schemaName));
        innerBuilder.setTableName(ByteStringer.wrap((byte[])tableName));
        innerBuilder.setLastDDLTimestamp(lastDDLTimestamp);
        requestBuilder.addLastDDLTimestampRequests(innerBuilder);
        return requestBuilder.build();
    }
}

