/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.phoenix.end2end.BasePermissionsIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PermissionsCacheIT
extends BasePermissionsIT {
    public PermissionsCacheIT() throws Exception {
        super(true);
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        BasePermissionsIT.initCluster(true);
    }

    @Test
    public void testPermissionsCachedWithAccessChecker() throws Throwable {
        if (!this.isNamespaceMapped) {
            return;
        }
        final String schema = PermissionsCacheIT.generateUniqueName();
        String tableName = PermissionsCacheIT.generateUniqueName();
        String phoenixTableName = SchemaUtil.getTableName((String)schema, (String)tableName);
        try (Connection conn = this.getConnection();){
            this.grantPermissions(this.regularUser1.getShortName(), PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES, Permission.Action.READ, Permission.Action.EXEC);
            this.grantPermissions(this.regularUser1.getShortName(), Collections.singleton("SYSTEM:SEQUENCE"), Permission.Action.WRITE, Permission.Action.READ, Permission.Action.EXEC);
            superUser1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        PermissionsCacheIT.this.verifyAllowed(PermissionsCacheIT.this.createSchema(schema), BasePermissionsIT.superUser1);
                        PermissionsCacheIT.this.grantPermissions(PermissionsCacheIT.this.regularUser1.getShortName(), schema, Permission.Action.CREATE);
                        PermissionsCacheIT.this.grantPermissions(AuthUtil.toGroupEntry((String)"group_system_access"), schema, Permission.Action.CREATE);
                    }
                    catch (Throwable e) {
                        if (e instanceof Exception) {
                            throw (Exception)e;
                        }
                        throw new Exception(e);
                    }
                    return null;
                }
            });
            this.verifyAllowed(this.createTable(phoenixTableName), this.regularUser1);
            HBaseTestingUtility utility = PermissionsCacheIT.getUtility();
            Configuration conf = utility.getConfiguration();
            ZKWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher((HBaseZKTestingUtility)utility);
            String aclZnodeParent = conf.get("zookeeper.znode.acl.parent", "acl");
            String aclZNode = ZNodePaths.joinZNode((String)zkw.getZNodePaths().baseZNode, (String)aclZnodeParent);
            String tableZNode = ZNodePaths.joinZNode((String)aclZNode, (String)("@" + schema));
            byte[] data = ZKUtil.getData((ZKWatcher)zkw, (String)tableZNode);
            ListMultimap userPermissions = PermissionStorage.readPermissions((byte[])data, (Configuration)conf);
            Assert.assertTrue((String)"User permissions not found in cache:", (boolean)userPermissions.containsKey((Object)this.regularUser1.getName()));
            List tablePermissions = userPermissions.get((Object)this.regularUser1.getName());
            for (Permission tablePerm : tablePermissions) {
                Assert.assertTrue((String)"Table create permission don't exist", (boolean)tablePerm.implies(Permission.Action.CREATE));
            }
        }
        catch (Exception e) {
            System.out.println("Exception occurred: " + e);
            throw e;
        }
    }
}

