/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.BasePermissionsIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PermissionNSEnabledIT
extends BasePermissionsIT {
    public PermissionNSEnabledIT() throws Exception {
        super(true);
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        BasePermissionsIT.initCluster(true);
    }

    private BasePermissionsIT.AccessTestAction createMappedView(final String schemaName, final String tableName) throws SQLException {
        return new BasePermissionsIT.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = PermissionNSEnabledIT.this.getConnection();
                     Statement stmt = conn.createStatement();){
                    String viewStmtSQL = "CREATE VIEW \"" + schemaName + "\".\"" + tableName + "\" ( PK varchar primary key)";
                    Assert.assertFalse((boolean)stmt.execute(viewStmtSQL));
                }
                return null;
            }
        };
    }

    @Test
    public void testCreateMappedView() throws Throwable {
        final String schema = PermissionNSEnabledIT.generateUniqueName();
        final String tableName = PermissionNSEnabledIT.generateUniqueName();
        this.verifyAllowed(this.createSchema(schema), superUser1);
        this.grantPermissions(this.regularUser1.getShortName(), schema, Permission.Action.WRITE, Permission.Action.READ, Permission.Action.EXEC, Permission.Action.ADMIN);
        this.grantPermissions(this.regularUser1.getShortName(), "SYSTEM", Permission.Action.WRITE, Permission.Action.READ, Permission.Action.EXEC);
        superUser1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Admin admin = BasePermissionsIT.testUtil.getAdmin();
                TableDescriptorBuilder tdb = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(schema + ":" + tableName)));
                ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"0")).build();
                tdb.setColumnFamily(cfd);
                TableDescriptor td = tdb.build();
                admin.createTable(td);
                return null;
            }
        });
        this.verifyAllowed(this.createMappedView(schema, tableName), this.regularUser1);
    }

    @Test
    public void testSchemaPermissions() throws Throwable {
        this.grantSystemTableAccess();
        String schemaName = "S_" + PermissionNSEnabledIT.generateUniqueName();
        superUser1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    PermissionNSEnabledIT.this.grantPermissions(PermissionNSEnabledIT.this.regularUser1.getShortName(), Permission.Action.ADMIN);
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw new Exception(e);
                }
                return null;
            }
        });
        this.verifyAllowed(this.createSchema(schemaName), this.regularUser1);
        this.verifyDenied(this.dropSchema(schemaName), AccessDeniedException.class, this.unprivilegedUser);
        this.verifyDenied(this.createSchema(schemaName), AccessDeniedException.class, this.unprivilegedUser);
        this.verifyAllowed(this.dropSchema(schemaName), this.regularUser1);
    }

    @Test
    public void testConnectionCreationFailsWhenNoExecPermsOnSystemCatalog() throws Throwable {
        this.grantSystemTableAccess();
        superUser1.runAs(() -> {
            TableName systemCatalogTableName = TableName.valueOf((String)SchemaUtil.getPhysicalHBaseTableName((String)"SYSTEM", (String)"CATALOG", (boolean)true).getString());
            try {
                this.revokePermissions(this.unprivilegedUser.getShortName(), Collections.singleton(systemCatalogTableName.getNameAsString()), Permission.Action.EXEC);
            }
            catch (Throwable t) {
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new Exception(t);
            }
            return null;
        });
        this.unprivilegedUser.runAs(() -> {
            try (Connection ignored = this.getConnection();){
                Assert.fail((String)"Should have failed with a wrapped AccessDeniedException");
            }
            catch (Throwable ex) {
                Assert.assertTrue((String)"Should not get an incompatible jars exception", (ex instanceof SQLException && ((SQLException)ex).getErrorCode() != SQLExceptionCode.INCOMPATIBLE_CLIENT_SERVER_JAR.getErrorCode() ? 1 : 0) != 0);
                Assert.assertTrue((String)"Expected a wrapped AccessDeniedException", (boolean)(ex.getCause() instanceof AccessDeniedException));
            }
            return null;
        });
    }

    @Test
    public void testViewCreationFailsWhenNoExecPermsOnSystemChildLink() throws Throwable {
        this.grantSystemTableAccess();
        final TableName systemChildLink = TableName.valueOf((String)SchemaUtil.getPhysicalHBaseTableName((String)"SYSTEM", (String)"CHILD_LINK", (boolean)true).getString());
        final String schemaName = "S_" + PermissionNSEnabledIT.generateUniqueName();
        final String tableName = "T_" + PermissionNSEnabledIT.generateUniqueName();
        String fullTableName = schemaName + "." + tableName;
        String viewName = "V_" + PermissionNSEnabledIT.generateUniqueName();
        this.verifyAllowed(this.createSchema(schemaName), superUser1);
        this.verifyAllowed(this.createTable(fullTableName), superUser1);
        superUser1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                try {
                    PermissionNSEnabledIT.this.revokePermissions(PermissionNSEnabledIT.this.unprivilegedUser.getShortName(), Collections.singleton(systemChildLink.getNameAsString()), Permission.Action.EXEC);
                    PermissionNSEnabledIT.this.grantPermissions(PermissionNSEnabledIT.this.unprivilegedUser.getShortName(), Collections.singleton(SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)tableName, (boolean)true).getString()), Permission.Action.READ, Permission.Action.EXEC);
                }
                catch (Throwable t) {
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new Exception(t);
                }
                return null;
            }
        });
        this.verifyDenied(this.createView(viewName, fullTableName), AccessDeniedException.class, this.unprivilegedUser);
        superUser1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                try {
                    PermissionNSEnabledIT.this.grantPermissions(PermissionNSEnabledIT.this.unprivilegedUser.getShortName(), Collections.singleton(systemChildLink.getNameAsString()), Permission.Action.EXEC);
                }
                catch (Throwable t) {
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new Exception(t);
                }
                return null;
            }
        });
        this.verifyAllowed(this.createView(viewName, fullTableName), this.unprivilegedUser);
    }
}

