/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class PercentileIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentile() throws Exception {
        String tenantId = PercentileIT.getOrganizationId();
        String tableName = PercentileIT.initATableValues(tenantId, null, PercentileIT.getDefaultSplits(tenantId), null);
        String query = "SELECT PERCENTILE_CONT(0.9) WITHIN GROUP (ORDER BY A_INTEGER ASC) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal percentile = rs.getBigDecimal(1);
            percentile = percentile.setScale(1, RoundingMode.HALF_UP);
            Assert.assertEquals((double)8.6, (double)percentile.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentileDesc() throws Exception {
        String tenantId = PercentileIT.getOrganizationId();
        String tableName = PercentileIT.initATableValues(tenantId, null, PercentileIT.getDefaultSplits(tenantId), null);
        String query = "SELECT PERCENTILE_CONT(0.9) WITHIN GROUP (ORDER BY A_INTEGER DESC) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal percentile = rs.getBigDecimal(1);
            percentile = percentile.setScale(1, RoundingMode.HALF_UP);
            Assert.assertEquals((double)1.4, (double)percentile.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentileWithGroupby() throws Exception {
        String tenantId = PercentileIT.getOrganizationId();
        String tableName = PercentileIT.initATableValues(tenantId, null, PercentileIT.getDefaultSplits(tenantId), null);
        String query = "SELECT A_STRING, PERCENTILE_CONT(0.9) WITHIN GROUP (ORDER BY A_INTEGER ASC) FROM " + tableName + " GROUP BY A_STRING";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            BigDecimal percentile = rs.getBigDecimal(2);
            percentile = percentile.setScale(1, RoundingMode.HALF_UP);
            Assert.assertEquals((double)7.0, (double)percentile.doubleValue(), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            percentile = rs.getBigDecimal(2);
            percentile = percentile.setScale(1, RoundingMode.HALF_UP);
            Assert.assertEquals((double)9.0, (double)percentile.doubleValue(), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            percentile = rs.getBigDecimal(2);
            percentile = percentile.setScale(1, RoundingMode.HALF_UP);
            Assert.assertEquals((double)8.0, (double)percentile.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentileWithGroupbyAndOrderBy() throws Exception {
        String tenantId = PercentileIT.getOrganizationId();
        String tableName = PercentileIT.initATableValues(tenantId, null, PercentileIT.getDefaultSplits(tenantId), null);
        String query = "SELECT A_STRING, PERCENTILE_CONT(0.9) WITHIN GROUP (ORDER BY A_INTEGER ASC) AS PC FROM " + tableName + " GROUP BY A_STRING ORDER BY PC";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            BigDecimal percentile = rs.getBigDecimal(2);
            percentile = percentile.setScale(1, RoundingMode.HALF_UP);
            Assert.assertEquals((double)7.0, (double)percentile.doubleValue(), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            percentile = rs.getBigDecimal(2);
            percentile = percentile.setScale(1, RoundingMode.HALF_UP);
            Assert.assertEquals((double)8.0, (double)percentile.doubleValue(), (double)0.0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            percentile = rs.getBigDecimal(2);
            percentile = percentile.setScale(1, RoundingMode.HALF_UP);
            Assert.assertEquals((double)9.0, (double)percentile.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentileDiscAsc() throws Exception {
        String tenantId = PercentileIT.getOrganizationId();
        String tableName = PercentileIT.initATableValues(tenantId, null, PercentileIT.getDefaultSplits(tenantId), null);
        String query = "SELECT PERCENTILE_DISC(0.9) WITHIN GROUP (ORDER BY A_INTEGER ASC) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            int percentile_disc = rs.getInt(1);
            Assert.assertEquals((long)9L, (long)percentile_disc);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentileDiscDesc() throws Exception {
        String tenantId = PercentileIT.getOrganizationId();
        String tableName = PercentileIT.initATableValues(tenantId, null, PercentileIT.getDefaultSplits(tenantId), null);
        String query = "SELECT PERCENTILE_DISC(0.9) WITHIN GROUP (ORDER BY A_INTEGER DESC) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            int percentile_disc = rs.getInt(1);
            Assert.assertEquals((long)1L, (long)percentile_disc);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentileDiscWithGroupby() throws Exception {
        String tenantId = PercentileIT.getOrganizationId();
        String tableName = PercentileIT.initATableValues(tenantId, null, PercentileIT.getDefaultSplits(tenantId), null);
        String query = "SELECT A_STRING, PERCENTILE_DISC(0.5) WITHIN GROUP (ORDER BY A_INTEGER ASC) FROM " + tableName + " GROUP BY A_STRING";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            int percentile_disc = rs.getInt(2);
            Assert.assertEquals((long)2L, (long)percentile_disc);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            percentile_disc = rs.getInt(2);
            Assert.assertEquals((long)5L, (long)percentile_disc);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            percentile_disc = rs.getInt(2);
            Assert.assertEquals((long)8L, (long)percentile_disc);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentileDiscWithGroupbyAndOrderBy() throws Exception {
        String tenantId = PercentileIT.getOrganizationId();
        String tableName = PercentileIT.initATableValues(tenantId, null, PercentileIT.getDefaultSplits(tenantId), null);
        String query = "SELECT A_STRING, PERCENTILE_DISC(0.5) WITHIN GROUP (ORDER BY A_INTEGER ASC) FROM " + tableName + " GROUP BY A_STRING ORDER BY A_STRING DESC";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            int percentile_disc = rs.getInt(2);
            Assert.assertEquals((long)8L, (long)percentile_disc);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            percentile_disc = rs.getInt(2);
            Assert.assertEquals((long)5L, (long)percentile_disc);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            percentile_disc = rs.getInt(2);
            Assert.assertEquals((long)2L, (long)percentile_disc);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentRank() throws Exception {
        String tenantId = PercentileIT.getOrganizationId();
        String tableName = PercentileIT.initATableValues(tenantId, null, PercentileIT.getDefaultSplits(tenantId), null);
        String query = "SELECT PERCENT_RANK(5) WITHIN GROUP (ORDER BY A_INTEGER ASC) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal rank = rs.getBigDecimal(1);
            rank = rank.setScale(2, RoundingMode.HALF_UP);
            Assert.assertEquals((double)0.56, (double)rank.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentRankWithNegativeNumeric() throws Exception {
        String tenantId = PercentileIT.getOrganizationId();
        String tableName = PercentileIT.initATableValues(tenantId, null, PercentileIT.getDefaultSplits(tenantId), null);
        String query = "SELECT PERCENT_RANK(-2) WITHIN GROUP (ORDER BY A_INTEGER ASC) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal rank = rs.getBigDecimal(1);
            rank = rank.setScale(2, RoundingMode.HALF_UP);
            Assert.assertEquals((double)0.0, (double)rank.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentRankDesc() throws Exception {
        String tenantId = PercentileIT.getOrganizationId();
        String tableName = PercentileIT.initATableValues(tenantId, null, PercentileIT.getDefaultSplits(tenantId), null);
        String query = "SELECT PERCENT_RANK(8.9) WITHIN GROUP (ORDER BY A_INTEGER DESC) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal rank = rs.getBigDecimal(1);
            rank = rank.setScale(2, RoundingMode.HALF_UP);
            Assert.assertEquals((double)0.11, (double)rank.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentRankDescOnVARCHARColumn() throws Exception {
        String tenantId = PercentileIT.getOrganizationId();
        String tableName = PercentileIT.initATableValues(tenantId, null, PercentileIT.getDefaultSplits(tenantId), null);
        String query = "SELECT PERCENT_RANK('ba') WITHIN GROUP (ORDER BY A_STRING DESC) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal rank = rs.getBigDecimal(1);
            rank = rank.setScale(2, RoundingMode.HALF_UP);
            Assert.assertEquals((double)0.11, (double)rank.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentRankDescOnDECIMALColumn() throws Exception {
        String tenantId = PercentileIT.getOrganizationId();
        String tableName = PercentileIT.initATableValues(tenantId, null, PercentileIT.getDefaultSplits(tenantId), null);
        String query = "SELECT PERCENT_RANK(2) WITHIN GROUP (ORDER BY x_decimal ASC) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal rank = rs.getBigDecimal(1);
            rank = rank.setScale(2, RoundingMode.HALF_UP);
            Assert.assertEquals((double)0.33, (double)rank.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiplePercentRanksOnSelect() throws Exception {
        String tenantId = PercentileIT.getOrganizationId();
        String tableName = PercentileIT.initATableValues(tenantId, null, PercentileIT.getDefaultSplits(tenantId), null);
        String query = "SELECT PERCENT_RANK(2) WITHIN GROUP (ORDER BY x_decimal ASC), PERCENT_RANK(8.9) WITHIN GROUP (ORDER BY A_INTEGER DESC) FROM " + tableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal rank = rs.getBigDecimal(1);
            rank = rank.setScale(2, RoundingMode.HALF_UP);
            Assert.assertEquals((double)0.33, (double)rank.doubleValue(), (double)0.0);
            rank = rs.getBigDecimal(2);
            rank = rank.setScale(2, RoundingMode.HALF_UP);
            Assert.assertEquals((double)0.11, (double)rank.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentileContOnDescPKColumn() throws Exception {
        String indexDataTableName = PercentileIT.generateUniqueName();
        String fullTableName = "INDEX_TEST." + indexDataTableName;
        String query = "SELECT PERCENTILE_CONT(1) WITHIN GROUP (ORDER BY long_pk ASC) FROM " + fullTableName;
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl());){
            conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + "IMMUTABLE_ROWS=true");
            PercentileIT.populateINDEX_DATA_TABLETable(indexDataTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal percentile = rs.getBigDecimal(1);
            percentile = percentile.setScale(1, RoundingMode.HALF_UP);
            Assert.assertEquals((double)3.0, (double)percentile.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentRankOnDescPKColumn() throws Exception {
        String indexDataTableName = PercentileIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl());){
            String fullTableName = "INDEX_TEST." + indexDataTableName;
            String query = "SELECT PERCENT_RANK(2) WITHIN GROUP (ORDER BY long_pk ASC) FROM " + fullTableName;
            conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + "IMMUTABLE_ROWS=true");
            PercentileIT.populateINDEX_DATA_TABLETable(indexDataTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal rank = rs.getBigDecimal(1);
            rank = rank.setScale(2, RoundingMode.HALF_UP);
            Assert.assertEquals((double)0.67, (double)rank.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPercentileDiscOnDescPKColumn() throws Exception {
        String indexDataTableName = PercentileIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl());){
            String fullTableName = "INDEX_TEST." + indexDataTableName;
            String query = "SELECT PERCENTILE_DISC(0.4) WITHIN GROUP (ORDER BY long_pk DESC) FROM " + fullTableName;
            conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + "IMMUTABLE_ROWS=true");
            PercentileIT.populateINDEX_DATA_TABLETable(indexDataTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            long percentile_disc = rs.getLong(1);
            Assert.assertEquals((long)2L, (long)percentile_disc);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testPercentileOnEmptyTable() throws Exception {
        String tableName = PercentileIT.generateUniqueName();
        PercentileIT.ensureTableCreated(PercentileIT.getUrl(), tableName, "ATABLE", null, null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            Assert.assertFalse((boolean)stmt.execute("DELETE FROM " + tableName));
            String query = "SELECT PERCENTILE_CONT(0.5) WITHIN GROUP (ORDER BY A_INTEGER ASC) FROM " + tableName;
            ResultSet rs = stmt.executeQuery(query);
            Assert.assertNotNull((Object)rs);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getBigDecimal(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateINDEX_DATA_TABLETable(String indexDataTableName) throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Date date = DateUtil.parseDate((String)"2015-01-01 00:00:00");
        try (Connection conn = DriverManager.getConnection(PercentileIT.getUrl(), props);){
            String upsert = "UPSERT INTO INDEX_TEST." + indexDataTableName + " VALUES(?, ?, ?, ?, ?, ?)";
            PreparedStatement stmt = conn.prepareStatement(upsert);
            stmt.setString(1, "varchar1");
            stmt.setString(2, "char1");
            stmt.setInt(3, 1);
            stmt.setLong(4, 1L);
            stmt.setBigDecimal(5, new BigDecimal(1.0));
            stmt.setDate(6, date);
            stmt.executeUpdate();
            stmt.setString(1, "varchar2");
            stmt.setString(2, "char2");
            stmt.setInt(3, 2);
            stmt.setLong(4, 2L);
            stmt.setBigDecimal(5, new BigDecimal(2.0));
            stmt.setDate(6, date);
            stmt.executeUpdate();
            stmt.setString(1, "varchar3");
            stmt.setString(2, "char3");
            stmt.setInt(3, 3);
            stmt.setLong(4, 3L);
            stmt.setBigDecimal(5, new BigDecimal(3.0));
            stmt.setDate(6, date);
            stmt.executeUpdate();
            conn.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String initATableValues(String tenantId1, String tenantId2, byte[][] splits, Date date) throws Exception {
        String tableName = PercentileIT.generateUniqueName();
        PercentileIT.ensureTableCreated(PercentileIT.getUrl(), tableName, "ATABLE", splits, null, null);
        Connection conn = DriverManager.getConnection(PercentileIT.getUrl());
        try {
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + "(    ORGANIZATION_ID,     ENTITY_ID,     A_STRING,     B_STRING,     A_INTEGER,     A_DATE,     X_DECIMAL,     X_LONG,     X_INTEGER,    Y_INTEGER)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            if (tenantId1 != null) {
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00A123122312312");
                stmt.setString(3, "a");
                stmt.setString(4, "b");
                stmt.setInt(5, 1);
                stmt.setDate(6, date);
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00A223122312312");
                stmt.setString(3, "a");
                stmt.setString(4, "c");
                stmt.setInt(5, 2);
                stmt.setDate(6, date == null ? null : new Date(date.getTime() + 86400000L));
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00A323122312312");
                stmt.setString(3, "a");
                stmt.setString(4, "c");
                stmt.setInt(5, 3);
                stmt.setDate(6, date == null ? null : new Date(date.getTime() + 172800000L));
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00A423122312312");
                stmt.setString(3, "a");
                stmt.setString(4, "b");
                stmt.setInt(5, 7);
                stmt.setDate(6, date == null ? null : date);
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00B523122312312");
                stmt.setString(3, "b");
                stmt.setString(4, "c");
                stmt.setInt(5, 6);
                stmt.setDate(6, date == null ? null : new Date(date.getTime() + 86400000L));
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00B623122312312");
                stmt.setString(3, "b");
                stmt.setString(4, "c");
                stmt.setInt(5, 5);
                stmt.setDate(6, date == null ? null : new Date(date.getTime() + 172800000L));
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00B723122312312");
                stmt.setString(3, "b");
                stmt.setString(4, "c");
                stmt.setInt(5, 4);
                stmt.setDate(6, date == null ? null : date);
                stmt.setBigDecimal(7, BigDecimal.valueOf(0.1));
                stmt.setLong(8, 5L);
                stmt.setInt(9, 5);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00B823122312312");
                stmt.setString(3, "b");
                stmt.setString(4, "c");
                stmt.setInt(5, 9);
                stmt.setDate(6, date == null ? null : new Date(date.getTime() + 86400000L));
                stmt.setBigDecimal(7, BigDecimal.valueOf(3.9));
                long l = -2147483649L;
                assert (l < Integer.MIN_VALUE);
                stmt.setLong(8, l);
                stmt.setInt(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId1);
                stmt.setString(2, "00C923122312312");
                stmt.setString(3, "c");
                stmt.setString(4, "c");
                stmt.setInt(5, 8);
                stmt.setDate(6, date == null ? null : new Date(date.getTime() + 172800000L));
                stmt.setBigDecimal(7, BigDecimal.valueOf(3.3));
                l = 0x80000000L;
                assert (l > Integer.MAX_VALUE);
                stmt.setLong(8, l);
                stmt.setInt(9, 3);
                stmt.setInt(10, 300);
                stmt.execute();
            }
            if (tenantId2 != null) {
                stmt.setString(1, tenantId2);
                stmt.setString(2, "00A123122312312");
                stmt.setString(3, "a");
                stmt.setString(4, "b");
                stmt.setInt(5, 1);
                stmt.setDate(6, date);
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
                stmt.setString(1, tenantId2);
                stmt.setString(2, "00A223122312312");
                stmt.setString(3, "a");
                stmt.setString(4, "c");
                stmt.setInt(5, 2);
                stmt.setDate(6, date == null ? null : new Date(date.getTime() + 86400000L));
                stmt.setBigDecimal(7, null);
                stmt.setNull(8, -5);
                stmt.setNull(9, 4);
                stmt.setNull(10, 4);
                stmt.execute();
            }
            conn.commit();
        }
        finally {
            conn.close();
            return tableName;
        }
    }
}

