/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.IndexScrutiny;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ParallelStatsDisabledTest.class})
public class PartialScannerResultsDisabledIT
extends ParallelStatsDisabledIT {
    public static final String TEST_TABLE_DDL = "CREATE TABLE IF NOT EXISTS %s\n(\n    ORGANIZATION_ID CHAR(15) NOT NULL,\n    FEED_ELEMENT_ID CHAR(15) NOT NULL,\n    CONTAINER_ID CHAR(15) NOT NULL,\n    FEED_TYPE VARCHAR(1) NOT NULL, \n    NETWORK_ID CHAR(15) NOT NULL,\n    USER_ID CHAR(15) NOT NULL,\n    CREATED_TIME TIMESTAMP,\n    LAST_UPDATE TIMESTAMP,\n    RELEVANCE_SCORE DOUBLE,\n    FEED_ITEM_TYPE VARCHAR(1),\n    FEED_ELEMENT_TYPE VARCHAR(1),\n    FEED_ELEMENT_IS_SYS_GEN BOOLEAN,\n    FEED_ELEMENT_STATUS VARCHAR(1),\n    FEED_ELEMENT_VISIBILITY VARCHAR(1),\n    PARENT_ID CHAR(15),\n    CREATED_BY CHAR(15),\n    BEST_COMMENT_ID CHAR(15),\n    COMMENT_COUNT INTEGER,\n    CONSTRAINT PK PRIMARY KEY\n    (\n        ORGANIZATION_ID,\n        FEED_ELEMENT_ID,\n        CONTAINER_ID,\n        FEED_TYPE,\n        NETWORK_ID,\n        USER_ID\n    )\n) COLUMN_ENCODED_BYTES = 0";
    public static final String INDEX_1_DDL = "CREATE INDEX IF NOT EXISTS %s\nON %s (\n    NETWORK_ID,\n    CONTAINER_ID,\n    FEED_TYPE,\n    USER_ID,\n    CREATED_TIME DESC,\n    FEED_ELEMENT_ID DESC,\n    CREATED_BY\n)     INCLUDE (\n    FEED_ITEM_TYPE,\n    FEED_ELEMENT_TYPE,\n    FEED_ELEMENT_IS_SYS_GEN,\n    FEED_ELEMENT_STATUS,\n    FEED_ELEMENT_VISIBILITY,\n    PARENT_ID,\n    BEST_COMMENT_ID,\n    COMMENT_COUNT\n)";
    private static final String UPSERT_INTO_DATA_TABLE = "UPSERT INTO %s\n(\n    ORGANIZATION_ID,\n    FEED_ELEMENT_ID,\n    CONTAINER_ID,\n    FEED_TYPE,\n    NETWORK_ID,\n    USER_ID,\n    CREATED_TIME,\n    LAST_UPDATE,\n    FEED_ITEM_TYPE,\n    FEED_ELEMENT_TYPE,\n    FEED_ELEMENT_IS_SYS_GEN,\n    FEED_ELEMENT_STATUS,\n    FEED_ELEMENT_VISIBILITY,\n    PARENT_ID,\n    CREATED_BY,\n    BEST_COMMENT_ID,\n    COMMENT_COUNT\n)VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private String dataTableName;
    private String indexTableName;
    private String schemaName;
    private String dataTableFullName;
    private static String indexTableFullName;
    private static final Logger LOGGER;
    private static Random random;
    private static Random sourceOfRandomness;
    private static AtomicInteger upsertIdCounter;

    @Before
    public void setup() throws Exception {
        this.generateUniqueTableNames();
        PartialScannerResultsDisabledIT.createTestTable(PartialScannerResultsDisabledIT.getUrl(), String.format(TEST_TABLE_DDL, this.dataTableFullName));
        PartialScannerResultsDisabledIT.createTestTable(PartialScannerResultsDisabledIT.getUrl(), String.format(INDEX_1_DDL, this.indexTableName, this.dataTableFullName));
    }

    @Test
    public void testWithEnoughData() throws Exception {
        try (Connection conn = DriverManager.getConnection(PartialScannerResultsDisabledIT.getUrl());){
            PartialScannerResultsDisabledIT.writeSingleBatch(conn, 100, 20, this.dataTableFullName);
            LOGGER.info("Running scrutiny");
            long rowCount = IndexScrutiny.scrutinizeIndex(conn, this.dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)2000L, (long)rowCount);
        }
    }

    @Test
    public void partialResultDuringSelect() throws SQLException {
        String tableName = PartialScannerResultsDisabledIT.generateUniqueName();
        Properties props = new Properties();
        props.setProperty("hbase.client.scanner.max.result.size", "5");
        int numRecords = 10;
        try (Connection conn = DriverManager.getConnection(url, props);){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (PK1 INTEGER NOT NULL PRIMARY KEY, KV1 VARCHAR)");
            String upsert = "UPSERT INTO " + tableName + " VALUES (?, ?)";
            PreparedStatement stmt = conn.prepareStatement(upsert);
            for (int i = 0; i < numRecords; ++i) {
                stmt.setInt(1, i);
                stmt.setString(2, UUID.randomUUID().toString());
                stmt.executeUpdate();
            }
            conn.commit();
            String sql = "SELECT * FROM " + tableName;
            Statement s = conn.createStatement();
            s.setFetchSize(100);
            ResultSet rs = s.executeQuery(sql);
            int count = 0;
            while (rs.next()) {
                if (rs.getString(2) != null) continue;
                Assert.fail((String)"Null value because of partial row scan");
            }
            ++count;
        }
    }

    private static String randString(int length, Random random) {
        return RandomStringUtils.randomAlphabetic((int)length);
    }

    public static void writeSingleBatch(Connection connection, int batchSize, int numBatches, String tableName) throws Exception {
        for (int j = 0; j < numBatches; ++j) {
            try (PreparedStatement statement = connection.prepareStatement(String.format(UPSERT_INTO_DATA_TABLE, tableName));){
                for (int i = 0; i < batchSize; ++i) {
                    int index = 0;
                    String id = "" + upsertIdCounter.getAndIncrement();
                    statement.setString(++index, id);
                    statement.setString(++index, id);
                    statement.setString(++index, id);
                    statement.setString(++index, PartialScannerResultsDisabledIT.randString(1, sourceOfRandomness));
                    statement.setString(++index, PartialScannerResultsDisabledIT.randString(15, sourceOfRandomness));
                    statement.setString(++index, PartialScannerResultsDisabledIT.randString(15, sourceOfRandomness));
                    statement.setTimestamp(++index, new Timestamp(System.currentTimeMillis()));
                    statement.setTimestamp(++index, new Timestamp(System.currentTimeMillis()));
                    statement.setString(++index, PartialScannerResultsDisabledIT.randString(1, sourceOfRandomness));
                    statement.setString(++index, PartialScannerResultsDisabledIT.randString(1, sourceOfRandomness));
                    statement.setBoolean(++index, false);
                    statement.setString(++index, PartialScannerResultsDisabledIT.randString(1, sourceOfRandomness));
                    statement.setString(++index, PartialScannerResultsDisabledIT.randString(1, sourceOfRandomness));
                    statement.setString(++index, PartialScannerResultsDisabledIT.randString(15, sourceOfRandomness));
                    statement.setString(++index, PartialScannerResultsDisabledIT.randString(15, sourceOfRandomness));
                    statement.setString(++index, PartialScannerResultsDisabledIT.randString(15, sourceOfRandomness));
                    statement.setInt(++index, random.nextInt());
                    statement.execute();
                }
                connection.commit();
                continue;
            }
        }
    }

    private void generateUniqueTableNames() {
        this.schemaName = PartialScannerResultsDisabledIT.generateUniqueName();
        this.dataTableName = PartialScannerResultsDisabledIT.generateUniqueName() + "_DATA";
        this.dataTableFullName = SchemaUtil.getTableName((String)this.schemaName, (String)this.dataTableName);
        this.indexTableName = PartialScannerResultsDisabledIT.generateUniqueName() + "_IDX";
        indexTableFullName = SchemaUtil.getTableName((String)this.schemaName, (String)this.indexTableName);
    }

    static {
        LOGGER = LoggerFactory.getLogger(PartialScannerResultsDisabledIT.class);
        random = new Random(1L);
        sourceOfRandomness = new Random(0L);
        upsertIdCounter = new AtomicInteger(1);
    }
}

