/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.query.BaseTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PartialResultServerConfigurationIT {
    private static HBaseTestingUtility hbaseTestUtil;
    private static String zkQuorum;
    private static String url;

    @BeforeClass
    public static synchronized void setUp() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        hbaseTestUtil = new HBaseTestingUtility(conf);
        BaseTest.setUpConfigForMiniCluster(conf);
        conf.setLong("hbase.client.scanner.max.result.size", 5L);
        conf.setLong("hbase.server.scanner.max.result.size", 5L);
        hbaseTestUtil.startMiniCluster();
        zkQuorum = "localhost:" + hbaseTestUtil.getZkCluster().getClientPort();
        url = "jdbc:phoenix+zk:" + zkQuorum;
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
        DriverManager.registerDriver((Driver)((Object)new PhoenixTestDriver()));
    }

    @AfterClass
    public static synchronized void tearDownAfterClass() throws Exception {
        try {
            DriverManager.deregisterDriver((Driver)PhoenixDriver.INSTANCE);
        }
        finally {
            ServerMetadataCacheTestImpl.resetCache();
            hbaseTestUtil.shutdownMiniCluster();
        }
    }

    @Test
    public void testJoinScan() throws Exception {
        String tableNameR = BaseTest.generateUniqueName();
        String tableNameL = BaseTest.generateUniqueName();
        int numRecords = 1000;
        try (Connection conn = DriverManager.getConnection(url);){
            int i;
            conn.createStatement().execute("CREATE TABLE " + tableNameR + " (PK1 INTEGER NOT NULL PRIMARY KEY, KV1 VARCHAR)");
            String upsert = "UPSERT INTO " + tableNameR + " VALUES (?, ?)";
            Random random = new Random();
            PreparedStatement stmt = conn.prepareStatement(upsert);
            for (i = 0; i < numRecords; ++i) {
                stmt.setInt(1, i);
                stmt.setString(2, UUID.randomUUID().toString());
                stmt.executeUpdate();
            }
            stmt.setInt(1, 9999);
            stmt.setString(2, UUID.randomUUID().toString());
            stmt.executeUpdate();
            conn.commit();
            conn.createStatement().execute("CREATE TABLE " + tableNameL + " (PK1 INTEGER NOT NULL PRIMARY KEY, KV1 VARCHAR)");
            upsert = "UPSERT INTO " + tableNameL + " VALUES (?, ?)";
            stmt = conn.prepareStatement(upsert);
            while (i < numRecords * 2) {
                stmt.setInt(1, random.nextInt());
                stmt.setString(2, "KV" + random.nextInt());
                stmt.executeUpdate();
                ++i;
            }
            stmt.setInt(1, 9999);
            stmt.setString(2, UUID.randomUUID().toString());
            stmt.executeUpdate();
            conn.commit();
            String sql = "SELECT * FROM " + tableNameR + " A JOIN " + tableNameL + " B ON A.PK1 = B.PK1";
            Statement s = conn.createStatement();
            s.setFetchSize(2);
            ResultSet rs = s.executeQuery(sql);
            int count = 0;
            while (rs.next()) {
                if (rs.getString(2) == null || rs.getString(4) == null) {
                    Assert.fail((String)"Null value because of partial result from scan");
                }
                ++count;
            }
            Assert.assertEquals((long)count, (long)1L);
        }
    }
}

