/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.index.IndexTestUtil;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.hbase.index.Indexer;
import org.apache.phoenix.index.GlobalIndexChecker;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.IndexUpgradeTool;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
@Category(value={NeedsOwnMiniClusterTest.class})
public class ParameterizedIndexUpgradeToolIT
extends BaseTest {
    private static final String[] INDEXES_LIST = new String[8];
    private static final String[] INDEXES_LIST_NAMESPACE = new String[8];
    private static final String[] INDEXES_LIST_SIMPLIFIED = new String[1];
    private static final String[] INDEXES_LIST_NAMESPACE_SIMPLIFIED = new String[1];
    private static final String[] TRANSACTIONAL_INDEXES_LIST = new String[2];
    private static final String[] TABLE_LIST = new String[4];
    private static final String[] TABLE_LIST_NAMESPACE = new String[4];
    private static final String[] TABLE_LIST_SIMPLIFIED = new String[1];
    private static final String[] TABLE_LIST_NAMESPACE_SIMPLIFIED = new String[1];
    private static final String[] TRANSACTIONAL_TABLE_LIST = new String[1];
    private static String INPUT_LIST = "";
    private Path tmpDir;
    private static Map<String, String> serverProps = Maps.newHashMapWithExpectedSize((int)1);
    private static Map<String, String> clientProps = Maps.newHashMapWithExpectedSize((int)1);
    private final boolean mutable;
    private final boolean upgrade;
    private final boolean isNamespaceEnabled;
    private final boolean rebuild;
    private StringBuilder optionsBuilder;
    private String tableDDLOptions;
    private Connection conn;
    private Connection connTenant;
    private Admin admin;
    private IndexUpgradeTool iut;
    private static String systemTmpDir = System.getProperty("java.io.tmpdir");
    @Mock
    private IndexTool indexToolMock;
    @Captor
    private ArgumentCaptor<String[]> argCapture;

    @BeforeClass
    public static synchronized void saveTmp() throws Exception {
        systemTmpDir = System.getProperty("java.io.tmpdir");
    }

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.optionsBuilder = new StringBuilder();
        this.setClusterProperties();
        ParameterizedIndexUpgradeToolIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
        this.conn = DriverManager.getConnection(ParameterizedIndexUpgradeToolIT.getUrl(), new Properties());
        this.conn.setAutoCommit(true);
        String tenantId = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("TenantId", tenantId);
        this.connTenant = DriverManager.getConnection(ParameterizedIndexUpgradeToolIT.getUrl(), props);
        ConnectionQueryServices queryServices = this.conn.unwrap(PhoenixConnection.class).getQueryServices();
        this.admin = queryServices.getAdmin();
        if (!this.mutable) {
            this.optionsBuilder.append(" IMMUTABLE_ROWS=true");
        }
        this.tableDDLOptions = this.optionsBuilder.toString();
        this.tmpDir = Files.createTempDirectory(ParameterizedIndexUpgradeToolIT.class.getCanonicalName(), new FileAttribute[0]);
    }

    private void setClusterProperties() {
        if (Boolean.toString(this.upgrade).equals(clientProps.get("phoenix.index.region.observer.enabled")) || Boolean.toString(!this.isNamespaceEnabled).equals(serverProps.get("phoenix.schema.isNamespaceMappingEnabled"))) {
            ParameterizedIndexUpgradeToolIT.tearDownMiniCluster(1);
            System.setProperty("java.io.tmpdir", systemTmpDir);
        }
        clientProps.put("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(this.isNamespaceEnabled));
        clientProps.put("phoenix.schema.mapSystemTablesToNamespace", Boolean.toString(this.isNamespaceEnabled));
        clientProps.put("phoenix.schema.dropMetaData", Boolean.toString(true));
        serverProps.putAll(clientProps);
        clientProps.put("phoenix.index.region.observer.enabled", Boolean.toString(!this.upgrade));
    }

    private void prepareFullSetup() throws SQLException, IOException {
        String transactIndex;
        String transactTable;
        String multiTenantTable;
        String mockTableThree;
        String mockTableTwo;
        String mockTableOne;
        this.clearOldTableNames();
        ParameterizedIndexUpgradeToolIT.TABLE_LIST[0] = mockTableOne = "TEST." + ParameterizedIndexUpgradeToolIT.generateUniqueName();
        ParameterizedIndexUpgradeToolIT.TABLE_LIST[1] = mockTableTwo = "TEST1." + ParameterizedIndexUpgradeToolIT.generateUniqueName();
        ParameterizedIndexUpgradeToolIT.TABLE_LIST[2] = mockTableThree = "TEST." + ParameterizedIndexUpgradeToolIT.generateUniqueName();
        ParameterizedIndexUpgradeToolIT.TABLE_LIST[3] = multiTenantTable = "TEST." + ParameterizedIndexUpgradeToolIT.generateUniqueName();
        INPUT_LIST = StringUtils.join((Object[])TABLE_LIST, (String)",");
        if (this.isNamespaceEnabled) {
            ParameterizedIndexUpgradeToolIT.TABLE_LIST_NAMESPACE[0] = mockTableOne.replace(".", ":");
            ParameterizedIndexUpgradeToolIT.TABLE_LIST_NAMESPACE[1] = mockTableTwo.replace(".", ":");
            ParameterizedIndexUpgradeToolIT.TABLE_LIST_NAMESPACE[2] = mockTableThree.replace(".", ":");
            ParameterizedIndexUpgradeToolIT.TABLE_LIST_NAMESPACE[3] = multiTenantTable.replace(".", ":");
            this.conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS TEST");
            this.conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS TEST1");
        }
        this.conn.createStatement().execute("CREATE TABLE " + mockTableOne + " (id bigint NOT NULL PRIMARY KEY, a.name varchar, sal bigint, address varchar)" + this.tableDDLOptions);
        this.conn.createStatement().execute("CREATE TABLE " + mockTableTwo + " (id bigint NOT NULL PRIMARY KEY, name varchar, city varchar, phone bigint)" + this.tableDDLOptions);
        this.conn.createStatement().execute("CREATE TABLE " + mockTableThree + " (id bigint NOT NULL PRIMARY KEY, name varchar, age bigint)" + this.tableDDLOptions);
        String createTblStr = "CREATE TABLE " + multiTenantTable + " (TENANT_ID VARCHAR(15) NOT NULL,ID INTEGER NOT NULL, NAME VARCHAR, CONSTRAINT PK_1 PRIMARY KEY (TENANT_ID, ID)) MULTI_TENANT=true";
        this.conn.createStatement().execute(createTblStr);
        ParameterizedIndexUpgradeToolIT.TRANSACTIONAL_TABLE_LIST[0] = transactTable = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        this.conn.createStatement().execute("CREATE TABLE " + transactTable + " (id bigint NOT NULL PRIMARY KEY, a.name varchar, sal bigint, address varchar)  TRANSACTIONAL=true, TRANSACTION_PROVIDER='OMID' " + (this.tableDDLOptions.trim().length() > 0 ? "," : "") + this.tableDDLOptions);
        String mockOneViewOne = "TEST." + ParameterizedIndexUpgradeToolIT.generateUniqueName();
        String mockOneViewTwo = "TEST." + ParameterizedIndexUpgradeToolIT.generateUniqueName();
        String mockTwoViewOne = "TEST1." + ParameterizedIndexUpgradeToolIT.generateUniqueName();
        String transactView = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        this.conn.createStatement().execute("CREATE VIEW " + mockOneViewOne + " (view_column varchar) AS SELECT * FROM " + mockTableOne + " WHERE a.name = 'a'");
        this.conn.createStatement().execute("CREATE VIEW " + mockOneViewTwo + " (view_column varchar, zip varchar) AS SELECT * FROM " + mockTableOne + " WHERE a.name = 'a'");
        this.conn.createStatement().execute("CREATE VIEW " + mockTwoViewOne + " (view_column varchar, state varchar) AS SELECT * FROM " + mockTableTwo + " WHERE name = 'c'");
        this.conn.createStatement().execute("CREATE VIEW " + transactView + " (view_column varchar, state varchar) AS SELECT * FROM " + transactTable + " WHERE name = 'c'");
        String indexOneMockOneViewOne = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        String indexTwoMockOneViewTwo = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        String indexOneMockTwoViewTwo = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        String indexThreeMockOneViewOne = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        String transactViewIndex = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        ParameterizedIndexUpgradeToolIT.INDEXES_LIST[6] = MetaDataUtil.getViewIndexPhysicalName((String)mockTableOne);
        ParameterizedIndexUpgradeToolIT.INDEXES_LIST[7] = MetaDataUtil.getViewIndexPhysicalName((String)mockTableTwo);
        if (this.isNamespaceEnabled) {
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST_NAMESPACE[6] = MetaDataUtil.getViewIndexPhysicalName((String)TABLE_LIST_NAMESPACE[0]);
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST_NAMESPACE[7] = MetaDataUtil.getViewIndexPhysicalName((String)TABLE_LIST_NAMESPACE[1]);
        }
        this.conn.createStatement().execute("CREATE INDEX " + indexOneMockOneViewOne + " ON " + mockOneViewOne + " (view_column)");
        this.conn.createStatement().execute("CREATE INDEX " + indexTwoMockOneViewTwo + " ON " + mockOneViewTwo + " (zip)");
        this.conn.createStatement().execute("CREATE INDEX " + indexOneMockTwoViewTwo + " ON " + mockTwoViewOne + " (state, city)");
        this.conn.createStatement().execute("CREATE INDEX " + indexThreeMockOneViewOne + " ON " + mockOneViewOne + " (view_column)");
        this.conn.createStatement().execute("CREATE INDEX " + transactViewIndex + " ON " + transactView + " (view_column)");
        String indexOneMockOne = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        String indexTwoMockOne = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        String indexOneMockTwo = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        String indexTwoMockTwo = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        String indexThreeMockTwo = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        String indexThreeMockThree = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        ParameterizedIndexUpgradeToolIT.TRANSACTIONAL_INDEXES_LIST[0] = transactIndex = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        ParameterizedIndexUpgradeToolIT.TRANSACTIONAL_INDEXES_LIST[1] = MetaDataUtil.getViewIndexPhysicalName((String)transactTable);
        if (this.isNamespaceEnabled) {
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST_NAMESPACE[0] = "TEST:" + indexOneMockOne;
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST_NAMESPACE[1] = "TEST:" + indexTwoMockOne;
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST_NAMESPACE[2] = "TEST1:" + indexOneMockTwo;
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST_NAMESPACE[3] = "TEST1:" + indexTwoMockTwo;
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST_NAMESPACE[4] = "TEST1:" + indexThreeMockTwo;
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST_NAMESPACE[5] = "TEST:" + indexThreeMockThree;
        } else {
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST[0] = "TEST." + indexOneMockOne;
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST[1] = "TEST." + indexTwoMockOne;
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST[2] = "TEST1." + indexOneMockTwo;
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST[3] = "TEST1." + indexTwoMockTwo;
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST[4] = "TEST1." + indexThreeMockTwo;
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST[5] = "TEST." + indexThreeMockThree;
        }
        this.conn.createStatement().execute("CREATE INDEX " + indexOneMockOne + " ON " + mockTableOne + " (sal, a.name)");
        this.conn.createStatement().execute("CREATE INDEX " + indexTwoMockOne + " ON " + mockTableOne + " (a.name)");
        this.conn.createStatement().execute("CREATE INDEX " + indexOneMockTwo + " ON " + mockTableTwo + " (city)");
        this.conn.createStatement().execute("CREATE INDEX " + indexTwoMockTwo + " ON " + mockTableTwo + " (phone)");
        this.conn.createStatement().execute("CREATE INDEX " + indexThreeMockTwo + " ON " + mockTableTwo + " (name)");
        this.conn.createStatement().execute("CREATE INDEX " + indexThreeMockThree + " ON " + mockTableThree + " (age, name)");
        this.conn.createStatement().execute("CREATE INDEX " + transactIndex + " ON " + transactTable + " (sal)");
        String tenantView = "TEST." + ParameterizedIndexUpgradeToolIT.generateUniqueName();
        String tenantViewIndex = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        this.connTenant.createStatement().execute("CREATE VIEW " + tenantView + " AS SELECT * FROM " + multiTenantTable);
        this.connTenant.createStatement().execute("CREATE INDEX " + tenantViewIndex + " ON " + tenantView + " (NAME)");
        this.conn.createStatement().execute("ALTER INDEX " + indexTwoMockOneViewTwo + " ON " + mockOneViewOne + " DISABLE");
        this.connTenant.createStatement().execute("ALTER INDEX " + tenantViewIndex + " ON " + tenantView + " DISABLE");
        this.conn.createStatement().execute("ALTER INDEX " + indexTwoMockOne + " ON " + mockTableOne + " DISABLE");
        this.iut = new IndexUpgradeTool(this.upgrade ? "upgrade" : "rollback", INPUT_LIST, null, Files.createTempFile(this.tmpDir, "index_upgrade_", null, new FileAttribute[0]).toString(), true, this.indexToolMock, this.rebuild);
        this.iut.setConf(ParameterizedIndexUpgradeToolIT.getUtility().getConfiguration());
        this.iut.setTest(true);
    }

    private void clearOldTableNames() {
        Arrays.fill(TABLE_LIST, null);
        Arrays.fill(TABLE_LIST_NAMESPACE, null);
        Arrays.fill(TABLE_LIST_SIMPLIFIED, null);
        Arrays.fill(TABLE_LIST_NAMESPACE_SIMPLIFIED, null);
        Arrays.fill(INDEXES_LIST, null);
        Arrays.fill(INDEXES_LIST_NAMESPACE, null);
        Arrays.fill(INDEXES_LIST_SIMPLIFIED, null);
        Arrays.fill(INDEXES_LIST_NAMESPACE_SIMPLIFIED, null);
        Arrays.fill(TRANSACTIONAL_INDEXES_LIST, null);
        Arrays.fill(TRANSACTIONAL_TABLE_LIST, null);
    }

    private void prepareSimplifiedSetup() throws SQLException, IOException {
        String mockTableOne;
        this.clearOldTableNames();
        INPUT_LIST = mockTableOne = "TEST." + ParameterizedIndexUpgradeToolIT.generateUniqueName();
        if (this.isNamespaceEnabled) {
            this.conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS TEST");
            this.conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS TEST1");
            ParameterizedIndexUpgradeToolIT.TABLE_LIST_NAMESPACE_SIMPLIFIED[0] = mockTableOne.replace(".", ":");
        } else {
            ParameterizedIndexUpgradeToolIT.TABLE_LIST_SIMPLIFIED[0] = mockTableOne;
        }
        this.conn.createStatement().execute("CREATE TABLE " + mockTableOne + " (id bigint NOT NULL PRIMARY KEY, a.name varchar, sal bigint, address varchar)" + this.tableDDLOptions);
        this.conn.commit();
        String indexOneMockOne = ParameterizedIndexUpgradeToolIT.generateUniqueName();
        if (this.isNamespaceEnabled) {
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST_NAMESPACE_SIMPLIFIED[0] = "TEST:" + indexOneMockOne;
        } else {
            ParameterizedIndexUpgradeToolIT.INDEXES_LIST_SIMPLIFIED[0] = "TEST." + indexOneMockOne;
        }
        this.conn.createStatement().execute("CREATE INDEX " + indexOneMockOne + " ON " + mockTableOne + " (sal, a.name)");
        this.conn.commit();
        this.iut = new IndexUpgradeTool(this.upgrade ? "upgrade" : "rollback", INPUT_LIST, null, Files.createTempFile(this.tmpDir, "index_upgrade_", null, new FileAttribute[0]).toString(), true, this.indexToolMock, this.rebuild);
        this.iut.setConf(ParameterizedIndexUpgradeToolIT.getUtility().getConfiguration());
        this.iut.setTest(true);
    }

    private void validate(boolean pre, boolean isSimplified) throws IOException {
        String[] tableList;
        String[] indexList;
        if (isSimplified) {
            if (this.isNamespaceEnabled) {
                indexList = INDEXES_LIST_NAMESPACE_SIMPLIFIED;
                tableList = TABLE_LIST_NAMESPACE_SIMPLIFIED;
            } else {
                indexList = INDEXES_LIST_SIMPLIFIED;
                tableList = TABLE_LIST_SIMPLIFIED;
            }
        } else if (this.isNamespaceEnabled) {
            indexList = INDEXES_LIST_NAMESPACE;
            tableList = TABLE_LIST_NAMESPACE;
        } else {
            indexList = INDEXES_LIST;
            tableList = TABLE_LIST;
        }
        if (pre) {
            if (this.upgrade) {
                this.checkOldIndexingCoprocessors(indexList, tableList);
            } else {
                this.checkNewIndexingCoprocessors(indexList, tableList);
            }
        } else if (this.upgrade) {
            this.checkNewIndexingCoprocessors(indexList, tableList);
        } else {
            this.checkOldIndexingCoprocessors(indexList, tableList);
        }
    }

    private void checkNewIndexingCoprocessors(String[] indexList, String[] tableList) throws IOException {
        TableDescriptor indexDesc;
        if (this.mutable) {
            for (String table : tableList) {
                if (table == null) continue;
                indexDesc = this.admin.getDescriptor(TableName.valueOf((String)table));
                Assert.assertTrue((String)("Can't find IndexRegionObserver for " + table), (boolean)indexDesc.hasCoprocessor(IndexRegionObserver.class.getName()));
                Assert.assertFalse((String)("Found Indexer on " + table), (boolean)indexDesc.hasCoprocessor(Indexer.class.getName()));
                IndexTestUtil.assertCoprocConfig(indexDesc, IndexRegionObserver.class.getName(), "|org.apache.phoenix.hbase.index.IndexRegionObserver|805306366|index.builder=org.apache.phoenix.index.PhoenixIndexBuilder,org.apache.hadoop.hbase.index.codec.class=org.apache.phoenix.index.PhoenixIndexCodec");
            }
        }
        for (String index : indexList) {
            if (index == null) continue;
            indexDesc = this.admin.getDescriptor(TableName.valueOf((String)index));
            Assert.assertTrue((String)("Couldn't find GlobalIndexChecker on " + index), (boolean)indexDesc.hasCoprocessor(GlobalIndexChecker.class.getName()));
            IndexTestUtil.assertCoprocConfig(indexDesc, GlobalIndexChecker.class.getName(), "|org.apache.phoenix.index.GlobalIndexChecker|805306365|");
        }
        for (String index : TRANSACTIONAL_INDEXES_LIST) {
            if (index == null) continue;
            Assert.assertFalse((String)("Found GlobalIndexChecker on transactional index " + index), (boolean)this.admin.getDescriptor(TableName.valueOf((String)index)).hasCoprocessor(GlobalIndexChecker.class.getName()));
        }
        for (String table : TRANSACTIONAL_TABLE_LIST) {
            if (table == null) continue;
            Assert.assertFalse((String)"Found IndexRegionObserver on transactional table", (boolean)this.admin.getDescriptor(TableName.valueOf((String)table)).hasCoprocessor(IndexRegionObserver.class.getName()));
        }
    }

    private void checkOldIndexingCoprocessors(String[] indexList, String[] tableList) throws IOException {
        if (this.mutable) {
            for (String table : tableList) {
                TableDescriptor indexDesc = this.admin.getDescriptor(TableName.valueOf((String)table));
                Assert.assertTrue((String)("Can't find Indexer for " + table), (boolean)indexDesc.hasCoprocessor(Indexer.class.getName()));
                Assert.assertFalse((String)("Found IndexRegionObserver on " + table), (boolean)indexDesc.hasCoprocessor(IndexRegionObserver.class.getName()));
                IndexTestUtil.assertCoprocConfig(indexDesc, Indexer.class.getName(), "|org.apache.phoenix.hbase.index.Indexer|805306366|index.builder=org.apache.phoenix.index.PhoenixIndexBuilder,org.apache.hadoop.hbase.index.codec.class=org.apache.phoenix.index.PhoenixIndexCodec");
            }
        }
        for (String index : indexList) {
            Assert.assertFalse((String)("Found GlobalIndexChecker on " + index), (boolean)this.admin.getDescriptor(TableName.valueOf((String)index)).hasCoprocessor(GlobalIndexChecker.class.getName()));
        }
    }

    @Parameterized.Parameters(name="IndexUpgradeToolIT_mutable={0},upgrade={1},isNamespaceEnabled={2}, rebuild={3}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({false, false, true, false}, {true, false, false, true}, {false, true, false, false}, {true, true, true, true});
    }

    public ParameterizedIndexUpgradeToolIT(boolean mutable, boolean upgrade, boolean isNamespaceEnabled, boolean rebuild) {
        this.mutable = mutable;
        this.upgrade = upgrade;
        this.isNamespaceEnabled = isNamespaceEnabled;
        this.rebuild = rebuild;
    }

    @Test
    public void testNonDryRunToolWithMultiTables() throws Exception {
        this.prepareFullSetup();
        this.validate(true, false);
        this.iut.setDryRun(false);
        this.iut.setLogFile(null);
        this.iut.prepareToolSetup();
        this.iut.executeTool();
        this.validate(false, false);
        if (!this.mutable) {
            Assert.assertEquals((String)"Index upgrade tool didn't wait for client cache to expire for immutable tables", (Object)true, (Object)this.iut.getIsWaitComplete());
        } else {
            Assert.assertEquals((String)"Index upgrade tool waited for client cache to expire for mutable tables", (Object)false, (Object)this.iut.getIsWaitComplete());
        }
        if (this.upgrade && this.rebuild) {
            ((IndexTool)Mockito.verify((Object)this.indexToolMock, (VerificationMode)Mockito.times((int)11))).run((String[])this.argCapture.capture());
        } else {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexToolMock});
        }
    }

    @Test
    public void testDryRunAndFailures() throws Exception {
        this.prepareFullSetup();
        this.validate(true, false);
        this.iut.setInputTables("TEST3.TABLE_NOT_PRESENT");
        this.iut.prepareToolSetup();
        int status = this.iut.executeTool();
        Assert.assertEquals((long)-1L, (long)status);
        this.validate(true, false);
        Path inputPath = Paths.get(this.tmpDir.toString(), "input_file_index_upgrade.csv");
        BufferedWriter writer = new BufferedWriter(new FileWriter(inputPath.toFile()));
        writer.write(INPUT_LIST);
        writer.close();
        this.iut.setInputTables(null);
        this.iut.setInputFile(inputPath.toString());
        this.iut.prepareToolSetup();
        status = this.iut.executeTool();
        Assert.assertEquals((long)0L, (long)status);
        this.validate(true, false);
        if (this.upgrade && !this.isNamespaceEnabled) {
            this.conn.createStatement().execute("CREATE TABLE TEST.NEW_TABLE (id bigint NOT NULL PRIMARY KEY, a.name varchar, sal bigint, address varchar)" + this.tableDDLOptions);
            this.iut.setInputTables("TEST.NEW_TABLE");
            this.iut.prepareToolSetup();
            status = this.iut.executeTool();
            Assert.assertEquals((long)0L, (long)status);
            this.conn.createStatement().execute("DROP TABLE TEST.NEW_TABLE");
        }
    }

    @Test
    public void testRollbackAfterFailure() throws Exception {
        this.prepareSimplifiedSetup();
        this.validate(true, true);
        if (this.upgrade) {
            this.iut.setFailUpgradeTask(true);
        } else {
            this.iut.setFailDowngradeTask(true);
        }
        this.iut.prepareToolSetup();
        int status = this.iut.executeTool();
        Assert.assertEquals((long)-1L, (long)status);
        this.validate(true, true);
    }

    @Test
    public void testTableReenableAfterDoubleFailure() throws Exception {
        this.prepareSimplifiedSetup();
        this.validate(true, true);
        this.iut.setFailUpgradeTask(true);
        this.iut.setFailDowngradeTask(true);
        this.iut.prepareToolSetup();
        try {
            this.iut.executeTool();
        }
        catch (RuntimeException e) {
            this.validateTablesEnabled(INPUT_LIST);
            return;
        }
        Assert.fail((String)"Should have thrown an exception!");
    }

    private void validateTablesEnabled(String inputList) throws IOException, SQLException {
        Admin admin = this.conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
        String[] tableNames = inputList.split(",");
        Assert.assertNotNull((Object)tableNames);
        Assert.assertTrue((tableNames.length > 0 ? 1 : 0) != 0);
        for (String tableName : tableNames) {
            String physicalTableName = SchemaUtil.getPhysicalHBaseTableName((String)SchemaUtil.getSchemaNameFromFullName((String)tableName), (String)SchemaUtil.getTableNameFromFullName((String)tableName), (boolean)this.isNamespaceEnabled).getString();
            Assert.assertTrue((boolean)admin.isTableEnabled(TableName.valueOf((String)physicalTableName)));
        }
    }
}

