/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionStatesCount;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.phoenix.iterate.ScanningResultPostDummyResultCaller;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.QueryBuilder;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParallelStatsDisabledWithRegionMovesIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelStatsDisabledWithRegionMovesIT.class);
    protected static boolean hasTestStarted = false;
    protected static int countOfDummyResults = 0;
    protected static final Set<String> TABLE_NAMES = new HashSet<String>();

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        props.put("phoenix.server.page.size.ms", Long.toString(0L));
        props.put("phoenix.tests.minicluster.numregionservers", String.valueOf(2));
        props.put("hbase.client.scanner.max.result.size", String.valueOf(1));
        props.put("phoenix.scanning.result.post.dummy.process", TestScanningResultPostDummyResultCaller.class.getName());
        ParallelStatsDisabledWithRegionMovesIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @AfterClass
    public static synchronized void freeResources() throws Exception {
        BaseTest.freeResourcesIfBeyondThreshold();
    }

    protected static void moveRegionsOfTable(String tableName) throws IOException {
        try (AsyncConnection asyncConnection = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)ParallelStatsDisabledWithRegionMovesIT.getUtility().getConfiguration()).get();){
            AsyncAdmin admin = asyncConnection.getAdmin();
            ArrayList servers = new ArrayList((Collection)admin.getRegionServers().get());
            ServerName server1 = (ServerName)servers.get(0);
            ServerName server2 = (ServerName)servers.get(1);
            List regionsOnServer1 = (List)admin.getRegions(server1).get();
            List regionsOnServer2 = (List)admin.getRegions(server2).get();
            regionsOnServer1.forEach(regionInfo -> {
                if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                    try {
                        for (int i = 0; i < 2; ++i) {
                            RegionStatesCount regionStatesCount = (RegionStatesCount)((ClusterMetrics)admin.getClusterMetrics().get()).getTableRegionStatesCount().get(TableName.valueOf((String)tableName));
                            if (regionStatesCount.getRegionsInTransition() == 0 && regionStatesCount.getOpenRegions() == regionStatesCount.getTotalRegions()) {
                                LOGGER.info("Moving region {} to {}", (Object)regionInfo.getRegionNameAsString(), (Object)server2);
                                admin.move(regionInfo.getEncodedNameAsBytes(), server2).get(3L, TimeUnit.SECONDS);
                                break;
                            }
                            LOGGER.info("Table {} has some region(s) in RIT or not online", (Object)tableName);
                        }
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        LOGGER.error("Something went wrong", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
            regionsOnServer2.forEach(regionInfo -> {
                if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                    try {
                        for (int i = 0; i < 2; ++i) {
                            RegionStatesCount regionStatesCount = (RegionStatesCount)((ClusterMetrics)admin.getClusterMetrics().get()).getTableRegionStatesCount().get(TableName.valueOf((String)tableName));
                            if (regionStatesCount.getRegionsInTransition() == 0 && regionStatesCount.getOpenRegions() == regionStatesCount.getTotalRegions()) {
                                admin.move(regionInfo.getEncodedNameAsBytes(), server1).get(3L, TimeUnit.SECONDS);
                                LOGGER.info("Moving region {} to {}", (Object)regionInfo.getRegionNameAsString(), (Object)server1);
                                break;
                            }
                            LOGGER.info("Table {} has some region(s) in RIT or not online", (Object)tableName);
                        }
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        LOGGER.error("Something went wrong", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Something went wrong..", (Throwable)e);
        }
    }

    protected static void splitAllRegionsOfTable(String tableName, int splitAtRow) {
        try (AsyncConnection asyncConnection = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)ParallelStatsDisabledWithRegionMovesIT.getUtility().getConfiguration()).get();){
            AsyncAdmin admin = asyncConnection.getAdmin();
            List regionsOfTable = (List)admin.getRegions(TableName.valueOf((String)tableName)).get();
            regionsOfTable.forEach(regionInfo -> {
                if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                    try {
                        for (int i = 0; i < 5; ++i) {
                            RegionStatesCount regionStatesCount = (RegionStatesCount)((ClusterMetrics)admin.getClusterMetrics().get()).getTableRegionStatesCount().get(TableName.valueOf((String)tableName));
                            if (regionStatesCount.getRegionsInTransition() == 0 && regionStatesCount.getOpenRegions() == regionStatesCount.getTotalRegions()) {
                                byte[] splitPoint;
                                try (Table table = utility.getConnection().getTable(TableName.valueOf((String)tableName));
                                     ResultScanner resultScanner = table.getScanner(new Scan());){
                                    Result result = null;
                                    for (int rowCount = 0; rowCount < splitAtRow; ++rowCount) {
                                        result = resultScanner.next();
                                        if (result != null) continue;
                                        LOGGER.info("Table {} has only {} rows, splitting at row number {} not possible", new Object[]{tableName, rowCount, splitAtRow});
                                        return;
                                    }
                                    splitPoint = result == null ? null : ByteUtil.closestPossibleRowAfter((byte[])result.getRow());
                                }
                                LOGGER.info("Splitting region {}", (Object)regionInfo.getRegionNameAsString());
                                admin.flushRegion(regionInfo.getRegionName()).get(3L, TimeUnit.SECONDS);
                                admin.splitRegion(regionInfo.getRegionName(), splitPoint).get(4L, TimeUnit.SECONDS);
                                break;
                            }
                            LOGGER.info("Table {} has some region(s) in RIT or not online", (Object)tableName);
                            Thread.sleep(1000L);
                        }
                    }
                    catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
                        LOGGER.error("Something went wrong", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Something went wrong..", (Throwable)e);
        }
    }

    protected ResultSet executeQueryThrowsException(Connection conn, QueryBuilder queryBuilder, String expectedPhoenixExceptionMsg, String expectedSparkExceptionMsg) {
        ResultSet rs = null;
        try {
            rs = this.executeQuery(conn, queryBuilder);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(expectedPhoenixExceptionMsg));
        }
        return rs;
    }

    public static void validateQueryPlan(Connection conn, QueryBuilder queryBuilder, String expectedPhoenixPlan, String expectedSparkPlan) throws SQLException {
        if (StringUtils.isNotBlank((CharSequence)expectedPhoenixPlan)) {
            ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + queryBuilder.build());
            Assert.assertEquals((Object)expectedPhoenixPlan, (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        }
    }

    protected static void assertResultSetWithRegionMoves(ResultSet rs, Object[][] rows, String tableName) throws Exception {
        for (int rowIndex = 0; rowIndex < rows.length; ++rowIndex) {
            Assert.assertTrue((String)("rowIndex:[" + rowIndex + "] rs.next error!"), (boolean)rs.next());
            if (rowIndex == 0) {
                ParallelStatsDisabledWithRegionMovesIT.moveRegionsOfTable(tableName);
            }
            for (int columnIndex = 1; columnIndex <= rows[rowIndex].length; ++columnIndex) {
                Object realValue = rs.getObject(columnIndex);
                Object expectedValue = rows[rowIndex][columnIndex - 1];
                if (realValue == null) {
                    Assert.assertNull((String)("rowIndex:[" + rowIndex + "],columnIndex:[" + columnIndex + "]"), (Object)expectedValue);
                    continue;
                }
                Assert.assertEquals((String)("rowIndex:[" + rowIndex + "],columnIndex:[" + columnIndex + "]"), (Object)expectedValue, (Object)realValue);
            }
        }
        Assert.assertFalse((boolean)rs.next());
    }

    protected static class TestScanningResultPostDummyResultCaller
    extends ScanningResultPostDummyResultCaller {
        protected TestScanningResultPostDummyResultCaller() {
        }

        public void postDummyProcess() {
            if (hasTestStarted && countOfDummyResults++ % 3 == 0 && (countOfDummyResults < 17 || countOfDummyResults > 28 && countOfDummyResults < 40)) {
                LOGGER.info("Moving regions of tables {}. current count of dummy results: {}", TABLE_NAMES, (Object)countOfDummyResults);
                TABLE_NAMES.forEach(table -> {
                    try {
                        ParallelStatsDisabledWithRegionMovesIT.moveRegionsOfTable(table);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to move regions of table: {}", table);
                    }
                });
            }
        }
    }
}

