/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.end2end.BaseOwnClusterIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.mapreduce.OrphanViewTool;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class OrphanViewToolIT
extends BaseOwnClusterIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrphanViewToolIT.class);
    private final boolean isMultiTenant;
    private static final long fanout = 2L;
    private static final long childCount = 2L;
    private static final long grandChildCount = 4L;
    private static final long grandGrandChildCount = 8L;
    private static String tmpDir;
    private static String viewFileName;
    private static String physicalLinkFileName;
    private static String parentLinkFileName;
    private static String childLinkFileName;
    protected static String SCHEMA1;
    protected static String SCHEMA2;
    protected static String SCHEMA3;
    protected static String SCHEMA4;
    private final String TENANT_SPECIFIC_URL = OrphanViewToolIT.getUrl() + ';' + "TenantId" + "=tenant";
    private static final String createBaseTableFirstPartDDL = "CREATE TABLE IF NOT EXISTS %s";
    private static final String createBaseTableSecondPartDDL = "(%s PK2 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR  CONSTRAINT NAME_PK PRIMARY KEY (%s PK2)) %s";
    private static final String createBaseTableIndexDDL = "CREATE INDEX %s ON %s (V1)";
    private static final String deleteTableRows;
    private static final String createViewDDL = "CREATE VIEW %s AS SELECT * FROM %s";
    private static final String countAllViewsQuery;
    private static final String countViewsQuery;
    private static final String deleteViewRows;
    private static final String countChildLinksQuery;
    private static final String deleteChildLinks;
    private static final String countParentLinksQuery;
    private static final String deleteParentLinks;
    private static final String countPhysicalLinksQuery;
    private static final String deletePhysicalLinks;
    private static final String deleteSchemaRows = "DELETE FROM %s WHERE TABLE_SCHEM %s";

    public OrphanViewToolIT(boolean isMultiTenant) {
        this.isMultiTenant = isMultiTenant;
    }

    @Parameterized.Parameters(name="OrphanViewToolIT_multiTenant={0}")
    public static synchronized Collection<Boolean> data() {
        return Arrays.asList(false, true);
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        OrphanViewToolIT.setUpTestDriver(ReadOnlyProps.EMPTY_PROPS);
        tmpDir = Files.createTempDirectory(OrphanViewToolIT.class.getCanonicalName(), new FileAttribute[0]).toString();
        viewFileName = Paths.get(tmpDir, OrphanViewTool.fileName[0]).toString();
        physicalLinkFileName = Paths.get(tmpDir, OrphanViewTool.fileName[1]).toString();
        parentLinkFileName = Paths.get(tmpDir, OrphanViewTool.fileName[2]).toString();
        childLinkFileName = Paths.get(tmpDir, OrphanViewTool.fileName[3]).toString();
    }

    @AfterClass
    public static synchronized void cleanUp() throws Exception {
        boolean refCountLeaked = OrphanViewToolIT.isAnyStoreRefCountLeaked();
        for (int i = 0; i < 4; ++i) {
            File file = Paths.get(tmpDir, OrphanViewTool.fileName[i]).toFile();
            if (!file.exists()) continue;
            file.delete();
        }
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    private String generateDDL(String format) {
        return this.generateDDL("", format);
    }

    private String generateDDL(String options, String format) {
        StringBuilder optionsBuilder = new StringBuilder(options);
        if (this.isMultiTenant) {
            if (optionsBuilder.length() != 0) {
                optionsBuilder.append(",");
            }
            optionsBuilder.append("MULTI_TENANT=true");
        }
        return String.format(format, this.isMultiTenant ? "TENANT_ID VARCHAR NOT NULL, " : "", this.isMultiTenant ? "TENANT_ID, " : "", optionsBuilder.toString());
    }

    private void deleteRowsFrom(Connection connection, String systemTableName, String baseTableSchema, String childViewSchemaName, String grandchildViewSchemaName, String grandGrandChildViewSchemaName) throws SQLException {
        connection.createStatement().execute(String.format(deleteSchemaRows, systemTableName, baseTableSchema == null ? "IS NULL" : " = '" + baseTableSchema + "'"));
        connection.createStatement().execute(String.format(deleteSchemaRows, systemTableName, childViewSchemaName == null ? "IS NULL" : " = '" + childViewSchemaName + "'"));
        connection.createStatement().execute(String.format(deleteSchemaRows, systemTableName, grandchildViewSchemaName == null ? "IS NULL" : " = '" + grandchildViewSchemaName + "'"));
        connection.createStatement().execute(String.format(deleteSchemaRows, systemTableName, grandGrandChildViewSchemaName == null ? "IS NULL" : " = '" + grandGrandChildViewSchemaName + "'"));
    }

    private void deleteAllRows(Connection connection, String baseTableSchema, String childViewSchemaName, String grandchildViewSchemaName, String grandGrandChildViewSchemaName) throws SQLException {
        this.deleteRowsFrom(connection, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, baseTableSchema, childViewSchemaName, grandchildViewSchemaName, grandGrandChildViewSchemaName);
        this.deleteRowsFrom(connection, PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME, baseTableSchema, childViewSchemaName, grandchildViewSchemaName, grandGrandChildViewSchemaName);
        connection.commit();
    }

    private void createBaseTableIndexAndViews(Connection baseTableConnection, String baseTableFullName, Connection viewConnection, String childViewSchemaName, String grandchildViewSchemaName, String grandGrandChildViewSchemaName) throws SQLException {
        baseTableConnection.createStatement().execute(this.generateDDL(String.format(createBaseTableFirstPartDDL, baseTableFullName) + createBaseTableSecondPartDDL));
        baseTableConnection.createStatement().execute(String.format(createBaseTableIndexDDL, OrphanViewToolIT.generateUniqueName(), baseTableFullName));
        int i = 0;
        while ((long)i < 2L) {
            String childView = SchemaUtil.getTableName((String)childViewSchemaName, (String)OrphanViewToolIT.generateUniqueName());
            viewConnection.createStatement().execute(String.format(createViewDDL, childView, baseTableFullName));
            int j = 0;
            while ((long)j < 2L) {
                String grandchildView = SchemaUtil.getTableName((String)grandchildViewSchemaName, (String)OrphanViewToolIT.generateUniqueName());
                viewConnection.createStatement().execute(String.format(createViewDDL, grandchildView, childView));
                int k = 0;
                while ((long)k < 2L) {
                    viewConnection.createStatement().execute(String.format(createViewDDL, SchemaUtil.getTableName((String)grandGrandChildViewSchemaName, (String)OrphanViewToolIT.generateUniqueName()), grandchildView));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void verifyLineCount(String fileName, long lineCount) throws IOException {
        LineNumberReader reader = new LineNumberReader(new FileReader(fileName));
        while (reader.readLine() != null) {
        }
        int count = reader.getLineNumber();
        if ((long)count != lineCount) {
            LOGGER.debug(count + " != " + lineCount);
        }
        Assert.assertTrue(((long)count == lineCount ? 1 : 0) != 0);
        reader.close();
    }

    private void verifyCountQuery(Connection connection, String query, String schemaName, long count) throws SQLException {
        ResultSet rs = connection.createStatement().executeQuery(String.format(query, schemaName == null ? "IS NULL" : "= '" + schemaName + "'"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((rs.getLong(1) == count ? 1 : 0) != 0);
    }

    @Test
    public void testCreateTableAndViews() throws Exception {
        String baseTableName = OrphanViewToolIT.generateUniqueName();
        String baseTableFullName = SchemaUtil.getTableName((String)SCHEMA1, (String)baseTableName);
        try (Connection connection = DriverManager.getConnection(OrphanViewToolIT.getUrl());
             Connection viewConnection = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL) : connection;){
            this.createBaseTableIndexAndViews(connection, baseTableFullName, viewConnection, SCHEMA2, SCHEMA3, SCHEMA4);
            OrphanViewToolIT.runOrphanViewTool(true, false, true, false);
            this.verifyOrphanFileLineCounts(0L, 0L, 0L, 0L);
            ResultSet rs = connection.createStatement().executeQuery(countAllViewsQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((rs.getLong(1) == 14L ? 1 : 0) != 0);
            this.deleteAllRows(connection, SCHEMA1, SCHEMA2, SCHEMA3, SCHEMA4);
        }
    }

    private void verifyNoChildLink(Connection connection, String viewSchemaName) throws Exception {
        this.verifyCountQuery(connection, countChildLinksQuery, viewSchemaName, 0L);
    }

    private void verifyNoViewNoLinkInSystemCatalog(Connection connection, String viewSchemaName) throws Exception {
        this.verifyCountQuery(connection, countViewsQuery, viewSchemaName, 0L);
        this.verifyCountQuery(connection, countParentLinksQuery, viewSchemaName, 0L);
        this.verifyCountQuery(connection, countPhysicalLinksQuery, viewSchemaName, 0L);
    }

    private void verifyOrphanFileLineCounts(long viewCount, long parentLinkCount, long physicalLinkCount, long childLinkCount) throws Exception {
        this.verifyLineCount(viewFileName, viewCount);
        this.verifyLineCount(parentLinkFileName, parentLinkCount);
        this.verifyLineCount(physicalLinkFileName, physicalLinkCount);
        this.verifyLineCount(childLinkFileName, childLinkCount);
    }

    private void executeDeleteQuery(Connection connection, String deleteQuery, String schemaName) throws Exception {
        connection.createStatement().execute(String.format(deleteQuery, schemaName == null ? "IS NULL" : "= '" + schemaName + "'"));
        connection.commit();
    }

    @Test
    public void testDeleteBaseTableRows() throws Exception {
        String baseTableName = OrphanViewToolIT.generateUniqueName();
        String baseTableFullName = SchemaUtil.getTableName((String)SCHEMA1, (String)baseTableName);
        try (Connection connection = DriverManager.getConnection(OrphanViewToolIT.getUrl());
             Connection viewConnection = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL) : connection;){
            this.createBaseTableIndexAndViews(connection, baseTableFullName, viewConnection, SCHEMA2, SCHEMA2, SCHEMA2);
            this.executeDeleteQuery(connection, deleteTableRows, SCHEMA1);
            ResultSet rs = connection.createStatement().executeQuery(countAllViewsQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((rs.getLong(1) == 14L ? 1 : 0) != 0);
            OrphanViewToolIT.runOrphanViewTool(false, true, true, false);
            this.verifyOrphanFileLineCounts(14L, 0L, 14L, 2L);
            rs = connection.createStatement().executeQuery(countAllViewsQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((rs.getLong(1) == 14L ? 1 : 0) != 0);
            OrphanViewToolIT.runOrphanViewTool(true, false, false, true);
            this.verifyNoViewNoLinkInSystemCatalog(connection, SCHEMA2);
            this.verifyNoChildLink(connection, SCHEMA1);
            this.deleteAllRows(connection, SCHEMA1, SCHEMA2, SCHEMA3, SCHEMA4);
        }
    }

    @Test
    public void testDeleteChildViewRows() throws Exception {
        String baseTableName = OrphanViewToolIT.generateUniqueName();
        String baseTableFullName = SchemaUtil.getTableName((String)SCHEMA1, (String)baseTableName);
        try (Connection connection = DriverManager.getConnection(OrphanViewToolIT.getUrl());
             Connection viewConnection = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL) : connection;){
            this.createBaseTableIndexAndViews(connection, baseTableFullName, viewConnection, null, SCHEMA3, SCHEMA3);
            this.executeDeleteQuery(connection, deleteViewRows, null);
            this.verifyCountQuery(connection, countViewsQuery, SCHEMA3, 12L);
            OrphanViewToolIT.runOrphanViewTool(true, false, true, false);
            this.verifyOrphanFileLineCounts(12L, 4L, 2L, 6L);
            this.verifyNoViewNoLinkInSystemCatalog(connection, null);
            this.verifyNoViewNoLinkInSystemCatalog(connection, SCHEMA3);
            this.verifyNoChildLink(connection, SCHEMA1);
            this.verifyNoChildLink(connection, null);
            this.deleteAllRows(connection, SCHEMA1, null, SCHEMA3, SCHEMA4);
        }
    }

    @Test
    public void testDeleteGrandchildViewRows() throws Exception {
        String baseTableName = OrphanViewToolIT.generateUniqueName();
        String baseTableFullName = SchemaUtil.getTableName((String)SCHEMA1, (String)baseTableName);
        try (Connection connection = DriverManager.getConnection(OrphanViewToolIT.getUrl());
             Connection viewConnection = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL) : connection;){
            this.createBaseTableIndexAndViews(connection, baseTableFullName, viewConnection, SCHEMA2, SCHEMA3, null);
            this.executeDeleteQuery(connection, deleteViewRows, SCHEMA3);
            this.verifyCountQuery(connection, countViewsQuery, null, 8L);
            OrphanViewToolIT.runOrphanViewTool(true, false, true, false);
            this.verifyOrphanFileLineCounts(8L, 12L, 4L, 12L);
            this.verifyNoViewNoLinkInSystemCatalog(connection, SCHEMA3);
            this.verifyNoViewNoLinkInSystemCatalog(connection, null);
            this.verifyNoChildLink(connection, SCHEMA2);
            this.verifyNoChildLink(connection, SCHEMA3);
            this.deleteAllRows(connection, SCHEMA1, SCHEMA2, SCHEMA3, null);
        }
    }

    @Test
    public void testDeleteParentChildLinkRows() throws Exception {
        String baseTableName = OrphanViewToolIT.generateUniqueName();
        String baseTableFullName = SchemaUtil.getTableName((String)SCHEMA1, (String)baseTableName);
        try (Connection connection = DriverManager.getConnection(OrphanViewToolIT.getUrl());
             Connection viewConnection = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL) : connection;){
            this.createBaseTableIndexAndViews(connection, baseTableFullName, viewConnection, SCHEMA2, SCHEMA3, SCHEMA4);
            this.executeDeleteQuery(connection, deleteChildLinks, SCHEMA2);
            this.verifyCountQuery(connection, countViewsQuery, SCHEMA4, 8L);
            OrphanViewToolIT.runOrphanViewTool(true, false, true, false);
            this.verifyOrphanFileLineCounts(12L, 0L, 0L, 0L);
            this.verifyNoViewNoLinkInSystemCatalog(connection, SCHEMA3);
            this.verifyNoViewNoLinkInSystemCatalog(connection, SCHEMA4);
            this.verifyNoChildLink(connection, SCHEMA2);
            this.verifyNoChildLink(connection, SCHEMA3);
            this.deleteAllRows(connection, SCHEMA1, SCHEMA2, SCHEMA3, SCHEMA4);
        }
    }

    @Test
    public void testDeleteChildParentLinkRows() throws Exception {
        String baseTableName = OrphanViewToolIT.generateUniqueName();
        String baseTableFullName = SchemaUtil.getTableName((String)SCHEMA1, (String)baseTableName);
        try (Connection connection = DriverManager.getConnection(OrphanViewToolIT.getUrl());
             Connection viewConnection = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL) : connection;){
            this.createBaseTableIndexAndViews(connection, baseTableFullName, viewConnection, SCHEMA2, SCHEMA3, SCHEMA4);
            this.executeDeleteQuery(connection, deleteParentLinks, SCHEMA4);
            this.verifyCountQuery(connection, countViewsQuery, SCHEMA4, 8L);
            OrphanViewToolIT.runOrphanViewTool(true, false, true, false);
            this.verifyOrphanFileLineCounts(8L, 0L, 0L, 0L);
            this.verifyNoViewNoLinkInSystemCatalog(connection, SCHEMA4);
            this.verifyNoChildLink(connection, SCHEMA3);
            this.deleteAllRows(connection, SCHEMA1, SCHEMA2, SCHEMA3, SCHEMA4);
        }
    }

    @Test
    public void testDeletePhysicalTableLinks() throws Exception {
        String baseTableName = OrphanViewToolIT.generateUniqueName();
        String baseTableFullName = SchemaUtil.getTableName((String)SCHEMA1, (String)baseTableName);
        try (Connection connection = DriverManager.getConnection(OrphanViewToolIT.getUrl());
             Connection viewConnection = this.isMultiTenant ? DriverManager.getConnection(this.TENANT_SPECIFIC_URL) : connection;){
            this.createBaseTableIndexAndViews(connection, baseTableFullName, viewConnection, SCHEMA2, SCHEMA3, SCHEMA3);
            this.executeDeleteQuery(connection, deletePhysicalLinks, SCHEMA2);
            this.verifyCountQuery(connection, countViewsQuery, SCHEMA2, 2L);
            this.verifyCountQuery(connection, countViewsQuery, SCHEMA3, 12L);
            OrphanViewToolIT.runOrphanViewTool(true, false, true, false);
            this.verifyLineCount(viewFileName, 14L);
            this.verifyNoViewNoLinkInSystemCatalog(connection, SCHEMA2);
            this.verifyNoViewNoLinkInSystemCatalog(connection, SCHEMA3);
            this.verifyNoChildLink(connection, SCHEMA1);
            this.verifyNoChildLink(connection, SCHEMA2);
            this.verifyNoChildLink(connection, SCHEMA3);
            this.deleteAllRows(connection, SCHEMA1, SCHEMA2, SCHEMA3, SCHEMA4);
        }
    }

    public static String[] getArgValues(boolean clean, boolean identify, boolean outputPath, boolean inputPath) throws InterruptedException {
        ArrayList args = Lists.newArrayList();
        if (outputPath) {
            args.add("-op");
            args.add(tmpDir);
        }
        if (inputPath) {
            args.add("-ip");
            args.add(tmpDir);
        }
        if (clean) {
            args.add("-c");
        }
        if (identify) {
            args.add("-i");
        }
        long ageMs = 2000L;
        Thread.sleep(2000L);
        args.add("-a");
        args.add(Long.toString(2000L));
        return args.toArray(new String[0]);
    }

    public static void runOrphanViewTool(boolean clean, boolean identify, boolean outputPath, boolean inputPath) throws Exception {
        OrphanViewTool orphanViewTool = new OrphanViewTool();
        Configuration conf = new Configuration(OrphanViewToolIT.getUtility().getConfiguration());
        orphanViewTool.setConf(conf);
        String[] cmdArgs = OrphanViewToolIT.getArgValues(clean, identify, outputPath, inputPath);
        int status = orphanViewTool.run(cmdArgs);
        Assert.assertEquals((long)0L, (long)status);
    }

    static {
        SCHEMA1 = "SCHEMA1";
        SCHEMA2 = "SCHEMA2";
        SCHEMA3 = "SCHEMA3";
        SCHEMA4 = "SCHEMA4";
        deleteTableRows = "DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "TABLE_SCHEM" + " %s AND " + "TABLE_TYPE" + " = '" + PTableType.TABLE.getSerializedValue() + "'";
        countAllViewsQuery = "SELECT COUNT(*) FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "TABLE_TYPE" + " = '" + PTableType.VIEW.getSerializedValue() + "'";
        countViewsQuery = "SELECT COUNT(*) FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "TABLE_SCHEM" + " %s AND " + "TABLE_TYPE" + " = '" + PTableType.VIEW.getSerializedValue() + "'";
        deleteViewRows = "DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "TABLE_SCHEM" + " %s AND " + "TABLE_TYPE" + " = '" + PTableType.VIEW.getSerializedValue() + "'";
        countChildLinksQuery = "SELECT COUNT(*) FROM " + PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME + " WHERE " + "TABLE_SCHEM" + " %s AND " + "LINK_TYPE" + " = " + PTable.LinkType.CHILD_TABLE.getSerializedValue();
        deleteChildLinks = "DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME + " WHERE " + "TABLE_SCHEM" + " %s AND " + "LINK_TYPE" + " = " + PTable.LinkType.CHILD_TABLE.getSerializedValue();
        countParentLinksQuery = "SELECT COUNT(*) FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "TABLE_SCHEM" + " %s AND " + "LINK_TYPE" + " = " + PTable.LinkType.PARENT_TABLE.getSerializedValue();
        deleteParentLinks = "DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "TABLE_SCHEM" + " %s AND " + "LINK_TYPE" + " = " + PTable.LinkType.PARENT_TABLE.getSerializedValue();
        countPhysicalLinksQuery = "SELECT COUNT(*) FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "TABLE_SCHEM" + " %s AND " + "LINK_TYPE" + " = " + PTable.LinkType.PHYSICAL_TABLE.getSerializedValue();
        deletePhysicalLinks = "DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "TABLE_SCHEM" + " %s AND " + "LINK_TYPE" + " = " + PTable.LinkType.PHYSICAL_TABLE.getSerializedValue();
    }
}

