/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class OrderByWithServerMemoryLimitIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.query.server.spoolThresholdBytes", Integer.toString(1));
        props.put("phoenix.query.server.orderBy.spooling.enabled", Boolean.toString(Boolean.FALSE));
        OrderByWithServerMemoryLimitIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testOrderByWithServerMemoryLimit() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(OrderByWithServerMemoryLimitIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String tableName = OrderByWithServerMemoryLimitIT.generateUniqueName();
            String ddl = "CREATE TABLE " + tableName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string))\n";
            OrderByWithServerMemoryLimitIT.createTestTable(OrderByWithServerMemoryLimitIT.getUrl(), ddl);
            String dml = "UPSERT INTO " + tableName + " VALUES(?, ?)";
            PreparedStatement stmt = conn.prepareStatement(dml);
            stmt.setString(1, "a");
            stmt.setInt(2, 40);
            stmt.execute();
            stmt.setString(1, "b");
            stmt.setInt(2, 20);
            stmt.execute();
            stmt.setString(1, "c");
            stmt.setInt(2, 30);
            stmt.execute();
            conn.commit();
            String query = "select * from " + tableName + " order by 2";
            ResultSet rs = conn.createStatement().executeQuery(query);
            try {
                rs.next();
                Assert.fail((String)"Expected PhoenixIOException due to IllegalStateException");
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("ERROR 101 (08000): Unexpected IO exception. ERROR 101 (08000): Queue full. Consider increasing memory threshold or spooling to disk"));
            }
        }
    }
}

