/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class OperationTimeoutWithReasonIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOperationTimeout() throws SQLException {
        Throwable throwable;
        Statement stmt;
        String tableName = OperationTimeoutWithReasonIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (COL1 VARCHAR NOT NULL PRIMARY KEY, COL2 VARCHAR)";
        try (Connection conn = DriverManager.getConnection(OperationTimeoutWithReasonIT.getUrl());){
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute(ddl);
                String dml = String.format("UPSERT INTO %s VALUES (?, ?)", tableName);
                try (PreparedStatement prepStmt = conn.prepareStatement(dml);){
                    for (int i = 1; i <= 100; ++i) {
                        prepStmt.setString(1, "key" + i);
                        prepStmt.setString(2, "value" + i);
                        prepStmt.executeUpdate();
                    }
                }
                conn.commit();
            }
            catch (Throwable dml) {
                throwable = dml;
                throw dml;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable dml) {
                            throwable.addSuppressed(dml);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        try {
            conn = DriverManager.getConnection(OperationTimeoutWithReasonIT.getUrl());
            var4_4 = null;
            try {
                stmt = conn.createStatement();
                throwable = null;
                try {
                    stmt.setQueryTimeout(5);
                    ResultSet rs = stmt.executeQuery(String.format("SELECT * FROM %s", tableName));
                    MyClock clock = new MyClock(10L, 10000L);
                    EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
                    try {
                        rs.next();
                        Assert.fail();
                    }
                    catch (SQLException e) {
                        Assert.assertEquals((long)SQLExceptionCode.OPERATION_TIMED_OUT.getErrorCode(), (long)e.getErrorCode());
                        Assert.assertTrue((boolean)e.getMessage().contains("Query couldn't be completed in the allotted time: 5000 ms"));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                var4_4 = throwable4;
                throw throwable4;
            }
            finally {
                if (conn != null) {
                    if (var4_4 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable5) {
                            var4_4.addSuppressed(throwable5);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private static final class MyClock
    extends EnvironmentEdge {
        private long time;
        private final long delay;

        public MyClock(long time, long delay) {
            this.time = time;
            this.delay = delay;
        }

        public long currentTime() {
            long currentTime = this.time;
            this.time += this.delay;
            return currentTime;
        }
    }
}

