/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class OctetLengthFunctionEnd2EndIT
extends ParallelStatsDisabledIT {
    private static final String KEY = "key";
    private static final String TABLE_NAME = OctetLengthFunctionEnd2EndIT.generateUniqueName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void initTable() throws Exception {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(OctetLengthFunctionEnd2EndIT.getUrl());
            String ddl = "CREATE TABLE " + TABLE_NAME + " (k VARCHAR NOT NULL PRIMARY KEY, b BINARY(4), vb1 VARBINARY, vb2 VARBINARY)";
            conn.createStatement().execute(ddl);
            conn.commit();
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    @Test
    public void test() throws Exception {
        Connection conn = DriverManager.getConnection(OctetLengthFunctionEnd2EndIT.getUrl());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + TABLE_NAME + "(k,b,vb1) VALUES (?, ?, ?)");
        stmt.setString(1, KEY);
        stmt.setBytes(2, new byte[]{1, 2, 3, 4});
        stmt.setBytes(3, new byte[]{1, 2, 3, 4});
        stmt.executeUpdate();
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT OCTET_LENGTH(vb1), OCTET_LENGTH(b), OCTET_LENGTH(vb2) FROM " + TABLE_NAME);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        Assert.assertEquals((long)4L, (long)rs.getInt(2));
        rs.getInt(3);
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
    }
}

