/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.phoenix.end2end.IndexScrutinyToolBaseIT;
import org.apache.phoenix.mapreduce.index.IndexScrutinyMapperForTest;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.index.PhoenixScrutinyJobCounters;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class NonParameterizedIndexScrutinyToolIT
extends IndexScrutinyToolBaseIT {
    @Test
    public void testScrutinyOnArrayTypes() throws Exception {
        String dataTableName = NonParameterizedIndexScrutinyToolIT.generateUniqueName();
        String indexTableName = NonParameterizedIndexScrutinyToolIT.generateUniqueName();
        String dataTableDDL = "CREATE TABLE %s (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, VB VARBINARY)";
        String indexTableDDL = "CREATE INDEX %s ON %s (NAME) INCLUDE (VB)";
        String upsertData = "UPSERT INTO %s VALUES (?, ?, ?)";
        String upsertIndex = "UPSERT INTO %s (\"0:NAME\", \":ID\", \"0:VB\") values (?,?,?)";
        try (Connection conn = DriverManager.getConnection(NonParameterizedIndexScrutinyToolIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            conn.createStatement().execute(String.format(dataTableDDL, dataTableName));
            conn.createStatement().execute(String.format(indexTableDDL, indexTableName, dataTableName));
            PreparedStatement upsertDataStmt = conn.prepareStatement(String.format(upsertData, dataTableName));
            NonParameterizedIndexScrutinyToolIT.upsertRow(upsertDataStmt, 1, "name-1", new byte[]{127, 0, 0, 1});
            NonParameterizedIndexScrutinyToolIT.upsertRow(upsertDataStmt, 2, "name-2", new byte[]{127, 1, 0, 5});
            conn.commit();
            List<Job> completedJobs = this.runScrutiny(null, dataTableName, indexTableName);
            Job job = completedJobs.get(0);
            Assert.assertTrue((boolean)job.isSuccessful());
            Counters counters = job.getCounters();
            Assert.assertEquals((long)2L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
            Assert.assertEquals((long)0L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
            NonParameterizedIndexScrutinyToolIT.upsertRow(upsertDataStmt, 3, "name-3", new byte[]{1, 1, 1, 1});
            conn.commit();
            PreparedStatement upsertIndexStmt = conn.prepareStatement(String.format(upsertIndex, indexTableName));
            upsertIndexStmt.setString(1, "name-3");
            upsertIndexStmt.setInt(2, 3);
            upsertIndexStmt.setBytes(3, new byte[]{0, 0, 0, 1});
            upsertIndexStmt.executeUpdate();
            conn.commit();
            completedJobs = this.runScrutiny(null, dataTableName, indexTableName);
            job = completedJobs.get(0);
            Assert.assertTrue((boolean)job.isSuccessful());
            counters = job.getCounters();
            Assert.assertEquals((long)2L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
            Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
            NonParameterizedIndexScrutinyToolIT.upsertRow(upsertDataStmt, 4, "name-4", null);
            conn.commit();
            upsertIndexStmt.setString(1, "name-4");
            upsertIndexStmt.setInt(2, 4);
            upsertIndexStmt.setBytes(3, new byte[]{0, 0, 1, 1});
            upsertIndexStmt.executeUpdate();
            conn.commit();
            completedJobs = this.runScrutiny(null, dataTableName, indexTableName);
            job = completedJobs.get(0);
            Assert.assertTrue((boolean)job.isSuccessful());
            counters = job.getCounters();
            Assert.assertEquals((long)2L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
            Assert.assertEquals((long)2L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
            NonParameterizedIndexScrutinyToolIT.upsertRow(upsertDataStmt, 5, "name-5", new byte[]{0, 1, 1, 1});
            conn.commit();
            upsertIndexStmt.setString(1, "name-5");
            upsertIndexStmt.setInt(2, 5);
            upsertIndexStmt.setBytes(3, null);
            upsertIndexStmt.executeUpdate();
            conn.commit();
            completedJobs = this.runScrutiny(null, dataTableName, indexTableName);
            job = completedJobs.get(0);
            Assert.assertTrue((boolean)job.isSuccessful());
            counters = job.getCounters();
            Assert.assertEquals((long)2L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
            Assert.assertEquals((long)3L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
            NonParameterizedIndexScrutinyToolIT.upsertRow(upsertDataStmt, 6, "name-6", null);
            conn.commit();
            upsertIndexStmt.setString(1, "name-6");
            upsertIndexStmt.setInt(2, 6);
            upsertIndexStmt.setBytes(3, null);
            upsertIndexStmt.executeUpdate();
            conn.commit();
            completedJobs = this.runScrutiny(null, dataTableName, indexTableName);
            job = completedJobs.get(0);
            Assert.assertTrue((boolean)job.isSuccessful());
            counters = job.getCounters();
            Assert.assertEquals((long)3L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
            Assert.assertEquals((long)3L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScrutinyOnRowsNearExpiry() throws Exception {
        String schema = NonParameterizedIndexScrutinyToolIT.generateUniqueName();
        String dataTableName = NonParameterizedIndexScrutinyToolIT.generateUniqueName();
        String indexTableName = NonParameterizedIndexScrutinyToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schema, (String)dataTableName);
        String dataTableDDL = "CREATE TABLE %s (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) TTL=3600";
        String indexTableDDL = "CREATE INDEX %s ON %s (NAME) INCLUDE (ZIP)";
        String upsertData = "UPSERT INTO %s VALUES (?, ?, ?)";
        IndexScrutinyMapperForTest.ScrutinyTestClock testClock = new IndexScrutinyMapperForTest.ScrutinyTestClock(0L);
        try (Connection conn = DriverManager.getConnection(NonParameterizedIndexScrutinyToolIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            conn.createStatement().execute(String.format(dataTableDDL, dataTableFullName));
            conn.createStatement().execute(String.format(indexTableDDL, indexTableName, dataTableFullName));
            PreparedStatement upsertDataStmt = conn.prepareStatement(String.format(upsertData, dataTableFullName));
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)testClock);
            NonParameterizedIndexScrutinyToolIT.upsertRow(upsertDataStmt, 1, "name-1", 98051);
            NonParameterizedIndexScrutinyToolIT.upsertRow(upsertDataStmt, 2, "name-2", 98052);
            conn.commit();
            List<Job> completedJobs = this.runScrutiny(schema, dataTableName, indexTableName);
            Job job = completedJobs.get(0);
            Assert.assertTrue((boolean)job.isSuccessful());
            Counters counters = job.getCounters();
            Assert.assertEquals((long)2L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.EXPIRED_ROW_COUNT));
            Assert.assertEquals((long)0L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
            Assert.assertEquals((long)0L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScrutinyOnRowsNearExpiry_viewIndex() throws Exception {
        String schemaName = "S" + NonParameterizedIndexScrutinyToolIT.generateUniqueName();
        String dataTableName = "T" + NonParameterizedIndexScrutinyToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String viewIndexName = "VI" + NonParameterizedIndexScrutinyToolIT.generateUniqueName();
        String viewName = "V" + NonParameterizedIndexScrutinyToolIT.generateUniqueName();
        String viewFullName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String dataTableDDL = "CREATE TABLE %s (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) TTL=3600";
        String viewDDL = "CREATE VIEW %s AS SELECT * FROM %s";
        String indexTableDDL = "CREATE INDEX %s ON %s (NAME) INCLUDE (ZIP)";
        String upsertData = "UPSERT INTO %s VALUES (?, ?, ?)";
        IndexScrutinyMapperForTest.ScrutinyTestClock testClock = new IndexScrutinyMapperForTest.ScrutinyTestClock(0L);
        try (Connection conn = DriverManager.getConnection(NonParameterizedIndexScrutinyToolIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            conn.createStatement().execute(String.format(dataTableDDL, dataTableFullName));
            conn.createStatement().execute(String.format(viewDDL, viewFullName, dataTableFullName));
            conn.createStatement().execute(String.format(indexTableDDL, viewIndexName, viewFullName));
            PreparedStatement upsertDataStmt = conn.prepareStatement(String.format(upsertData, viewFullName));
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)testClock);
            NonParameterizedIndexScrutinyToolIT.upsertRow(upsertDataStmt, 1, "name-1", 98051);
            NonParameterizedIndexScrutinyToolIT.upsertRow(upsertDataStmt, 2, "name-2", 98052);
            conn.commit();
            List<Job> completedJobs = this.runScrutiny(schemaName, viewName, viewIndexName);
            Job job = completedJobs.get(0);
            Assert.assertTrue((boolean)job.isSuccessful());
            Counters counters = job.getCounters();
            Assert.assertEquals((long)2L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.EXPIRED_ROW_COUNT));
            Assert.assertEquals((long)0L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
            Assert.assertEquals((long)0L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    public static void upsertRow(PreparedStatement stmt, int id, String name, byte[] val) throws SQLException {
        int index = 1;
        stmt.setInt(index++, id);
        stmt.setString(index++, name);
        stmt.setBytes(index++, val);
        stmt.executeUpdate();
    }

    public static void upsertRow(PreparedStatement stmt, int id, String name, int val) throws SQLException {
        int index = 1;
        stmt.setInt(index++, id);
        stmt.setString(index++, name);
        stmt.setInt(index++, val);
        stmt.executeUpdate();
    }

    private List<Job> runScrutiny(String schemaName, String dataTableName, String indexTableName) throws Exception {
        return this.runScrutiny(schemaName, dataTableName, indexTableName, null, null);
    }

    private List<Job> runScrutiny(String schemaName, String dataTableName, String indexTableName, Long batchSize, IndexScrutinyTool.SourceTable sourceTable) throws Exception {
        String[] cmdArgs = this.getArgValues(schemaName, dataTableName, indexTableName, batchSize, sourceTable, false, null, null, null, Long.MAX_VALUE);
        return this.runScrutiny(IndexScrutinyMapperForTest.class, cmdArgs);
    }
}

